/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class EditorView
extends PlainView {
    private static HashMap<Pattern, Color> patternColors;
    private static String TAG_PATTERN;
    private static String TAG_END_PATTERN;
    private static String TAG_ATTRIBUTE_PATTERN;
    private static String TAG_ATTRIBUTE_VALUE;
    private static String TAG_COMMENT;
    private static String TAG_CDATA_START;
    private static String TAG_CDATA_END;
    private static String[] keywords;

    public EditorView(Element element) {
        super(element);
        this.getDocument().putProperty("tabSize", 4);
    }

    @Override
    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        Document document = this.getDocument();
        String string = document.getText(n3, n4 - n3);
        Segment segment = this.getLineBuffer();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Color> treeMap2 = new TreeMap<Integer, Color>();
        for (Map.Entry<Pattern, Color> object : patternColors.entrySet()) {
            Matcher matcher = object.getKey().matcher(string);
            while (matcher.find()) {
                treeMap.put(matcher.start(1), matcher.end());
                treeMap2.put(matcher.start(1), object.getValue());
            }
        }
        int n5 = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            int n6 = (Integer)entry.getKey();
            int n7 = (Integer)entry.getValue();
            if (n5 < n6) {
                graphics.setColor(Color.black);
                document.getText(n3 + n5, n6 - n5, segment);
                n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n5);
            }
            graphics.setColor((Color)treeMap2.get(n6));
            n5 = n7;
            document.getText(n3 + n6, n5 - n6, segment);
            n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n6);
        }
        if (n5 < string.length()) {
            graphics.setColor(Color.black);
            document.getText(n3 + n5, string.length() - n5, segment);
            n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n5);
        }
        return n;
    }

    static {
        TAG_PATTERN = "(</?[a-z]*)\\s?>?";
        TAG_END_PATTERN = "(/>)";
        TAG_ATTRIBUTE_PATTERN = "\\s(\\w*)\\=";
        TAG_ATTRIBUTE_VALUE = "[a-z-]*\\=(\"[^\"]*\")";
        TAG_COMMENT = "(<!--.*-->)";
        TAG_CDATA_START = "(\\<!\\[CDATA\\[).*";
        TAG_CDATA_END = ".*(]]>)";
        keywords = new String[]{"and", "del", "for", "is", "raise", "assert", "elif", "from", "lambda", "return", "break", "else", "global", "not", "try", "class", "except", "if", "or", "while", "continue", "exec", "import", "pass", "yield", "def", "finally", "in", "print"};
        patternColors = new HashMap();
        for (int i = 0; i < keywords.length; ++i) {
            patternColors.put(Pattern.compile(keywords[i]), new Color(63, 127, 127));
        }
    }
}

