/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import org.sikuli.ide.PreferencesUser;
import org.sikuli.script.Debug;
import org.sikuli.script.Settings;

class HighlightLabelView
extends LabelView {
    static FontMetrics _fMetrics;
    static String tabStr;
    private static Map<Pattern, Color> patternColors;
    private static Font fontParenthesis;
    private static String[] keywords;
    private static String[] keywordsSikuliClass;
    private static String[] keywordsSikuli;
    private static String[] constantsSikuli;

    public HighlightLabelView(Element element) {
        super(element);
    }

    private static String nSpaces(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    @Override
    public float getMinimumSpan(int n) {
        float f = super.getMinimumSpan(n);
        if (n == 0) {
            f = this.tabbedWidth();
        }
        return f;
    }

    @Override
    public float getMaximumSpan(int n) {
        float f = super.getMaximumSpan(n);
        if (n == 0) {
            f = this.tabbedWidth();
        }
        return f;
    }

    @Override
    public float getPreferredSpan(int n) {
        float f = super.getPreferredSpan(n);
        if (n == 0) {
            f = this.tabbedWidth();
        }
        return f;
    }

    private float tabbedWidth() {
        String string = this.getText(this.getStartOffset(), this.getEndOffset()).toString();
        int n = this.countTab(string);
        if (Settings.isMac()) {
            return (float)this.stringWidth(string) + this.getRealTabWidth() * (float)n;
        }
        return this.stringWidth(string) + this.getTabWidth() * n;
    }

    private int countTab(String string) {
        int n = -1;
        int n2 = 0;
        while ((n = string.indexOf(9, n + 1)) != -1) {
            ++n2;
        }
        return n2;
    }

    private int stringWidth(String string) {
        if (_fMetrics == null) {
            _fMetrics = this.getGraphics().getFontMetrics();
        }
        return _fMetrics.stringWidth(string);
    }

    private float getRealTabWidth() {
        int n = Settings.isMac() ? this.stringWidth("\t") : this.stringWidth(" ");
        return this.getTabWidth() - n;
    }

    private int getTabWidth() {
        return this.stringWidth(tabStr);
    }

    @Override
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Shape shape2;
        biasArray[0] = Position.Bias.Forward;
        Debug.log((int)9, (String)("viewToModel: " + f + " " + f2), (Object[])new Object[0]);
        String string = this.getText(this.getStartOffset(), this.getEndOffset()).toString();
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        int n3 = 0;
        while (n < n2) {
            Debug.log((int)9, (String)("viewToModel: " + n + " " + n2 + " " + n3), (Object[])new Object[0]);
            n3 = (n + n2) / 2;
            try {
                shape2 = this.modelToView(n3, shape, biasArray[0]);
                float f3 = shape2.getBounds().x;
                if (f3 > f) {
                    n2 = n3;
                    continue;
                }
                if (!(f3 < f)) break;
                n = n3 + 1;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
                break;
            }
        }
        n3 = n - 1 >= this.getStartOffset() ? n - 1 : this.getStartOffset();
        try {
            Debug.log((int)9, (String)("viewToModel: try " + n3), (Object[])new Object[0]);
            shape2 = this.modelToView(n3, shape, biasArray[0]);
            Shape shape3 = this.modelToView(n3 + 1, shape, biasArray[0]);
            if (Math.abs((float)shape2.getBounds().x - f) <= Math.abs((float)shape3.getBounds().x - f)) {
                return n3;
            }
            return n3 + 1;
        }
        catch (BadLocationException badLocationException) {
            return n3;
        }
    }

    @Override
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        Debug.log((int)9, (String)("[modelToView] start: " + n2 + " end: " + n3 + " pos:" + n), (Object[])new Object[0]);
        String string = this.getText(n2, n).toString();
        String string2 = this.getText(n, n3).toString();
        Debug.log((int)9, (String)("[modelToView] [" + string + "]-pos-[" + string2 + "]"), (Object[])new Object[0]);
        int n4 = this.countTab(string);
        int n5 = this.countTab(string2);
        Debug.log((int)9, (String)("[modelToView] " + n4 + " " + n5), (Object[])new Object[0]);
        Shape shape2 = super.modelToView(n, shape, bias);
        Rectangle rectangle = shape2.getBounds();
        Debug.log((int)9, (String)("[modelToView] super.bounds: " + rectangle), (Object[])new Object[0]);
        if (n != n3) {
            rectangle.x = (int)((float)rectangle.x + (float)n4 * this.getRealTabWidth());
        }
        Debug.log((int)9, (String)("[modelToView] new bounds: " + rectangle), (Object[])new Object[0]);
        return rectangle;
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String string = this.getText(this.getStartOffset(), this.getEndOffset()).toString();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Color> treeMap2 = new TreeMap<Integer, Color>();
        this.buildColorMaps(string, treeMap, treeMap2);
        if (_fMetrics == null) {
            _fMetrics = graphics2D.getFontMetrics();
        }
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n = rectangle.x;
        int n2 = rectangle.y + rectangle.height - _fMetrics.getDescent();
        int n3 = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            int n4 = (Integer)entry.getKey();
            int n5 = (Integer)entry.getValue();
            if (n3 > n4) break;
            graphics2D.setColor(Color.black);
            String string2 = string.substring(n3, n4);
            n = this.drawString(graphics2D, string2, n, n2);
            graphics2D.setColor((Color)treeMap2.get(n4));
            n3 = n5;
            string2 = string.substring(n4, n3);
            n = this.drawString(graphics2D, string2, n, n2);
        }
        if (n3 < string.length()) {
            graphics2D.setColor(Color.black);
            String string3 = string.substring(n3, string.length());
            this.drawString(graphics2D, string3, n, n2);
        }
    }

    int drawString(Graphics2D graphics2D, String string, int n, int n2) {
        if (string.length() == 0) {
            return n;
        }
        int n3 = string.indexOf(9);
        if (n3 != -1) {
            n = this.drawString(graphics2D, string.substring(0, n3), n, n2);
            n = this.drawTab(graphics2D, n, n2);
            n = this.drawString(graphics2D, string.substring(n3 + 1), n, n2);
        } else {
            graphics2D.drawString(string, n, n2);
            n += this.stringWidth(string);
        }
        return n;
    }

    int drawTab(Graphics2D graphics2D, int n, int n2) {
        return this.drawString(graphics2D, tabStr, n, n2);
    }

    int drawParenthesis(Graphics2D graphics2D, String string, int n, int n2) {
        Font font = graphics2D.getFont();
        graphics2D.setFont(fontParenthesis);
        graphics2D.drawString(string, n, n2);
        graphics2D.setFont(font);
        return n += graphics2D.getFontMetrics().stringWidth(string);
    }

    void buildColorMaps(String string, Map<Integer, Integer> map, Map<Integer, Color> map2) {
        for (Map.Entry<Pattern, Color> entry : patternColors.entrySet()) {
            Matcher matcher = entry.getKey().matcher(string);
            while (matcher.find()) {
                map.put(matcher.start(1), matcher.end());
                map2.put(matcher.start(1), entry.getValue());
            }
        }
    }

    static {
        int n;
        _fMetrics = null;
        tabStr = HighlightLabelView.nSpaces(PreferencesUser.getInstance().getTabWidth());
        keywords = new String[]{"and", "del", "for", "is", "raise", "assert", "elif", "from", "lambda", "return", "break", "else", "global", "not", "try", "class", "except", "if", "or", "while", "continue", "exec", "import", "pass", "yield", "def", "finally", "in", "print", "with"};
        keywordsSikuliClass = new String[]{"Region", "Screen", "Match", "Pattern", "Location", "VDict", "Env", "Key", "Button", "Finder", "App", "KeyModifier", "Vision"};
        keywordsSikuli = new String[]{"find", "wait", "findAll", "waitVanish", "exists", "click", "doubleClick", "rightClick", "hover", "wheel", "type", "paste", "dragDrop", "drag", "dropAt", "mouseMove", "mouseDown", "mouseUp", "keyDown", "keyUp", "onAppear", "onVanish", "onChange", "observe", "stopObserver", "popup", "capture", "input", "sleep", "run", "switchApp", "openApp", "closeApp", "assertExist", "assertNotExist", "selectRegion", "getOS", "getMouseLocation", "exit", "right", "left", "above", "below", "nearby", "inside", "getScreen", "getCenter", "setX", "setY", "setW", "setH", "setRect", "setROI", "getX", "getY", "getW", "getH", "getRect", "getROI", "highlight", "getNumberScreens", "getBounds", "similar", "targetOffset", "getLastMatch", "getLastMatches", "getTargetOffset", "getFilename", "setAutoWaitTimeout", "setBundlePath", "setShowActions", "setThrowException", "hasNext", "next", "destroy", "exact", "offset", "getOSVersion", "getScore", "getTarget", "getBundlePath", "getAutoWaitTimeout", "getThrowException", "getClipboard", "addImagePath", "removeImagePath", "getImagePath", "open", "close", "focus", "window", "focusedWindow"};
        constantsSikuli = new String[]{"FOREVER", "KEY_SHIFT", "KEY_CTRL", "KEY_META", "KEY_ALT", "KEY_CMD", "KEY_WIN", "ENTER", "BACKSPACE", "TAB", "ESC", "UP", "RIGHT", "DOWN", "LEFT", "PAGE_UP", "PAGE_DOWN", "DELETE", "END", "HOME", "INSERT", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11", "F12", "F13", "F14", "F15", "SHIFT", "CTRL", "ALT", "META", "CMD", "WIN", "SCREEN", "MIDDLE", "WHEEL_UP", "WHEEL_DOWN", "PRINTSCREEN", "SCROLL_LOCK", "PAUSE", "CAPS_LOCK", "NUM0", "NUM1", "NUM2", "NUM3", "NUM4", "NUM5", "NUM6", "NUM7", "NUM8", "NUM9", "SEPARATOR", "NUM_LOCK", "ADD", "MINUS", "MULTIPLY", "DIVIDE"};
        PreferencesUser.getInstance().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if (preferenceChangeEvent.getKey().equals("TAB_WIDTH")) {
                    tabStr = HighlightLabelView.nSpaces(Integer.parseInt(preferenceChangeEvent.getNewValue()));
                }
            }
        });
        fontParenthesis = new Font("Osaka-Mono", 0, 30);
        patternColors = new HashMap<Pattern, Color>();
        patternColors.put(Pattern.compile("(#:.*$)"), new Color(220, 220, 220));
        patternColors.put(Pattern.compile("(#.*$)"), new Color(138, 140, 193));
        patternColors.put(Pattern.compile("(\"[^\"]*\"?)"), new Color(128, 0, 0));
        patternColors.put(Pattern.compile("('[^']*'?)"), new Color(128, 0, 0));
        patternColors.put(Pattern.compile("\\b([0-9]+)\\b"), new Color(128, 64, 0));
        for (n = 0; n < keywords.length; ++n) {
            patternColors.put(Pattern.compile("\\b(" + keywords[n] + ")\\b"), Color.blue);
        }
        for (n = 0; n < keywordsSikuli.length; ++n) {
            patternColors.put(Pattern.compile("\\b(" + keywordsSikuli[n] + ")\\b"), new Color(63, 127, 127));
        }
        for (n = 0; n < keywordsSikuliClass.length; ++n) {
            patternColors.put(Pattern.compile("\\b(" + keywordsSikuliClass[n] + ")\\b"), new Color(215, 41, 56));
        }
        for (n = 0; n < constantsSikuli.length; ++n) {
            patternColors.put(Pattern.compile("\\b(" + constantsSikuli[n] + ")\\b"), new Color(128, 64, 0));
        }
    }
}

