/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

class JTextPaneHTMLTransferHandler
extends TransferHandler {
    @Override
    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
        super.exportToClipboard(jComponent, clipboard, n);
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        JTextPane jTextPane = (JTextPane)jComponent;
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jTextPane.getEditorKit();
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        int n = jTextPane.getSelectionStart();
        int n2 = jTextPane.getSelectionEnd();
        int n3 = n;
        StringBuilder stringBuilder = new StringBuilder();
        while (n3 < n2) {
            Element element = styledDocument.getCharacterElement(n3);
            Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset();
            if (object == HTML.Tag.BR) {
                stringBuilder.append("\n");
            } else if (object == HTML.Tag.CONTENT) {
                if (n4 < n) {
                    n4 = n;
                }
                if (n5 > n2) {
                    n5 = n2;
                }
                try {
                    String string = styledDocument.getText(n4, n5 - n4);
                    stringBuilder.append(string);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            n3 = n5;
        }
        return new StringSelection(stringBuilder.toString());
    }
}

