/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.sikuli.ide.AutoCompleteCombo;
import org.sikuli.ide.EditorPatternButton;
import org.sikuli.ide.SikuliIDEI18N;

public class PatternPaneNaming
extends JPanel {
    static final int TXT_FILE_EXT_LENGTH = 4;
    static final int TXT_FILENAME_LENGTH = 20;
    static final int MAX_OCR_TEXT_LENGTH = 12;
    static final int THUMB_MAX_HEIGHT = 200;
    EditorPatternButton _imgBtn;
    JTextField _txtPath;
    JTextField _txtFileExt;
    JComboBox _txtFilename;
    String _oldFilename;

    static String _I(String string, Object ... objectArray) {
        return SikuliIDEI18N._I(string, objectArray);
    }

    public PatternPaneNaming(EditorPatternButton editorPatternButton, JLabel jLabel) {
        super(new GridBagLayout());
        this.init(editorPatternButton, jLabel);
    }

    private void init(EditorPatternButton editorPatternButton, JLabel jLabel) {
        this._imgBtn = editorPatternButton;
        JLabel jLabel2 = new JLabel(PatternPaneNaming._I("lblPath", new Object[0]));
        JLabel jLabel3 = new JLabel(PatternPaneNaming._I("lblFilename", new Object[0]));
        String string = this._imgBtn.getFilename();
        File file = new File(string);
        String string2 = file.getParent();
        this._oldFilename = string = this.getFilenameWithoutExt(file);
        BufferedImage bufferedImage = this._imgBtn.createThumbnailImage(200);
        Border border = LineBorder.createGrayLineBorder();
        JLabel jLabel4 = new JLabel(new ImageIcon(bufferedImage));
        jLabel4.setBorder(border);
        this._txtPath = new JTextField(string2, 20);
        this._txtPath.setEditable(false);
        this._txtPath.setEnabled(false);
        Object[] objectArray = new String[]{string};
        this._txtFilename = new AutoCompleteCombo(objectArray);
        this._txtFileExt = new JTextField(this.getFileExt(file), 4);
        this._txtFileExt.setEditable(false);
        this._txtFileExt.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(100, 0, 0, 0);
        this.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 20, 10);
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this._txtPath, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        this.add((Component)jLabel3, gridBagConstraints);
        this.add((Component)this._txtFilename, gridBagConstraints);
        this.add((Component)this._txtFileExt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(200, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
    }

    protected void updateFilename() {
        this._oldFilename = (String)this._txtFilename.getSelectedItem();
    }

    private String getFilenameWithoutExt(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    private String getFileExt(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        return string.substring(n);
    }

    public String getAbsolutePath() {
        return this._txtPath.getText() + File.separatorChar + this._txtFilename.getSelectedItem() + this._txtFileExt.getText();
    }

    public boolean isDirty() {
        return this._oldFilename != (String)this._txtFilename.getSelectedItem();
    }
}

