/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.sikuli.ide.PatternSimilaritySlider;
import org.sikuli.ide.SikuliIDEI18N;
import org.sikuli.ide.util.LoadingSpinner;
import org.sikuli.script.Debug;
import org.sikuli.script.Finder;
import org.sikuli.script.Match;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.ScreenUnion;
import org.sikuli.script.natives.Vision;

class PatternPaneScreenshot
extends JPanel
implements ChangeListener,
ComponentListener {
    static final int DEFAULT_H = 500;
    static int MAX_NUM_MATCHING = 100;
    Region _match_region;
    int _width;
    int _height;
    double _scale;
    double _ratio;
    boolean _runFind = false;
    float _similarity;
    int _numMatches;
    Set<Match> _fullMatches = null;
    final Boolean _fullMatchesSynch = true;
    ArrayList<Match> _showMatches = null;
    final Boolean _showMatchesSynch = true;
    protected ScreenImage _simg;
    protected BufferedImage _screen = null;
    protected Rectangle _uBound;
    private JLabel btnSimilar;
    private JLabel _lblMatchCount;
    private JSlider sldSimilar;
    private JSpinner txtNumMatches;
    private LoadingSpinner _loading;

    static String _I(String string, Object ... objectArray) {
        return SikuliIDEI18N._I(string, objectArray);
    }

    public PatternPaneScreenshot(ScreenImage screenImage) {
        this.init(screenImage);
    }

    private void init(ScreenImage screenImage) {
        this._match_region = new ScreenUnion();
        int n = this._match_region.w;
        int n2 = this._match_region.h;
        this._ratio = (double)n / (double)n2;
        this._height = 500;
        this._scale = (double)this._height / (double)n2;
        this._width = (int)((double)n * this._scale);
        this.setPreferredSize(new Dimension(this._width, this._height));
        this.addComponentListener(this);
        this._simg = screenImage;
        this._screen = screenImage.getImage();
        MAX_NUM_MATCHING = (int)Vision.getParameter((String)"FindAllMaxReturn");
        this.autoResize();
        this._loading = new LoadingSpinner();
    }

    public JComponent createControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.btnSimilar = new JLabel(PatternPaneScreenshot._I("lblSimilarity", new Object[0]));
        this.sldSimilar = this.createSlider();
        JLabel jLabel = new JLabel(PatternPaneScreenshot._I("lblNumberOfMatches", new Object[0]));
        this._lblMatchCount = new JLabel("0");
        Dimension dimension = this._lblMatchCount.getPreferredSize();
        dimension.width *= 2;
        this._lblMatchCount.setPreferredSize(dimension);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(10, 0, MAX_NUM_MATCHING, 1);
        this.txtNumMatches = new JSpinner(spinnerNumberModel);
        jLabel.setLabelFor(this.txtNumMatches);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.btnSimilar, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)this.sldSimilar, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel.add((Component)this._lblMatchCount, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)new JLabel("/"), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 100);
        jPanel.add((Component)this.txtNumMatches, gridBagConstraints);
        this.txtNumMatches.addChangeListener(this);
        return jPanel;
    }

    private JSlider createSlider() {
        this.sldSimilar = new PatternSimilaritySlider(0, 100, 70, this.btnSimilar);
        this.sldSimilar.setMajorTickSpacing(10);
        this.sldSimilar.setPaintTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("0.0"));
        hashtable.put(new Integer(50), new JLabel("0.5"));
        hashtable.put(new Integer(100), new JLabel("0.99"));
        this.sldSimilar.setLabelTable(hashtable);
        this.sldSimilar.setPaintLabels(true);
        this.sldSimilar.addChangeListener(this);
        return this.sldSimilar;
    }

    public void setParameters(final String string, final boolean bl, final float f, final int n) throws IOException, AWTException {
        if (!this._runFind) {
            this._runFind = true;
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Finder finder = new Finder(PatternPaneScreenshot.this._simg, PatternPaneScreenshot.this._match_region);
                        finder.findAll(new Pattern(string).similar(1.0E-5f));
                        PatternPaneScreenshot.this._fullMatches = new TreeSet<Match>(new Comparator(){

                            public int compare(Object object, Object object2) {
                                return -1 * ((Comparable)object).compareTo(object2);
                            }

                            @Override
                            public boolean equals(Object object) {
                                return false;
                            }

                            public int hashCode() {
                                int n = 3;
                                return n;
                            }
                        });
                        int n2 = 0;
                        while (finder.hasNext() && ++n2 <= MAX_NUM_MATCHING) {
                            Match match = finder.next();
                            Boolean bl2 = PatternPaneScreenshot.this._fullMatchesSynch;
                            synchronized (bl2) {
                                PatternPaneScreenshot.this._fullMatches.add(match);
                            }
                            PatternPaneScreenshot.this.setParameters(bl, f, n);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            thread.start();
        } else {
            this.setParameters(bl, f, n);
        }
    }

    public void setParameters(boolean bl, float f, int n) {
        this._similarity = !bl ? f : 0.99f;
        this._numMatches = n;
        this.filterMatches(this._similarity, this._numMatches);
        this.sldSimilar.setValue((int)(f * 100.0f));
        this.repaint();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.autoResize();
    }

    private void autoResize() {
        this._width = this.getWidth();
        if (this._width == 0) {
            this._width = (int)this.getPreferredSize().getWidth();
        }
        this._height = (int)((double)this._width / this._ratio);
        this._scale = (double)this._height / (double)this._match_region.h;
        this.setPreferredSize(new Dimension(this._width, this._height));
        this.repaint();
    }

    public boolean isExact() {
        return this._similarity >= 0.99f;
    }

    public float getSimilarity() {
        return this._similarity;
    }

    public int getNumMatches() {
        return this._numMatches;
    }

    public void setSimilarity(float f) {
        this._similarity = f > 0.99f ? 0.99f : f;
        this.filterMatches(this._similarity, this._numMatches);
        this.repaint();
    }

    public void setNumMatches(int n) {
        this._numMatches = n;
        this.filterMatches(this._similarity, this._numMatches);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void filterMatches(float f, int n) {
        int n2 = 0;
        if (this._fullMatches != null && n >= 0) {
            Debug.log((int)7, (String)"filterMatches(%.2f,%d): %d", (Object[])new Object[]{Float.valueOf(f), n, n2});
            if (this._showMatches == null) {
                this._showMatches = new ArrayList();
            }
            Boolean bl = this._showMatchesSynch;
            synchronized (bl) {
                this._showMatches.clear();
                if (n == 0) {
                    return;
                }
                Boolean bl2 = this._fullMatchesSynch;
                synchronized (bl2) {
                    for (Match match : this._fullMatches) {
                        if (!(match.getScore() >= (double)f)) continue;
                        this._showMatches.add(match);
                        if (++n2 < n) continue;
                        break;
                    }
                }
            }
            this._lblMatchCount.setText(Integer.toString(n2));
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this._screen != null) {
            graphics2D.drawImage(this._screen, 0, 0, this._width, this._height, null);
            if (this._showMatches != null) {
                this.paintMatches(graphics2D);
            } else {
                this.paintOverlay(graphics2D);
            }
        }
    }

    void paintOverlay(Graphics2D graphics2D) {
        graphics2D.setColor(new Color(0, 0, 0, 150));
        graphics2D.fillRect(0, 0, this._width, this._height);
        BufferedImage bufferedImage = this._loading.getFrame();
        graphics2D.drawImage(bufferedImage, null, this._width / 2 - bufferedImage.getWidth() / 2, this._height / 2 - bufferedImage.getHeight() / 2);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintMatches(Graphics2D graphics2D) {
        Boolean bl = this._showMatchesSynch;
        synchronized (bl) {
            for (Match match : this._showMatches) {
                int n = (int)((double)(match.x - this._match_region.x) * this._scale);
                int n2 = (int)((double)(match.y - this._match_region.y) * this._scale);
                int n3 = (int)((double)match.w * this._scale);
                int n4 = (int)((double)match.h * this._scale);
                Color color = PatternSimilaritySlider.getScoreColor(match.getScore());
                graphics2D.setColor(color);
                graphics2D.fillRect(n, n2, n3, n4);
                graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JSlider) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            this.setSimilarity((float)n / 100.0f);
        } else if (object instanceof JSpinner) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            int n = (Integer)jSpinner.getValue();
            this.setNumMatches(n);
        }
    }
}

