/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.sikuli.ide.PatternSimilaritySlider;
import org.sikuli.ide.SikuliIDEI18N;
import org.sikuli.ide.util.LoadingSpinner;
import org.sikuli.script.Debug;
import org.sikuli.script.Finder;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.sikuli.script.ScreenImage;

class PatternPaneTargetOffset
extends JPanel
implements MouseListener,
MouseWheelListener,
ChangeListener {
    static final int DEFAULT_H = 300;
    static final float DEFAULT_PATTERN_RATIO = 0.4f;
    ScreenImage _simg;
    BufferedImage _img;
    Match _match = null;
    int _viewX;
    int _viewY;
    int _viewW;
    int _viewH;
    float _zoomRatio;
    float _ratio;
    Location _tar = new Location(0, 0);
    Location _offset = new Location(0, 0);
    JSpinner txtX;
    JSpinner txtY;
    private LoadingSpinner _loading;
    private boolean _finding = true;
    private static Color COLOR_BG_LINE = new Color(210, 210, 210, 130);

    public PatternPaneTargetOffset(ScreenImage screenImage, String string, Location location) {
        this._simg = screenImage;
        this._ratio = 0.4f;
        Rectangle rectangle = this._simg.getROI();
        int n = 300 / rectangle.height * rectangle.width;
        this.setPreferredSize(new Dimension(n, 300));
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this._loading = new LoadingSpinner();
        this.findTarget(string, location);
    }

    void findTarget(final String string, final Location location) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Finder finder = new Finder(PatternPaneTargetOffset.this._simg, Region.create((int)0, (int)0, (int)0, (int)0));
                try {
                    finder.find(string);
                    if (finder.hasNext()) {
                        PatternPaneTargetOffset.this._match = finder.next();
                        if (location != null) {
                            PatternPaneTargetOffset.this.setTarget(location.x, location.y);
                        } else {
                            PatternPaneTargetOffset.this.setTarget(0, 0);
                        }
                    }
                    PatternPaneTargetOffset.this._img = ImageIO.read(new File(string));
                }
                catch (IOException iOException) {
                    Debug.error((String)("Can't load " + string), (Object[])new Object[0]);
                }
                PatternPaneTargetOffset patternPaneTargetOffset = PatternPaneTargetOffset.this;
                synchronized (patternPaneTargetOffset) {
                    PatternPaneTargetOffset.this._finding = false;
                }
                PatternPaneTargetOffset.this.repaint();
            }
        });
        thread.start();
    }

    static String _I(String string, Object ... objectArray) {
        return SikuliIDEI18N._I(string, objectArray);
    }

    private void zoomToMatch() {
        this._viewW = (int)((float)this._match.w / this._ratio);
        this._zoomRatio = (float)this.getWidth() / (float)this._viewW;
        this._viewH = (int)((float)this.getHeight() / this._zoomRatio);
        this._viewX = this._match.x + this._match.w / 2 - this._viewW / 2;
        this._viewY = this._match.y + this._match.h / 2 - this._viewH / 2;
    }

    public void setTarget(int n, int n2) {
        Debug.log((int)3, (String)("new target: " + n + "," + n2), (Object[])new Object[0]);
        if (this._match != null) {
            Location location = this._match.getCenter();
            this._tar.x = location.x + n;
            this._tar.y = location.y + n2;
        } else {
            this._tar.x = n;
            this._tar.y = n2;
        }
        this._offset = new Location(n, n2);
        if (this.txtX != null) {
            this.txtX.setValue(new Integer(n));
            this.txtY.setValue(new Integer(n2));
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Location location = this.convertViewToScreen(mouseEvent.getPoint());
        Debug.log((int)4, (String)("click: " + mouseEvent.getPoint() + " -> " + location), (Object[])new Object[0]);
        if (this._match != null) {
            Location location2 = this._match.getCenter();
            this.setTarget(location.x - location2.x, location.y - location2.y);
        } else {
            this.setTarget(location.x, location.y);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        int n2 = (int)((float)this.getWidth() * this._ratio);
        float f = (float)n2 / (float)this._img.getWidth();
        int n3 = (int)((float)this._img.getHeight() * this._zoomRatio);
        if (n < 0) {
            if (n2 < 2 * this.getWidth() && n3 < 2 * this.getHeight()) {
                this._ratio = (float)((double)this._ratio * 1.1);
            }
        } else if (n2 > 20 && n3 > 20) {
            this._ratio = (float)((double)this._ratio * 0.9);
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    void paintRulers(Graphics graphics) {
        int n;
        int n2 = (int)(10.0f * this._zoomRatio);
        if (n2 < 2) {
            n2 = 2;
        }
        int n3 = this.getHeight();
        int n4 = this.getWidth();
        if (n3 % 2 == 1) {
            --n3;
        }
        if (n4 % 2 == 1) {
            --n4;
        }
        graphics.setColor(COLOR_BG_LINE);
        for (n = n4 / 2; n >= 0; n -= n2) {
            graphics.drawLine(n, 0, n, n3);
            graphics.drawLine(n4 - n, 0, n4 - n, n3);
        }
        for (n = n3 / 2; n >= 0; n -= n2) {
            graphics.drawLine(0, n, n4, n);
            graphics.drawLine(0, n3 - n, n4, n3 - n);
        }
    }

    void paintBackground(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    void paintPatternOnly(Graphics graphics) {
        int n = (int)((float)this.getWidth() * this._ratio);
        this._zoomRatio = (float)n / (float)this._img.getWidth();
        int n2 = (int)((float)this._img.getHeight() * this._zoomRatio);
        int n3 = this.getWidth() / 2 - n / 2;
        int n4 = this.getHeight() / 2 - n2 / 2;
        this.paintBackground(graphics);
        graphics.drawImage(this._img, n3, n4, n, n2, null);
    }

    void paintSubScreen(Graphics graphics) {
        if (this._viewX < 0 || this._viewY < 0) {
            this.paintBackground(graphics);
        }
        int n = this._viewX < 0 ? 0 : this._viewX;
        int n2 = this._viewY < 0 ? 0 : this._viewY;
        int n3 = this._viewW - (n - this._viewX);
        int n4 = this._viewH - (n2 - this._viewY);
        BufferedImage bufferedImage = this._simg.getImage();
        if (n + n3 >= bufferedImage.getWidth()) {
            n3 = bufferedImage.getWidth() - n;
        }
        if (n2 + n4 >= bufferedImage.getHeight()) {
            n4 = bufferedImage.getHeight() - n2;
        }
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(n, n2, n3, n4);
        int n5 = (int)((float)(n - this._viewX) * this._zoomRatio);
        int n6 = (int)((float)(n2 - this._viewY) * this._zoomRatio);
        int n7 = (int)((float)n3 * this._zoomRatio);
        int n8 = (int)((float)n4 * this._zoomRatio);
        graphics.drawImage(bufferedImage2, n5, n6, n7, n8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            if (this._match != null) {
                this.zoomToMatch();
                this.paintSubScreen(graphics2D);
                this.paintMatch(graphics2D);
            } else {
                this.paintPatternOnly(graphics2D);
            }
            this.paintRulers(graphics2D);
            this.paintTarget(graphics2D);
            PatternPaneTargetOffset patternPaneTargetOffset = this;
            synchronized (patternPaneTargetOffset) {
                if (this._finding) {
                    this.paintLoading(graphics2D);
                }
            }
        }
    }

    void paintLoading(Graphics2D graphics2D) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setColor(new Color(0, 0, 0, 200));
        graphics2D.fillRect(0, 0, n, n2);
        BufferedImage bufferedImage = this._loading.getFrame();
        graphics2D.drawImage(bufferedImage, null, n / 2 - bufferedImage.getWidth() / 2, n2 / 2 - bufferedImage.getHeight() / 2);
        this.repaint();
    }

    Location convertViewToScreen(Point point) {
        Location location = new Location(0, 0);
        if (this._match != null) {
            location.x = (int)((float)point.x / this._zoomRatio + (float)this._viewX);
            location.y = (int)((float)point.y / this._zoomRatio + (float)this._viewY);
        } else {
            location.x = (int)((float)(point.x - this.getWidth() / 2) / this._zoomRatio);
            location.y = (int)((float)(point.y - this.getHeight() / 2) / this._zoomRatio);
        }
        return location;
    }

    Point convertScreenToView(Location location) {
        Point point = new Point();
        if (this._match != null) {
            point.x = (int)((float)(location.x - this._viewX) * this._zoomRatio);
            point.y = (int)((float)(location.y - this._viewY) * this._zoomRatio);
        } else {
            point.x = (int)((float)(this.getWidth() / 2) + (float)location.x * this._zoomRatio);
            point.y = (int)((float)(this.getHeight() / 2) + (float)location.y * this._zoomRatio);
        }
        return point;
    }

    void paintTarget(Graphics2D graphics2D) {
        Point point = this.convertScreenToView(this._tar);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(point.x - 10, point.y + 1, point.x + 10, point.y + 1);
        graphics2D.drawLine(point.x + 1, point.y - 10, point.x + 1, point.y + 10);
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawLine(point.x - 10, point.y, point.x + 10, point.y);
        graphics2D.drawLine(point.x, point.y - 10, point.x, point.y + 10);
    }

    void paintMatch(Graphics2D graphics2D) {
        int n = (int)((float)this.getWidth() * this._ratio);
        int n2 = (int)((float)n / (float)this._img.getWidth() * (float)this._img.getHeight());
        int n3 = this.getWidth() / 2 - n / 2;
        int n4 = this.getHeight() / 2 - n2 / 2;
        Color color = PatternSimilaritySlider.getScoreColor(this._match.getScore());
        graphics2D.setColor(color);
        graphics2D.fillRect(n3, n4, n, n2);
        graphics2D.drawRect(n3, n4, n - 1, n2 - 1);
    }

    public JComponent createControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(PatternPaneTargetOffset._I("lblTargetOffsetX", new Object[0]));
        JLabel jLabel2 = new JLabel(PatternPaneTargetOffset._I("lblTargetOffsetY", new Object[0]));
        int n = this._offset != null ? this._offset.x : 0;
        int n2 = this._offset != null ? this._offset.y : 0;
        this.txtX = new JSpinner(new SpinnerNumberModel(n, -999, 999, 1));
        this.txtY = new JSpinner(new SpinnerNumberModel(n2, -999, 999, 1));
        this.txtX.addChangeListener(this);
        this.txtY.addChangeListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)this.txtX, gridBagConstraints);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jPanel.add((Component)this.txtY, gridBagConstraints);
        return jPanel;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = (Integer)this.txtX.getValue();
        int n2 = (Integer)this.txtY.getValue();
        this.setTarget(n, n2);
    }

    public Location getTargetOffset() {
        return new Location(this._offset);
    }
}

