/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;

class PatternSimilaritySlider
extends JSlider {
    final JPopupMenu pop = new JPopupMenu();
    JMenuItem item = new JMenuItem();
    private int curVal = -1;
    private JLabel lblVal = null;

    public PatternSimilaritySlider(int n, int n2, int n3, JLabel jLabel) {
        super(n, n2, n3);
        this.curVal = n3;
        this.lblVal = jLabel;
        this.init();
    }

    private void init() {
        this.showValue(this.lblVal, this.curVal);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        for (int i = 13; i < n - 13; ++i) {
            float f = (float)i / (float)(n - 26);
            graphics.setColor(PatternSimilaritySlider.getScoreColor(f));
            graphics.drawLine(i, 20, i, 30);
        }
        if (this.getValue() != this.curVal) {
            this.curVal = this.getValue();
            this.showValue(this.lblVal, this.curVal);
        }
        super.paintComponent(graphics);
    }

    public void showValue(JLabel jLabel, int n) {
        float f = n > 99 ? 0.99f : (float)n / 100.0f;
        String string = String.format("Similarity: %.2f", Float.valueOf(f));
        jLabel.setText(string);
        jLabel.repaint();
    }

    static Color getScoreColor(double d) {
        Color color = new Color(Color.HSBtoRGB(0.5f + (float)d / 2.0f, 1.0f, 1.0f));
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 20 + (int)(d * 130.0));
        return color2;
    }
}

