/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.sikuli.ide.EditorPatternButton;
import org.sikuli.ide.PatternPaneNaming;
import org.sikuli.ide.PatternPaneScreenshot;
import org.sikuli.ide.PatternPaneTargetOffset;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.ide.SikuliIDEI18N;
import org.sikuli.script.Debug;
import org.sikuli.script.FileManager;
import org.sikuli.script.Location;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.ScreenUnion;

public class PatternWindow
extends JFrame {
    private EditorPatternButton _imgBtn;
    private PatternPaneScreenshot _screenshot;
    private PatternPaneTargetOffset _tarOffsetPane;
    private PatternPaneNaming paneNaming;
    private JTabbedPane tabPane;
    private JPanel paneTarget;
    private JPanel panePreview;
    private JLabel[] msgApplied;
    private int tabSequence = 0;
    private static final int tabMax = 3;
    private ScreenImage _simg;
    private boolean dirty;

    static String _I(String string, Object ... objectArray) {
        return SikuliIDEI18N._I(string, objectArray);
    }

    public PatternWindow(EditorPatternButton editorPatternButton, boolean bl, float f, int n) {
        this.init(editorPatternButton, bl, f, n);
    }

    private void init(EditorPatternButton editorPatternButton, boolean bl, float f, int n) {
        this.setTitle(PatternWindow._I("winPatternSettings", new Object[0]));
        this.setDefaultCloseOperation(0);
        this._imgBtn = editorPatternButton;
        Point point = editorPatternButton.getLocationOnScreen();
        Debug.log((int)4, (String)("pattern window: " + point), (Object[])new Object[0]);
        this.setLocation(point.x + editorPatternButton.getWidth(), point.y);
        this.takeScreenshot();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.tabPane = new JTabbedPane();
        this.tabPane.setPreferredSize(new Dimension(790, 700));
        this.msgApplied = new JLabel[3];
        this.msgApplied[this.tabSequence] = new JLabel("...");
        this.paneNaming = new PatternPaneNaming(this._imgBtn, this.msgApplied[this.tabSequence++]);
        this.tabPane.addTab(PatternWindow._I("tabNaming", new Object[0]), this.paneNaming);
        this.msgApplied[this.tabSequence] = new JLabel("...");
        this.panePreview = this.createPreviewPanel();
        ++this.tabSequence;
        this.tabPane.addTab(PatternWindow._I("tabMatchingPreview", new Object[0]), this.panePreview);
        this.msgApplied[this.tabSequence] = new JLabel("...");
        this.paneTarget = this.createTargetPanel();
        ++this.tabSequence;
        this.tabPane.addTab(PatternWindow._I("tabTargetOffset", new Object[0]), this.paneTarget);
        container.add((Component)this.tabPane, "Center");
        container.add((Component)this.createButtons(), "South");
        container.doLayout();
        this.pack();
        try {
            this._screenshot.setParameters(this._imgBtn.getFilename(), bl, f, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setDirty(false);
        this.setVisible(true);
    }

    public void setMessageApplied(int n, boolean bl) {
        if (bl) {
            this.msgApplied[n].setText("Changes have been applied");
        } else {
            this.msgApplied[n].setText("...");
        }
    }

    public void close() {
        this._simg = null;
        this._imgBtn.resetWindow();
    }

    public JTabbedPane getTabbedPane() {
        return this.tabPane;
    }

    void takeScreenshot() {
        SikuliIDE sikuliIDE = SikuliIDE.getInstance();
        sikuliIDE.setVisible(false);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ScreenUnion screenUnion = new ScreenUnion();
        this._simg = screenUnion.getScreen().capture();
        sikuliIDE.setVisible(true);
    }

    private JPanel createPreviewPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.createScreenshots(jPanel);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this._screenshot.createControls());
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.msgApplied[this.tabSequence]);
        jPanel.doLayout();
        return jPanel;
    }

    private void createScreenshots(Container container) {
        this._screenshot = new PatternPaneScreenshot(this._simg);
        this.createMarginBox(container, this._screenshot);
    }

    private void createMarginBox(Container container, Component component) {
        container.add(Box.createVerticalStrut(10));
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        box.add(component);
        box.add(Box.createHorizontalStrut(10));
        container.add(box);
        container.add(Box.createVerticalStrut(10));
    }

    private JPanel createTargetPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this._tarOffsetPane = new PatternPaneTargetOffset(this._simg, this._imgBtn.getFilename(), this._imgBtn.getTargetOffset());
        this.createMarginBox(jPanel, this._tarOffsetPane);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this._tarOffsetPane.createControls());
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.msgApplied[this.tabSequence]);
        jPanel.doLayout();
        return jPanel;
    }

    private JComponent createButtons() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JButton jButton = new JButton(PatternWindow._I("ok", new Object[0]));
        jButton.addActionListener(new ActionOK(this));
        JButton jButton2 = new JButton(PatternWindow._I("apply", new Object[0]));
        jButton2.addActionListener(new ActionApply(this));
        JButton jButton3 = new JButton(PatternWindow._I("cancel", new Object[0]));
        jButton3.addActionListener(new ActionCancel(this));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 0, 10, 0);
        gridBagConstraints.anchor = 26;
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)jButton3, gridBagConstraints);
        return jPanel;
    }

    public void setTargetOffset(Location location) {
        if (location != null) {
            this._tarOffsetPane.setTarget(location.x, location.y);
        }
    }

    private void actionPerformedUpdates(Window window) {
        boolean bl = this.isDirty();
        if (this.paneNaming.isDirty()) {
            String string;
            int n;
            String string2 = this.paneNaming.getAbsolutePath();
            String string3 = this._imgBtn.getFilename();
            if (FileManager.exists((String)string2) && (n = JOptionPane.showConfirmDialog(window, SikuliIDEI18N._I("msgFileExists", string = FileManager.getName((String)string2)), SikuliIDEI18N._I("dlgFileExists", new Object[0]), 2, 0)) != 0) {
                return;
            }
            try {
                FileManager.xcopy((String)string3, (String)string2, null);
                new File(string3).delete();
                this._imgBtn.setFilename(string2);
            }
            catch (IOException iOException) {
                Debug.error((String)("renaming failed: " + string3 + " " + string2), (Object[])new Object[0]);
                Debug.error((String)iOException.getMessage(), (Object[])new Object[0]);
            }
            this.paneNaming.updateFilename();
            this.addDirty(true);
        }
        this.addDirty(this._imgBtn.setParameters(this._screenshot.isExact(), this._screenshot.getSimilarity(), this._screenshot.getNumMatches()));
        this.addDirty(this._imgBtn.setTargetOffset(this._tarOffsetPane.getTargetOffset()));
        Debug.log((int)2, (String)("update: " + this._imgBtn.toString()), (Object[])new Object[0]);
        if (this.isDirty() || bl) {
            int n = this._imgBtn.getWindow().getTabbedPane().getSelectedIndex();
            this._imgBtn.getWindow().setMessageApplied(n, true);
            this._imgBtn.repaint();
        }
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    private boolean setDirty(boolean bl) {
        boolean bl2 = this.dirty;
        this.dirty = bl;
        return bl2;
    }

    protected void addDirty(boolean bl) {
        this.dirty |= bl;
    }

    class ActionCancel
    implements ActionListener {
        private Window _parent;

        public ActionCancel(Window window) {
            this._parent = window;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PatternWindow.this.isDirty()) {
                PatternWindow.this._imgBtn.resetParameters();
            }
            PatternWindow.this._imgBtn.getWindow().close();
            this._parent.dispose();
        }
    }

    class ActionApply
    implements ActionListener {
        private Window _parent;

        public ActionApply(Window window) {
            this._parent = window;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PatternWindow.this.actionPerformedUpdates(this._parent);
            PatternWindow.this._imgBtn.getWindow().getTabbedPane().getSelectedComponent().transferFocus();
        }
    }

    class ActionOK
    implements ActionListener {
        private Window _parent;

        public ActionOK(JFrame jFrame) {
            this._parent = jFrame;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PatternWindow.this.actionPerformedUpdates(this._parent);
            PatternWindow.this._imgBtn.getWindow().close();
            this._parent.dispose();
            SikuliIDE.getInstance().getCurrentCodePane().setDirty(PatternWindow.this.setDirty(false));
        }
    }
}

