/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.script.Debug;

public class PreferencesUser {
    static final int yes = 1;
    static final int no = 0;
    static final int AUTO_NAMING_TIMESTAMP = 0;
    static final int AUTO_NAMING_OCR = 1;
    static final int AUTO_NAMING_OFF = 2;
    static final int HORIZONTAL = 0;
    static final int VERTICAL = 1;
    static final int UNKNOWN = -1;
    static final int NEWBEE = 0;
    static final int SCRIPTER = 1;
    static final int SIKULI_USER = 2;
    static final int THUMB_HEIGHT = 50;
    static final String DEFAULT_CONSOLE_CSS = "body   { font-family:serif; font-size: 12px; }.normal{ color: black; }.debug { color:#505000; }.info  { color: blue; }.log   { color: #09806A; }.error { color: red; }";
    static PreferencesUser _instance = null;
    Preferences pref = Preferences.userNodeForPackage(SikuliIDE.class);

    public static PreferencesUser getInstance() {
        if (_instance == null) {
            _instance = new PreferencesUser();
        }
        return _instance;
    }

    private PreferencesUser() {
        Debug.log((int)2, (String)"init user preferences", (Object[])new Object[0]);
    }

    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.pref.addPreferenceChangeListener(preferenceChangeListener);
    }

    public void setUserType(int n) {
        this.pref.putInt("USER_TYPE", n);
    }

    public int getUserType() {
        return this.pref.getInt("USER_TYPE", -1);
    }

    public void setCaptureHotkey(int n) {
        this.pref.putInt("CAPTURE_HOTKEY", n);
    }

    public int getCaptureHotkey() {
        return this.pref.getInt("CAPTURE_HOTKEY", 50);
    }

    public void setCaptureHotkeyModifiers(int n) {
        if (n < 0) {
            // empty if block
        }
        this.pref.putInt("CAPTURE_HOTKEY_MODIFIERS", n);
    }

    public int getCaptureHotkeyModifiers() {
        return this.pref.getInt("CAPTURE_HOTKEY_MODIFIERS", this.defaultCaptureHotkeyModifiers());
    }

    private int defaultCaptureHotkeyModifiers() {
        String string = System.getProperty("os.name").toLowerCase();
        int n = 5;
        if (string.startsWith("windows") || string.startsWith("linux")) {
            n = 3;
        }
        return n;
    }

    public void setCaptureDelay(double d) {
        this.pref.putDouble("CAPTURE_DELAY", d);
    }

    public double getCaptureDelay() {
        return this.pref.getDouble("CAPTURE_DELAY", 1.0);
    }

    public void setStopHotkey(int n) {
        this.pref.putInt("STOP_HOTKEY", n);
    }

    public int getStopHotkey() {
        return this.pref.getInt("STOP_HOTKEY", 67);
    }

    public void setStopHotkeyModifiers(int n) {
        this.pref.putInt("STOP_HOTKEY_MODIFIERS", n);
    }

    public int getStopHotkeyModifiers() {
        return this.pref.getInt("GET_HOTKEY_MODIFIERS", this.defaultStopHotkeyModifiers());
    }

    private int defaultStopHotkeyModifiers() {
        String string = System.getProperty("os.name").toLowerCase();
        int n = 5;
        if (string.startsWith("windows") || string.startsWith("linux")) {
            n = 9;
        }
        return n;
    }

    public void setExpandTab(boolean bl) {
        this.pref.putBoolean("EXPAND_TAB", bl);
    }

    public boolean getExpandTab() {
        return this.pref.getBoolean("EXPAND_TAB", true);
    }

    public void setTabWidth(int n) {
        this.pref.putInt("TAB_WIDTH", n);
    }

    public int getTabWidth() {
        return this.pref.getInt("TAB_WIDTH", 4);
    }

    public String getTabWhitespace() {
        if (this.getExpandTab()) {
            char[] cArray = new char[this.getTabWidth()];
            Arrays.fill(cArray, ' ');
            return new String(cArray);
        }
        return "\t";
    }

    public void setFontSize(int n) {
        this.pref.putInt("FONT_SIZE", n);
    }

    public int getFontSize() {
        return this.pref.getInt("FONT_SIZE", 18);
    }

    public void setFontName(String string) {
        this.pref.put("FONT_NAME", string);
    }

    public String getFontName() {
        return this.pref.get("FONT_NAME", "Monospaced");
    }

    public void setLocale(Locale locale) {
        this.pref.put("LOCALE", locale.toString());
    }

    public Locale getLocale() {
        String string = this.pref.get("LOCALE", Locale.getDefault().toString());
        String[] stringArray = string.split("_");
        if (stringArray.length == 1) {
            return new Locale(stringArray[0]);
        }
        if (stringArray.length == 2) {
            return new Locale(stringArray[0], stringArray[1]);
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }

    public void setAutoNamingMethod(int n) {
        this.pref.putInt("AUTO_NAMING", n);
    }

    public int getAutoNamingMethod() {
        return this.pref.getInt("AUTO_NAMING", 1);
    }

    public void setDefaultThumbHeight(int n) {
        this.pref.putInt("DEFAULT_THUMB_HEIGHT", n);
    }

    public void resetDefaultThumbHeight() {
        this.pref.putInt("DEFAULT_THUMB_HEIGHT", 50);
    }

    public int getDefaultThumbHeight() {
        return this.pref.getInt("DEFAULT_THUMB_HEIGHT", 50);
    }

    public void setPrefMoreCommandBar(boolean bl) {
        this.pref.putInt("PREF_MORE_COMMAND_BAR", bl ? 1 : 0);
    }

    public boolean getPrefMoreCommandBar() {
        return this.pref.getInt("PREF_MORE_COMMAND_BAR", 1) != 0;
    }

    public void setAutoCaptureForCmdButtons(boolean bl) {
        this.pref.putInt("AUTO_CAPTURE_FOR_CMD_BUTTONS", bl ? 1 : 0);
    }

    public boolean getAutoCaptureForCmdButtons() {
        return this.pref.getInt("AUTO_CAPTURE_FOR_CMD_BUTTONS", 1) != 0;
    }

    public void setAtSaveMakeHTML(boolean bl) {
        this.pref.putBoolean("AT_SAVE_MAKE_HTML", bl);
    }

    public boolean getAtSaveMakeHTML() {
        return this.pref.getBoolean("AT_SAVE_MAKE_HTML", false);
    }

    public void setAtSaveCleanBundle(boolean bl) {
        this.pref.putBoolean("AT_SAVE_CLEAN_BUNDLE", bl);
    }

    public boolean getAtSaveCleanBundle() {
        return this.pref.getBoolean("AT_SAVE_CLEAN_BUNDLE", true);
    }

    public void setPrefMoreRunSave(boolean bl) {
        this.pref.putBoolean("PREF_MORE_RUN_SAVE", bl);
    }

    public boolean getPrefMoreRunSave() {
        return this.pref.getBoolean("PREF_MORE_RUN_SAVE", false);
    }

    public void setPrefMoreHighlight(boolean bl) {
        this.pref.putBoolean("PREF_MORE_HIGHLIGHT", bl);
    }

    public boolean getPrefMoreHighlight() {
        return this.pref.getBoolean("PREF_MORE_HIGHLIGHT", false);
    }

    public void setCheckUpdate(boolean bl) {
        this.pref.putBoolean("CHECK_UPDATE", bl);
    }

    public boolean getCheckUpdate() {
        return this.pref.getBoolean("CHECK_UPDATE", true);
    }

    public void setLastSeenUpdate(String string) {
        this.pref.put("LAST_SEEN_UPDATE", string);
    }

    public String getLastSeenUpdate() {
        return this.pref.get("LAST_SEEN_UPDATE", "0.0");
    }

    public void setCheckUpdateTime() {
        this.pref.putLong("LAST_CHECK_UPDATE", new Date().getTime());
    }

    public long getCheckUpdateTime() {
        return this.pref.getLong("LAST_CHECK_UPDATE", new Date().getTime());
    }

    public void setIdeSize(Dimension dimension) {
        String string = (int)dimension.getWidth() + "x" + (int)dimension.getHeight();
        this.pref.put("IDE_SIZE", string);
    }

    public Dimension getIdeSize() {
        String string = this.pref.get("IDE_SIZE", "1024x700");
        String[] stringArray = string.split("x");
        return new Dimension(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
    }

    public void setIdeLocation(Point point) {
        String string = point.x + "," + point.y;
        this.pref.put("IDE_LOCATION", string);
    }

    public Point getIdeLocation() {
        String string = this.pref.get("IDE_LOCATION", "0,0");
        String[] stringArray = string.split(",");
        return new Point(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
    }

    public void setPrefMoreImageThumbs(boolean bl) {
        this.pref.putBoolean("PREF_MORE_IMAGE_THUMBS", bl);
    }

    public boolean getPrefMoreImageThumbs() {
        return this.pref.getBoolean("PREF_MORE_IMAGE_THUMBS", true);
    }

    public void setPrefMorePlainText(boolean bl) {
        this.pref.putBoolean("PREF_MORE_PLAIN_TEXT", bl);
    }

    public boolean getPrefMorePlainText() {
        return this.pref.getBoolean("PREF_MORE_PLAIN_TEXT", false);
    }

    public void setIdeSession(String string) {
        this.pref.put("IDE_SESSION", string);
    }

    public String getIdeSession() {
        return this.pref.get("IDE_SESSION", null);
    }

    public void setPrefMoreImages(boolean bl) {
        this.pref.putBoolean("PREF_MORE_IMAGES", bl);
    }

    public boolean getPrefMoreImages() {
        return this.pref.getBoolean("PREF_MORE_IMAGES", false);
    }

    public void setPrefMoreImagesPath(String string) {
        this.pref.put("PREF_MORE_IMAGES_PATH", string);
    }

    public String getPrefMoreImagesPath() {
        return this.pref.get("PREF_MORE_IMAGES_PATH", null);
    }

    public void setPrefMoreMessage(int n) {
        this.pref.putInt("PREF_MORE_MESSAGE", n);
    }

    public int getPrefMoreMessage() {
        return this.pref.getInt("PREF_MORE_MESSAGE", 0);
    }

    public void setPrefMoreLogActions(boolean bl) {
        this.pref.putBoolean("PREF_MORE_LOG_ACTIONS", bl);
    }

    public boolean getPrefMoreLogActions() {
        return this.pref.getBoolean("PREF_MORE_LOG_ACTIONS", true);
    }

    public void setPrefMoreLogInfo(boolean bl) {
        this.pref.putBoolean("PREF_MORE_LOG_INFO", bl);
    }

    public boolean getPrefMoreLogInfo() {
        return this.pref.getBoolean("PREF_MORE_LOG_INFO", true);
    }

    public void setPrefMoreLogDebug(boolean bl) {
        this.pref.putBoolean("PREF_MORE_LOG_INFO", bl);
    }

    public boolean getPrefMoreLogDebug() {
        return this.pref.getBoolean("PREF_MORE_LOG_DEBUG", true);
    }

    public void setConsoleCSS(String string) {
        this.pref.put("CONSOLE_CSS", string);
    }

    public String getConsoleCSS() {
        return this.pref.get("CONSOLE_CSS", DEFAULT_CONSOLE_CSS);
    }

    public void setPrefMoreTextSearch(boolean bl) {
        this.pref.putBoolean("PREF_MORE_TEXT_SEARCH", bl);
    }

    public boolean getPrefMoreTextSearch() {
        return this.pref.getBoolean("PREF_MORE_TEXT_SEARCH", false);
    }

    public void setPrefMoreTextOCR(boolean bl) {
        this.pref.putBoolean("PREF_MORE_TEXT_OCR", bl);
    }

    public boolean getPrefMoreTextOCR() {
        return this.pref.getBoolean("PREF_MORE_TEXT_OCR", false);
    }

    public void put(String string, String string2) {
        this.pref.put(string, string2);
    }

    public String get(String string, String string2) {
        return this.pref.get(string, string2);
    }

    public void setDefaults(int n) {
        if (0 == n) {
            this.setCaptureHotkey(50);
            this.setCaptureHotkeyModifiers(this.defaultCaptureHotkeyModifiers());
            this.setCaptureDelay(1.0);
        }
        this.setStopHotkey(67);
        this.setStopHotkeyModifiers(this.defaultStopHotkeyModifiers());
        if (0 == n) {
            this.setExpandTab(true);
            this.setTabWidth(4);
        }
        if (0 == n) {
            this.setFontSize(14);
            this.setFontName("Monospaced");
        }
        if (0 == n) {
            this.setLocale(Locale.getDefault());
        }
        if (0 == n) {
            this.setAutoNamingMethod(0);
        }
        if (this.getPrefMoreImageThumbs()) {
            this.setDefaultThumbHeight(50);
        } else {
            this.setDefaultThumbHeight(0);
        }
        if (0 == n) {
            this.setPrefMoreCommandBar(true);
            this.setAutoCaptureForCmdButtons(true);
        } else {
            this.setPrefMoreCommandBar(false);
        }
        if (0 == n) {
            this.setAtSaveMakeHTML(true);
        } else {
            this.setAtSaveMakeHTML(false);
        }
        this.setAtSaveCleanBundle(true);
        this.setPrefMoreRunSave(false);
        this.setPrefMoreHighlight(false);
        this.setCheckUpdate(false);
        this.setLastSeenUpdate("0.0");
        this.setCheckUpdateTime();
        if (0 == n) {
            this.setIdeSize(new Dimension(0, 0));
            this.setIdeLocation(new Point(0, 0));
        }
        this.setPrefMoreImages(false);
        this.setPrefMoreImagesPath("");
        if (0 == n) {
            this.setPrefMoreMessage(0);
        } else {
            this.setPrefMoreMessage(1);
        }
        this.setPrefMoreLogActions(true);
        this.setPrefMoreLogInfo(true);
        this.setPrefMoreLogDebug(true);
        this.setConsoleCSS(DEFAULT_CONSOLE_CSS);
        this.setPrefMoreTextSearch(false);
        this.setPrefMoreTextOCR(false);
    }
}

