/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Element;
import org.jdesktop.layout.GroupLayout;
import org.sikuli.ide.EditorPane;
import org.sikuli.ide.LocaleListCellRenderer;
import org.sikuli.ide.PreferencesUser;
import org.sikuli.ide.PreferencesWindowMore;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.ide.SikuliIDEI18N;
import org.sikuli.ide.util.Utils;
import org.sikuli.script.Debug;
import org.sikuli.script.Settings;

public class PreferencesWin
extends JFrame {
    PreferencesUser pref = PreferencesUser.getInstance();
    private boolean isInitialized = false;
    int cap_hkey;
    int cap_mod;
    int old_cap_hkey;
    int old_cap_mod;
    Font _oldFont;
    String _oldFontName;
    int _oldFontSize;
    private double _delay;
    private int _old_cap_hkey;
    private int _old_cap_mod;
    private int _autoNamingMethod;
    private boolean _chkAutoUpdate;
    private boolean _chkExpandTab;
    private int _spnTabWidth;
    Locale _locale;
    EditorPane codePane;
    JFrame winPrefMore;
    boolean isDirty = false;
    private JTabbedPane _tabPane;
    private JTextField _txtHotkey;
    private JLabel _lblHotkey;
    private JLabel _lblDelay;
    private JSpinner spnDelay;
    private JLabel _lblDelaySecs;
    private JLabel _lblNaming;
    private JRadioButton _radTimestamp;
    private JRadioButton _radOCR;
    private JRadioButton _radOff;
    private JPanel _paneTextEditing;
    private JCheckBox chkExpandTab;
    private JLabel _lblTabWidth;
    private JComboBox _cmbFontName;
    private JLabel _lblFont;
    private JLabel _titleAppearance;
    private JLabel _titleIndentation;
    private JSpinner spnTabWidth;
    private JLabel _lblFontSize;
    private JSpinner _spnFontSize;
    private JCheckBox chkAutoUpdate;
    private JComboBox _cmbLang;
    private JLabel _lblUpdates;
    private JLabel _lblLanguage;
    private JButton _btnOk;
    private JButton _btnApply;
    private JButton _btnCancel;
    private JButton _btnMore;

    public PreferencesWin() {
        this.setTitle(SikuliIDE._I("winPreferences", new Object[0]));
        this.initComponents();
        this.loadPrefs();
        this.isInitialized = true;
    }

    private void initComponents() {
        DefaultComponentFactory defaultComponentFactory = DefaultComponentFactory.getInstance();
        this._tabPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        this._txtHotkey = new JTextField();
        this._lblHotkey = new JLabel();
        this._lblDelay = new JLabel();
        this.spnDelay = new JSpinner();
        this._lblDelaySecs = new JLabel();
        this._lblNaming = new JLabel();
        this._radTimestamp = new JRadioButton();
        this._radOCR = new JRadioButton();
        this._radOff = new JRadioButton();
        this._paneTextEditing = new JPanel();
        this.chkExpandTab = new JCheckBox();
        this._lblTabWidth = new JLabel();
        this._cmbFontName = new JComboBox();
        this._lblFont = new JLabel();
        this._titleAppearance = defaultComponentFactory.createTitle("");
        this._titleIndentation = defaultComponentFactory.createTitle("");
        this.spnTabWidth = new JSpinner();
        this._lblFontSize = new JLabel();
        this._spnFontSize = new JSpinner();
        JPanel jPanel2 = new JPanel();
        this.chkAutoUpdate = new JCheckBox();
        this._cmbLang = new JComboBox();
        this._lblUpdates = new JLabel();
        this._lblLanguage = new JLabel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel(null);
        this._btnOk = new JButton();
        this._btnApply = new JButton();
        this._btnCancel = new JButton();
        this._btnMore = new JButton();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this._tabPane.setBorder(new EmptyBorder(10, 10, 0, 10));
        this._txtHotkey.setHorizontalAlignment(4);
        this._txtHotkey.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                PreferencesWin.this.txtHotkeyFocusGained(focusEvent);
            }
        });
        this._txtHotkey.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                PreferencesWin.this.txtHotkeyKeyPressed(keyEvent);
            }
        });
        this._lblHotkey.setLabelFor(this._txtHotkey);
        this._lblDelay.setLabelFor(this.spnDelay);
        this.spnDelay.setModel(new SpinnerNumberModel((Number)1.0, Double.valueOf(0.0), null, (Number)0.1));
        this._radTimestamp.setSelected(true);
        Object object = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)object);
        object.setHorizontalGroup((GroupLayout.Group)object.createParallelGroup().add((GroupLayout.Group)object.createSequentialGroup().add(26, 26, 26).add((GroupLayout.Group)object.createParallelGroup().add(2, (Component)this._lblDelay).add(2, (Component)this._lblHotkey).add(2, (Component)this._lblNaming)).addPreferredGap(0).add((GroupLayout.Group)object.createParallelGroup().add((Component)this._radTimestamp).add((Component)this._radOCR).add((Component)this._radOff).add((GroupLayout.Group)object.createSequentialGroup().add((Component)this.spnDelay, -1, 148, Short.MAX_VALUE).addPreferredGap(0).add((Component)this._lblDelaySecs, -1, 161, Short.MAX_VALUE)).add((Component)this._txtHotkey, -1, 315, Short.MAX_VALUE)).add(69, 69, 69)));
        object.setVerticalGroup((GroupLayout.Group)object.createParallelGroup().add((GroupLayout.Group)object.createSequentialGroup().add(34, 34, 34).add((GroupLayout.Group)object.createParallelGroup(3).add((Component)this._lblHotkey, -2, 22, -2).add((Component)this._txtHotkey, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)object.createParallelGroup().add((Component)this._lblDelay, -2, 28, -2).add((Component)this.spnDelay, -2, -1, -2).add((Component)this._lblDelaySecs, -2, 28, -2)).addPreferredGap(0).add((GroupLayout.Group)object.createParallelGroup(1, false).add((GroupLayout.Group)object.createSequentialGroup().add((GroupLayout.Group)object.createParallelGroup(3).add((Component)this._lblNaming, -2, 22, -2).add((Component)this._radTimestamp)).add(18, 18, 18).add((Component)this._radOff).addPreferredGap(0)).add(2, (GroupLayout.Group)object.createSequentialGroup().add((Component)this._radOCR).add(21, 21, 21))).add(80, 80, 80)));
        this._tabPane.addTab(SikuliIDEI18N._I("prefTabScreenCapturing", new Object[0]), jPanel);
        this._lblTabWidth.setLabelFor(this.spnTabWidth);
        this._cmbFontName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PreferencesWin.this.fontNameItemStateChanged(itemEvent);
            }
        });
        this._lblFont.setLabelFor(this._cmbFontName);
        this._lblFontSize.setLabelFor(this._spnFontSize);
        this._spnFontSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PreferencesWin.this.fontSizeStateChanged(changeEvent);
            }
        });
        object = new GroupLayout((Container)this._paneTextEditing);
        this._paneTextEditing.setLayout((LayoutManager)object);
        object.setHorizontalGroup((GroupLayout.Group)object.createParallelGroup().add(2, (GroupLayout.Group)object.createSequentialGroup().add(95, 95, 95).add((GroupLayout.Group)object.createParallelGroup().add((Component)this._titleIndentation, -2, -1, -2).add((GroupLayout.Group)object.createSequentialGroup().add((Component)this._titleAppearance, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)object.createParallelGroup().add((GroupLayout.Group)object.createSequentialGroup().add(29, 29, 29).add((GroupLayout.Group)object.createParallelGroup().add(2, (Component)this._lblTabWidth).add(2, (Component)this._lblFont).add(2, (Component)this._lblFontSize)).addPreferredGap(0).add((GroupLayout.Group)object.createParallelGroup().add((Component)this._cmbFontName, 0, 218, Short.MAX_VALUE).add((Component)this._spnFontSize, -2, 67, -2).add((Component)this.spnTabWidth, -2, 52, -2)).addPreferredGap(0, 97, Short.MAX_VALUE)).add((Component)this.chkExpandTab, -1, 420, Short.MAX_VALUE)))).addContainerGap()));
        object.setVerticalGroup((GroupLayout.Group)object.createParallelGroup().add((GroupLayout.Group)object.createSequentialGroup().add(21, 21, 21).add((Component)this._titleIndentation, -2, -1, -2).add((GroupLayout.Group)object.createParallelGroup().add((GroupLayout.Group)object.createSequentialGroup().add(81, 81, 81).add((Component)this._titleAppearance, -2, -1, -2)).add((GroupLayout.Group)object.createSequentialGroup().addPreferredGap(0).add((Component)this.chkExpandTab).addPreferredGap(0).add((GroupLayout.Group)object.createParallelGroup().add((Component)this._lblTabWidth, -2, 16, -2).add((Component)this.spnTabWidth, -2, -1, -2)).add(40, 40, 40).add((GroupLayout.Group)object.createParallelGroup(3).add((Component)this._lblFont).add((Component)this._cmbFontName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)object.createParallelGroup(2).add((Component)this._lblFontSize, -2, 27, -2).add((Component)this._spnFontSize, -2, -1, -2)))).addContainerGap(154, Short.MAX_VALUE)));
        object.linkSize(new Component[]{this._lblTabWidth, this.spnTabWidth}, 2);
        object.linkSize(new Component[]{this._cmbFontName, this._lblFont}, 2);
        this._tabPane.addTab(SikuliIDEI18N._I("PreferencesWin.paneTextEditing.tab.title", new Object[0]), this._paneTextEditing);
        this._lblUpdates.setFont(this._lblUpdates.getFont().deriveFont(this._lblUpdates.getFont().getStyle() | 1));
        this._lblLanguage.setFont(this._lblLanguage.getFont().deriveFont(this._lblLanguage.getFont().getStyle() | 1));
        object = new GroupLayout((Container)jPanel2);
        jPanel2.setLayout((LayoutManager)object);
        object.setHorizontalGroup((GroupLayout.Group)object.createParallelGroup().add((GroupLayout.Group)object.createSequentialGroup().add(137, 137, 137).add((GroupLayout.Group)object.createParallelGroup().add((GroupLayout.Group)object.createSequentialGroup().add((Component)this._lblLanguage).add(185, 185, 185)).add((GroupLayout.Group)object.createSequentialGroup().add(38, 38, 38).add((Component)this._cmbLang, -2, 215, -2)).add((GroupLayout.Group)object.createSequentialGroup().add((Component)this._lblUpdates).add(318, 318, 318)).add(2, (GroupLayout.Group)object.createSequentialGroup().add(38, 38, 38).add((Component)this.chkAutoUpdate, -1, 376, Short.MAX_VALUE))).addContainerGap()));
        object.setVerticalGroup((GroupLayout.Group)object.createParallelGroup().add((GroupLayout.Group)object.createSequentialGroup().add(26, 26, 26).add((Component)this._lblUpdates).addPreferredGap(0).add((Component)this.chkAutoUpdate).add(40, 40, 40).add((Component)this._lblLanguage).addPreferredGap(0).add((Component)this._cmbLang, -2, -1, -2).addContainerGap(196, Short.MAX_VALUE)));
        this._tabPane.addTab(SikuliIDEI18N._I("prefTabGeneralSettings", new Object[0]), jPanel2);
        container.add((Component)this._tabPane, "Center");
        jPanel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jPanel4);
        this._btnMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesWin.this.btnMoreActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this._btnMore);
        this._btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesWin.this.btnOkActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this._btnOk);
        this._btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesWin.this.btnApplyActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this._btnApply);
        this._btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesWin.this.btnCancelActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this._btnCancel);
        container.add((Component)jPanel3, "South");
        this.setSize(600, 475);
        this.setLocationRelativeTo(this.getOwner());
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this._radTimestamp);
        ((ButtonGroup)object).add(this._radOCR);
        ((ButtonGroup)object).add(this._radOff);
        this.initComponentsI18n();
    }

    private void initComponentsI18n() {
        DefaultComponentFactory.setTextAndMnemonic(this._titleAppearance, SikuliIDEI18N._I("PreferencesWin.titleAppearance.textWithMnemonic", new Object[0]));
        DefaultComponentFactory.setTextAndMnemonic(this._titleIndentation, SikuliIDEI18N._I("PreferencesWin.titleIndentation.textWithMnemonic", new Object[0]));
        this._lblHotkey.setText(SikuliIDEI18N._I("prefCaptureHotkey", new Object[0]));
        this._lblDelay.setText(SikuliIDEI18N._I("prefCaptureDelay", new Object[0]));
        this._lblDelaySecs.setText(SikuliIDEI18N._I("prefSeconds", new Object[0]));
        this._lblNaming.setText(SikuliIDEI18N._I("prefAutoNaming", new Object[0]));
        this._radTimestamp.setText(SikuliIDEI18N._I("prefTimestamp", new Object[0]));
        this._radOCR.setText(SikuliIDEI18N._I("prefRecognizedText", new Object[0]));
        this._radOff.setText(SikuliIDEI18N._I("prefManualInput", new Object[0]));
        this._tabPane.setTitleAt(0, SikuliIDEI18N._I("prefTabScreenCapturing", new Object[0]));
        this.chkExpandTab.setText(SikuliIDEI18N._I("PreferencesWin.chkExpandTab.text", new Object[0]));
        this._lblTabWidth.setText(SikuliIDEI18N._I("PreferencesWin.lblTabWidth.text", new Object[0]));
        this._lblFont.setText(SikuliIDEI18N._I("PreferencesWin.lblFont.text", new Object[0]));
        this._lblFontSize.setText(SikuliIDEI18N._I("PreferencesWin.lblFontSize.text", new Object[0]));
        this._tabPane.setTitleAt(1, SikuliIDEI18N._I("PreferencesWin.paneTextEditing.tab.title", new Object[0]));
        this.chkAutoUpdate.setText(SikuliIDEI18N._I("prefGeneralAutoCheck", new Object[0]));
        this._lblUpdates.setText(SikuliIDEI18N._I("PreferencesWin.lblUpdates.text", new Object[0]));
        this._lblLanguage.setText(SikuliIDEI18N._I("PreferencesWin.lblLanguage.text", new Object[0]));
        this._tabPane.setTitleAt(2, SikuliIDEI18N._I("prefTabGeneralSettings", new Object[0]));
        this._btnMore.setText(SikuliIDEI18N._I("more", new Object[0]));
        this._btnOk.setText(SikuliIDEI18N._I("ok", new Object[0]));
        this._btnApply.setText(SikuliIDEI18N._I("apply", new Object[0]));
        this._btnCancel.setText(SikuliIDEI18N._I("cancel", new Object[0]));
    }

    private void loadPrefs() {
        SikuliIDE sikuliIDE = SikuliIDE.getInstance();
        this._delay = this.pref.getCaptureDelay();
        this.spnDelay.setValue(this._delay);
        this.old_cap_hkey = this.cap_hkey = this.pref.getCaptureHotkey();
        this._old_cap_hkey = this.cap_hkey;
        this.old_cap_mod = this.cap_mod = this.pref.getCaptureHotkeyModifiers();
        this._old_cap_mod = this.cap_mod;
        this.setTxtHotkey(this.cap_hkey, this.cap_mod);
        this._autoNamingMethod = this.pref.getAutoNamingMethod();
        switch (this._autoNamingMethod) {
            case 0: {
                this._radTimestamp.setSelected(true);
                break;
            }
            case 1: {
                this._radOCR.setSelected(true);
                break;
            }
            case 2: {
                this._radOff.setSelected(true);
                break;
            }
            default: {
                Debug.error((String)"Error in reading auto naming method preferences", (Object[])new Object[0]);
            }
        }
        this._chkAutoUpdate = this.pref.getCheckUpdate();
        this.chkAutoUpdate.setSelected(this._chkAutoUpdate);
        this._chkExpandTab = this.pref.getExpandTab();
        this.chkExpandTab.setSelected(this._chkExpandTab);
        this._spnTabWidth = this.pref.getTabWidth();
        this.spnTabWidth.setValue(this._spnTabWidth);
        this.initFontPrefs();
        this.initLangPrefs();
        this.codePane = sikuliIDE.getCurrentCodePane();
        if (this.codePane != null) {
            this._oldFont = this.codePane.getFont();
        } else {
            this._oldFontName = this.pref.getFontName();
            this._oldFontSize = this.pref.getFontSize();
        }
        this._locale = this.pref.getLocale();
    }

    private void savePrefs() {
        SikuliIDE sikuliIDE = SikuliIDE.getInstance();
        this.pref.setCaptureDelay((Double)this.spnDelay.getValue());
        this.pref.setCaptureHotkey(this.cap_hkey);
        this.pref.setCaptureHotkeyModifiers(this.cap_mod);
        this.pref.setAutoNamingMethod(this._radTimestamp.isSelected() ? 0 : (this._radOCR.isSelected() ? 1 : 2));
        if (this.old_cap_hkey != this.cap_hkey || this.old_cap_mod != this.cap_mod) {
            sikuliIDE.removeCaptureHotkey(this.old_cap_hkey, this.old_cap_mod);
            sikuliIDE.installCaptureHotkey(this.cap_hkey, this.cap_mod);
        }
        this.pref.setCheckUpdate(this.chkAutoUpdate.isSelected());
        this.pref.setExpandTab(this.chkExpandTab.isSelected());
        this.pref.setTabWidth((Integer)this.spnTabWidth.getValue());
        this.pref.setFontName((String)this._cmbFontName.getSelectedItem());
        this.pref.setFontSize((Integer)this._spnFontSize.getValue());
        Locale locale = (Locale)this._cmbLang.getSelectedItem();
        this.pref.setLocale(locale);
        SikuliIDEI18N.setLocale(locale);
        this.isDirty = true;
    }

    private void resetPrefs() {
        SikuliIDE sikuliIDE = SikuliIDE.getInstance();
        this.pref.setCaptureDelay(this._delay);
        this.pref.setCaptureHotkey(this._old_cap_hkey);
        this.pref.setCaptureHotkeyModifiers(this._old_cap_mod);
        if (this.old_cap_hkey != this._old_cap_hkey || this.old_cap_mod != this._old_cap_mod) {
            sikuliIDE.removeCaptureHotkey(this.old_cap_hkey, this.old_cap_mod);
            sikuliIDE.installCaptureHotkey(this._old_cap_hkey, this.old_cap_mod);
        }
        this.pref.setAutoNamingMethod(this._autoNamingMethod);
        this.pref.setCheckUpdate(this._chkAutoUpdate);
        this.pref.setExpandTab(this._chkExpandTab);
        this.pref.setTabWidth(this._spnTabWidth);
        if (this.codePane == null) {
            this.pref.setFontName(this._oldFontName);
            this.pref.setFontSize(this._oldFontSize);
        } else {
            this.pref.setFontName(this._oldFont.getFontName());
            this.pref.setFontSize(this._oldFont.getSize());
            this.codePane.setFont(this._oldFont);
        }
        this.pref.setLocale(this._locale);
        SikuliIDEI18N.setLocale(this._locale);
    }

    private void initFontPrefs() {
        String[] stringArray;
        for (String string : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            this._cmbFontName.addItem(string);
        }
        this._cmbFontName.setSelectedItem(this.pref.getFontName());
        this._spnFontSize.setValue(this.pref.getFontSize());
    }

    private void initLangPrefs() {
        String[] stringArray = new String[]{"es", "pt_BR", "ar", "fr", "ru", "bg", "he", "sv", "ca", "ja", "tr", "da", "ko", "uk", "de", "nl", "zh_CN", "en_US", "pl", "zh_TW"};
        Locale[] localeArray = new Locale[stringArray.length];
        int n = 0;
        for (String object : stringArray) {
            Locale locale;
            if (object.indexOf("_") >= 0) {
                String[] stringArray2 = object.split("_");
                locale = new Locale(stringArray2[0], stringArray2[1]);
            } else {
                locale = new Locale(object);
            }
            localeArray[n++] = locale;
        }
        Arrays.sort(localeArray, new Comparator<Locale>(){

            @Override
            public int compare(Locale locale, Locale locale2) {
                return locale.getDisplayLanguage().compareTo(locale2.getDisplayLanguage());
            }
        });
        for (Locale locale : localeArray) {
            this._cmbLang.addItem(locale);
        }
        this._cmbLang.setRenderer(new LocaleListCellRenderer());
        Object object = this.pref.getLocale();
        this._cmbLang.setSelectedItem(object);
        if (!this._cmbLang.getSelectedItem().equals(object)) {
            if (((Locale)object).getVariant().length() > 0) {
                object = new Locale(((Locale)object).getLanguage(), ((Locale)object).getCountry());
                this._cmbLang.setSelectedItem(object);
            }
            if (!this._cmbLang.getSelectedItem().equals(object)) {
                this._cmbLang.setSelectedItem(new Locale(((Locale)object).getLanguage()));
            }
        }
    }

    private void btnMoreActionPerformed(ActionEvent actionEvent) {
        this.winPrefMore = new JFrame("Preferences: more Options ...");
        Container container = this.winPrefMore.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)new PreferencesWindowMore(), "Center");
        this.winPrefMore.pack();
        this.winPrefMore.setAlwaysOnTop(true);
        this.winPrefMore.setDefaultCloseOperation(2);
        if (Settings.isJava7()) {
            this.winPrefMore.setLocation(this.getLocation().x - 70, this.getLocation().y);
        } else {
            this.winPrefMore.setLocation(this.getLocation().x + this.getWidth() + 10, this.getLocation().y);
        }
        this.winPrefMore.setVisible(true);
    }

    private void btnOkActionPerformed(ActionEvent actionEvent) {
        this.savePrefs();
        String string = "Until some bugs have been fixed,\nyou should restart the IDE now!\n(except for most options in [more options ...])\nOtherwise you might notice strange behavior ;-)\n--- but only if you have made any changes!\n\nUse CANCEL next time, if nothing was changed!";
        JOptionPane.showMessageDialog(this, string, "--- Preferences have been saved ---", 2);
        if (this.winPrefMore != null) {
            this.winPrefMore.dispose();
        }
        this.dispose();
    }

    private void btnApplyActionPerformed(ActionEvent actionEvent) {
        this.savePrefs();
    }

    private void btnCancelActionPerformed(ActionEvent actionEvent) {
        if (this.isDirty) {
            this.resetPrefs();
        }
        if (this.winPrefMore != null) {
            this.winPrefMore.dispose();
        }
        this.dispose();
    }

    private void setTxtHotkey(int n, int n2) {
        this.cap_hkey = n;
        this.cap_mod = n2;
        this._txtHotkey.setText(Utils.convertKeyToText(n, n2));
    }

    private void txtHotkeyFocusGained(FocusEvent focusEvent) {
        this._txtHotkey.setEditable(true);
    }

    private void txtHotkeyKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        Debug.log((int)7, (String)("" + n + " " + n2), (Object[])new Object[0]);
        this.setTxtHotkey(n, n2);
        this._txtHotkey.setEditable(false);
    }

    private void updateFontPreview() {
        if (!this.isInitialized || this.codePane == null) {
            return;
        }
        SikuliIDE sikuliIDE = SikuliIDE.getInstance();
        Font font = new Font((String)this._cmbFontName.getSelectedItem(), 0, (Integer)this._spnFontSize.getValue());
        try {
            Element element = this.codePane.getDocument().getDefaultRootElement();
            this.codePane.jumpTo(element.getElementIndex(this.codePane.getCaretPosition()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.codePane.setFont(font);
        this.isDirty = true;
    }

    private void fontNameItemStateChanged(ItemEvent itemEvent) {
        this.updateFontPreview();
    }

    private void fontSizeStateChanged(ChangeEvent changeEvent) {
        this.updateFontPreview();
    }
}

