/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import com.explodingpixels.macwidgets.MacUtils;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.commons.cli.CommandLine;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXSearchField;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.sikuli.ide.AquaCloseableTabbedPaneUI;
import org.sikuli.ide.ButtonCapture;
import org.sikuli.ide.ButtonGenCommand;
import org.sikuli.ide.ButtonOnToolbar;
import org.sikuli.ide.CloseableTabbedPane;
import org.sikuli.ide.CloseableTabbedPaneListener;
import org.sikuli.ide.EditorConsolePane;
import org.sikuli.ide.EditorKit;
import org.sikuli.ide.EditorLineNumberView;
import org.sikuli.ide.EditorPane;
import org.sikuli.ide.EditorPatternButton;
import org.sikuli.ide.EditorRegionButton;
import org.sikuli.ide.EditorUndoManager;
import org.sikuli.ide.NativeLayer;
import org.sikuli.ide.PreferencesUser;
import org.sikuli.ide.PreferencesWin;
import org.sikuli.ide.SikuliIDEFileChooser;
import org.sikuli.ide.SikuliIDEI18N;
import org.sikuli.ide.SikuliIDESettings;
import org.sikuli.ide.SikuliIDEStatusBar;
import org.sikuli.ide.extmanager.ExtensionManagerFrame;
import org.sikuli.ide.util.Utils;
import org.sikuli.ide.z_notused.sikuli_test.UnitTestRunner;
import org.sikuli.script.CommandArgs;
import org.sikuli.script.Debug;
import org.sikuli.script.EventObserver;
import org.sikuli.script.EventSubject;
import org.sikuli.script.FileManager;
import org.sikuli.script.HotkeyEvent;
import org.sikuli.script.HotkeyListener;
import org.sikuli.script.HotkeyManager;
import org.sikuli.script.Location;
import org.sikuli.script.OverlayCapturePrompt;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;
import org.sikuli.script.SikuliScript;
import org.sikuli.script.SikuliScriptRunner;
import org.sikuli.utility.AutoUpdater;

public class SikuliIDE
extends JFrame {
    static final boolean ENABLE_UNIFIED_TOOLBAR = true;
    static final Color COLOR_SEARCH_FAILED = Color.red;
    static final Color COLOR_SEARCH_NORMAL = Color.black;
    static final int WARNING_CANCEL = 2;
    static final int WARNING_ACCEPTED = 1;
    static final int WARNING_DO_NOTHING = 0;
    static boolean _runningSkl = false;
    private static NativeLayer _native;
    private Dimension _windowSize = null;
    private Point _windowLocation = null;
    private boolean smallScreen = false;
    private int commandBarHeight = 800;
    private CloseableTabbedPane _mainPane;
    private EditorLineNumberView lineNumberColumn;
    private JSplitPane _mainSplitPane;
    private JTabbedPane msgPane;
    private boolean msgPaneCollapsed = false;
    private EditorConsolePane _console;
    private JXCollapsiblePane _cmdList;
    private SikuliIDEStatusBar _status = null;
    private ButtonCapture _btnCapture;
    private ButtonRun _btnRun;
    private ButtonRun _btnRunViz;
    private boolean ideIsRunningScript = false;
    private JXSearchField _searchField;
    private JMenuBar _menuBar = new JMenuBar();
    private JMenu _fileMenu = new JMenu(SikuliIDE._I("menuFile", new Object[0]));
    private JMenu _editMenu = new JMenu(SikuliIDE._I("menuEdit", new Object[0]));
    private UndoAction _undoAction = new UndoAction();
    private RedoAction _redoAction = new RedoAction();
    private FindAction _findHelper;
    private JMenu _runMenu = new JMenu(SikuliIDE._I("menuRun", new Object[0]));
    private JMenu _viewMenu = new JMenu(SikuliIDE._I("menuView", new Object[0]));
    private JMenu _toolMenu = new JMenu(SikuliIDE._I("menuTool", new Object[0]));
    private JMenu _helpMenu = new JMenu(SikuliIDE._I("menuHelp", new Object[0]));
    private JXCollapsiblePane _sidePane;
    private JPanel _unitPane;
    private JCheckBoxMenuItem _chkShowUnitTest;
    private JMenuItem chkShowCmdList = null;
    private JCheckBoxMenuItem chkShowThumbs;
    private UnitTestRunner _testRunner;
    private static CommandLine _cmdLine;
    private static boolean _useStderr;
    private static SikuliIDE _instance;
    private static Icon PY_SRC_ICON;
    private boolean _inited = false;
    private static boolean runMe;
    private int restoredScripts = 0;
    private int alreadyOpenedTab = -1;
    private static final String NL;
    private Pattern pFile = Pattern.compile("File..(.*?\\.py).*?,.*?line.*?(\\d+),.*?in(.*?)" + NL + "(.*?)" + NL);
    private int errorLine;
    private int errorColumn;
    private String errorType;
    private String errorText;
    private int errorClass;
    private String errorTrace;
    private static final int PY_SYNTAX = 0;
    private static final int PY_RUNTIME = 1;
    private static final int PY_JAVA = 2;
    private static final int PY_UNKNOWN = -1;
    private PreferencesUser prefs;

    public static String _I(String string, Object ... objectArray) {
        try {
            return SikuliIDEI18N._I(string, objectArray);
        }
        catch (Exception exception) {
            System.out.println("[I18N] " + string);
            return string;
        }
    }

    public static void errorMsg(String string) {
        if (_useStderr) {
            System.err.println(string);
        } else {
            JOptionPane.showMessageDialog(null, string);
        }
    }

    public static ImageIcon getIconResource(String string) {
        URL uRL = SikuliIDE.class.getResource(string);
        if (uRL == null) {
            Debug.error((String)("Warning: could not load \"" + string + "\" icon"), (Object[])new Object[0]);
            return null;
        }
        return new ImageIcon(uRL);
    }

    public static void main(String[] stringArray) {
        Settings.showJavaInfo();
        CommandArgs commandArgs = new CommandArgs("IDE");
        _cmdLine = commandArgs.getCommandLine(stringArray);
        boolean bl = false;
        if (_cmdLine.hasOption("h")) {
            commandArgs.printHelp();
            return;
        }
        if (_cmdLine.hasOption("test")) {
            Debug.error((String)"Test no longer supported! See docs for alternatives", (Object[])new Object[0]);
            return;
        }
        if (_cmdLine.hasOption("s")) {
            _useStderr = true;
        }
        if (_cmdLine.hasOption("load")) {
            bl = true;
            Debug.error((String)"Option -load: not yet working", (Object[])new Object[0]);
            return;
        }
        if (!bl && stringArray != null && stringArray.length >= 1) {
            int n = 0;
            String string = stringArray[0];
            if (!string.startsWith("-") && string.endsWith(".skl")) {
                String string2 = FileManager.unzipSKL((String)string);
                if (string2 != null) {
                    stringArray[0] = string2;
                    _runningSkl = true;
                } else {
                    System.exit(-2);
                }
                Debug.error((String)"Sikuli IDE is no longer used to run scripts from command line\nThis is delegated now to sikuli-script.jar\nLook into the docs for more information on command line usage", (Object[])new Object[0]);
                try {
                    SikuliScript.main((String[])stringArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!_runningSkl) {
                    System.exit(n);
                } else {
                    return;
                }
            }
        }
        Settings.setArgs((String[])CommandArgs.getPyArgs((CommandLine)_cmdLine));
        SikuliIDE.initNativeLayer();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (Settings.isMac()) {
            _native.initApp();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        SikuliIDE.getInstance(stringArray);
    }

    protected SikuliIDE(String[] stringArray) {
        super("Sikuli IDE");
        this.initSikuliIDE(stringArray);
    }

    private void initSikuliIDE(String[] stringArray) {
        Debug.log((int)5, (String)("create SikuliIDE " + stringArray), (Object[])new Object[0]);
        this.prefs = PreferencesUser.getInstance();
        if (this.prefs.getUserType() < 0) {
            this.prefs.setUserType(0);
            this.prefs.setIdeSession("");
            this.prefs.setDefaults(this.prefs.getUserType());
        }
        _native.initIDE(this);
        this._windowSize = this.prefs.getIdeSize();
        this._windowLocation = this.prefs.getIdeLocation();
        Rectangle rectangle = new Location(this._windowLocation).getScreen().getRect();
        if (this._windowSize.width == 0 || this._windowSize.width > rectangle.width || this._windowSize.height > rectangle.height || new Location(this._windowLocation).getScreenContaining(false) == null) {
            if (rectangle.width < 1025) {
                this._windowSize = new Dimension(1024, 700);
                this._windowLocation = new Point(0, 0);
            } else {
                this._windowSize = new Dimension(rectangle.width - 150, rectangle.height - 100);
                this._windowLocation = new Point(75, 0);
            }
        }
        if (this._windowSize.getHeight() < (double)this.commandBarHeight) {
            this.smallScreen = true;
        }
        this.setSize(this._windowSize);
        this.setLocation(this._windowLocation);
        this.initMenuBars(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.initTabPane();
        this.initMsgPane(this.prefs.getPrefMoreMessage() == 0);
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        jPanel.add((Component)this._mainPane, "Center");
        this._mainSplitPane = this.prefs.getPrefMoreMessage() == 1 ? new JSplitPane(1, jPanel, this.msgPane) : new JSplitPane(0, jPanel, this.msgPane);
        this._mainSplitPane.setResizeWeight(0.6);
        this._mainSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        JComponent jComponent = this.createCommandPane();
        if (PreferencesUser.getInstance().getPrefMoreCommandBar()) {
            jPanel2.add((Component)jComponent, "West");
        }
        jPanel2.add((Component)this._mainSplitPane, "Center");
        container.add((Component)jPanel2, "Center");
        JToolBar jToolBar = this.initToolbar();
        container.add((Component)jToolBar, "North");
        container.add((Component)this.initStatusbar(), "South");
        container.doLayout();
        this.initShortcutKeys();
        this.initHotkeys();
        this.setDefaultCloseOperation(3);
        this.initWindowListener();
        this.initTooltip();
        this.restoreSession();
        this.autoCheckUpdate();
        if (this._mainPane.getTabCount() == 0) {
            new FileAction().doNew(null);
        }
        this._inited = true;
        this.getCurrentCodePane().requestFocus();
        this.setVisible(true);
        this._mainSplitPane.setDividerLocation(0.6);
    }

    public static synchronized SikuliIDE getInstance(String[] stringArray) {
        if (_instance == null) {
            _instance = new SikuliIDE(stringArray);
        }
        return _instance;
    }

    public static synchronized SikuliIDE getInstance() {
        return SikuliIDE.getInstance(null);
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(SikuliIDESettings.SikuliVersion + " - " + string);
    }

    private static void initNativeLayer() {
        String string = "unknown";
        if (Settings.isWindows()) {
            string = "Windows";
        } else if (Settings.isMac()) {
            string = "Mac";
        } else if (Settings.isLinux()) {
            string = "Linux";
        }
        String string2 = "org.sikuli.ide.NativeLayerFor" + string;
        try {
            Class<?> clazz = Class.forName(string2);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            _native = (NativeLayer)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean saveSession(int n, boolean bl) {
        int n2 = this._mainPane.getTabCount();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n2; ++i) {
            try {
                File file;
                JScrollPane jScrollPane = (JScrollPane)this._mainPane.getComponentAt(i);
                EditorPane editorPane = (EditorPane)jScrollPane.getViewport().getView();
                if (n == 0) {
                    if (bl) {
                        editorPane.setDirty(false);
                        if (editorPane.isSourceBundleTemp()) {
                            FileManager.deleteTempDir((String)editorPane.getSrcBundle());
                        }
                    }
                    if (editorPane.getCurrentFilename() == null) {
                        continue;
                    }
                } else if (editorPane.isDirty() && !new FileAction().doSaveIntern(i)) {
                    if (!bl) continue;
                    editorPane.setDirty(false);
                    continue;
                }
                if ((file = editorPane.getCurrentFile()) == null) continue;
                String string = editorPane.getSrcBundle();
                Debug.log((int)5, (String)("save session: " + string), (Object[])new Object[0]);
                if (i != 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(string);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        PreferencesUser.getInstance().setIdeSession(stringBuilder.toString());
        return true;
    }

    private void restoreSession() {
        String string = PreferencesUser.getInstance().getIdeSession();
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            Debug.log((int)5, (String)("restore session: " + stringArray[i]), (Object[])new Object[0]);
            File file = new File(stringArray[i]);
            if (!file.exists() || !this.loadFile(stringArray[i])) continue;
            ++this.restoredScripts;
        }
    }

    public CloseableTabbedPane getTabPane() {
        return this._mainPane;
    }

    public EditorPane getCurrentCodePane() {
        if (this._mainPane.getSelectedIndex() == -1) {
            return null;
        }
        JScrollPane jScrollPane = (JScrollPane)this._mainPane.getSelectedComponent();
        EditorPane editorPane = (EditorPane)jScrollPane.getViewport().getView();
        return editorPane;
    }

    public void setCurrentFileTabTitle(String string) {
        int n = this._mainPane.getSelectedIndex();
        this.setFileTabTitle(string, n);
    }

    public String getCurrentFileTabTitle() {
        String string = this._mainPane.getTitleAt(this._mainPane.getSelectedIndex());
        if (string.startsWith("*")) {
            return string.substring(1);
        }
        return string;
    }

    public void setFileTabTitle(String string, int n) {
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string.substring(string.lastIndexOf("/") + 1);
        string = string.substring(0, string.lastIndexOf("."));
        this._mainPane.setTitleAt(n, string);
        this.setTitle(string);
    }

    public void setCurrentFileTabTitleDirty(boolean bl) {
        int n = this._mainPane.getSelectedIndex();
        String string = this._mainPane.getTitleAt(n);
        if (!bl && string.startsWith("*")) {
            string = string.substring(1);
            this._mainPane.setTitleAt(n, string);
        } else if (bl && !string.startsWith("*")) {
            string = "*" + string;
            this._mainPane.setTitleAt(n, string);
        }
    }

    public boolean loadFile(String string) {
        new FileAction().doNew(null);
        try {
            this.setCurrentFileTabTitle(string);
            this.getCurrentCodePane().loadFile(string);
            return true;
        }
        catch (IOException iOException) {
            Debug.error((String)("Can't load file " + string), (Object[])new Object[0]);
            Debug.error((String)iOException.getMessage(), (Object[])new Object[0]);
            return false;
        }
    }

    @Deprecated
    public String getCurrentFilename() {
        EditorPane editorPane = this.getCurrentCodePane();
        String string = editorPane.getCurrentFile().getAbsolutePath();
        return string;
    }

    public ArrayList<String> getOpenedFilenames() {
        int n = this._mainPane.getTabCount();
        File file = null;
        ArrayList<String> arrayList = new ArrayList<String>(0);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                JScrollPane jScrollPane = (JScrollPane)this._mainPane.getComponentAt(i);
                EditorPane editorPane = (EditorPane)jScrollPane.getViewport().getView();
                file = editorPane.getCurrentFile();
                if (file != null) {
                    String string = Utils.slashify(file.getAbsolutePath(), false);
                    string = string.substring(0, string.lastIndexOf("/"));
                    arrayList.add(string);
                    continue;
                }
                arrayList.add("");
            }
        }
        return arrayList;
    }

    public int isAlreadyOpen(String string) {
        this.alreadyOpenedTab = this.getOpenedFilenames().indexOf(string);
        return this.alreadyOpenedTab;
    }

    private void autoCheckUpdate() {
        PreferencesUser preferencesUser = PreferencesUser.getInstance();
        if (!preferencesUser.getCheckUpdate()) {
            return;
        }
        long l = preferencesUser.getCheckUpdateTime();
        long l2 = new Date().getTime();
        if (l2 - l > 86400000L) {
            Debug.log((int)3, (String)"autocheck update", (Object[])new Object[0]);
            new HelpAction().checkUpdate(true);
        }
        preferencesUser.setCheckUpdateTime();
    }

    public boolean isRunningScript() {
        return this.ideIsRunningScript;
    }

    public void setIsRunningScript(boolean bl) {
        this.ideIsRunningScript = bl;
    }

    protected boolean doBeforeRun() {
        if (this.checkDirtyPanes()) {
            int n;
            if (this.prefs.getPrefMoreRunSave()) {
                n = 1;
            } else {
                n = this.askForSaveAll("Run");
                if (n < 0) {
                    return false;
                }
            }
            this.saveSession(n, false);
        }
        Settings.ActionLogs = this.prefs.getPrefMoreLogActions();
        Settings.DebugLogs = this.prefs.getPrefMoreLogDebug();
        Settings.InfoLogs = this.prefs.getPrefMoreLogInfo();
        Settings.Highlight = this.prefs.getPrefMoreHighlight();
        Settings.OcrTextSearch = this.prefs.getPrefMoreTextSearch();
        Settings.OcrTextRead = this.prefs.getPrefMoreTextOCR();
        return true;
    }

    protected boolean doBeforeQuit() {
        if (this.checkDirtyPanes()) {
            int n = this.askForSaveAll("Quit");
            if (n < 0) {
                return false;
            }
            return this.saveSession(n, true);
        }
        return this.saveSession(0, true);
    }

    private int askForSaveAll(String string) {
        Object[] objectArray;
        String string2 = "Some scripts are not saved yet!";
        String string3 = SikuliIDEI18N._I("dlgAskCloseTab", new Object[0]);
        int n = JOptionPane.showOptionDialog(this, string2, string3, 0, 2, null, objectArray = new String[]{string + " immediately", "Save all and " + string, SikuliIDEI18N._I("cancel", new Object[0])}, objectArray[2]);
        if (n == 2 || n == -1) {
            return -1;
        }
        return n;
    }

    public boolean isInited() {
        return this._inited;
    }

    private JMenuItem createMenuItem(JMenuItem jMenuItem, KeyStroke keyStroke, ActionListener actionListener) {
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    private JMenuItem createMenuItem(String string, KeyStroke keyStroke, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        return this.createMenuItem(jMenuItem, keyStroke, actionListener);
    }

    private void initFileMenu() throws NoSuchMethodException {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._fileMenu.setMnemonic(70);
        this._fileMenu.add(this.createMenuItem(SikuliIDE._I("menuFileNew", new Object[0]), KeyStroke.getKeyStroke(78, n), (ActionListener)new FileAction("doNew")));
        this._fileMenu.add(this.createMenuItem(SikuliIDE._I("menuFileOpen", new Object[0]), KeyStroke.getKeyStroke(79, n), (ActionListener)new FileAction("doLoad")));
        this._fileMenu.add(this.createMenuItem(SikuliIDE._I("menuFileSave", new Object[0]), KeyStroke.getKeyStroke(83, n), (ActionListener)new FileAction("doSave")));
        this._fileMenu.add(this.createMenuItem(SikuliIDE._I("menuFileSaveAs", new Object[0]), KeyStroke.getKeyStroke(83, 1 | n), (ActionListener)new FileAction("doSaveAs")));
        this._fileMenu.add(this.createMenuItem(SikuliIDE._I("menuFileExport", new Object[0]), KeyStroke.getKeyStroke(69, 1 | n), (ActionListener)new FileAction("doExport")));
        this._fileMenu.add(this.createMenuItem(SikuliIDE._I("menuFileCloseTab", new Object[0]), KeyStroke.getKeyStroke(87, n), (ActionListener)new FileAction("doCloseTab")));
        if (!Settings.isMac()) {
            this._fileMenu.addSeparator();
            this._fileMenu.add(this.createMenuItem(SikuliIDE._I("menuFilePreferences", new Object[0]), KeyStroke.getKeyStroke(80, n), (ActionListener)new FileAction("doPreferences")));
        }
        if (!Settings.isMac()) {
            this._fileMenu.addSeparator();
            this._fileMenu.add(this.createMenuItem(SikuliIDE._I("menuFileQuit", new Object[0]), null, (ActionListener)new FileAction("doQuit")));
        }
    }

    public void showPreferencesWindow() {
        PreferencesWin preferencesWin = new PreferencesWin();
        preferencesWin.setAlwaysOnTop(true);
        preferencesWin.setDefaultCloseOperation(0);
        if (!Settings.isJava7()) {
            preferencesWin.setLocation(SikuliIDE.getInstance().getLocation());
        }
        preferencesWin.setVisible(true);
    }

    public boolean closeCurrentTab() {
        EditorPane editorPane = this.getCurrentCodePane();
        new FileAction().doCloseTab(null);
        return editorPane != this.getCurrentCodePane();
    }

    protected boolean quit() {
        SikuliIDE sikuliIDE = SikuliIDE.getInstance();
        new FileAction().doQuit(null);
        return sikuliIDE.getCurrentCodePane() == null;
    }

    protected boolean checkDirtyPanes() {
        for (int i = 0; i < this._mainPane.getTabCount(); ++i) {
            try {
                JScrollPane jScrollPane = (JScrollPane)this._mainPane.getComponentAt(i);
                EditorPane editorPane = (EditorPane)jScrollPane.getViewport().getView();
                if (!editorPane.isDirty()) continue;
                return true;
            }
            catch (Exception exception) {
                Debug.error((String)("checkDirtyPanes: " + exception.getMessage()), (Object[])new Object[0]);
            }
        }
        return false;
    }

    private void initEditMenu() throws NoSuchMethodException {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._editMenu.setMnemonic(69);
        JMenuItem jMenuItem = this._editMenu.add(this._undoAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, n));
        JMenuItem jMenuItem2 = this._editMenu.add(this._redoAction);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(90, n | 1));
        this._editMenu.addSeparator();
        this._editMenu.add(this.createMenuItem(SikuliIDE._I("menuEditCut", new Object[0]), KeyStroke.getKeyStroke(88, n), (ActionListener)new EditAction("doCut")));
        this._editMenu.add(this.createMenuItem(SikuliIDE._I("menuEditCopy", new Object[0]), KeyStroke.getKeyStroke(67, n), (ActionListener)new EditAction("doCopy")));
        this._editMenu.add(this.createMenuItem(SikuliIDE._I("menuEditPaste", new Object[0]), KeyStroke.getKeyStroke(86, n), (ActionListener)new EditAction("doPaste")));
        this._editMenu.add(this.createMenuItem(SikuliIDE._I("menuEditSelectAll", new Object[0]), KeyStroke.getKeyStroke(65, n), (ActionListener)new EditAction("doSelectAll")));
        this._editMenu.addSeparator();
        JMenu jMenu = new JMenu(SikuliIDE._I("menuFind", new Object[0]));
        this._findHelper = new FindAction();
        jMenu.setMnemonic(70);
        jMenu.add(this.createMenuItem(SikuliIDE._I("menuFindFind", new Object[0]), KeyStroke.getKeyStroke(70, n), (ActionListener)new FindAction("doFind")));
        jMenu.add(this.createMenuItem(SikuliIDE._I("menuFindFindNext", new Object[0]), KeyStroke.getKeyStroke(71, n), (ActionListener)new FindAction("doFindNext")));
        jMenu.add(this.createMenuItem(SikuliIDE._I("menuFindFindPrev", new Object[0]), KeyStroke.getKeyStroke(71, n | 1), (ActionListener)new FindAction("doFindPrev")));
        this._editMenu.add(jMenu);
        this._editMenu.addSeparator();
        this._editMenu.add(this.createMenuItem(SikuliIDE._I("menuEditIndent", new Object[0]), KeyStroke.getKeyStroke(9, 0), (ActionListener)new EditAction("doIndent")));
        this._editMenu.add(this.createMenuItem(SikuliIDE._I("menuEditUnIndent", new Object[0]), KeyStroke.getKeyStroke(9, 1), (ActionListener)new EditAction("doUnindent")));
    }

    public void updateUndoRedoStates() {
        this._undoAction.updateUndoState();
        this._redoAction.updateRedoState();
    }

    private void initRunMenu() throws NoSuchMethodException {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._runMenu.setMnemonic(82);
        this._runMenu.add(this.createMenuItem(SikuliIDE._I("menuRunRun", new Object[0]), KeyStroke.getKeyStroke(82, n), (ActionListener)new RunAction("run")));
        this._runMenu.add(this.createMenuItem(SikuliIDE._I("menuRunRunAndShowActions", new Object[0]), KeyStroke.getKeyStroke(82, 8 | n), (ActionListener)new RunAction("runShowActions")));
        PreferencesUser preferencesUser = PreferencesUser.getInstance();
        JMenuItem jMenuItem = this.createMenuItem(SikuliIDE._I("menuRunStop", new Object[0]), KeyStroke.getKeyStroke(preferencesUser.getStopHotkey(), preferencesUser.getStopHotkeyModifiers()), (ActionListener)new RunAction("runShowActions"));
        jMenuItem.setEnabled(false);
        this._runMenu.add(jMenuItem);
    }

    private void initViewMenu() throws NoSuchMethodException {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._viewMenu.setMnemonic(86);
        if (this.prefs.getPrefMoreCommandBar()) {
            this.chkShowCmdList = new JCheckBoxMenuItem(SikuliIDE._I("menuViewCommandList", new Object[0]), true);
            this._viewMenu.add(this.createMenuItem(this.chkShowCmdList, KeyStroke.getKeyStroke(76, n), (ActionListener)new ViewAction("toggleCmdList")));
        }
        this.chkShowThumbs = new JCheckBoxMenuItem(SikuliIDE._I("menuShowThumbs", new Object[0]), false);
        this._viewMenu.add(this.createMenuItem(this.chkShowThumbs, KeyStroke.getKeyStroke(84, n), (ActionListener)new ViewAction("toggleShowThumbs")));
    }

    private void initToolMenu() throws NoSuchMethodException {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._toolMenu.setMnemonic(84);
        if (Settings.SikuliRepo != null) {
            this._toolMenu.add(this.createMenuItem(SikuliIDE._I("menuToolExtensions", new Object[0]), null, (ActionListener)new ToolAction("extensions")));
        }
    }

    public void showExtensionsFrame() {
        String string = "You might proceed, if you\n- have some programming skills\n- read the docs about extensions\n- know what you are doing\n\nOtherwise you should press Cancel!";
        String string2 = "Need your attention!";
        Object[] objectArray = new String[]{"OK", "Be quiet!", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, string, string2, 0, 2, null, objectArray, objectArray[2]);
        if (n == 2 || n == -1) {
            return;
        }
        if (n == 1) {
            // empty if block
        }
        ExtensionManagerFrame extensionManagerFrame = ExtensionManagerFrame.getInstance();
        extensionManagerFrame.setVisible(true);
    }

    private void initHelpMenu() throws NoSuchMethodException {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._helpMenu.setMnemonic(72);
        this._helpMenu.add(this.createMenuItem(SikuliIDE._I("menuHelpQuickStart", new Object[0]), null, (ActionListener)new HelpAction("openQuickStart")));
        this._helpMenu.addSeparator();
        this._helpMenu.add(this.createMenuItem(SikuliIDE._I("menuHelpGuide", new Object[0]), null, (ActionListener)new HelpAction("openDoc")));
        this._helpMenu.add(this.createMenuItem(SikuliIDE._I("menuHelpDocumentations", new Object[0]), null, (ActionListener)new HelpAction("openTutor")));
        this._helpMenu.add(this.createMenuItem(SikuliIDE._I("menuHelpFAQ", new Object[0]), null, (ActionListener)new HelpAction("openFAQ")));
        this._helpMenu.add(this.createMenuItem(SikuliIDE._I("menuHelpAsk", new Object[0]), null, (ActionListener)new HelpAction("openAsk")));
        this._helpMenu.add(this.createMenuItem(SikuliIDE._I("menuHelpBugReport", new Object[0]), null, (ActionListener)new HelpAction("openBugReport")));
        this._helpMenu.add(this.createMenuItem(SikuliIDE._I("menuHelpTranslation", new Object[0]), null, (ActionListener)new HelpAction("openTranslation")));
        this._helpMenu.addSeparator();
        this._helpMenu.add(this.createMenuItem(SikuliIDE._I("menuHelpHomepage", new Object[0]), null, (ActionListener)new HelpAction("openHomepage")));
        this._helpMenu.addSeparator();
        this._helpMenu.add(this.createMenuItem(SikuliIDE._I("menuHelpCheckUpdate", new Object[0]), null, (ActionListener)new HelpAction("doCheckUpdate")));
    }

    private void initMenuBars(JFrame jFrame) {
        try {
            this.initFileMenu();
            this.initEditMenu();
            this.initRunMenu();
            this.initViewMenu();
            this.initToolMenu();
            this.initHelpMenu();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        this._menuBar.add(this._fileMenu);
        this._menuBar.add(this._editMenu);
        this._menuBar.add(this._runMenu);
        this._menuBar.add(this._viewMenu);
        this._menuBar.add(this._toolMenu);
        this._menuBar.add(this._helpMenu);
        jFrame.setJMenuBar(this._menuBar);
    }

    private String[] getCommandCategories() {
        String[] stringArray = new String[]{SikuliIDE._I("cmdListFind", new Object[0]), SikuliIDE._I("cmdListMouse", new Object[0]), SikuliIDE._I("cmdListKeyboard", new Object[0]), SikuliIDE._I("cmdListObserver", new Object[0])};
        return stringArray;
    }

    private String[][] getCommandsOnToolbar() {
        String[][] stringArray = new String[][]{{"find"}, {"PATTERN"}, {SikuliIDE._I("cmdFind", new Object[0])}, {"findAll"}, {"PATTERN"}, {SikuliIDE._I("cmdFindAll", new Object[0])}, {"wait"}, {"PATTERN", "[timeout]"}, {SikuliIDE._I("cmdWait", new Object[0])}, {"waitVanish"}, {"PATTERN", "[timeout]"}, {SikuliIDE._I("cmdWaitVanish", new Object[0])}, {"exists"}, {"PATTERN", "[timeout]"}, {SikuliIDE._I("cmdExists", new Object[0])}, {"----"}, new String[0], new String[0], {"click"}, {"PATTERN", "[modifiers]"}, {SikuliIDE._I("cmdClick", new Object[0])}, {"doubleClick"}, {"PATTERN", "[modifiers]"}, {SikuliIDE._I("cmdDoubleClick", new Object[0])}, {"rightClick"}, {"PATTERN", "[modifiers]"}, {SikuliIDE._I("cmdRightClick", new Object[0])}, {"hover"}, {"PATTERN"}, {SikuliIDE._I("cmdHover", new Object[0])}, {"dragDrop"}, {"PATTERN", "PATTERN", "[modifiers]"}, {SikuliIDE._I("cmdDragDrop", new Object[0])}, {"----"}, new String[0], new String[0], {"type"}, {"_text", "[modifiers]"}, {SikuliIDE._I("cmdType", new Object[0])}, {"type"}, {"PATTERN", "_text", "[modifiers]"}, {SikuliIDE._I("cmdType2", new Object[0])}, {"paste"}, {"_text", "[modifiers]"}, {SikuliIDE._I("cmdPaste", new Object[0])}, {"paste"}, {"PATTERN", "_text", "[modifiers]"}, {SikuliIDE._I("cmdPaste2", new Object[0])}, {"----"}, new String[0], new String[0], {"onAppear"}, {"PATTERN", "_hnd"}, {SikuliIDE._I("cmdOnAppear", new Object[0])}, {"onVanish"}, {"PATTERN", "_hnd"}, {SikuliIDE._I("cmdOnVanish", new Object[0])}, {"onChange"}, {"_hnd"}, {SikuliIDE._I("cmdOnChange", new Object[0])}, {"observe"}, {"[time]", "[background]"}, {SikuliIDE._I("cmdObserve", new Object[0])}};
        return stringArray;
    }

    private JComponent createCommandPane() {
        JXTaskPaneContainer jXTaskPaneContainer = new JXTaskPaneContainer();
        PreferencesUser preferencesUser = PreferencesUser.getInstance();
        JCheckBox jCheckBox = new JCheckBox(SikuliIDE._I("cmdListAutoCapture", new Object[0]), preferencesUser.getAutoCaptureForCmdButtons());
        jCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = ((JCheckBox)changeEvent.getSource()).isSelected();
                PreferencesUser preferencesUser = PreferencesUser.getInstance();
                preferencesUser.setAutoCaptureForCmdButtons(bl);
            }
        });
        JXTaskPane jXTaskPane = new JXTaskPane();
        jXTaskPane.setTitle(SikuliIDE._I("cmdListSettings", new Object[0]));
        jXTaskPane.add((Component)jCheckBox);
        jXTaskPane.setCollapsed(true);
        jXTaskPaneContainer.add(jXTaskPane);
        int n = 0;
        JXTaskPane jXTaskPane2 = new JXTaskPane();
        jXTaskPane2.setTitle(this.getCommandCategories()[n++]);
        jXTaskPaneContainer.add(jXTaskPane2);
        String[][] stringArray = this.getCommandsOnToolbar();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i++][0];
            String[] stringArray2 = stringArray[i++];
            String[] stringArray3 = stringArray[i];
            if (string.equals("----")) {
                boolean bl = n == 2;
                if (n == 3) {
                    if (this.prefs.getUserType() == 0) break;
                    bl = true;
                }
                jXTaskPane2 = new JXTaskPane();
                jXTaskPane2.setTitle(this.getCommandCategories()[n++]);
                jXTaskPaneContainer.add(jXTaskPane2);
                jXTaskPane2.setCollapsed(bl);
                continue;
            }
            jXTaskPane2.add((Component)new ButtonGenCommand(string, stringArray3[0], stringArray2));
        }
        Dimension dimension = jXTaskPaneContainer.getSize();
        jXTaskPaneContainer.setPreferredSize(new Dimension(250, 1000));
        this._cmdList = new JXCollapsiblePane(JXCollapsiblePane.Direction.LEFT);
        this._cmdList.setMinimumSize(new Dimension(0, 0));
        this._cmdList.add((Component)new JScrollPane((Component)jXTaskPaneContainer));
        this._cmdList.setCollapsed(false);
        return this._cmdList;
    }

    private JToolBar initCmdToolbar() {
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.add(this.createCommandPane());
        return jToolBar;
    }

    private JToolBar initToolbar() {
        MacUtils.makeWindowLeopardStyle((JRootPane)this.getRootPane());
        JToolBar jToolBar = new JToolBar();
        ButtonInsertImage buttonInsertImage = new ButtonInsertImage();
        this._btnCapture = new ButtonCapture();
        ButtonSubregion buttonSubregion = new ButtonSubregion();
        jToolBar.add(this._btnCapture);
        jToolBar.add(buttonInsertImage);
        jToolBar.add(buttonSubregion);
        jToolBar.add(Box.createHorizontalGlue());
        this._btnRun = new ButtonRun();
        jToolBar.add(this._btnRun);
        this._btnRunViz = new ButtonRunViz();
        jToolBar.add(this._btnRunViz);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(this.createSearchField());
        jToolBar.add(Box.createRigidArea(new Dimension(7, 0)));
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    public String getCurrentBundlePath() {
        EditorPane editorPane = this.getCurrentCodePane();
        return editorPane.getSrcBundle();
    }

    private JComponent createSearchField() {
        this._searchField = new JXSearchField("Find");
        this._searchField.setUseNativeSearchFieldIfPossible(true);
        this._searchField.setMinimumSize(new Dimension(220, 30));
        this._searchField.setPreferredSize(new Dimension(220, 30));
        this._searchField.setMaximumSize(new Dimension(380, 30));
        this._searchField.setMargin(new Insets(0, 3, 0, 3));
        this._searchField.setCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SikuliIDE.this.getCurrentCodePane().requestFocus();
                SikuliIDE.this._findHelper.setFailed(false);
            }
        });
        this._searchField.setFindAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Settings.isLinux()) {
                    SikuliIDE.this._searchField.selectAll();
                }
                boolean bl = SikuliIDE.this._findHelper.findNext(SikuliIDE.this._searchField.getText());
                SikuliIDE.this._findHelper.setFailed(!bl);
            }
        });
        this._searchField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                boolean bl;
                if (keyEvent.getKeyCode() == 10) {
                    if (!Settings.isLinux()) {
                        SikuliIDE.this._searchField.selectAll();
                    }
                    bl = SikuliIDE.this._findHelper.findNext(SikuliIDE.this._searchField.getText());
                } else {
                    bl = SikuliIDE.this._findHelper.findStr(SikuliIDE.this._searchField.getText());
                }
                SikuliIDE.this._findHelper.setFailed(!bl);
            }
        });
        return this._searchField;
    }

    private void initTabPane() {
        this._mainPane = new CloseableTabbedPane();
        this._mainPane.setUI(new AquaCloseableTabbedPaneUI());
        this._mainPane.addCloseableTabbedPaneListener(new CloseableTabbedPaneListener(){

            @Override
            public boolean closeTab(int n) {
                try {
                    JScrollPane jScrollPane = (JScrollPane)SikuliIDE.this._mainPane.getComponentAt(n);
                    EditorPane editorPane = (EditorPane)jScrollPane.getViewport().getView();
                    int n2 = SikuliIDE.this._mainPane.getComponentCount();
                    Debug.log((int)8, (String)("close tab " + n + " n:" + SikuliIDE.this._mainPane.getComponentCount()), (Object[])new Object[0]);
                    boolean bl = editorPane.close();
                    Debug.log((int)8, (String)("after close tab n:" + SikuliIDE.this._mainPane.getComponentCount()), (Object[])new Object[0]);
                    if (bl && SikuliIDE.this._mainPane.getTabCount() < 2) {
                        new FileAction().doNew(null);
                    }
                    return bl;
                }
                catch (Exception exception) {
                    Debug.info((String)("Can't close this tab: " + exception.getStackTrace()), (Object[])new Object[0]);
                    exception.printStackTrace();
                    return false;
                }
            }
        });
        this._mainPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                if (n >= 0) {
                    SikuliIDE.this.setTitle(jTabbedPane.getTitleAt(n));
                    SikuliIDE.this.chkShowThumbs.setState(SikuliIDE.this.getCurrentCodePane().showThumbs);
                }
                SikuliIDE.this.updateUndoRedoStates();
            }
        });
    }

    private void initMsgPane(boolean bl) {
        this.msgPane = new JTabbedPane();
        this._console = new EditorConsolePane();
        this.msgPane.addTab(SikuliIDE._I("paneMessage", new Object[0]), this._console);
        if (Settings.isWindows() || Settings.isLinux()) {
            this.msgPane.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        }
        this.msgPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                if (SikuliIDE.this.msgPaneCollapsed) {
                    SikuliIDE.this._mainSplitPane.setDividerLocation(SikuliIDE.this._mainSplitPane.getLastDividerLocation());
                    SikuliIDE.this.msgPaneCollapsed = false;
                } else {
                    int n = SikuliIDE.this._mainSplitPane.getWidth() - 35;
                    if (SikuliIDE.this.prefs.getPrefMoreMessage() == 0) {
                        n = SikuliIDE.this._mainSplitPane.getHeight() - 35;
                    }
                    SikuliIDE.this._mainSplitPane.setDividerLocation(n);
                    SikuliIDE.this.msgPaneCollapsed = true;
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
    }

    public Container getMsgPane() {
        return this.msgPane;
    }

    private SikuliIDEStatusBar initStatusbar() {
        this._status = new SikuliIDEStatusBar();
        return this._status;
    }

    public static SikuliIDEStatusBar getStatusbar() {
        if (_instance == null) {
            return null;
        }
        return SikuliIDE._instance._status;
    }

    private void initWindowListener() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SikuliIDE.this.quit();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PreferencesUser.getInstance().setIdeSize(SikuliIDE.this.getSize());
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                PreferencesUser.getInstance().setIdeLocation(SikuliIDE.this.getLocation());
            }
        });
    }

    private void initTooltip() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setDismissDelay(30000);
    }

    private void nextTab() {
        int n = this._mainPane.getSelectedIndex();
        int n2 = (n + 1) % this._mainPane.getTabCount();
        this._mainPane.setSelectedIndex(n2);
    }

    private void prevTab() {
        int n = this._mainPane.getSelectedIndex();
        int n2 = (n - 1 + this._mainPane.getTabCount()) % this._mainPane.getTabCount();
        this._mainPane.setSelectedIndex(n2);
    }

    private void initShortcutKeys() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            private boolean isKeyNextTab(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9 && keyEvent.getModifiers() == 2) {
                    return true;
                }
                return keyEvent.getKeyCode() == 93 && keyEvent.getModifiers() == 5;
            }

            private boolean isKeyPrevTab(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9 && keyEvent.getModifiers() == 3) {
                    return true;
                }
                return keyEvent.getKeyCode() == 91 && keyEvent.getModifiers() == 5;
            }

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                if (keyEvent.getID() == 401) {
                    if (this.isKeyNextTab(keyEvent)) {
                        SikuliIDE.this.nextTab();
                    } else if (this.isKeyPrevTab(keyEvent)) {
                        SikuliIDE.this.prevTab();
                    }
                }
            }
        }, 8L);
    }

    public void removeCaptureHotkey(int n, int n2) {
        HotkeyManager.getInstance()._removeHotkey(n, n2);
    }

    public void installCaptureHotkey(int n, int n2) {
        HotkeyManager.getInstance()._addHotkey(n, n2, new HotkeyListener(){

            public void hotkeyPressed(HotkeyEvent hotkeyEvent) {
                if (!SikuliIDE.getInstance().isRunningScript()) {
                    SikuliIDE.this.onQuickCapture();
                }
            }
        });
    }

    public void onQuickCapture() {
        this.onQuickCapture(null);
    }

    public void onQuickCapture(String string) {
        Debug.log((int)2, (String)"QuickCapture", (Object[])new Object[0]);
        this._btnCapture.capture(0);
    }

    public void removeStopHotkey(int n, int n2) {
        HotkeyManager.getInstance()._removeHotkey(n, n2);
    }

    public void installStopHotkey(int n, int n2) {
        HotkeyManager.getInstance()._addHotkey(n, n2, new HotkeyListener(){

            public void hotkeyPressed(HotkeyEvent hotkeyEvent) {
                SikuliIDE.this.onStopRunning();
            }
        });
    }

    public void onStopRunning() {
        Debug.log((int)2, (String)"StopRunning", (Object[])new Object[0]);
        this.setVisible(true);
        this._btnRun.stopRunning();
        this._btnRunViz.stopRunning();
    }

    private void initHotkeys() {
        PreferencesUser preferencesUser = PreferencesUser.getInstance();
        int n = preferencesUser.getCaptureHotkey();
        int n2 = preferencesUser.getCaptureHotkeyModifiers();
        this.installCaptureHotkey(n, n2);
        n = preferencesUser.getStopHotkey();
        n2 = preferencesUser.getStopHotkeyModifiers();
        this.installStopHotkey(n, n2);
    }

    private void initSidePane() {
        this.initUnitPane();
        this._sidePane = new JXCollapsiblePane(JXCollapsiblePane.Direction.RIGHT);
        this._sidePane.setMinimumSize(new Dimension(0, 0));
        CloseableTabbedPane closeableTabbedPane = new CloseableTabbedPane();
        this._sidePane.getContentPane().add(closeableTabbedPane);
        closeableTabbedPane.setMinimumSize(new Dimension(0, 0));
        closeableTabbedPane.addTab(SikuliIDE._I("tabUnitTest", new Object[0]), this._unitPane);
        closeableTabbedPane.addCloseableTabbedPaneListener(new CloseableTabbedPaneListener(){

            @Override
            public boolean closeTab(int n) {
                SikuliIDE.this._sidePane.setCollapsed(true);
                SikuliIDE.this._chkShowUnitTest.setState(false);
                return false;
            }
        });
        this._sidePane.setCollapsed(true);
    }

    private void initUnitPane() {
        this._testRunner = new UnitTestRunner();
        this._unitPane = this._testRunner.getPanel();
        this._chkShowUnitTest.setState(false);
        this.addAuxTab(SikuliIDE._I("paneTestTrace", new Object[0]), this._testRunner.getTracePane());
    }

    public void addAuxTab(String string, JComponent jComponent) {
        this.msgPane.addTab(string, jComponent);
    }

    public void jumpTo(String string) throws BadLocationException {
        EditorPane editorPane = SikuliIDE.getInstance().getCurrentCodePane();
        editorPane.jumpTo(string);
        editorPane.grabFocus();
    }

    public void jumpTo(int n) throws BadLocationException {
        EditorPane editorPane = SikuliIDE.getInstance().getCurrentCodePane();
        editorPane.jumpTo(n);
        editorPane.grabFocus();
    }

    static {
        _useStderr = false;
        _instance = null;
        PY_SRC_ICON = SikuliIDE.getIconResource("/icons/py-src-16x16.png");
        runMe = false;
        NL = String.format("%n", new Object[0]);
    }

    class ButtonRecord
    extends JToggleButton
    implements ActionListener {
        public ButtonRecord() {
            URL uRL = SikuliIDE.class.getResource("/icons/record.png");
            this.setIcon(new ImageIcon(uRL));
            this.setMaximumSize(new Dimension(26, 26));
            this.setBorderPainted(false);
            this.setToolTipText("Record");
            this.addActionListener(this);
        }

        private void initSikuliGenerator() {
        }

        public void startSikuliGenerator() {
            try {
                String[] stringArray = new String[]{"/tmp/sikuli-video.mov", "/tmp/sikuli-event.log"};
                Class<?> clazz = Class.forName("SikuliGenerator");
                Class[] classArray = new Class[]{String[].class, EditorPane.class};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                constructor.newInstance(stringArray, SikuliIDE.this.getCurrentCodePane());
            }
            catch (Exception exception) {
                Debug.error((String)"Error in starting up SikuliGenerator...", (Object[])new Object[0]);
                exception.printStackTrace();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.getModel().isSelected()) {
                Debug.info((String)"start recording", (Object[])new Object[0]);
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        Utils.runRecorder();
                        Debug.info((String)"recording completed", (Object[])new Object[0]);
                        ButtonRecord.this.getModel().setSelected(false);
                        ButtonRecord.this.startSikuliGenerator();
                    }
                };
                thread.start();
            } else {
                Debug.info((String)"stop recording...", (Object[])new Object[0]);
                Utils.stopRecorder();
            }
        }
    }

    class ButtonRunViz
    extends ButtonRun {
        public ButtonRunViz() {
            URL uRL = SikuliIDE.class.getResource("/icons/run_big_yl.png");
            this.setIcon(new ImageIcon(uRL));
            this.setToolTipText(SikuliIDE._I("menuRunRunAndShowActions", new Object[0]));
            this.setText(SikuliIDE._I("btnRunSlowMotionLabel", new Object[0]));
        }

        @Override
        protected void addPythonCode(SikuliScriptRunner sikuliScriptRunner) {
            sikuliScriptRunner.runSlowMotion();
        }
    }

    class ButtonRun
    extends ButtonOnToolbar
    implements ActionListener {
        private Thread _runningThread = null;

        public ButtonRun() {
            URL uRL = SikuliIDE.class.getResource("/icons/run_big_green.png");
            this.setIcon(new ImageIcon(uRL));
            this.initTooltip();
            this.addActionListener(this);
            this.setText(SikuliIDE._I("btnRunLabel", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.runCurrentScript();
        }

        public void runCurrentScript() {
            SikuliIDE sikuliIDE = SikuliIDE.getInstance();
            if (SikuliIDE.this.ideIsRunningScript || !sikuliIDE.doBeforeRun()) {
                return;
            }
            sikuliIDE.setIsRunningScript(true);
            this._runningThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EditorPane editorPane = SikuliIDE.getInstance().getCurrentCodePane();
                    File file = FileManager.createTempFile((String)"py");
                    if (file == null) {
                        return;
                    }
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
                        editorPane.write(bufferedWriter);
                        SikuliIDE.getInstance().setVisible(false);
                        SikuliIDE.this._console.clear();
                        ButtonRun.this.resetErrorMark();
                        ButtonRun.this.runPython(file);
                    }
                    catch (Exception exception) {
                        Pattern pattern = Pattern.compile("SystemExit: ([0-9]+)");
                        Matcher matcher = pattern.matcher(exception.toString());
                        if (matcher.find()) {
                            Debug.info((String)SikuliIDE._I("msgExit", matcher.group(1)), (Object[])new Object[0]);
                        } else {
                            ButtonRun.this.findErrorSource(exception, file.getAbsolutePath());
                        }
                    }
                    finally {
                        SikuliIDE.getInstance().setIsRunningScript(false);
                        SikuliIDE.getInstance().setVisible(true);
                        ButtonRun.this._runningThread = null;
                    }
                }
            };
            this._runningThread.start();
        }

        protected void runPython(File file) throws Exception {
            String string = SikuliIDE.getInstance().getCurrentBundlePath();
            SikuliScriptRunner sikuliScriptRunner = new SikuliScriptRunner(Settings.getArgs(), "IDE");
            this.addPythonCode(sikuliScriptRunner);
            try {
                sikuliScriptRunner.runPython(string, file);
                sikuliScriptRunner.close();
            }
            catch (Exception exception) {
                sikuliScriptRunner.close();
                throw exception;
            }
        }

        protected void addPythonCode(SikuliScriptRunner sikuliScriptRunner) {
        }

        public void stopRunning() {
            if (this._runningThread != null) {
                this._runningThread.interrupt();
                this._runningThread.stop();
            }
        }

        private void initTooltip() {
            PreferencesUser preferencesUser = PreferencesUser.getInstance();
            String string = Utils.convertKeyToText(preferencesUser.getStopHotkey(), preferencesUser.getStopHotkeyModifiers());
            String string2 = SikuliIDE._I("btnRunStopHint", string);
            this.setToolTipText(SikuliIDE._I("btnRun", string2));
        }

        private void findErrorSource(Throwable throwable, String string) {
            Pattern pattern;
            Matcher matcher;
            String string2 = throwable.toString();
            SikuliIDE.this.errorLine = -1;
            SikuliIDE.this.errorColumn = -1;
            SikuliIDE.this.errorClass = -1;
            SikuliIDE.this.errorType = "--UnKnown--";
            SikuliIDE.this.errorText = "--UnKnown--";
            Matcher matcher2 = null;
            if (string2.startsWith("Traceback")) {
                Pattern pattern2 = Pattern.compile(NL + "(.*?):.(.*)$");
                matcher2 = SikuliIDE.this.pFile.matcher(string2);
                if (matcher2.find()) {
                    Debug.log((int)2, (String)("Runtime error line: " + matcher2.group(2) + "\n in function: " + matcher2.group(3) + "\n statement: " + matcher2.group(4)), (Object[])new Object[0]);
                    SikuliIDE.this.errorLine = Integer.parseInt(matcher2.group(2));
                    SikuliIDE.this.errorClass = 1;
                    Matcher matcher3 = pattern2.matcher(string2);
                    if (matcher3.find()) {
                        Debug.log((int)2, (String)("Error:" + matcher3.group(1)), (Object[])new Object[0]);
                        Debug.log((int)2, (String)("Error:" + matcher3.group(2)), (Object[])new Object[0]);
                        SikuliIDE.this.errorType = matcher3.group(1);
                        SikuliIDE.this.errorText = matcher3.group(2);
                    } else {
                        Pattern pattern3 = Pattern.compile(": FindFailed: (.*?)" + NL);
                        Matcher matcher4 = pattern3.matcher(string2);
                        if (matcher4.find()) {
                            SikuliIDE.this.errorType = "FindFailed";
                            SikuliIDE.this.errorText = matcher4.group(1);
                        } else {
                            SikuliIDE.this.errorClass = -1;
                        }
                    }
                }
            } else if (string2.startsWith("SyntaxError") && (matcher = (pattern = Pattern.compile(", (\\d+), (\\d+),")).matcher(string2)).find()) {
                Debug.log((int)4, (String)("SyntaxError error line: " + matcher.group(1)), (Object[])new Object[0]);
                Pattern pattern4 = Pattern.compile("\\((.*?)\\(");
                Matcher matcher5 = pattern4.matcher(string2);
                matcher5.find();
                SikuliIDE.this.errorText = matcher5.group(1) == null ? SikuliIDE.this.errorText : matcher5.group(1);
                Debug.log((int)4, (String)("SyntaxError: " + SikuliIDE.this.errorText), (Object[])new Object[0]);
                SikuliIDE.this.errorLine = Integer.parseInt(matcher.group(1));
                SikuliIDE.this.errorColumn = Integer.parseInt(matcher.group(2));
                SikuliIDE.this.errorClass = 0;
                SikuliIDE.this.errorType = "SyntaxError";
            }
            String string3 = "script [ " + SikuliIDE.this._mainPane.getTitleAt(SikuliIDE.this._mainPane.getSelectedIndex());
            if (SikuliIDE.this.errorLine != -1) {
                string3 = string3 + " ] stopped with error in line " + SikuliIDE.this.errorLine;
                if (SikuliIDE.this.errorColumn != -1) {
                    string3 = string3 + " at column " + SikuliIDE.this.errorColumn;
                }
                this.addErrorMark(SikuliIDE.this.errorLine);
            } else {
                string3 = string3 + "] stopped with error at line --unknown--";
            }
            if (SikuliIDE.this.errorClass == 1 || SikuliIDE.this.errorClass == 0) {
                Debug.error((String)string3, (Object[])new Object[0]);
                Debug.error((String)(SikuliIDE.this.errorType + " ( " + SikuliIDE.this.errorText + " )"), (Object[])new Object[0]);
                if (SikuliIDE.this.errorClass == 1) {
                    SikuliIDE.this.errorClass = this.findErrorSourceWalkTrace(matcher2, string);
                    if (SikuliIDE.this.errorTrace.length() > 0) {
                        Debug.error((String)("--- Traceback --- error source first\nline: module ( function ) statement \n" + SikuliIDE.this.errorTrace), (Object[])new Object[0]);
                    }
                }
            } else if (SikuliIDE.this.errorClass != 2) {
                Debug.error((String)string3, (Object[])new Object[0]);
                Debug.error((String)"Could not evaluate error source nor reason. Analyze StackTrace!", (Object[])new Object[0]);
                Debug.error((String)string2, (Object[])new Object[0]);
            }
        }

        private int findErrorSourceWalkTrace(Matcher matcher, String string) {
            Pattern pattern = Pattern.compile(".*/(.*?).py");
            String string2 = "SikuliImporter,";
            StringBuilder stringBuilder = new StringBuilder();
            while (matcher.find()) {
                String string3;
                if (matcher.group(1).equals(string)) {
                    string3 = "main";
                } else {
                    Matcher matcher2 = pattern.matcher(matcher.group(1));
                    matcher2.find();
                    string3 = matcher2.group(1);
                    if (string2.contains(string3 + ",")) continue;
                }
                String string4 = matcher.group(2) + ": " + string3 + " ( " + matcher.group(3) + " ) " + matcher.group(4) + NL;
                stringBuilder.insert(0, string4);
            }
            Debug.log((int)2, (String)("------------- Traceback -------------\n" + stringBuilder), (Object[])new Object[0]);
            SikuliIDE.this.errorTrace = stringBuilder.toString();
            return SikuliIDE.this.errorClass;
        }

        private void findErrorSourceFromJavaStackTrace(Throwable throwable, String string) {
            Debug.error((String)"seems to be an error in the Java API supporting code", (Object[])new Object[0]);
            for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
                StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
                Debug.log((int)2, (String)"stack trace:", (Object[])new Object[0]);
                for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[i];
                    Debug.log((int)2, (String)(stackTraceElement.getLineNumber() + " " + stackTraceElement.getFileName()), (Object[])new Object[0]);
                    if (stackTraceElement.getLineNumber() < 0 || !string.equals(stackTraceElement.getFileName())) continue;
                    SikuliIDE.this.errorLine = stackTraceElement.getLineNumber();
                }
                Debug.log((int)2, (String)("cause: " + throwable2), (Object[])new Object[0]);
            }
        }

        public void addErrorMark(int n) {
            JScrollPane jScrollPane = (JScrollPane)SikuliIDE.this._mainPane.getSelectedComponent();
            EditorLineNumberView editorLineNumberView = (EditorLineNumberView)jScrollPane.getRowHeader().getView();
            editorLineNumberView.addErrorMark(n);
            EditorPane editorPane = SikuliIDE.this.getCurrentCodePane();
            editorPane.jumpTo(n);
            editorPane.requestFocus();
        }

        public void resetErrorMark() {
            JScrollPane jScrollPane = (JScrollPane)SikuliIDE.this._mainPane.getSelectedComponent();
            EditorLineNumberView editorLineNumberView = (EditorLineNumberView)jScrollPane.getRowHeader().getView();
            editorLineNumberView.resetErrorMark();
        }
    }

    class ButtonSubregion
    extends ButtonOnToolbar
    implements ActionListener,
    EventObserver {
        public ButtonSubregion() {
            URL uRL = SikuliIDE.class.getResource("/icons/region-icon.png");
            this.setIcon(new ImageIcon(uRL));
            this.setText(SikuliIDE._I("btnRegionLabel", new Object[0]));
            this.setToolTipText(SikuliIDE._I("btnRegionHint", new Object[0]));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SikuliIDE sikuliIDE = SikuliIDE.getInstance();
            EditorPane editorPane = sikuliIDE.getCurrentCodePane();
            sikuliIDE.setVisible(false);
            OverlayCapturePrompt overlayCapturePrompt = new OverlayCapturePrompt(null, (EventObserver)this);
            overlayCapturePrompt.prompt(SikuliIDE._I("msgCapturePrompt", new Object[0]), 500);
        }

        public void update(EventSubject eventSubject) {
            if (eventSubject instanceof OverlayCapturePrompt) {
                this.complete((OverlayCapturePrompt)eventSubject);
            }
        }

        public void complete(OverlayCapturePrompt overlayCapturePrompt) {
            SikuliIDE sikuliIDE = SikuliIDE.getInstance();
            EditorPane editorPane = sikuliIDE.getCurrentCodePane();
            ScreenImage screenImage = overlayCapturePrompt.getSelection();
            overlayCapturePrompt.close();
            if (screenImage != null) {
                Rectangle rectangle = screenImage.getROI();
                int n = (int)rectangle.getX();
                int n2 = (int)rectangle.getY();
                int n3 = (int)rectangle.getWidth();
                int n4 = (int)rectangle.getHeight();
                sikuliIDE.setVisible(false);
                if (SikuliIDE.this.prefs.getPrefMoreImageThumbs()) {
                    EditorRegionButton editorRegionButton = new EditorRegionButton(editorPane, n, n2, n3, n4);
                    editorPane.insertComponent(editorRegionButton);
                } else {
                    editorPane.insertString(editorPane.getRegionString(n, n2, n3, n4));
                }
            }
            sikuliIDE.setVisible(true);
            editorPane.requestFocus();
        }
    }

    class ButtonInsertImage
    extends ButtonOnToolbar
    implements ActionListener {
        public ButtonInsertImage() {
            URL uRL = SikuliIDE.class.getResource("/icons/insert-image-icon.png");
            this.setIcon(new ImageIcon(uRL));
            this.setText(SikuliIDE._I("btnInsertImageLabel", new Object[0]));
            this.setToolTipText(SikuliIDE._I("btnInsertImageHint", new Object[0]));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = SikuliIDE.getInstance().getCurrentCodePane();
            File file = new SikuliIDEFileChooser(SikuliIDE.getInstance()).loadImage();
            if (file == null) {
                return;
            }
            String string = Utils.slashify(file.getAbsolutePath(), false);
            Debug.info((String)("load image: " + string), (Object[])new Object[0]);
            String string2 = editorPane.copyFileToBundle(string).getAbsolutePath();
            if (SikuliIDE.this.prefs.getDefaultThumbHeight() > 0) {
                EditorPatternButton editorPatternButton = new EditorPatternButton(editorPane, string2);
                editorPane.insertComponent(editorPatternButton);
            } else {
                editorPane.insertString("\"" + new File(string2).getName() + "\"");
            }
        }
    }

    class HelpAction
    extends MenuAction {
        static final String CHECK_UPDATE = "doCheckUpdate";
        static final String QUICK_START = "openQuickStart";
        static final String OPEN_DOC = "openDoc";
        static final String OPEN_GUIDE = "openTutor";
        static final String OPEN_FAQ = "openFAQ";
        static final String OPEN_ASK = "openAsk";
        static final String OPEN_BUG_REPORT = "openBugReport";
        static final String OPEN_TRANSLATION = "openTranslation";
        static final String OPEN_HOMEPAGE = "openHomepage";

        public HelpAction() {
        }

        public HelpAction(String string) throws NoSuchMethodException {
            super(string);
        }

        public void openQuickStart(ActionEvent actionEvent) {
            FileManager.openURL((String)"http://sikuli.org/");
        }

        public void openDoc(ActionEvent actionEvent) {
            FileManager.openURL((String)"http://doc.sikuli.org");
        }

        public void openTutor(ActionEvent actionEvent) {
            FileManager.openURL((String)"http://www.sikuli.org/videos.html");
        }

        public void openFAQ(ActionEvent actionEvent) {
            FileManager.openURL((String)"https://answers.launchpad.net/sikuli/+faqs");
        }

        public void openAsk(ActionEvent actionEvent) {
            FileManager.openURL((String)"https://answers.launchpad.net/sikuli");
        }

        public void openBugReport(ActionEvent actionEvent) {
            FileManager.openURL((String)"https://bugs.launchpad.net/sikuli/+filebug");
        }

        public void openTranslation(ActionEvent actionEvent) {
            FileManager.openURL((String)"https://translations.launchpad.net/sikuli/sikuli-x/+translations");
        }

        public void openHomepage(ActionEvent actionEvent) {
            FileManager.openURL((String)"http://sikuli.org");
        }

        public void doCheckUpdate(ActionEvent actionEvent) {
            if (!this.checkUpdate(false)) {
                JOptionPane.showMessageDialog(null, SikuliIDE._I("msgNoUpdate", new Object[0]), SikuliIDESettings.SikuliVersion, 1);
            }
        }

        public boolean checkUpdate(boolean bl) {
            AutoUpdater autoUpdater = new AutoUpdater();
            PreferencesUser preferencesUser = PreferencesUser.getInstance();
            Debug.log((int)3, (String)"being asked to check update", (Object[])new Object[0]);
            if (autoUpdater.checkUpdate()) {
                String string = autoUpdater.getVersion();
                if (bl && preferencesUser.getLastSeenUpdate().equals(string)) {
                    return false;
                }
                String string2 = autoUpdater.getDetails();
                autoUpdater.showUpdateFrame(SikuliIDE._I("dlgUpdateAvailable", string), string2);
                PreferencesUser.getInstance().setLastSeenUpdate(string);
                return true;
            }
            return false;
        }
    }

    class ToolAction
    extends MenuAction {
        static final String EXTENSIONS = "extensions";

        public ToolAction() {
        }

        public ToolAction(String string) throws NoSuchMethodException {
            super(string);
        }

        public void extensions(ActionEvent actionEvent) {
            SikuliIDE.this.showExtensionsFrame();
        }
    }

    class ViewAction
    extends MenuAction {
        static final String UNIT_TEST = "toggleUnitTest";
        static final String CMD_LIST = "toggleCmdList";
        static final String SHOW_THUMBS = "toggleShowThumbs";

        public ViewAction() {
        }

        public ViewAction(String string) throws NoSuchMethodException {
            super(string);
        }

        public void toggleCmdList(ActionEvent actionEvent) {
            SikuliIDE.this._cmdList.setCollapsed(!SikuliIDE.this._cmdList.isCollapsed());
        }

        public void toggleShowThumbs(ActionEvent actionEvent) {
            SikuliIDE.this.getCurrentCodePane().showThumbs = SikuliIDE.this.chkShowThumbs.getState();
            if (!SikuliIDE.this.getCurrentCodePane().reparse()) {
                SikuliIDE.this.chkShowThumbs.setState(!SikuliIDE.this.chkShowThumbs.getState());
                SikuliIDE.this.getCurrentCodePane().showThumbs = SikuliIDE.this.chkShowThumbs.getState();
            }
        }

        public void toggleUnitTest(ActionEvent actionEvent) {
            if (SikuliIDE.this._chkShowUnitTest.getState()) {
                SikuliIDE.this._sidePane.setCollapsed(false);
            } else {
                SikuliIDE.this._sidePane.setCollapsed(true);
            }
        }
    }

    class RunAction
    extends MenuAction {
        static final String RUN = "run";
        static final String RUN_SHOW_ACTIONS = "runShowActions";

        public RunAction() {
        }

        public RunAction(String string) throws NoSuchMethodException {
            super(string);
        }

        public void run(ActionEvent actionEvent) {
            this.doRun(SikuliIDE.this._btnRun);
        }

        public void runShowActions(ActionEvent actionEvent) {
            this.doRun(SikuliIDE.this._btnRunViz);
        }

        private void doRun(ButtonRun buttonRun) {
            buttonRun.runCurrentScript();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(SikuliIDE._I("menuEditRedo", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditorUndoManager editorUndoManager = SikuliIDE.this.getCurrentCodePane().getUndoManager();
            try {
                editorUndoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            this.updateRedoState();
            SikuliIDE.this._undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (SikuliIDE.this.getCurrentCodePane() != null && SikuliIDE.this.getCurrentCodePane().getUndoManager().canRedo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(SikuliIDE._I("menuEditUndo", new Object[0]));
            this.setEnabled(false);
        }

        public void updateUndoState() {
            if (SikuliIDE.this.getCurrentCodePane() != null && SikuliIDE.this.getCurrentCodePane().getUndoManager().canUndo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditorUndoManager editorUndoManager = SikuliIDE.this.getCurrentCodePane().getUndoManager();
            try {
                editorUndoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.updateUndoState();
            SikuliIDE.this._redoAction.updateRedoState();
        }
    }

    class FindAction
    extends MenuAction {
        static final String FIND = "doFind";
        static final String FIND_NEXT = "doFindNext";
        static final String FIND_PREV = "doFindPrev";

        public FindAction() {
        }

        public FindAction(String string) throws NoSuchMethodException {
            super(string);
        }

        public void doFind(ActionEvent actionEvent) {
            SikuliIDE.this._searchField.selectAll();
            SikuliIDE.this._searchField.requestFocus();
        }

        public void doFindNext(ActionEvent actionEvent) {
            this.findNext(SikuliIDE.this._searchField.getText());
        }

        public void doFindPrev(ActionEvent actionEvent) {
            this.findPrev(SikuliIDE.this._searchField.getText());
        }

        private boolean _find(String string, int n, boolean bl) {
            EditorPane editorPane = SikuliIDE.this.getCurrentCodePane();
            int n2 = editorPane.search(string, n, bl);
            Debug.log((int)7, (String)("find \"" + string + "\" at " + n + ", found: " + n2), (Object[])new Object[0]);
            return n2 >= 0;
        }

        public boolean findStr(String string) {
            if (SikuliIDE.this.getCurrentCodePane() != null) {
                return this._find(string, SikuliIDE.this.getCurrentCodePane().getCaretPosition(), true);
            }
            return false;
        }

        public boolean findPrev(String string) {
            if (SikuliIDE.this.getCurrentCodePane() != null) {
                return this._find(string, SikuliIDE.this.getCurrentCodePane().getCaretPosition(), false);
            }
            return false;
        }

        public boolean findNext(String string) {
            if (SikuliIDE.this.getCurrentCodePane() != null) {
                return this._find(string, SikuliIDE.this.getCurrentCodePane().getCaretPosition() + string.length(), true);
            }
            return false;
        }

        public void setFailed(boolean bl) {
            Debug.log((int)7, (String)("search failed: " + bl), (Object[])new Object[0]);
            SikuliIDE.this._searchField.setBackground(Color.white);
            if (bl) {
                SikuliIDE.this._searchField.setForeground(COLOR_SEARCH_FAILED);
            } else {
                SikuliIDE.this._searchField.setForeground(COLOR_SEARCH_NORMAL);
            }
        }
    }

    class EditAction
    extends MenuAction {
        static final String CUT = "doCut";
        static final String COPY = "doCopy";
        static final String PASTE = "doPaste";
        static final String SELECT_ALL = "doSelectAll";
        static final String INDENT = "doIndent";
        static final String UNINDENT = "doUnindent";

        public EditAction() {
        }

        public EditAction(String string) throws NoSuchMethodException {
            super(string);
        }

        private void performEditorAction(String string, ActionEvent actionEvent) {
            SikuliIDE sikuliIDE = SikuliIDE.getInstance();
            EditorPane editorPane = sikuliIDE.getCurrentCodePane();
            editorPane.getActionMap().get(string).actionPerformed(actionEvent);
        }

        public void doCut(ActionEvent actionEvent) {
            this.performEditorAction("cut-to-clipboard", actionEvent);
        }

        public void doCopy(ActionEvent actionEvent) {
            this.performEditorAction("copy-to-clipboard", actionEvent);
        }

        public void doPaste(ActionEvent actionEvent) {
            this.performEditorAction("paste-from-clipboard", actionEvent);
        }

        public void doSelectAll(ActionEvent actionEvent) {
            this.performEditorAction("select-all", actionEvent);
        }

        public void doIndent(ActionEvent actionEvent) {
            SikuliIDE sikuliIDE = SikuliIDE.getInstance();
            EditorPane editorPane = sikuliIDE.getCurrentCodePane();
            new EditorKit.InsertTabAction().actionPerformed(editorPane);
        }

        public void doUnindent(ActionEvent actionEvent) {
            SikuliIDE sikuliIDE = SikuliIDE.getInstance();
            EditorPane editorPane = sikuliIDE.getCurrentCodePane();
            new EditorKit.DeindentAction().actionPerformed(editorPane);
        }
    }

    class FileAction
    extends MenuAction {
        static final String NEW = "doNew";
        static final String OPEN = "doLoad";
        static final String SAVE = "doSave";
        static final String SAVE_AS = "doSaveAs";
        static final String EXPORT = "doExport";
        static final String CLOSE_TAB = "doCloseTab";
        static final String PREFERENCES = "doPreferences";
        static final String QUIT = "doQuit";

        public FileAction() {
        }

        public FileAction(String string) throws NoSuchMethodException {
            super(string);
        }

        public void doQuit(ActionEvent actionEvent) {
            EditorPane editorPane;
            SikuliIDE sikuliIDE = SikuliIDE.getInstance();
            if (!SikuliIDE.this.doBeforeQuit()) {
                return;
            }
            while ((editorPane = sikuliIDE.getCurrentCodePane()) != null) {
                if (sikuliIDE.closeCurrentTab()) continue;
                return;
            }
            System.exit(0);
        }

        public void doPreferences(ActionEvent actionEvent) {
            SikuliIDE.getInstance().showPreferencesWindow();
        }

        public void doNew(ActionEvent actionEvent) {
            EditorPane editorPane = new EditorPane();
            JScrollPane jScrollPane = new JScrollPane(editorPane);
            SikuliIDE.this.lineNumberColumn = new EditorLineNumberView(editorPane);
            jScrollPane.setRowHeaderView(SikuliIDE.this.lineNumberColumn);
            SikuliIDE.this._mainPane.addTab(SikuliIDE._I("tabUntitled", new Object[0]), jScrollPane);
            SikuliIDE.this._mainPane.setSelectedIndex(SikuliIDE.this._mainPane.getTabCount() - 1);
            editorPane.requestFocus();
        }

        public void doLoad(ActionEvent actionEvent) {
            SikuliIDE.this.alreadyOpenedTab = SikuliIDE.this._mainPane.getSelectedIndex();
            try {
                this.doNew(actionEvent);
                EditorPane editorPane = SikuliIDE.getInstance().getCurrentCodePane();
                String string = editorPane.loadFile();
                if (string != null) {
                    SikuliIDE.getInstance().setCurrentFileTabTitle(string);
                } else {
                    this.doCloseTab(actionEvent);
                    SikuliIDE.this._mainPane.setSelectedIndex(SikuliIDE.this.alreadyOpenedTab);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void doSave(ActionEvent actionEvent) {
            try {
                EditorPane editorPane = SikuliIDE.getInstance().getCurrentCodePane();
                String string = editorPane.saveFile();
                if (string != null) {
                    SikuliIDE.getInstance().setCurrentFileTabTitle(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public boolean doSaveIntern(int n) {
            JScrollPane jScrollPane = (JScrollPane)SikuliIDE.this._mainPane.getComponentAt(n);
            EditorPane editorPane = (EditorPane)jScrollPane.getViewport().getView();
            try {
                String string = editorPane.saveFile();
                if (string == null) {
                    return false;
                }
                SikuliIDE.getInstance().setFileTabTitle(string, n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
            return true;
        }

        public void doSaveAs(ActionEvent actionEvent) {
            try {
                EditorPane editorPane = SikuliIDE.getInstance().getCurrentCodePane();
                String string = editorPane.saveAsFile();
                if (string != null) {
                    SikuliIDE.getInstance().setCurrentFileTabTitle(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void doExport(ActionEvent actionEvent) {
            try {
                EditorPane editorPane = SikuliIDE.getInstance().getCurrentCodePane();
                String string = editorPane.exportAsZip();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void doCloseTab(ActionEvent actionEvent) {
            EditorPane editorPane = SikuliIDE.getInstance().getCurrentCodePane();
            try {
                if (editorPane.close()) {
                    SikuliIDE.this._mainPane.remove(SikuliIDE.this._mainPane.getSelectedIndex());
                }
            }
            catch (IOException iOException) {
                Debug.info((String)("Can't close this tab: " + iOException.getStackTrace()), (Object[])new Object[0]);
            }
            editorPane = SikuliIDE.getInstance().getCurrentCodePane();
            if (editorPane != null) {
                editorPane.requestFocus();
            } else if (actionEvent != null) {
                new FileAction().doNew(null);
            }
        }
    }

    class MenuAction
    implements ActionListener {
        protected Method actMethod = null;
        protected String action;

        public MenuAction() {
        }

        public MenuAction(String string) throws NoSuchMethodException {
            Class[] classArray = new Class[]{};
            Class[] classArray2 = new Class[1];
            try {
                classArray2[0] = Class.forName("java.awt.event.ActionEvent");
                this.actMethod = this.getClass().getMethod(string, classArray2);
                this.action = string;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.error((String)("Can't find menu action: " + classNotFoundException), (Object[])new Object[0]);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.actMethod != null) {
                try {
                    Debug.log((int)3, (String)("MenuAction." + this.action), (Object[])new Object[0]);
                    Object[] objectArray = new Object[]{actionEvent};
                    this.actMethod.invoke((Object)this, objectArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

