/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import org.sikuli.ide.GeneralFileFilter;
import org.sikuli.ide.PreferencesUser;
import org.sikuli.script.Settings;

public class SikuliIDEFileChooser {
    static final int FILES = 0;
    static final int DIRS = 1;
    static final int SAVE = 1;
    static final int LOAD = 0;
    Frame _parent;

    public SikuliIDEFileChooser(Frame frame) {
        this._parent = frame;
    }

    private File showFileChooser(String string, int n, GeneralFileFilter[] generalFileFilterArray, int n2) {
        if (Settings.isMac()) {
            if (Settings.isJava7() && n2 == 1) {
                return this.showJFileChooser(string, n, generalFileFilterArray, 0);
            }
            FileDialog fileDialog = new FileDialog(this._parent, string, n);
            for (GeneralFileFilter generalFileFilter : generalFileFilterArray) {
                fileDialog.setFilenameFilter(generalFileFilter);
            }
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return null;
            }
            return new File(fileDialog.getDirectory(), fileDialog.getFile());
        }
        return this.showJFileChooser(string, n, generalFileFilterArray, n2);
    }

    private File showJFileChooser(String string, int n, GeneralFileFilter[] generalFileFilterArray, int n2) {
        PreferencesUser preferencesUser;
        String string2;
        JFileChooser jFileChooser = new JFileChooser();
        if (n == 1) {
            jFileChooser.setDialogType(1);
        }
        if (!(string2 = (preferencesUser = PreferencesUser.getInstance()).get("LAST_OPEN_DIR", "")).equals("")) {
            jFileChooser.setCurrentDirectory(new File(string2));
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        for (GeneralFileFilter generalFileFilter : generalFileFilterArray) {
            jFileChooser.setFileFilter(generalFileFilter);
        }
        jFileChooser.setFileSelectionMode(n2);
        jFileChooser.setSelectedFile(null);
        if (jFileChooser.showDialog(this._parent, null) != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        String string3 = file.getParent();
        PreferencesUser.getInstance().put("LAST_OPEN_DIR", string3);
        return file;
    }

    public File loadImage() {
        return this.showFileChooser("Open a Image File", 0, new GeneralFileFilter[]{new GeneralFileFilter("png", "PNG Image Files (*.png)"), new GeneralFileFilter("jpg", "JPEG Image Files (*.jpg)")}, 0);
    }

    public File load() {
        return this.showFileChooser("Open a Sikuli Source File", 0, new GeneralFileFilter[]{new GeneralFileFilter("sikuli", "Sikuli source files (*.sikuli)")}, 1);
    }

    public File save() {
        return this.showFileChooser("Save a Sikuli Source File", 1, new GeneralFileFilter[]{new GeneralFileFilter("sikuli", "Sikuli source files (*.sikuli)")}, 1);
    }

    public File export() {
        return this.showFileChooser("Export a Sikuli Executable File", 1, new GeneralFileFilter[]{new GeneralFileFilter("skl", "Sikuli executable files (*.skl)")}, 0);
    }
}

