/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide.extmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.sikuli.ide.SikuliIDEI18N;
import org.sikuli.ide.extmanager.ExtensionManagerFrame;
import org.sikuli.script.Debug;
import org.sikuli.script.ExtensionManager;
import org.sikuli.script.Settings;

class ExtensionItem
extends JPanel
implements ActionListener {
    JButton _installCtrl;
    JButton _infoCtrl;
    String _name;
    String _infourl;
    String _jarurl;
    String _version;
    String _description;
    boolean _installed;
    final int NOT_INSTALLED = 0;
    final int INSTALLED = 1;
    final int OUT_OF_DATE = 2;
    int _status = 0;
    JPanel _controls;
    JPanel _content;
    JLabel _htmlLabel;

    public ExtensionItem(String string, String string2, String string3, String string4, String string5, String string6) {
        URL uRL;
        this._name = string;
        this._version = string2;
        this._infourl = string5;
        this._infourl = string5;
        this._jarurl = string6;
        this._description = string3;
        this._status = this.getStatus();
        this.setLayout(new BoxLayout(this, 1));
        Border border = BorderFactory.createEtchedBorder(1);
        this.setBorder(border);
        this._content = new JPanel();
        BufferedImage bufferedImage = null;
        try {
            uRL = new URL(string4);
            bufferedImage = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bufferedImage == null) {
            try {
                uRL = new URL(Settings.SikuliRepo + "extensionImage.jpg");
                bufferedImage = ImageIO.read(uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(bufferedImage));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._content.setLayout(new BorderLayout(5, 5));
        this._content.add((Component)jLabel, "Before");
        this._htmlLabel = new JLabel(this.renderHTML());
        this._content.add(this._htmlLabel);
        this.add(this._content);
        JButton jButton = new JButton(SikuliIDEI18N._I("extBtnInstall", new Object[0]));
        jButton.addActionListener(this);
        jButton.setActionCommand("Install");
        this._installCtrl = jButton;
        this._installCtrl.setFocusable(false);
        jButton = new JButton(SikuliIDEI18N._I("extBtnInfo", new Object[0]));
        jButton.addActionListener(this);
        jButton.setActionCommand("Info");
        this._infoCtrl = jButton;
        this._infoCtrl.setFocusable(false);
        this._controls = new JPanel();
        this._controls.setLayout(new BorderLayout(5, 5));
        this._controls.add((Component)this._infoCtrl, "Before");
        this._controls.add((Component)this._installCtrl, "After");
        this.add(this._controls);
        this.updateControls();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ExtensionManagerFrame.getInstance().select((ExtensionItem)mouseEvent.getSource());
            }
        });
    }

    protected void setSelected(boolean bl) {
        this._controls.setVisible(bl);
    }

    private String renderHTML() {
        String string = ExtensionManager.getInstance().getVersion(this._name);
        if (string == null) {
            string = "Not installed";
        }
        return "<html><div style='width:300px'><b>" + this._name + "</b> " + "(" + string + ")" + "<br>" + this._description + "</div></html>";
    }

    private void updateControls() {
        int n = this.getStatus();
        if (n == 1) {
            this._installCtrl.setEnabled(false);
            this._installCtrl.setText(SikuliIDEI18N._I("extMsgInstalled", new Object[0]));
        } else if (n == 0) {
            this._installCtrl.setEnabled(true);
            this._installCtrl.setText(SikuliIDEI18N._I("extBtnInstallVer", this._version));
        } else if (n == 2) {
            this._installCtrl.setEnabled(true);
            this._installCtrl.setText(SikuliIDEI18N._I("extBtnUpdateVer", this._version));
        }
        this._htmlLabel.setText(this.renderHTML());
    }

    private int getStatus() {
        ExtensionManager extensionManager = ExtensionManager.getInstance();
        if (!extensionManager.isInstalled(this._name)) {
            return 0;
        }
        if (extensionManager.isOutOfDate(this._name, this._version)) {
            return 2;
        }
        return 1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Install")) {
            Debug.log((String)("Installing " + this._name + " from " + this._jarurl), (Object[])new Object[0]);
            ExtensionManager extensionManager = ExtensionManager.getInstance();
            if (extensionManager.install(this._name, this._jarurl, this._version)) {
                this.updateControls();
            }
        } else if (string.equals("Info")) {
            Debug.log((String)("Openning URL: " + this._infourl), (Object[])new Object[0]);
            ExtensionItem.openURL(this._infourl, this._name);
        }
    }

    static void openURL(String string, String string2) {
        try {
            URL uRL = new URL(string);
            Desktop.getDesktop().browse(uRL.toURI());
        }
        catch (Exception exception) {
            Debug.error((String)("SikuliExtension: " + string2 + " -- no information available!"), (Object[])new Object[0]);
        }
    }
}

