/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide.extmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.json.simple.JSONValue;
import org.sikuli.ide.extmanager.ExtensionItem;
import org.sikuli.script.Debug;
import org.sikuli.script.Settings;

public class ExtensionManagerFrame
extends JFrame {
    static final String EXTENSION_LIST_URL = Settings.SikuliRepo + "extensions.json";
    private static ExtensionManagerFrame _instance = null;
    private int selected_idx = 0;
    ArrayList<ExtensionItem> _extensions;

    public static ExtensionManagerFrame getInstance() {
        if (_instance == null) {
            _instance = new ExtensionManagerFrame();
        }
        return _instance;
    }

    private ExtensionManagerFrame() {
        this.setTitle("Sikuli Extensions");
        this.setResizable(false);
        this.createComponents();
        this.addKeyListener(new SelectExtensionKeyListener());
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void createComponents() {
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        try {
            this._extensions = this.retrieveExtensions();
            for (ExtensionItem object2 : this._extensions) {
                container.add(object2);
            }
            this.select(0);
        }
        catch (IOException iOException) {
            String string = "Unable to load extensions list from: " + EXTENSION_LIST_URL;
            JTextField jTextField = new JTextField(string);
            jTextField.setBackground(null);
            jTextField.setBorder(null);
            jTextField.setEditable(false);
            container.add(jTextField);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setMinimumSize(new Dimension(400, 20));
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtensionManagerFrame.this.dispose();
            }
        });
        jButton.setFocusable(false);
        jPanel.add((Component)jButton, "After");
        container.add(jPanel);
    }

    private ArrayList<ExtensionItem> retrieveExtensions() throws IOException {
        ArrayList<ExtensionItem> arrayList = new ArrayList<ExtensionItem>();
        Debug.log((int)2, (String)("Retrieving from " + EXTENSION_LIST_URL), (Object[])new Object[0]);
        String string = ExtensionManagerFrame.html2txt(EXTENSION_LIST_URL);
        Object object = JSONValue.parse(string);
        Map map = (Map)object;
        Map map2 = (Map)map.get("extension-list");
        List list = (List)map2.get("extensions");
        for (Object e : list) {
            Map map3 = (Map)e;
            String string2 = (String)map3.get("name");
            String string3 = (String)map3.get("version");
            String string4 = (String)map3.get("description");
            String string5 = (String)map3.get("imgurl");
            String string6 = (String)map3.get("infourl");
            String string7 = (String)map3.get("jarurl");
            arrayList.add(new ExtensionItem(string2, string3, string4, string5, string6, string7));
        }
        return arrayList;
    }

    private static String html2txt(String string) throws IOException {
        String string2;
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(5000);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = "";
        while ((string2 = bufferedReader.readLine()) != null) {
            string3 = string3 + string2;
        }
        bufferedReader.close();
        return string3;
    }

    protected void select(ExtensionItem extensionItem) {
        int n = this._extensions.indexOf(extensionItem);
        this.select(n);
    }

    private void select(int n) {
        this._extensions.get(this.selected_idx).setSelected(false);
        this.selected_idx = n;
        this._extensions.get(this.selected_idx).setSelected(true);
    }

    private void selectPrevious() {
        if (this.selected_idx == 0) {
            return;
        }
        this.select(this.selected_idx - 1);
    }

    private void selectNext() {
        if (this.selected_idx == this._extensions.size() - 1) {
            return;
        }
        this.select(this.selected_idx + 1);
    }

    public static void main(String[] stringArray) throws IOException {
        ExtensionManagerFrame extensionManagerFrame = ExtensionManagerFrame.getInstance();
        extensionManagerFrame.setVisible(true);
    }

    private class SelectExtensionKeyListener
    implements KeyListener {
        private SelectExtensionKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 38) {
                ExtensionManagerFrame.this.selectPrevious();
            } else if (n == 40) {
                ExtensionManagerFrame.this.selectNext();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

