/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide.indentation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.sikuli.ide.PreferencesUser;
import org.sikuli.ide.indentation.PythonState;
import org.sikuli.script.Debug;

public class PythonIndentation {
    public static final int PARENTHESIS_INDENTATION_TABSTOPS = 2;
    public static final int NESTED_PARENTHESIS_INDENTATION_TABSTOPS = 1;
    public static final int LONG_STRING_INDENTATION_COLUMNS = 3;
    public static final int EXPLICIT_LINE_JOINING_INDENTATION_TABSTOPS = 2;
    private static final Pattern ENDS_WITH_COLON = Pattern.compile("^[^#]*:\\s*(?:#.*)?$", 32);
    private static final Pattern UNINDENT_NEXT_LINE_STATEMENT = Pattern.compile("^\\s*(?:break|continue|pass|raise|return)\\b");
    private static final Pattern UNINDENT_LAST_LINE_STATEMENT = Pattern.compile("^\\s*(?:elif|else|except|finally)\\b");
    private static final Pattern COMPOUND_HEADER_STATEMENT_WITH_ARG = Pattern.compile("^\\s*(?:if|elif|for|while|with|except|def|class)\\b.*[\\w'\")\\]}](?:\\s*:)?\\s*$");
    private static final Pattern COMPOUND_HEADER_STATEMENT_WITHOUT_ARG = Pattern.compile("^\\s*(?:else|try|except|finally)\\b(?:\\s*:)?\\s*$");
    private Matcher endsWithColonMatcher = ENDS_WITH_COLON.matcher("");
    private Matcher unindentNextLineStatementMatcher = UNINDENT_NEXT_LINE_STATEMENT.matcher("");
    private Matcher unindentLastLineStatementMatcher = UNINDENT_LAST_LINE_STATEMENT.matcher("");
    private Matcher compoundHeaderStatementWithArgMatcher = COMPOUND_HEADER_STATEMENT_WITH_ARG.matcher("");
    private Matcher compoundHeaderStatementWithoutArgMatcher = COMPOUND_HEADER_STATEMENT_WITHOUT_ARG.matcher("");
    private PythonState pythonState = new PythonState();
    private boolean wasColonAdded = false;

    public void checkIndent(String string, int n) {
        if (!string.contains("\t") || string.contains(" ")) {
            // empty if block
        }
        int n2 = string.length();
        int n3 = PreferencesUser.getInstance().getTabWhitespace().length();
        if (n3 > 1 && string.contains("\t") && string.contains(" ")) {
            Debug.error((String)("PythonIndentation: indent has mixed tab and space in line " + n), (Object[])new Object[0]);
        }
        if (n3 == 1 || n2 % n3 == 0) {
            return;
        }
        Debug.error((String)("PythonIndentation: indent not consistent with tab settings in line " + n), (Object[])new Object[0]);
    }

    public int checkDedent(String string, int n) {
        int n2;
        int n3 = string.length();
        if (n3 < (n2 = PreferencesUser.getInstance().getTabWhitespace().length())) {
            return n3;
        }
        this.checkIndent(string, n);
        return n2;
    }

    public boolean endsLastLogicalLineWithColon() {
        if (this.wasColonAdded) {
            return true;
        }
        return this.endsWithColonMatcher.reset(this.pythonState.getLastLogicalLineStructure()).matches();
    }

    public boolean hasLastLogicalLineColon() {
        if (this.wasColonAdded) {
            return true;
        }
        return this.pythonState.getLastLogicalLineStructure().contains(":");
    }

    public boolean isLastLogicalLineUnindentNextLineStatement() {
        return this.unindentNextLineStatementMatcher.reset(this.pythonState.getLastLogicalLine()).find();
    }

    public boolean isUnindentLastLineStatement() {
        return this.unindentLastLineStatementMatcher.reset(this.pythonState.getLastPhysicalLine()).find();
    }

    public boolean isLastLogicalLineCompoundHeaderStatement() {
        String string = this.pythonState.getLastLogicalLineStructure();
        return this.compoundHeaderStatementWithArgMatcher.reset(string).find() || this.compoundHeaderStatementWithoutArgMatcher.reset(string).find();
    }

    public void setTabWidth(int n) {
        this.pythonState.setTabSize(n);
    }

    public int getTabWidth() {
        return this.pythonState.getTabSize();
    }

    public void reset() {
        this.pythonState.reset();
    }

    public void addText(String string) {
        this.wasColonAdded = false;
        this.pythonState.update(string);
    }

    public int getLastLineNumber() {
        return this.pythonState.getPhysicalLineNumber();
    }

    public void setLastLineEndsWithColon() {
        this.wasColonAdded = true;
    }

    public int shouldChangeLastLineIndentation() {
        if (this.pythonState.getPhysicalLineNumber() > this.pythonState.getLogicalLinePhysicalStartLineNumber()) {
            return 0;
        }
        if (this.pythonState.getLogicalLineNumber() > 0 && this.pythonState.getLastLogicalLineIndentation() < this.pythonState.getPrevLogicalLineIndentation()) {
            return 0;
        }
        int n = this.isUnindentLastLineStatement() ? -this.pythonState.getTabSize() : 0;
        int n2 = this.pythonState.getLastPhysicalLineIndentation();
        if (n2 + n < 0) {
            n = -n2;
        }
        return n;
    }

    public int shouldChangeNextLineIndentation() {
        if (!this.pythonState.isPhysicalLineComplete()) {
            return 0;
        }
        int n = this.pythonState.getLastLogicalLineIndentation();
        int n2 = this.pythonState.getLastPhysicalLineIndentation();
        int n3 = n - n2;
        if (this.pythonState.isLogicalLineComplete()) {
            if (this.endsLastLogicalLineWithColon()) {
                n3 += this.pythonState.getTabSize();
            } else if (this.isLastLogicalLineUnindentNextLineStatement()) {
                n3 -= this.pythonState.getTabSize();
            }
        } else {
            n3 = this.pythonState.inLongString() ? (this.pythonState.getDepth() > 1 ? (n3 += (2 + (this.pythonState.getDepth() - 2) * 1) * this.pythonState.getTabSize()) : (this.pythonState.getPhysicalLineNumber() == this.pythonState.getLogicalLinePhysicalStartLineNumber() ? 3 : 0)) : (this.pythonState.getDepth() > 0 ? (n3 += (2 + (this.pythonState.getDepth() - 1) * 1) * this.pythonState.getTabSize()) : (this.pythonState.isExplicitLineJoining() ? (this.pythonState.getPhysicalLineNumber() == this.pythonState.getLogicalLinePhysicalStartLineNumber() ? 2 * this.pythonState.getTabSize() : 0) : 0));
        }
        if (n2 + n3 < 0) {
            n3 = -n2;
        }
        return n3;
    }

    public boolean shouldAddColon() {
        if (!this.pythonState.isLogicalLineComplete()) {
            return false;
        }
        return this.isLastLogicalLineCompoundHeaderStatement() && !this.hasLastLogicalLineColon();
    }

    public static String getLeadingWhitespace(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && PythonIndentation.isWhitespace(string.charAt(n)); ++n) {
        }
        return string.substring(0, n);
    }

    public static String getLeadingWhitespace(StyledDocument styledDocument, int n, int n2) throws BadLocationException {
        Element element;
        String string = "";
        int n3 = n;
        while (n3 < n + n2 && !(element = styledDocument.getCharacterElement(n3)).getName().equals("component")) {
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset();
            String string2 = PythonIndentation.getLeadingWhitespace(styledDocument.getText(n4, n5 - n4));
            string = string + string2;
            if (string2.length() < n5 - n4) break;
            n3 = n5;
        }
        return string;
    }

    public static int atEndOfLine(StyledDocument styledDocument, int n, int n2, String string, int n3) {
        for (int i = n - n2; i < n3; ++i) {
            if (styledDocument.getCharacterElement(n).getName().equals("component") || !PythonIndentation.isWhitespace(string.charAt(i))) {
                return i + n2;
            }
            ++n;
        }
        return -1;
    }

    public static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }
}

