/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide.indentation;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sikuli.script.Debug;

public class PythonState {
    public static final int DEFAULT_TABSIZE = 4;
    private static final Pattern START_DELIMITER = Pattern.compile("('''|\"\"\"|['\"(\\[{#]|\\\\?(?:\r|\n|\r\n)|\\\\.)", 8);
    private static final Pattern DELIMITER = Pattern.compile("('''|\"\"\"|['\"()\\[\\]{}#]|\\\\?(?:\r|\n|\r\n)|\\\\.)");
    private static final Pattern SINGLE_QUOTE_DELIMITER = Pattern.compile("('|\\\\?(?:\r|\n|\r\n)|\\\\.)");
    private static final Pattern DOUBLE_QUOTE_DELIMITER = Pattern.compile("(\"|\\\\?(?:\r|\n|\r\n)|\\\\.)");
    private static final Pattern LONG_SINGLE_QUOTE_DELIMITER = Pattern.compile("('''|\\\\?(?:\r|\n|\r\n)|\\\\.)");
    private static final Pattern LONG_DOUBLE_QUOTE_DELIMITER = Pattern.compile("(\"\"\"|\\\\?(?:\r|\n|\r\n)|\\\\.)");
    private static final Pattern END_OF_LINE = Pattern.compile("(?:\n|\r\n?)");
    private Matcher startDelimiterMatcher = START_DELIMITER.matcher("").useAnchoringBounds(true);
    private Matcher delimiterMatcher = DELIMITER.matcher("").useAnchoringBounds(true);
    private Matcher singleQuoteMatcher = SINGLE_QUOTE_DELIMITER.matcher("").useAnchoringBounds(true);
    private Matcher doubleQuoteMatcher = DOUBLE_QUOTE_DELIMITER.matcher("").useAnchoringBounds(true);
    private Matcher longSingleQuoteMatcher = LONG_SINGLE_QUOTE_DELIMITER.matcher("").useAnchoringBounds(true);
    private Matcher longDoubleQuoteMatcher = LONG_DOUBLE_QUOTE_DELIMITER.matcher("").useAnchoringBounds(true);
    private Matcher endOfLineMatcher = END_OF_LINE.matcher("").useAnchoringBounds(true);
    private StringBuilder physicalLine;
    private StringBuilder logicalLine;
    private StringBuilder unmatchedChunk;
    private boolean completePhysicalLine;
    private boolean completeLogicalLine;
    private boolean explicitJoining;
    private int explicitJoinOffset;
    private int physicalLineNumber;
    private int logicalLineNumber;
    private int logicalLinePhysicalStartLineNumber;
    private int physicalLineIndentation;
    private int logicalLineIndentation;
    private int prevPhysicalLineIndentation;
    private int prevLogicalLineIndentation;
    private int tabsize = 4;
    private Stack<State> state = new Stack();
    private StringBuilder logicalLineStructure;

    public PythonState() {
        this.state.push(State.DEFAULT);
        this.physicalLine = new StringBuilder();
        this.logicalLine = new StringBuilder();
        this.unmatchedChunk = new StringBuilder();
        this.logicalLineStructure = new StringBuilder();
        this.reset();
    }

    public void setTabSize(int n) {
        this.tabsize = n;
    }

    public int getTabSize() {
        return this.tabsize;
    }

    public void reset() {
        this.state.setSize(1);
        this.physicalLine.setLength(0);
        this.logicalLine.setLength(0);
        this.unmatchedChunk.setLength(0);
        this.logicalLineStructure.setLength(0);
        this.completePhysicalLine = false;
        this.completeLogicalLine = false;
        this.explicitJoining = false;
        this.explicitJoinOffset = 0;
        this.physicalLineNumber = 0;
        this.logicalLineNumber = 0;
        this.logicalLinePhysicalStartLineNumber = 0;
        this.physicalLineIndentation = -1;
        this.logicalLineIndentation = -1;
        this.prevPhysicalLineIndentation = -1;
        this.prevLogicalLineIndentation = -1;
    }

    private boolean isEOL(String string) {
        return string.equals("\r") || string.equals("\n") || string.equals("\r\n");
    }

    private boolean isEscapedEOL(String string) {
        return string.length() >= 2 && string.charAt(0) == '\\' && this.isEOL(string.substring(1));
    }

    private boolean isEscapedChar(String string) {
        return string.length() == 2 && string.charAt(0) == '\\';
    }

    public void update(String string) {
        this.unmatchedChunk.append(string);
        int n = 0;
        String string2 = null;
        block9: while (n < this.unmatchedChunk.length()) {
            int n2;
            int n3 = n;
            Debug.log((int)9, (String)"%s: [%s]", (Object[])new Object[]{this.state.peek().name(), this.unmatchedChunk.substring(n3)});
            if (this.completePhysicalLine) {
                this.physicalLine.setLength(0);
                this.completePhysicalLine = false;
                ++this.physicalLineNumber;
                this.prevPhysicalLineIndentation = this.physicalLineIndentation;
            }
            if (this.completeLogicalLine) {
                this.logicalLine.setLength(0);
                this.logicalLineStructure.setLength(0);
                this.completeLogicalLine = false;
                ++this.logicalLineNumber;
                this.logicalLinePhysicalStartLineNumber = this.physicalLineNumber;
                this.prevLogicalLineIndentation = this.logicalLineIndentation;
                this.logicalLineIndentation = -1;
            }
            this.explicitJoining = false;
            switch (this.state.peek()) {
                case DEFAULT: {
                    this.startDelimiterMatcher.reset(this.unmatchedChunk);
                    this.startDelimiterMatcher.region(n3, this.unmatchedChunk.length());
                    if (!this.startDelimiterMatcher.find()) break block9;
                    string2 = this.startDelimiterMatcher.group(1);
                    n2 = this.startDelimiterMatcher.end(1);
                    if (this.isEscapedEOL(string2)) {
                        this.completePhysicalLine = true;
                        this.explicitJoining = true;
                        break;
                    }
                    if (this.isEOL(string2)) {
                        this.completePhysicalLine = true;
                        this.logicalLineStructure.append(this.unmatchedChunk.substring(n3, n2 - string2.length()));
                        break;
                    }
                    if (string2.equals("'")) {
                        this.state.push(State.IN_SINGLE_QUOTED_STRING);
                    } else if (string2.equals("\"")) {
                        this.state.push(State.IN_DOUBLE_QUOTED_STRING);
                    } else if (string2.equals("'''")) {
                        this.state.push(State.IN_LONG_SINGLE_QUOTED_STRING);
                    } else if (string2.equals("\"\"\"")) {
                        this.state.push(State.IN_LONG_DOUBLE_QUOTED_STRING);
                    } else if (string2.equals("(") || string2.equals("[") || string2.equals("{")) {
                        this.state.push(State.IN_PARENTHESIS);
                    } else if (string2.equals("#")) {
                        this.state.push(State.IN_COMMENT);
                    } else if (!this.isEscapedChar(string2)) {
                        throw new Error("unexpected match \"" + string2 + "\"");
                    }
                    this.logicalLineStructure.append(this.unmatchedChunk.substring(n3, n2));
                    break;
                }
                case IN_PARENTHESIS: {
                    this.delimiterMatcher.reset(this.unmatchedChunk);
                    this.delimiterMatcher.region(n3, this.unmatchedChunk.length());
                    if (!this.delimiterMatcher.find()) break block9;
                    string2 = this.delimiterMatcher.group(1);
                    n2 = this.delimiterMatcher.end(1);
                    if (string2.equals("'")) {
                        this.state.push(State.IN_SINGLE_QUOTED_STRING);
                        break;
                    }
                    if (string2.equals("\"")) {
                        this.state.push(State.IN_DOUBLE_QUOTED_STRING);
                        break;
                    }
                    if (string2.equals("'''")) {
                        this.state.push(State.IN_LONG_SINGLE_QUOTED_STRING);
                        break;
                    }
                    if (string2.equals("\"\"\"")) {
                        this.state.push(State.IN_LONG_DOUBLE_QUOTED_STRING);
                        break;
                    }
                    if (string2.equals("(") || string2.equals("[") || string2.equals("{")) {
                        this.state.push(State.IN_PARENTHESIS);
                        break;
                    }
                    if (string2.equals(")") || string2.equals("]") || string2.equals("}")) {
                        this.state.pop();
                        if (this.state.peek() != State.DEFAULT) break;
                        this.logicalLineStructure.append(string2);
                        break;
                    }
                    if (string2.equals("#")) {
                        this.state.push(State.IN_COMMENT);
                        break;
                    }
                    if (this.isEOL(string2)) {
                        this.completePhysicalLine = true;
                        break;
                    }
                    if (this.isEscapedEOL(string2)) {
                        this.completePhysicalLine = true;
                        this.explicitJoining = true;
                        break;
                    }
                    if (this.isEscapedChar(string2)) break;
                    throw new Error("unexpected match");
                }
                case IN_SINGLE_QUOTED_STRING: {
                    this.singleQuoteMatcher.reset(this.unmatchedChunk);
                    this.singleQuoteMatcher.region(n3, this.unmatchedChunk.length());
                    if (!this.singleQuoteMatcher.find()) break block9;
                    string2 = this.singleQuoteMatcher.group(1);
                    n2 = this.singleQuoteMatcher.end(1);
                    if (string2.equals("'")) {
                        this.state.pop();
                        if (this.state.peek() != State.DEFAULT) break;
                        this.logicalLineStructure.append(string2);
                        break;
                    }
                    if (this.isEOL(string2)) {
                        this.completePhysicalLine = true;
                        break;
                    }
                    if (this.isEscapedEOL(string2)) {
                        this.completePhysicalLine = true;
                        this.explicitJoining = true;
                        break;
                    }
                    if (this.isEscapedChar(string2)) break;
                    throw new Error("unexpected match");
                }
                case IN_DOUBLE_QUOTED_STRING: {
                    this.doubleQuoteMatcher.reset(this.unmatchedChunk);
                    this.doubleQuoteMatcher.region(n3, this.unmatchedChunk.length());
                    if (!this.doubleQuoteMatcher.find()) break block9;
                    string2 = this.doubleQuoteMatcher.group(1);
                    n2 = this.doubleQuoteMatcher.end(1);
                    if (string2.equals("\"")) {
                        this.state.pop();
                        if (this.state.peek() != State.DEFAULT) break;
                        this.logicalLineStructure.append(string2);
                        break;
                    }
                    if (this.isEOL(string2)) {
                        this.completePhysicalLine = true;
                        break;
                    }
                    if (this.isEscapedEOL(string2)) {
                        this.completePhysicalLine = true;
                        this.explicitJoining = true;
                        break;
                    }
                    if (this.isEscapedChar(string2)) break;
                    throw new Error("unexpected match");
                }
                case IN_LONG_SINGLE_QUOTED_STRING: {
                    this.longSingleQuoteMatcher.reset(this.unmatchedChunk);
                    this.longSingleQuoteMatcher.region(n3, this.unmatchedChunk.length());
                    if (!this.longSingleQuoteMatcher.find()) break block9;
                    string2 = this.longSingleQuoteMatcher.group(1);
                    n2 = this.longSingleQuoteMatcher.end(1);
                    if (string2.equals("'''")) {
                        this.state.pop();
                        if (this.state.peek() != State.DEFAULT) break;
                        this.logicalLineStructure.append(string2);
                        break;
                    }
                    if (this.isEOL(string2)) {
                        this.completePhysicalLine = true;
                        break;
                    }
                    if (this.isEscapedEOL(string2)) {
                        this.completePhysicalLine = true;
                        this.explicitJoining = true;
                        break;
                    }
                    if (this.isEscapedChar(string2)) break;
                    throw new Error("unexpected match");
                }
                case IN_LONG_DOUBLE_QUOTED_STRING: {
                    this.longDoubleQuoteMatcher.reset(this.unmatchedChunk);
                    this.longDoubleQuoteMatcher.region(n3, this.unmatchedChunk.length());
                    if (!this.longDoubleQuoteMatcher.find()) break block9;
                    string2 = this.longDoubleQuoteMatcher.group(1);
                    n2 = this.longDoubleQuoteMatcher.end(1);
                    if (string2.equals("\"\"\"")) {
                        this.state.pop();
                        if (this.state.peek() != State.DEFAULT) break;
                        this.logicalLineStructure.append(string2);
                        break;
                    }
                    if (this.isEOL(string2)) {
                        this.completePhysicalLine = true;
                        break;
                    }
                    if (this.isEscapedEOL(string2)) {
                        this.completePhysicalLine = true;
                        this.explicitJoining = true;
                        break;
                    }
                    if (this.isEscapedChar(string2)) break;
                    throw new Error("unexpected match");
                }
                case IN_COMMENT: {
                    this.endOfLineMatcher.reset(this.unmatchedChunk);
                    this.endOfLineMatcher.region(n3, this.unmatchedChunk.length());
                    if (!this.endOfLineMatcher.find()) break block9;
                    string2 = this.endOfLineMatcher.group();
                    n2 = this.endOfLineMatcher.end();
                    this.state.pop();
                    this.completePhysicalLine = true;
                    break;
                }
                default: {
                    throw new Error("This should never happen (probably a bug)");
                }
            }
            Debug.log((int)9, (String)"matcher=[%s]", (Object[])new Object[]{string2});
            this.physicalLine.append(this.unmatchedChunk.substring(n3 + this.explicitJoinOffset, n2));
            if (this.completePhysicalLine) {
                this.physicalLineIndentation = this.getPhysicalLineIndentation();
                if (this.logicalLineIndentation < 0) {
                    this.logicalLineIndentation = this.physicalLineIndentation;
                }
            }
            if (this.explicitJoining) {
                this.unmatchedChunk.delete(n2 - string2.length(), n2);
                this.logicalLine.append(this.unmatchedChunk.substring(n3 + this.explicitJoinOffset, n2 -= string2.length()));
                this.explicitJoinOffset = n2 - n3;
                this.completeLogicalLine = false;
                n = n3;
                if (n2 != this.unmatchedChunk.length()) continue;
                break;
            }
            this.logicalLine.append(this.unmatchedChunk.substring(n3 + this.explicitJoinOffset, n2));
            this.completeLogicalLine = this.completePhysicalLine && this.inDefaultState();
            this.explicitJoinOffset = 0;
            n = n2;
        }
        this.unmatchedChunk.delete(0, n);
        Debug.log((int)9, (String)"%s: unmatched: [%s]", (Object[])new Object[]{this.state.peek().name(), this.unmatchedChunk});
    }

    public State getState() {
        return this.state.peek();
    }

    public boolean inDefaultState() {
        return this.state.peek() == State.DEFAULT;
    }

    public boolean inParenthesis() {
        return this.state.peek() == State.IN_PARENTHESIS;
    }

    public boolean inString() {
        switch (this.state.peek()) {
            case IN_SINGLE_QUOTED_STRING: 
            case IN_DOUBLE_QUOTED_STRING: 
            case IN_LONG_SINGLE_QUOTED_STRING: 
            case IN_LONG_DOUBLE_QUOTED_STRING: {
                return true;
            }
        }
        return false;
    }

    public boolean inLongString() {
        return this.state.peek() == State.IN_LONG_SINGLE_QUOTED_STRING || this.state.peek() == State.IN_LONG_DOUBLE_QUOTED_STRING;
    }

    public boolean inComment() {
        return this.state.peek() == State.IN_COMMENT;
    }

    public int getDepth() {
        return this.state.size() - 1;
    }

    public String getLastLogicalLineStructure() {
        return this.logicalLineStructure.toString();
    }

    public String getLastPhysicalLine() {
        return this.physicalLine.toString();
    }

    public String getLastLogicalLine() {
        return this.logicalLine.toString();
    }

    public int getPhysicalLineNumber() {
        return this.physicalLineNumber;
    }

    public int getLogicalLineNumber() {
        return this.logicalLineNumber;
    }

    public int getLogicalLinePhysicalStartLineNumber() {
        return this.logicalLinePhysicalStartLineNumber;
    }

    public boolean isPhysicalLineComplete() {
        return this.completePhysicalLine;
    }

    public boolean isLogicalLineComplete() {
        return this.completeLogicalLine;
    }

    public boolean isExplicitLineJoining() {
        return this.explicitJoining;
    }

    private int getPhysicalLineIndentation() {
        int n = 0;
        for (int i = 0; i < this.physicalLine.length(); ++i) {
            char c = this.physicalLine.charAt(i);
            if (c == ' ') {
                ++n;
                continue;
            }
            if (c != '\t') break;
            n += this.tabsize;
        }
        return n;
    }

    public int getLastPhysicalLineIndentation() throws IllegalStateException {
        if (!this.completePhysicalLine) {
            throw new IllegalStateException("incomplete physical line");
        }
        return this.physicalLineIndentation;
    }

    public int getLastLogicalLineIndentation() throws IllegalStateException {
        if (this.logicalLineIndentation < 0) {
            throw new IllegalStateException("incomplete logical line");
        }
        return this.logicalLineIndentation;
    }

    public int getPrevPhysicalLineIndentation() throws IllegalStateException {
        if (this.prevPhysicalLineIndentation < 0) {
            throw new IllegalStateException("not enough physical lines");
        }
        return this.prevPhysicalLineIndentation;
    }

    public int getPrevLogicalLineIndentation() throws IllegalStateException {
        if (this.prevLogicalLineIndentation < 0) {
            throw new IllegalStateException("not enough logical lines");
        }
        return this.prevLogicalLineIndentation;
    }

    public static enum State {
        DEFAULT,
        IN_SINGLE_QUOTED_STRING,
        IN_DOUBLE_QUOTED_STRING,
        IN_LONG_SINGLE_QUOTED_STRING,
        IN_LONG_DOUBLE_QUOTED_STRING,
        IN_PARENTHESIS,
        IN_COMMENT;

    }
}

