/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide.z_notused.sikuli_test;

import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.ide.z_notused.sikuli_test.TestRunContext;
import org.sikuli.ide.z_notused.sikuli_test.TestRunView;

public class FailureRunView
implements TestRunView {
    JList fFailureList;
    TestRunContext fRunContext;

    public FailureRunView(TestRunContext testRunContext) {
        this.fRunContext = testRunContext;
        this.fFailureList = new JList(this.fRunContext.getFailures());
        this.fFailureList.setFont(new Font("Dialog", 0, 12));
        this.fFailureList.setSelectionMode(0);
        this.fFailureList.setCellRenderer(new FailureListCellRenderer());
        this.fFailureList.setVisibleRowCount(5);
        this.fFailureList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FailureRunView.this.testSelected();
            }
        });
    }

    @Override
    public Test getSelectedTest() {
        int n = this.fFailureList.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        ListModel listModel = this.fFailureList.getModel();
        TestFailure testFailure = (TestFailure)listModel.getElementAt(n);
        return testFailure.failedTest();
    }

    @Override
    public void activate() {
        this.testSelected();
    }

    @Override
    public void addTab(JTabbedPane jTabbedPane) {
        JScrollPane jScrollPane = new JScrollPane(this.fFailureList, 22, 32);
        ImageIcon imageIcon = SikuliIDE.getIconResource("/icons/error.gif");
        jTabbedPane.addTab("Failures", imageIcon, jScrollPane, "The list of failed tests");
    }

    @Override
    public void revealFailure(Test test) {
        this.fFailureList.setSelectedIndex(0);
    }

    @Override
    public void aboutToStart(Test test, TestResult testResult) {
    }

    @Override
    public void runFinished(Test test, TestResult testResult) {
    }

    protected void testSelected() {
        this.fRunContext.handleTestSelected(this.getSelectedTest());
    }

    static class FailureListCellRenderer
    extends DefaultListCellRenderer {
        private Icon fFailureIcon;
        private Icon fErrorIcon;

        FailureListCellRenderer() {
            this.loadIcons();
        }

        void loadIcons() {
            this.fFailureIcon = SikuliIDE.getIconResource("/icons/failure.gif");
            this.fErrorIcon = SikuliIDE.getIconResource("/icons/error.gif");
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            TestFailure testFailure = (TestFailure)object;
            String string = testFailure.failedTest().toString();
            String string2 = testFailure.exceptionMessage();
            if (string2 != null) {
                string = string + ":" + BaseTestRunner.truncate(string2);
            }
            if (testFailure.isFailure()) {
                if (this.fFailureIcon != null) {
                    this.setIcon(this.fFailureIcon);
                }
            } else if (this.fErrorIcon != null) {
                this.setIcon(this.fErrorIcon);
            }
            this.setText(string);
            this.setToolTipText(string);
            return component;
        }
    }
}

