/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide.z_notused.sikuli_test;

import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import junit.framework.Test;
import junit.framework.TestResult;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.ide.z_notused.sikuli_test.TestRunContext;
import org.sikuli.ide.z_notused.sikuli_test.TestRunView;
import org.sikuli.ide.z_notused.sikuli_test.TestSuitePanel;
import org.sikuli.ide.z_notused.sikuli_test.TestTreeModel;

public class TestHierarchyRunView
implements TestRunView {
    TestSuitePanel fTreeBrowser;
    TestRunContext fTestContext;

    public TestHierarchyRunView(TestRunContext testRunContext) {
        this.fTestContext = testRunContext;
        this.fTreeBrowser = new TestSuitePanel();
        this.fTreeBrowser.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TestHierarchyRunView.this.testSelected();
            }
        });
    }

    @Override
    public void addTab(JTabbedPane jTabbedPane) {
        ImageIcon imageIcon = SikuliIDE.getIconResource("/icons/hierarchy.gif");
        jTabbedPane.addTab("Tests", imageIcon, this.fTreeBrowser, "The test hierarchy");
    }

    @Override
    public Test getSelectedTest() {
        return this.fTreeBrowser.getSelectedTest();
    }

    @Override
    public void activate() {
        this.testSelected();
    }

    @Override
    public void revealFailure(Test test) {
        JTree jTree = this.fTreeBrowser.getTree();
        TestTreeModel testTreeModel = (TestTreeModel)jTree.getModel();
        Vector vector = new Vector();
        int n = testTreeModel.findTest(test, (Test)testTreeModel.getRoot(), vector);
        if (n >= 0) {
            Object[] objectArray = new Object[vector.size() + 1];
            vector.copyInto(objectArray);
            Object object = objectArray[vector.size() - 1];
            objectArray[vector.size()] = testTreeModel.getChild(object, n);
            TreePath treePath = new TreePath(objectArray);
            jTree.setSelectionPath(treePath);
            jTree.makeVisible(treePath);
        }
    }

    @Override
    public void aboutToStart(Test test, TestResult testResult) {
        this.fTreeBrowser.showTestTree(test);
        testResult.addListener(this.fTreeBrowser);
    }

    @Override
    public void runFinished(Test test, TestResult testResult) {
        testResult.removeListener(this.fTreeBrowser);
    }

    protected void testSelected() {
        this.fTestContext.handleTestSelected(this.getSelectedTest());
    }
}

