/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide.z_notused.sikuli_test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.ide.z_notused.sikuli_test.TestTreeModel;

class TestSuitePanel
extends JPanel
implements TestListener {
    private JTree fTree;
    private JScrollPane fScrollTree;
    private TestTreeModel fModel;

    public TestSuitePanel() {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(300, 100));
        this.fTree = new JTree();
        this.fTree.setModel(null);
        this.fTree.setRowHeight(20);
        ToolTipManager.sharedInstance().registerComponent(this.fTree);
        this.fTree.putClientProperty("JTree.lineStyle", "Angled");
        this.fScrollTree = new JScrollPane(this.fTree);
        this.add((Component)this.fScrollTree, "Center");
    }

    @Override
    public void addError(Test test, Throwable throwable) {
        this.fModel.addError(test);
        this.fireTestChanged(test, true);
    }

    @Override
    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.fModel.addFailure(test);
        this.fireTestChanged(test, true);
    }

    @Override
    public void endTest(Test test) {
        this.fModel.addRunTest(test);
        this.fireTestChanged(test, false);
    }

    @Override
    public void startTest(Test test) {
    }

    public Test getSelectedTest() {
        TreePath[] treePathArray = this.fTree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length == 1) {
            return (Test)treePathArray[0].getLastPathComponent();
        }
        return null;
    }

    public JTree getTree() {
        return this.fTree;
    }

    public void showTestTree(Test test) {
        this.fModel = new TestTreeModel(test);
        this.fTree.setModel(this.fModel);
        this.fTree.setCellRenderer(new TestTreeCellRenderer());
    }

    private void fireTestChanged(final Test test, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Vector vector = new Vector();
                int n = TestSuitePanel.this.fModel.findTest(test, (Test)TestSuitePanel.this.fModel.getRoot(), vector);
                if (n >= 0) {
                    Object[] objectArray = new Object[vector.size()];
                    vector.copyInto(objectArray);
                    TreePath treePath = new TreePath(objectArray);
                    TestSuitePanel.this.fModel.fireNodeChanged(treePath, n);
                    if (bl) {
                        Object[] objectArray2 = new Object[vector.size() + 1];
                        vector.copyInto(objectArray2);
                        objectArray2[vector.size()] = TestSuitePanel.this.fModel.getChild(treePath.getLastPathComponent(), n);
                        TreePath treePath2 = new TreePath(objectArray2);
                        TestSuitePanel.this.fTree.scrollPathToVisible(treePath2);
                    }
                }
            }
        });
    }

    static class TestTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Icon fErrorIcon;
        private Icon fOkIcon;
        private Icon fFailureIcon;

        TestTreeCellRenderer() {
            this.loadIcons();
        }

        void loadIcons() {
            this.fErrorIcon = SikuliIDE.getIconResource("/icons/error.gif");
            this.fOkIcon = SikuliIDE.getIconResource("/icons/ok.gif");
            this.fFailureIcon = SikuliIDE.getIconResource("/icons/failure.gif");
        }

        String stripParenthesis(Object object) {
            String string = object.toString();
            int n = string.indexOf(40);
            if (n < 1) {
                return string;
            }
            return string.substring(0, n);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            TreeModel treeModel = jTree.getModel();
            if (treeModel instanceof TestTreeModel) {
                TestTreeModel testTreeModel = (TestTreeModel)treeModel;
                Test test = (Test)object;
                String string = "";
                if (testTreeModel.isFailure(test)) {
                    if (this.fFailureIcon != null) {
                        this.setIcon(this.fFailureIcon);
                    }
                    string = " - Failed";
                } else if (testTreeModel.isError(test)) {
                    if (this.fErrorIcon != null) {
                        this.setIcon(this.fErrorIcon);
                    }
                    string = " - Error";
                } else if (testTreeModel.wasRun(test)) {
                    if (this.fOkIcon != null) {
                        this.setIcon(this.fOkIcon);
                    }
                    string = " - Passed";
                }
                if (component instanceof JComponent) {
                    ((JComponent)component).setToolTipText(this.getText() + string);
                }
            }
            this.setText(this.stripParenthesis(object));
            return component;
        }
    }
}

