/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide.z_notused.sikuli_test;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;
import junit.runner.FailureDetailView;
import junit.runner.StandardTestSuiteLoader;
import junit.runner.TestSuiteLoader;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.ide.z_notused.sikuli_test.CounterPanel;
import org.sikuli.ide.z_notused.sikuli_test.DefaultFailureDetailView;
import org.sikuli.ide.z_notused.sikuli_test.FailureRunView;
import org.sikuli.ide.z_notused.sikuli_test.ProgressBar;
import org.sikuli.ide.z_notused.sikuli_test.TestHierarchyRunView;
import org.sikuli.ide.z_notused.sikuli_test.TestRunContext;
import org.sikuli.ide.z_notused.sikuli_test.TestRunView;
import org.sikuli.script.Debug;

public class UnitTestRunner
extends BaseTestRunner
implements TestRunContext {
    private static final int GAP = 4;
    private JFrame minFrame;
    private JPanel mainPane;
    private JPanel minPane;
    private JToolBar toolbar;
    private JButton fRun;
    private ProgressBar fProgressIndicator;
    private CounterPanel fCounterPanel;
    private JTabbedPane fTestViewTab;
    private FailureDetailView fFailureView;
    private JScrollPane tracePane;
    private Vector fTestRunViews = new Vector();
    private DefaultListModel fFailures;
    private Thread fRunner;
    private TestResult fTestResult;
    private static final String FAILUREDETAILVIEW_KEY = "FailureViewClass";
    public static final int SUCCESS_EXIT = 0;
    public static final int FAILURE_EXIT = 1;
    public static final int EXCEPTION_EXIT = 2;

    public JComponent getTracePane() {
        return this.tracePane;
    }

    public JPanel getPanel() {
        return this.mainPane;
    }

    public JFrame getMinFrame() {
        return this.minFrame;
    }

    private JToolBar initToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.fRun = this.createRunButton();
        jToolBar.add(this.fRun);
        return jToolBar;
    }

    protected JButton createRunButton() {
        JButton jButton = new JButton("Run");
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnitTestRunner.this.runSuite();
            }
        });
        return jButton;
    }

    protected CounterPanel createCounterPanel() {
        return new CounterPanel();
    }

    protected JTabbedPane createTestRunViews() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        FailureRunView failureRunView = new FailureRunView(this);
        this.fTestRunViews.addElement(failureRunView);
        failureRunView.addTab(jTabbedPane);
        TestHierarchyRunView testHierarchyRunView = new TestHierarchyRunView(this);
        this.fTestRunViews.addElement(testHierarchyRunView);
        testHierarchyRunView.addTab(jTabbedPane);
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                UnitTestRunner.this.testViewChanged();
            }
        });
        return jTabbedPane;
    }

    public void testViewChanged() {
        TestRunView testRunView = (TestRunView)this.fTestRunViews.elementAt(this.fTestViewTab.getSelectedIndex());
        testRunView.activate();
    }

    private void initComponents() {
        this.toolbar = this.initToolbar();
        this.fProgressIndicator = new ProgressBar();
        this.fCounterPanel = this.createCounterPanel();
        this.fFailures = new DefaultListModel();
        this.fTestViewTab = this.createTestRunViews();
        this.fFailureView = this.createFailureDetailView();
        this.tracePane = new JScrollPane(this.fFailureView.getComponent(), 22, 32);
        this.initMinFrame();
    }

    private void initMinFrame() {
        this.minFrame = new JFrame("Sikuli Test");
        this.minFrame.setAlwaysOnTop(true);
        this.minFrame.setSize(255, 85);
        this.minFrame.getRootPane().putClientProperty("Window.alpha", new Float(0.7f));
    }

    protected FailureDetailView createFailureDetailView() {
        String string = BaseTestRunner.getPreference(FAILUREDETAILVIEW_KEY);
        if (string != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
                return (FailureDetailView)clazz.newInstance();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.mainPane, "Could not create Failure DetailView - using default view");
            }
        }
        return new DefaultFailureDetailView();
    }

    public UnitTestRunner() {
        this.mainPane = new JPanel(new GridBagLayout());
        this.mainPane.setMinimumSize(new Dimension(0, 0));
        this.mainPane.setPreferredSize(new Dimension(270, 200));
        this.minPane = new JPanel(new GridBagLayout());
        this.initComponents();
        this.addGrid(this.mainPane, this.toolbar, 0, 0, 2, 2, 1.0, 17);
        this.addGrid(this.mainPane, new JSeparator(), 0, 1, 2, 2, 1.0, 17);
        this.addGrid(this.mainPane, this.fCounterPanel, 0, 2, 2, 0, 0.0, 17);
        this.addGrid(this.mainPane, this.fProgressIndicator, 0, 3, 2, 2, 1.0, 17);
        this.addGrid(this.mainPane, new JSeparator(), 0, 5, 2, 2, 1.0, 17);
        this.addGrid(this.mainPane, new JLabel("Results:"), 0, 6, 2, 2, 1.0, 17);
        this.addGrid(this.mainPane, this.fTestViewTab, 0, 7, 2, 1, 1.0, 17);
    }

    void addMinComponentsToPane(JPanel jPanel) {
        this.addGrid(jPanel, this.toolbar, 0, 0, 2, 2, 1.0, 17);
        this.addGrid(jPanel, this.fCounterPanel, 0, 2, 2, 0, 0.0, 17);
        this.addGrid(jPanel, this.fProgressIndicator, 0, 3, 2, 2, 1.0, 17);
    }

    private void addGrid(JPanel jPanel, Component component, int n, int n2, int n3, int n4, double d, int n5) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.fill = n4;
        if (n4 == 1 || n4 == 3) {
            gridBagConstraints.weighty = 1.0;
        }
        gridBagConstraints.insets = new Insets(n2 == 0 ? 10 : 0, 4, 4, 4);
        jPanel.add(component, gridBagConstraints);
    }

    @Override
    public ListModel getFailures() {
        return this.fFailures;
    }

    @Override
    public void handleTestSelected(Test test) {
        this.moveCursorToTest(test);
        this.showFailureDetail(test);
    }

    private void moveCursorToTest(Test test) {
        if (test instanceof TestCase) {
            String string = ((TestCase)test).getName();
            try {
                SikuliIDE.getInstance().jumpTo(string);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    private void showFailureDetail(Test test) {
        if (test != null) {
            ListModel listModel = this.getFailures();
            for (int i = 0; i < listModel.getSize(); ++i) {
                TestFailure testFailure = (TestFailure)listModel.getElementAt(i);
                if (testFailure.failedTest() != test) continue;
                this.fFailureView.showFailure(testFailure);
                return;
            }
        }
        this.fFailureView.clear();
    }

    public synchronized void runSuite() {
        SikuliIDE sikuliIDE = SikuliIDE.getInstance();
        if (this.fRunner != null) {
            this.fTestResult.stop();
            this.showIDE(true);
        } else {
            try {
                this.showIDE(false);
                this.reset();
                String string = sikuliIDE.getCurrentFilename();
                String string2 = sikuliIDE.getCurrentBundlePath();
                Test test = this.genTestSuite(string, string2);
                this.doRun(test);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.showIDE(true);
            }
        }
    }

    private void showInfo(String string) {
        System.out.println(string);
    }

    private void postInfo(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UnitTestRunner.this.showInfo(string);
            }
        });
    }

    protected void reset() {
        this.fCounterPanel.reset();
        this.fProgressIndicator.reset();
        this.fFailureView.clear();
        this.fFailures.clear();
    }

    private void setButtonLabel(final JButton jButton, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jButton.setText(string);
            }
        });
    }

    protected void runFinished(final Test test) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Enumeration enumeration = UnitTestRunner.this.fTestRunViews.elements();
                while (enumeration.hasMoreElements()) {
                    TestRunView testRunView = (TestRunView)enumeration.nextElement();
                    testRunView.runFinished(test, UnitTestRunner.this.fTestResult);
                }
            }
        });
    }

    @Override
    public TestSuiteLoader getLoader() {
        return new StandardTestSuiteLoader();
    }

    private void revealFailure(Test test) {
        Enumeration enumeration = this.fTestRunViews.elements();
        while (enumeration.hasMoreElements()) {
            TestRunView testRunView = (TestRunView)enumeration.nextElement();
            testRunView.revealFailure(test);
        }
    }

    private void appendFailure(Test test, Throwable throwable) {
        this.fFailures.addElement(new TestFailure(test, throwable));
        if (this.fFailures.size() == 1) {
            this.revealFailure(test);
        }
    }

    @Override
    public void testFailed(final int n, final Test test, final Throwable throwable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (n) {
                    case 1: {
                        UnitTestRunner.this.fCounterPanel.setErrorValue(UnitTestRunner.this.fTestResult.errorCount());
                        UnitTestRunner.this.appendFailure(test, throwable);
                        break;
                    }
                    case 2: {
                        UnitTestRunner.this.fCounterPanel.setFailureValue(UnitTestRunner.this.fTestResult.failureCount());
                        UnitTestRunner.this.appendFailure(test, throwable);
                    }
                }
            }
        });
    }

    @Override
    public void testStarted(String string) {
        Debug.log((int)8, (String)("test started: " + string), (Object[])new Object[0]);
    }

    @Override
    public void testEnded(String string) {
        Debug.log((int)8, (String)("test ended: " + string), (Object[])new Object[0]);
        this.synchUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UnitTestRunner.this.fTestResult != null) {
                    UnitTestRunner.this.fCounterPanel.setRunValue(UnitTestRunner.this.fTestResult.runCount());
                    UnitTestRunner.this.fProgressIndicator.step(UnitTestRunner.this.fTestResult.runCount(), UnitTestRunner.this.fTestResult.wasSuccessful());
                }
            }
        });
    }

    private void synchUI() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    private void doRun(final Test test) {
        this.setButtonLabel(this.fRun, "Stop");
        this.fRunner = new Thread("TestRunner-Thread"){

            @Override
            public void run() {
                UnitTestRunner.this.start(test);
                UnitTestRunner.this.postInfo("Running...");
                long l = System.currentTimeMillis();
                test.run(UnitTestRunner.this.fTestResult);
                if (UnitTestRunner.this.fTestResult.shouldStop()) {
                    UnitTestRunner.this.postInfo("Stopped");
                } else {
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - l;
                    UnitTestRunner.this.postInfo("Finished: " + UnitTestRunner.this.elapsedTimeAsString(l3) + " seconds");
                }
                UnitTestRunner.this.runFinished(test);
                UnitTestRunner.this.setButtonLabel(UnitTestRunner.this.fRun, "Run");
                UnitTestRunner.this.showIDE(true);
                UnitTestRunner.this.fRunner = null;
                System.gc();
            }
        };
        this.fTestResult = this.createTestResult();
        this.fTestResult.addListener(this);
        this.aboutToStart(test);
        this.fRunner.start();
    }

    private void showIDE(boolean bl) {
        SikuliIDE.getInstance().setVisible(bl);
        if (bl) {
            this.addMinComponentsToPane(this.mainPane);
        } else {
            this.addMinComponentsToPane(this.minPane);
            Container container = this.minFrame.getContentPane();
            container.add(this.minPane);
            this.minFrame.doLayout();
        }
        this.minFrame.setVisible(!bl);
    }

    protected void aboutToStart(Test test) {
        Enumeration enumeration = this.fTestRunViews.elements();
        while (enumeration.hasMoreElements()) {
            TestRunView testRunView = (TestRunView)enumeration.nextElement();
            testRunView.aboutToStart(test, this.fTestResult);
        }
    }

    private void start(final Test test) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = test.countTestCases();
                UnitTestRunner.this.fProgressIndicator.start(n);
                UnitTestRunner.this.fCounterPanel.setTotal(n);
            }
        });
    }

    private String genTestClassName(String string) {
        String string2 = new File(string).getName();
        int n = string2.indexOf(".");
        return string2.substring(0, n);
    }

    private Test genTestSuite(String string, String string2) throws IOException {
        String string3;
        String string4 = this.genTestClassName(string);
        TestSuite testSuite = new TestSuite(string4);
        PythonInterpreter pythonInterpreter = new PythonInterpreter();
        String string5 = "# coding=utf-8\nfrom __future__ import with_statement\nimport junit\nfrom junit.framework.Assert import *\nfrom sikuli.Sikuli import *\nclass " + string4 + " (junit.framework.TestCase):\n" + "\tdef __init__(self, name):\n" + "\t\tjunit.framework.TestCase.__init__(self,name)\n" + "\t\tself.theTestFunction = getattr(self,name)\n" + "\t\tsetBundlePath('" + string2 + "')\n" + "\tdef runTest(self):\n" + "\t\tself.theTestFunction()\n";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string3 = bufferedReader.readLine()) != null) {
            string5 = string5 + "\t" + string3 + "\n";
        }
        pythonInterpreter.exec(string5);
        PyList pyList = (PyList)pythonInterpreter.eval("[" + string4 + "(f) for f in dir(" + string4 + ") if f.startswith(\"test\")]");
        while (pyList.size() > 0) {
            PyObject pyObject = pyList.pop();
            Test test = (Test)pyObject.__tojava__(TestCase.class);
            testSuite.addTest(test);
        }
        return testSuite;
    }

    @Override
    protected void runFailed(String string) {
        System.err.println(string);
        this.fRunner = null;
    }
}

