"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FineTuningServing__factory = void 0;
/* Autogenerated file. Do not edit manually. */
/* tslint:disable */
/* eslint-disable */
const ethers_1 = require("ethers");
const _abi = [
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'AccountExists',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'AccountNotExists',
        type: 'error',
    },
    {
        inputs: [],
        name: 'AdditionalInfoTooLong',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'string',
                name: 'reason',
                type: 'string',
            },
        ],
        name: 'InvalidVerifierInput',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'ServiceNotExist',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'TooManyRefunds',
        type: 'error',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'amount',
                type: 'uint256',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'pendingRefund',
                type: 'uint256',
            },
        ],
        name: 'BalanceUpdated',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'previousOwner',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'newOwner',
                type: 'address',
            },
        ],
        name: 'OwnershipTransferred',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'uint256',
                name: 'index',
                type: 'uint256',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'timestamp',
                type: 'uint256',
            },
        ],
        name: 'RefundRequested',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
        ],
        name: 'ServiceRemoved',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'string',
                name: 'url',
                type: 'string',
            },
            {
                components: [
                    {
                        internalType: 'uint256',
                        name: 'cpuCount',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nodeMemory',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'gpuCount',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nodeStorage',
                        type: 'uint256',
                    },
                    {
                        internalType: 'string',
                        name: 'gpuType',
                        type: 'string',
                    },
                ],
                indexed: false,
                internalType: 'struct Quota',
                name: 'quota',
                type: 'tuple',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'pricePerToken',
                type: 'uint256',
            },
            {
                indexed: false,
                internalType: 'address',
                name: 'providerSigner',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'bool',
                name: 'occupied',
                type: 'bool',
            },
        ],
        name: 'ServiceUpdated',
        type: 'event',
    },
    {
        inputs: [],
        name: 'MAX_LOCKTIME',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'MIN_LOCKTIME',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'accountExists',
        outputs: [
            {
                internalType: 'bool',
                name: '',
                type: 'bool',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                internalType: 'string',
                name: 'id',
                type: 'string',
            },
        ],
        name: 'acknowledgeDeliverable',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'providerSigner',
                type: 'address',
            },
        ],
        name: 'acknowledgeProviderSigner',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                internalType: 'string',
                name: 'additionalInfo',
                type: 'string',
            },
        ],
        name: 'addAccount',
        outputs: [],
        stateMutability: 'payable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'string',
                name: 'id',
                type: 'string',
            },
            {
                internalType: 'bytes',
                name: 'modelRootHash',
                type: 'bytes',
            },
        ],
        name: 'addDeliverable',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'string',
                name: 'url',
                type: 'string',
            },
            {
                components: [
                    {
                        internalType: 'uint256',
                        name: 'cpuCount',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nodeMemory',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'gpuCount',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nodeStorage',
                        type: 'uint256',
                    },
                    {
                        internalType: 'string',
                        name: 'gpuType',
                        type: 'string',
                    },
                ],
                internalType: 'struct Quota',
                name: 'quota',
                type: 'tuple',
            },
            {
                internalType: 'uint256',
                name: 'pricePerToken',
                type: 'uint256',
            },
            {
                internalType: 'address',
                name: 'providerSigner',
                type: 'address',
            },
            {
                internalType: 'bool',
                name: 'occupied',
                type: 'bool',
            },
            {
                internalType: 'string[]',
                name: 'models',
                type: 'string[]',
            },
        ],
        name: 'addOrUpdateService',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'deleteAccount',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                internalType: 'uint256',
                name: 'cancelRetrievingAmount',
                type: 'uint256',
            },
        ],
        name: 'depositFund',
        outputs: [],
        stateMutability: 'payable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'getAccount',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'balance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'pendingRefund',
                        type: 'uint256',
                    },
                    {
                        components: [
                            {
                                internalType: 'uint256',
                                name: 'index',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'amount',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'createdAt',
                                type: 'uint256',
                            },
                            {
                                internalType: 'bool',
                                name: 'processed',
                                type: 'bool',
                            },
                        ],
                        internalType: 'struct Refund[]',
                        name: 'refunds',
                        type: 'tuple[]',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'address',
                        name: 'providerSigner',
                        type: 'address',
                    },
                    {
                        components: [
                            {
                                internalType: 'string',
                                name: 'id',
                                type: 'string',
                            },
                            {
                                internalType: 'bytes',
                                name: 'modelRootHash',
                                type: 'bytes',
                            },
                            {
                                internalType: 'bytes',
                                name: 'encryptedSecret',
                                type: 'bytes',
                            },
                            {
                                internalType: 'bool',
                                name: 'acknowledged',
                                type: 'bool',
                            },
                            {
                                internalType: 'uint256',
                                name: 'timestamp',
                                type: 'uint256',
                            },
                        ],
                        internalType: 'struct Deliverable[]',
                        name: 'deliverables',
                        type: 'tuple[]',
                    },
                    {
                        internalType: 'uint256',
                        name: 'validRefundsLength',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'deliverablesHead',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'deliverablesCount',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct AccountDetails',
                name: '',
                type: 'tuple',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                internalType: 'uint256',
                name: 'offset',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'limit',
                type: 'uint256',
            },
        ],
        name: 'getAccountsByProvider',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'balance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'pendingRefund',
                        type: 'uint256',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'address',
                        name: 'providerSigner',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'validRefundsLength',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'deliverablesCount',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct AccountSummary[]',
                name: 'accounts',
                type: 'tuple[]',
            },
            {
                internalType: 'uint256',
                name: 'total',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'uint256',
                name: 'offset',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'limit',
                type: 'uint256',
            },
        ],
        name: 'getAccountsByUser',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'balance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'pendingRefund',
                        type: 'uint256',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'address',
                        name: 'providerSigner',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'validRefundsLength',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'deliverablesCount',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct AccountSummary[]',
                name: 'accounts',
                type: 'tuple[]',
            },
            {
                internalType: 'uint256',
                name: 'total',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: 'offset',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'limit',
                type: 'uint256',
            },
        ],
        name: 'getAllAccounts',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'balance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'pendingRefund',
                        type: 'uint256',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'address',
                        name: 'providerSigner',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'validRefundsLength',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'deliverablesCount',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct AccountSummary[]',
                name: 'accounts',
                type: 'tuple[]',
            },
            {
                internalType: 'uint256',
                name: 'total',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'getAllServices',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'string',
                        name: 'url',
                        type: 'string',
                    },
                    {
                        components: [
                            {
                                internalType: 'uint256',
                                name: 'cpuCount',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'nodeMemory',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'gpuCount',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'nodeStorage',
                                type: 'uint256',
                            },
                            {
                                internalType: 'string',
                                name: 'gpuType',
                                type: 'string',
                            },
                        ],
                        internalType: 'struct Quota',
                        name: 'quota',
                        type: 'tuple',
                    },
                    {
                        internalType: 'uint256',
                        name: 'pricePerToken',
                        type: 'uint256',
                    },
                    {
                        internalType: 'address',
                        name: 'providerSigner',
                        type: 'address',
                    },
                    {
                        internalType: 'bool',
                        name: 'occupied',
                        type: 'bool',
                    },
                    {
                        internalType: 'string[]',
                        name: 'models',
                        type: 'string[]',
                    },
                ],
                internalType: 'struct Service[]',
                name: 'services',
                type: 'tuple[]',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address[]',
                name: 'users',
                type: 'address[]',
            },
        ],
        name: 'getBatchAccountsByUsers',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'balance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'pendingRefund',
                        type: 'uint256',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'address',
                        name: 'providerSigner',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'validRefundsLength',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'deliverablesCount',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct AccountSummary[]',
                name: 'accounts',
                type: 'tuple[]',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                internalType: 'string',
                name: 'id',
                type: 'string',
            },
        ],
        name: 'getDeliverable',
        outputs: [
            {
                components: [
                    {
                        internalType: 'string',
                        name: 'id',
                        type: 'string',
                    },
                    {
                        internalType: 'bytes',
                        name: 'modelRootHash',
                        type: 'bytes',
                    },
                    {
                        internalType: 'bytes',
                        name: 'encryptedSecret',
                        type: 'bytes',
                    },
                    {
                        internalType: 'bool',
                        name: 'acknowledged',
                        type: 'bool',
                    },
                    {
                        internalType: 'uint256',
                        name: 'timestamp',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct Deliverable',
                name: '',
                type: 'tuple',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'getDeliverables',
        outputs: [
            {
                components: [
                    {
                        internalType: 'string',
                        name: 'id',
                        type: 'string',
                    },
                    {
                        internalType: 'bytes',
                        name: 'modelRootHash',
                        type: 'bytes',
                    },
                    {
                        internalType: 'bytes',
                        name: 'encryptedSecret',
                        type: 'bytes',
                    },
                    {
                        internalType: 'bool',
                        name: 'acknowledged',
                        type: 'bool',
                    },
                    {
                        internalType: 'uint256',
                        name: 'timestamp',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct Deliverable[]',
                name: '',
                type: 'tuple[]',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'getPendingRefund',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'getService',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'string',
                        name: 'url',
                        type: 'string',
                    },
                    {
                        components: [
                            {
                                internalType: 'uint256',
                                name: 'cpuCount',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'nodeMemory',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'gpuCount',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'nodeStorage',
                                type: 'uint256',
                            },
                            {
                                internalType: 'string',
                                name: 'gpuType',
                                type: 'string',
                            },
                        ],
                        internalType: 'struct Quota',
                        name: 'quota',
                        type: 'tuple',
                    },
                    {
                        internalType: 'uint256',
                        name: 'pricePerToken',
                        type: 'uint256',
                    },
                    {
                        internalType: 'address',
                        name: 'providerSigner',
                        type: 'address',
                    },
                    {
                        internalType: 'bool',
                        name: 'occupied',
                        type: 'bool',
                    },
                    {
                        internalType: 'string[]',
                        name: 'models',
                        type: 'string[]',
                    },
                ],
                internalType: 'struct Service',
                name: 'service',
                type: 'tuple',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: '_locktime',
                type: 'uint256',
            },
            {
                internalType: 'address',
                name: '_ledgerAddress',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'owner',
                type: 'address',
            },
            {
                internalType: 'uint256',
                name: '_penaltyPercentage',
                type: 'uint256',
            },
        ],
        name: 'initialize',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'initialized',
        outputs: [
            {
                internalType: 'bool',
                name: '',
                type: 'bool',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'ledgerAddress',
        outputs: [
            {
                internalType: 'address',
                name: '',
                type: 'address',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'lockTime',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'owner',
        outputs: [
            {
                internalType: 'address',
                name: '',
                type: 'address',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'penaltyPercentage',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'processRefund',
        outputs: [
            {
                internalType: 'uint256',
                name: 'totalAmount',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'balance',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'pendingRefund',
                type: 'uint256',
            },
        ],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'removeService',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'renounceOwnership',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'requestRefundAll',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: 'string',
                        name: 'id',
                        type: 'string',
                    },
                    {
                        internalType: 'bytes',
                        name: 'encryptedSecret',
                        type: 'bytes',
                    },
                    {
                        internalType: 'bytes',
                        name: 'modelRootHash',
                        type: 'bytes',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'address',
                        name: 'providerSigner',
                        type: 'address',
                    },
                    {
                        internalType: 'bytes',
                        name: 'signature',
                        type: 'bytes',
                    },
                    {
                        internalType: 'uint256',
                        name: 'taskFee',
                        type: 'uint256',
                    },
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                ],
                internalType: 'struct VerifierInput',
                name: 'verifierInput',
                type: 'tuple',
            },
        ],
        name: 'settleFees',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'bytes4',
                name: 'interfaceId',
                type: 'bytes4',
            },
        ],
        name: 'supportsInterface',
        outputs: [
            {
                internalType: 'bool',
                name: '',
                type: 'bool',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'newOwner',
                type: 'address',
            },
        ],
        name: 'transferOwnership',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: '_locktime',
                type: 'uint256',
            },
        ],
        name: 'updateLockTime',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: '_penaltyPercentage',
                type: 'uint256',
            },
        ],
        name: 'updatePenaltyPercentage',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        stateMutability: 'payable',
        type: 'receive',
    },
];
const _bytecode = '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';
const isSuperArgs = (xs) => xs.length > 1;
class FineTuningServing__factory extends ethers_1.ContractFactory {
    constructor(...args) {
        if (isSuperArgs(args)) {
            super(...args);
        }
        else {
            super(_abi, _bytecode, args[0]);
        }
    }
    getDeployTransaction(overrides) {
        return super.getDeployTransaction(overrides || {});
    }
    deploy(overrides) {
        return super.deploy(overrides || {});
    }
    connect(runner) {
        return super.connect(runner);
    }
    static bytecode = _bytecode;
    static abi = _abi;
    static createInterface() {
        return new ethers_1.Interface(_abi);
    }
    static connect(address, runner) {
        return new ethers_1.Contract(address, _abi, runner);
    }
}
exports.FineTuningServing__factory = FineTuningServing__factory;
//# sourceMappingURL=FineTuningServing__factory.js.map