"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InferenceServing__factory = void 0;
/* Autogenerated file. Do not edit manually. */
/* tslint:disable */
/* eslint-disable */
const ethers_1 = require("ethers");
const _abi = [
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'AccountExists',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'AccountNotExists',
        type: 'error',
    },
    {
        inputs: [],
        name: 'AdditionalInfoTooLong',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'string',
                name: 'reason',
                type: 'string',
            },
        ],
        name: 'InvalidTEESignature',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'ServiceNotExist',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'TooManyRefunds',
        type: 'error',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'amount',
                type: 'uint256',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'pendingRefund',
                type: 'uint256',
            },
        ],
        name: 'BalanceUpdated',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: false,
                internalType: 'address[]',
                name: 'users',
                type: 'address[]',
            },
            {
                indexed: false,
                internalType: 'uint256[]',
                name: 'balances',
                type: 'uint256[]',
            },
            {
                indexed: false,
                internalType: 'uint256[]',
                name: 'pendingRefunds',
                type: 'uint256[]',
            },
        ],
        name: 'BatchBalanceUpdated',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'previousOwner',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'newOwner',
                type: 'address',
            },
        ],
        name: 'OwnershipTransferred',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'amount',
                type: 'uint256',
            },
        ],
        name: 'ProviderStakeReturned',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'amount',
                type: 'uint256',
            },
        ],
        name: 'ProviderStaked',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'teeSignerAddress',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'bool',
                name: 'acknowledged',
                type: 'bool',
            },
        ],
        name: 'ProviderTEESignerAcknowledged',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'uint256',
                name: 'index',
                type: 'uint256',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'timestamp',
                type: 'uint256',
            },
        ],
        name: 'RefundRequested',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'service',
                type: 'address',
            },
        ],
        name: 'ServiceRemoved',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'service',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'string',
                name: 'serviceType',
                type: 'string',
            },
            {
                indexed: false,
                internalType: 'string',
                name: 'url',
                type: 'string',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'inputPrice',
                type: 'uint256',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'outputPrice',
                type: 'uint256',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'updatedAt',
                type: 'uint256',
            },
            {
                indexed: false,
                internalType: 'string',
                name: 'model',
                type: 'string',
            },
            {
                indexed: false,
                internalType: 'string',
                name: 'verifiability',
                type: 'string',
            },
        ],
        name: 'ServiceUpdated',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'enum SettlementStatus',
                name: 'status',
                type: 'uint8',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'unsettledAmount',
                type: 'uint256',
            },
        ],
        name: 'TEESettlementResult',
        type: 'event',
    },
    {
        inputs: [],
        name: 'MAX_LOCKTIME',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'MIN_LOCKTIME',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'MIN_PROVIDER_STAKE',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'accountExists',
        outputs: [
            {
                internalType: 'bool',
                name: '',
                type: 'bool',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                internalType: 'bool',
                name: 'acknowledged',
                type: 'bool',
            },
        ],
        name: 'acknowledgeTEESigner',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'acknowledgeTEESignerByOwner',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                internalType: 'string',
                name: 'additionalInfo',
                type: 'string',
            },
        ],
        name: 'addAccount',
        outputs: [],
        stateMutability: 'payable',
        type: 'function',
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: 'string',
                        name: 'serviceType',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'url',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'model',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'verifiability',
                        type: 'string',
                    },
                    {
                        internalType: 'uint256',
                        name: 'inputPrice',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'outputPrice',
                        type: 'uint256',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'address',
                        name: 'teeSignerAddress',
                        type: 'address',
                    },
                ],
                internalType: 'struct ServiceParams',
                name: 'params',
                type: 'tuple',
            },
        ],
        name: 'addOrUpdateService',
        outputs: [],
        stateMutability: 'payable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'deleteAccount',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                internalType: 'uint256',
                name: 'cancelRetrievingAmount',
                type: 'uint256',
            },
        ],
        name: 'depositFund',
        outputs: [],
        stateMutability: 'payable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'getAccount',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'balance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'pendingRefund',
                        type: 'uint256',
                    },
                    {
                        components: [
                            {
                                internalType: 'uint256',
                                name: 'index',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'amount',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'createdAt',
                                type: 'uint256',
                            },
                            {
                                internalType: 'bool',
                                name: 'processed',
                                type: 'bool',
                            },
                        ],
                        internalType: 'struct Refund[]',
                        name: 'refunds',
                        type: 'tuple[]',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'bool',
                        name: 'acknowledged',
                        type: 'bool',
                    },
                    {
                        internalType: 'uint256',
                        name: 'validRefundsLength',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct Account',
                name: '',
                type: 'tuple',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                internalType: 'uint256',
                name: 'offset',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'limit',
                type: 'uint256',
            },
        ],
        name: 'getAccountsByProvider',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'balance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'pendingRefund',
                        type: 'uint256',
                    },
                    {
                        components: [
                            {
                                internalType: 'uint256',
                                name: 'index',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'amount',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'createdAt',
                                type: 'uint256',
                            },
                            {
                                internalType: 'bool',
                                name: 'processed',
                                type: 'bool',
                            },
                        ],
                        internalType: 'struct Refund[]',
                        name: 'refunds',
                        type: 'tuple[]',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'bool',
                        name: 'acknowledged',
                        type: 'bool',
                    },
                    {
                        internalType: 'uint256',
                        name: 'validRefundsLength',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct Account[]',
                name: 'accounts',
                type: 'tuple[]',
            },
            {
                internalType: 'uint256',
                name: 'total',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'uint256',
                name: 'offset',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'limit',
                type: 'uint256',
            },
        ],
        name: 'getAccountsByUser',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'balance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'pendingRefund',
                        type: 'uint256',
                    },
                    {
                        components: [
                            {
                                internalType: 'uint256',
                                name: 'index',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'amount',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'createdAt',
                                type: 'uint256',
                            },
                            {
                                internalType: 'bool',
                                name: 'processed',
                                type: 'bool',
                            },
                        ],
                        internalType: 'struct Refund[]',
                        name: 'refunds',
                        type: 'tuple[]',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'bool',
                        name: 'acknowledged',
                        type: 'bool',
                    },
                    {
                        internalType: 'uint256',
                        name: 'validRefundsLength',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct Account[]',
                name: 'accounts',
                type: 'tuple[]',
            },
            {
                internalType: 'uint256',
                name: 'total',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: 'offset',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'limit',
                type: 'uint256',
            },
        ],
        name: 'getAllAccounts',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'balance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'pendingRefund',
                        type: 'uint256',
                    },
                    {
                        components: [
                            {
                                internalType: 'uint256',
                                name: 'index',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'amount',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'createdAt',
                                type: 'uint256',
                            },
                            {
                                internalType: 'bool',
                                name: 'processed',
                                type: 'bool',
                            },
                        ],
                        internalType: 'struct Refund[]',
                        name: 'refunds',
                        type: 'tuple[]',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'bool',
                        name: 'acknowledged',
                        type: 'bool',
                    },
                    {
                        internalType: 'uint256',
                        name: 'validRefundsLength',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct Account[]',
                name: 'accounts',
                type: 'tuple[]',
            },
            {
                internalType: 'uint256',
                name: 'total',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: 'offset',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'limit',
                type: 'uint256',
            },
        ],
        name: 'getAllServices',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'string',
                        name: 'serviceType',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'url',
                        type: 'string',
                    },
                    {
                        internalType: 'uint256',
                        name: 'inputPrice',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'outputPrice',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'updatedAt',
                        type: 'uint256',
                    },
                    {
                        internalType: 'string',
                        name: 'model',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'verifiability',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'address',
                        name: 'teeSignerAddress',
                        type: 'address',
                    },
                    {
                        internalType: 'bool',
                        name: 'teeSignerAcknowledged',
                        type: 'bool',
                    },
                ],
                internalType: 'struct Service[]',
                name: 'services',
                type: 'tuple[]',
            },
            {
                internalType: 'uint256',
                name: 'total',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address[]',
                name: 'users',
                type: 'address[]',
            },
        ],
        name: 'getBatchAccountsByUsers',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'balance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'pendingRefund',
                        type: 'uint256',
                    },
                    {
                        components: [
                            {
                                internalType: 'uint256',
                                name: 'index',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'amount',
                                type: 'uint256',
                            },
                            {
                                internalType: 'uint256',
                                name: 'createdAt',
                                type: 'uint256',
                            },
                            {
                                internalType: 'bool',
                                name: 'processed',
                                type: 'bool',
                            },
                        ],
                        internalType: 'struct Refund[]',
                        name: 'refunds',
                        type: 'tuple[]',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'bool',
                        name: 'acknowledged',
                        type: 'bool',
                    },
                    {
                        internalType: 'uint256',
                        name: 'validRefundsLength',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct Account[]',
                name: 'accounts',
                type: 'tuple[]',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'getPendingRefund',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'getService',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'string',
                        name: 'serviceType',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'url',
                        type: 'string',
                    },
                    {
                        internalType: 'uint256',
                        name: 'inputPrice',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'outputPrice',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'updatedAt',
                        type: 'uint256',
                    },
                    {
                        internalType: 'string',
                        name: 'model',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'verifiability',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                    {
                        internalType: 'address',
                        name: 'teeSignerAddress',
                        type: 'address',
                    },
                    {
                        internalType: 'bool',
                        name: 'teeSignerAcknowledged',
                        type: 'bool',
                    },
                ],
                internalType: 'struct Service',
                name: 'service',
                type: 'tuple',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: '_locktime',
                type: 'uint256',
            },
            {
                internalType: 'address',
                name: '_ledgerAddress',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'owner',
                type: 'address',
            },
        ],
        name: 'initialize',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'initialized',
        outputs: [
            {
                internalType: 'bool',
                name: '',
                type: 'bool',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'ledgerAddress',
        outputs: [
            {
                internalType: 'address',
                name: '',
                type: 'address',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'lockTime',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'owner',
        outputs: [
            {
                internalType: 'address',
                name: '',
                type: 'address',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'totalFee',
                        type: 'uint256',
                    },
                    {
                        internalType: 'bytes32',
                        name: 'requestsHash',
                        type: 'bytes32',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'bytes',
                        name: 'signature',
                        type: 'bytes',
                    },
                ],
                internalType: 'struct TEESettlementData[]',
                name: 'settlements',
                type: 'tuple[]',
            },
        ],
        name: 'previewSettlementResults',
        outputs: [
            {
                internalType: 'address[]',
                name: 'failedUsers',
                type: 'address[]',
            },
            {
                internalType: 'enum SettlementStatus[]',
                name: 'failureReasons',
                type: 'uint8[]',
            },
            {
                internalType: 'address[]',
                name: 'partialUsers',
                type: 'address[]',
            },
            {
                internalType: 'uint256[]',
                name: 'partialAmounts',
                type: 'uint256[]',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'processRefund',
        outputs: [
            {
                internalType: 'uint256',
                name: 'totalAmount',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'balance',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'pendingRefund',
                type: 'uint256',
            },
        ],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'removeService',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'renounceOwnership',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'requestRefundAll',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
        ],
        name: 'revokeTEESignerAcknowledgement',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'address',
                        name: 'provider',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'totalFee',
                        type: 'uint256',
                    },
                    {
                        internalType: 'bytes32',
                        name: 'requestsHash',
                        type: 'bytes32',
                    },
                    {
                        internalType: 'uint256',
                        name: 'nonce',
                        type: 'uint256',
                    },
                    {
                        internalType: 'bytes',
                        name: 'signature',
                        type: 'bytes',
                    },
                ],
                internalType: 'struct TEESettlementData[]',
                name: 'settlements',
                type: 'tuple[]',
            },
        ],
        name: 'settleFeesWithTEE',
        outputs: [
            {
                internalType: 'address[]',
                name: 'failedUsers',
                type: 'address[]',
            },
            {
                internalType: 'enum SettlementStatus[]',
                name: 'failureReasons',
                type: 'uint8[]',
            },
            {
                internalType: 'address[]',
                name: 'partialUsers',
                type: 'address[]',
            },
            {
                internalType: 'uint256[]',
                name: 'partialAmounts',
                type: 'uint256[]',
            },
        ],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'bytes4',
                name: 'interfaceId',
                type: 'bytes4',
            },
        ],
        name: 'supportsInterface',
        outputs: [
            {
                internalType: 'bool',
                name: '',
                type: 'bool',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'newOwner',
                type: 'address',
            },
        ],
        name: 'transferOwnership',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: '_locktime',
                type: 'uint256',
            },
        ],
        name: 'updateLockTime',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        stateMutability: 'payable',
        type: 'receive',
    },
];
const _bytecode = '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';
const isSuperArgs = (xs) => xs.length > 1;
class InferenceServing__factory extends ethers_1.ContractFactory {
    constructor(...args) {
        if (isSuperArgs(args)) {
            super(...args);
        }
        else {
            super(_abi, _bytecode, args[0]);
        }
    }
    getDeployTransaction(overrides) {
        return super.getDeployTransaction(overrides || {});
    }
    deploy(overrides) {
        return super.deploy(overrides || {});
    }
    connect(runner) {
        return super.connect(runner);
    }
    static bytecode = _bytecode;
    static abi = _abi;
    static createInterface() {
        return new ethers_1.Interface(_abi);
    }
    static connect(address, runner) {
        return new ethers_1.Contract(address, _abi, runner);
    }
}
exports.InferenceServing__factory = InferenceServing__factory;
//# sourceMappingURL=InferenceServing__factory.js.map