"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LedgerManager__factory = void 0;
/* Autogenerated file. Do not edit manually. */
/* tslint:disable */
/* eslint-disable */
const ethers_1 = require("ethers");
const _abi = [
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
        ],
        name: 'InsufficientBalance',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'serviceAddress',
                type: 'address',
            },
        ],
        name: 'InvalidServiceAddress',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'string',
                name: 'serviceType',
                type: 'string',
            },
        ],
        name: 'InvalidServiceType',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
        ],
        name: 'LedgerExists',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
        ],
        name: 'LedgerNotExists',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'string',
                name: 'serviceName',
                type: 'string',
            },
        ],
        name: 'ServiceNameExists',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'serviceAddress',
                type: 'address',
            },
        ],
        name: 'ServiceNotRegistered',
        type: 'error',
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: 'requested',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'maximum',
                type: 'uint256',
            },
        ],
        name: 'TooManyProviders',
        type: 'error',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'previousOwner',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'newOwner',
                type: 'address',
            },
        ],
        name: 'OwnershipTransferred',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'string',
                name: 'serviceType',
                type: 'string',
            },
            {
                indexed: false,
                internalType: 'string',
                name: 'version',
                type: 'string',
            },
            {
                indexed: false,
                internalType: 'address',
                name: 'serviceAddress',
                type: 'address',
            },
        ],
        name: 'RecommendedServiceUpdated',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'serviceAddress',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'string',
                name: 'serviceName',
                type: 'string',
            },
        ],
        name: 'ServiceRegistered',
        type: 'event',
    },
    {
        inputs: [],
        name: 'MAX_ADDITIONAL_INFO_LENGTH',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'MAX_PROVIDERS_PER_BATCH',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'MAX_SERVICES',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'MIN_ACCOUNT_BALANCE',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'MIN_TRANSFER_AMOUNT',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'string',
                name: 'additionalInfo',
                type: 'string',
            },
        ],
        name: 'addLedger',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'payable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'deleteLedger',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'depositFund',
        outputs: [],
        stateMutability: 'payable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'recipient',
                type: 'address',
            },
        ],
        name: 'depositFundFor',
        outputs: [],
        stateMutability: 'payable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'getAllActiveServices',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'serviceAddress',
                        type: 'address',
                    },
                    {
                        internalType: 'contract IServing',
                        name: 'serviceContract',
                        type: 'address',
                    },
                    {
                        internalType: 'string',
                        name: 'serviceType',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'version',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'fullName',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'description',
                        type: 'string',
                    },
                    {
                        internalType: 'bool',
                        name: 'isRecommended',
                        type: 'bool',
                    },
                    {
                        internalType: 'uint256',
                        name: 'registeredAt',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct ServiceInfo[]',
                name: '',
                type: 'tuple[]',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: 'offset',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'limit',
                type: 'uint256',
            },
        ],
        name: 'getAllLedgers',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'availableBalance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'totalBalance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                ],
                internalType: 'struct Ledger[]',
                name: 'ledgers',
                type: 'tuple[]',
            },
            {
                internalType: 'uint256',
                name: 'total',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'string',
                name: 'serviceType',
                type: 'string',
            },
        ],
        name: 'getAllVersions',
        outputs: [
            {
                internalType: 'string[]',
                name: 'versions',
                type: 'string[]',
            },
            {
                internalType: 'address[]',
                name: 'addresses',
                type: 'address[]',
            },
            {
                internalType: 'bool[]',
                name: 'isRecommendedFlags',
                type: 'bool[]',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
        ],
        name: 'getLedger',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'user',
                        type: 'address',
                    },
                    {
                        internalType: 'uint256',
                        name: 'availableBalance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'uint256',
                        name: 'totalBalance',
                        type: 'uint256',
                    },
                    {
                        internalType: 'string',
                        name: 'additionalInfo',
                        type: 'string',
                    },
                ],
                internalType: 'struct Ledger',
                name: '',
                type: 'tuple',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'string',
                name: 'serviceName',
                type: 'string',
            },
        ],
        name: 'getLedgerProviders',
        outputs: [
            {
                internalType: 'address[]',
                name: '',
                type: 'address[]',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'string',
                name: 'serviceType',
                type: 'string',
            },
        ],
        name: 'getRecommendedService',
        outputs: [
            {
                internalType: 'string',
                name: 'version',
                type: 'string',
            },
            {
                internalType: 'address',
                name: 'serviceAddress',
                type: 'address',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'string',
                name: 'serviceName',
                type: 'string',
            },
        ],
        name: 'getServiceAddressByName',
        outputs: [
            {
                internalType: 'address',
                name: '',
                type: 'address',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'serviceAddress',
                type: 'address',
            },
        ],
        name: 'getServiceInfo',
        outputs: [
            {
                components: [
                    {
                        internalType: 'address',
                        name: 'serviceAddress',
                        type: 'address',
                    },
                    {
                        internalType: 'contract IServing',
                        name: 'serviceContract',
                        type: 'address',
                    },
                    {
                        internalType: 'string',
                        name: 'serviceType',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'version',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'fullName',
                        type: 'string',
                    },
                    {
                        internalType: 'string',
                        name: 'description',
                        type: 'string',
                    },
                    {
                        internalType: 'bool',
                        name: 'isRecommended',
                        type: 'bool',
                    },
                    {
                        internalType: 'uint256',
                        name: 'registeredAt',
                        type: 'uint256',
                    },
                ],
                internalType: 'struct ServiceInfo',
                name: '',
                type: 'tuple',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'owner',
                type: 'address',
            },
        ],
        name: 'initialize',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'initialized',
        outputs: [
            {
                internalType: 'bool',
                name: '',
                type: 'bool',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'string',
                name: 'serviceType',
                type: 'string',
            },
            {
                internalType: 'string',
                name: 'version',
                type: 'string',
            },
        ],
        name: 'isRecommendedVersion',
        outputs: [
            {
                internalType: 'bool',
                name: '',
                type: 'bool',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'owner',
        outputs: [
            {
                internalType: 'address',
                name: '',
                type: 'address',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: 'amount',
                type: 'uint256',
            },
        ],
        name: 'refund',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'string',
                name: 'serviceType',
                type: 'string',
            },
            {
                internalType: 'string',
                name: 'version',
                type: 'string',
            },
            {
                internalType: 'address',
                name: 'serviceAddress',
                type: 'address',
            },
            {
                internalType: 'string',
                name: 'description',
                type: 'string',
            },
        ],
        name: 'registerService',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'renounceOwnership',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address[]',
                name: 'providers',
                type: 'address[]',
            },
            {
                internalType: 'string',
                name: 'serviceName',
                type: 'string',
            },
        ],
        name: 'retrieveFund',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'string',
                name: 'serviceType',
                type: 'string',
            },
            {
                internalType: 'string',
                name: 'version',
                type: 'string',
            },
        ],
        name: 'setRecommendedService',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'user',
                type: 'address',
            },
            {
                internalType: 'uint256',
                name: 'amount',
                type: 'uint256',
            },
        ],
        name: 'spendFund',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'provider',
                type: 'address',
            },
            {
                internalType: 'string',
                name: 'serviceName',
                type: 'string',
            },
            {
                internalType: 'uint256',
                name: 'amount',
                type: 'uint256',
            },
        ],
        name: 'transferFund',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'newOwner',
                type: 'address',
            },
        ],
        name: 'transferOwnership',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        stateMutability: 'payable',
        type: 'receive',
    },
];
const _bytecode = '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';
const isSuperArgs = (xs) => xs.length > 1;
class LedgerManager__factory extends ethers_1.ContractFactory {
    constructor(...args) {
        if (isSuperArgs(args)) {
            super(...args);
        }
        else {
            super(_abi, _bytecode, args[0]);
        }
    }
    getDeployTransaction(overrides) {
        return super.getDeployTransaction(overrides || {});
    }
    deploy(overrides) {
        return super.deploy(overrides || {});
    }
    connect(runner) {
        return super.connect(runner);
    }
    static bytecode = _bytecode;
    static abi = _abi;
    static createInterface() {
        return new ethers_1.Interface(_abi);
    }
    static connect(address, runner) {
        return new ethers_1.Contract(address, _abi, runner);
    }
}
exports.LedgerManager__factory = LedgerManager__factory;
//# sourceMappingURL=LedgerManager__factory.js.map