from typing import Dict, Any
from ai_kit.shared_console import shared_console

def search_web(query: str, max_results: int = 10) -> list[Dict[str, Any]]:
    """Search the web for information."""
    try:
        from duckduckgo_search import DDGS
    except ImportError:
        shared_console.print("[red]Error: duckduckgo_search is not installed. Please install it using 'pip install duckduckgo-search'[/red]")
        return []

    with DDGS() as ddgs:
        raw_results = ddgs.text(query, max_results=max_results)
        # Transform results to match expected format
        return [{
            'title': result['title'],
            'link': result['href'],
            'snippet': result['body']
        } for result in raw_results]