# generated by datamodel-codegen:
#   filename:  alfresco-core.yaml
#   timestamp: 2025-06-25T01:56:48+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Annotated, Any

from pydantic import BaseModel, ConfigDict, Field


class ActionBodyExec(BaseModel):
    actionDefinitionId: str
    params: dict[str, Any] | None = None
    targetId: Annotated[
        str | None,
        Field(
            description='The entity upon which to execute the action, typically a node ID or similar.'
        ),
    ] = None


class ActionExecResult(BaseModel):
    id: Annotated[str, Field(description='The unique identifier of the action pending execution')]


class ActionExecResultEntry(BaseModel):
    entry: ActionExecResult


class ActionParameterDefinition(BaseModel):
    displayLabel: str | None = None
    mandatory: bool | None = None
    multiValued: bool | None = None
    name: str | None = None
    type: str | None = None


class Activity(BaseModel):
    activitySummary: Annotated[
        dict[str, str] | None, Field(description='An object summarizing the activity')
    ] = None
    activityType: Annotated[str, Field(description='The type of the activity posted')]
    feedPersonId: Annotated[str, Field(description='The feed on which this activity was posted')]
    id: Annotated[int, Field(description='The unique id of the activity')]
    postPersonId: Annotated[
        str, Field(description='The id of the person who performed the activity')
    ]
    postedAt: Annotated[
        datetime | None, Field(description='The date time at which the activity was performed')
    ] = None
    siteId: Annotated[
        str | None,
        Field(description='The unique id of the site on which the activity was performed'),
    ] = None


class ActivityEntry(BaseModel):
    entry: Activity


class Association(BaseModel):
    assocType: str
    targetId: str


class AssociationBody(BaseModel):
    assocType: str
    targetId: str


class AssociationEntry(BaseModel):
    entry: Association


class AssociationInfo(BaseModel):
    assocType: str


class AuditApp(BaseModel):
    id: str
    isEnabled: bool | None = True
    maxEntryId: int | None = None
    minEntryId: int | None = None
    name: str | None = None


class AuditAppEntry(BaseModel):
    entry: AuditApp | None = None


class AuditBodyUpdate(BaseModel):
    isEnabled: bool | None = None


class Capabilities(BaseModel):
    isAdmin: bool | None = None
    isGuest: bool | None = None
    isMutable: bool | None = None


class ChildAssociation(BaseModel):
    assocType: str
    childId: str


class ChildAssociationBody(BaseModel):
    assocType: str
    childId: str


class ChildAssociationEntry(BaseModel):
    entry: ChildAssociation


class ChildAssociationInfo(BaseModel):
    assocType: str
    isPrimary: bool


class ClientBody(BaseModel):
    client: Annotated[str, Field(description='the client name')]


class CommentBody(BaseModel):
    content: str


class Company(BaseModel):
    address1: str | None = None
    address2: str | None = None
    address3: str | None = None
    email: str | None = None
    fax: str | None = None
    organization: str | None = None
    postcode: str | None = None
    telephone: str | None = None


class Constraint(BaseModel):
    description: Annotated[
        str | None, Field(description='the human-readable constraint description')
    ] = None
    id: str
    parameters: dict[str, dict[str, Any]] | None = None
    title: Annotated[str | None, Field(description='the human-readable constraint title')] = None
    type: Annotated[str | None, Field(description='the type of the constraint')] = None


class ContentInfo(BaseModel):
    encoding: str | None = None
    mimeType: str
    mimeTypeName: str | None = None
    sizeInBytes: int | None = None


class DeletedNodeBodyRestore(BaseModel):
    assocType: str | None = None
    targetParentId: str | None = None


class DirectAccessUrlBodyCreate(BaseModel):
    expiresAt: datetime | None = None
    validFor: Annotated[
        int | None,
        Field(description='The length of time in seconds that the url is valid for.\n', ge=1),
    ] = None


class Status(Enum):
    PENDING = 'PENDING'
    CANCELLED = 'CANCELLED'
    IN_PROGRESS = 'IN_PROGRESS'
    DONE = 'DONE'
    MAX_CONTENT_SIZE_EXCEEDED = 'MAX_CONTENT_SIZE_EXCEEDED'


class Download(BaseModel):
    bytesAdded: Annotated[
        int | None, Field(description='number of bytes added so far in the zip')
    ] = 0
    filesAdded: Annotated[
        int | None, Field(description='number of files added so far in the zip')
    ] = 0
    id: Annotated[str | None, Field(description='the id of the download node')] = None
    status: Annotated[
        Status | None, Field(description='the current status of the download node creation')
    ] = 'PENDING'
    totalBytes: Annotated[
        int | None, Field(description='the total number of bytes to be added in the zip')
    ] = 0
    totalFiles: Annotated[
        int | None, Field(description='the total number of files to be added in the zip')
    ] = 0


class DownloadBodyCreate(BaseModel):
    nodeIds: list[str]


class DownloadEntry(BaseModel):
    entry: Download


class Error1(BaseModel):
    briefSummary: str | None = None
    descriptionURL: str | None = None
    errorKey: str | None = None
    logId: str | None = None
    stackTrace: str | None = None
    statusCode: int | None = None


class Error(BaseModel):
    error: Error1


class Favorite(BaseModel):
    createdAt: Annotated[
        datetime | None, Field(description='The time the object was made a favorite.')
    ] = None
    properties: Annotated[
        dict[str, Any] | None,
        Field(
            description='A subset of the target favorite properties, system properties and properties already available in the target are excluded.'
        ),
    ] = None
    target: dict[str, Any]
    targetGuid: Annotated[str, Field(description='The guid of the object that is a favorite.')]


class FavoriteBodyCreate(BaseModel):
    target: dict[str, Any]


class FavoriteEntry(BaseModel):
    entry: Favorite


class FavoriteSite(BaseModel):
    id: str


class FavoriteSiteBodyCreate(BaseModel):
    id: str


class FavoriteSiteEntry(BaseModel):
    entry: FavoriteSite


class Group(BaseModel):
    displayName: str
    id: str
    isRoot: bool
    parentIds: list[str] | None = None
    zones: list[str] | None = None


class GroupBodyCreate(BaseModel):
    displayName: str
    id: str
    parentIds: list[str] | None = None


class GroupBodyUpdate(BaseModel):
    displayName: str


class GroupEntry(BaseModel):
    entry: Group


class MemberType(Enum):
    GROUP = 'GROUP'
    PERSON = 'PERSON'


class GroupMember(BaseModel):
    displayName: str
    id: str
    memberType: MemberType


class GroupMemberEntry(BaseModel):
    entry: GroupMember


class GroupMembershipBodyCreate(BaseModel):
    id: str
    memberType: MemberType


class NetworkQuota(BaseModel):
    id: str
    limit: int
    usage: int


class NodeBodyCopy(BaseModel):
    model_config = ConfigDict(
        regex_engine="python-re",
    )
    name: Annotated[
        str | None,
        Field(
            description='The name must not contain spaces or the following special characters: * " < > \\ / ? : and |.\nThe character . must not be used at the end of the name.\n',
            pattern='^(?!(.*[\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$))',
        ),
    ] = None
    targetParentId: str


class Association1(BaseModel):
    assocType: str | None = None


class Lifetime(Enum):
    PERSISTENT = 'PERSISTENT'
    EPHEMERAL = 'EPHEMERAL'


class Type(Enum):
    ALLOW_OWNER_CHANGES = 'ALLOW_OWNER_CHANGES'
    FULL = 'FULL'


class NodeBodyLock(BaseModel):
    lifetime: Lifetime | None = 'PERSISTENT'
    timeToExpire: Annotated[int | None, Field(ge=0)] = None
    type: Type | None = 'ALLOW_OWNER_CHANGES'


class NodeBodyMove(BaseModel):
    model_config = ConfigDict(
        regex_engine="python-re",
    )
    name: Annotated[
        str | None,
        Field(
            description='The name must not contain spaces or the following special characters: * " < > \\ / ? : and |.\nThe character . must not be used at the end of the name.\n',
            pattern='^(?!(.*[\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$))',
        ),
    ] = None
    targetParentId: str


class Pagination(BaseModel):
    count: Annotated[
        int | None, Field(description='The number of objects in the entries array.\n')
    ] = None
    hasMoreItems: Annotated[
        bool | None,
        Field(
            description='A boolean value which is **true** if there are more entities in the collection\nbeyond those in this response. A true value means a request with a larger value\nfor the **skipCount** or the **maxItems** parameter will return more entities.\n'
        ),
    ] = None
    maxItems: Annotated[
        int | None,
        Field(
            description='The value of the **maxItems** parameter used to generate this list.\nIf there was no **maxItems** parameter then the default value is 100.\n'
        ),
    ] = None
    skipCount: Annotated[
        int | None,
        Field(
            description='An integer describing how many entities exist in the collection before\nthose included in this list. If there was no **skipCount** parameter then the\ndefault value is 0.\n'
        ),
    ] = None
    totalItems: Annotated[
        int | None,
        Field(
            description='An integer describing the total number of entities in the collection.\nThe API might not be able to determine this value,\nin which case this property will not be present.\n'
        ),
    ] = None


class PasswordResetBody(BaseModel):
    id: Annotated[str, Field(description='the workflow id provided in the reset password email')]
    key: Annotated[str, Field(description='the workflow key provided in the reset password email')]
    password: Annotated[str, Field(description='the new password')]


class PathElement(BaseModel):
    aspectNames: list[str] | None = None
    id: str | None = None
    name: str | None = None
    nodeType: str | None = None


class PathInfo(BaseModel):
    elements: list[PathElement] | None = None
    isComplete: bool | None = None
    name: str | None = None


class AccessStatus(Enum):
    ALLOWED = 'ALLOWED'
    DENIED = 'DENIED'


class PermissionElement(BaseModel):
    accessStatus: AccessStatus | None = 'ALLOWED'
    authorityId: str | None = None
    name: str | None = None


class PermissionsBody(BaseModel):
    isInheritanceEnabled: bool | None = None
    locallySet: list[PermissionElement] | None = None


class PermissionsInfo(BaseModel):
    inherited: list[PermissionElement] | None = None
    isInheritanceEnabled: bool | None = None
    locallySet: list[PermissionElement] | None = None
    settable: list[str] | None = None


class Person(BaseModel):
    aspectNames: list[str] | None = None
    avatarId: str | None = None
    capabilities: Capabilities | None = None
    company: Company | None = None
    description: str | None = None
    displayName: str | None = None
    email: str
    emailNotificationsEnabled: bool | None = True
    enabled: bool
    firstName: str
    googleId: str | None = None
    id: str
    instantMessageId: str | None = None
    jobTitle: str | None = None
    lastName: str | None = None
    location: str | None = None
    mobile: str | None = None
    properties: dict[str, Any] | None = None
    skypeId: str | None = None
    statusUpdatedAt: datetime | None = None
    telephone: str | None = None
    userStatus: str | None = None


class PersonBodyCreate(BaseModel):
    aspectNames: list[str] | None = None
    company: Company | None = None
    description: str | None = None
    email: str
    emailNotificationsEnabled: bool | None = True
    enabled: bool | None = True
    firstName: str
    googleId: str | None = None
    id: str
    instantMessageId: str | None = None
    jobTitle: str | None = None
    lastName: str | None = None
    location: str | None = None
    mobile: str | None = None
    password: str
    properties: dict[str, Any] | None = None
    skypeId: str | None = None
    telephone: str | None = None
    userStatus: str | None = None


class PersonBodyUpdate(BaseModel):
    aspectNames: list[str] | None = None
    company: Company | None = None
    description: str | None = None
    email: str | None = None
    emailNotificationsEnabled: bool | None = None
    enabled: bool | None = None
    firstName: str | None = None
    googleId: str | None = None
    instantMessageId: str | None = None
    jobTitle: str | None = None
    lastName: str | None = None
    location: str | None = None
    mobile: str | None = None
    oldPassword: str | None = None
    password: str | None = None
    properties: dict[str, Any] | None = None
    skypeId: str | None = None
    telephone: str | None = None
    userStatus: str | None = None


class PersonEntry(BaseModel):
    entry: Person


class SubscriptionLevel(Enum):
    Free = 'Free'
    Standard = 'Standard'
    Enterprise = 'Enterprise'


class PersonNetwork(BaseModel):
    createdAt: datetime | None = None
    homeNetwork: Annotated[bool | None, Field(description='Is this the home network?')] = None
    id: Annotated[str, Field(description="This network's unique id")]
    isEnabled: bool
    paidNetwork: bool | None = None
    quotas: list[NetworkQuota] | None = None
    subscriptionLevel: SubscriptionLevel | None = None


class PersonNetworkEntry(BaseModel):
    entry: PersonNetwork


class List12(BaseModel):
    entries: list[PersonNetworkEntry] | None = None
    pagination: Pagination | None = None


class PersonNetworkPaging(BaseModel):
    list: List12


class List13(BaseModel):
    entries: list[PersonEntry] | None = None
    pagination: Pagination | None = None


class PersonPaging(BaseModel):
    list: List13 | None = None


class Preference(BaseModel):
    id: Annotated[str, Field(description='The unique id of the preference')]
    value: Annotated[
        str | None,
        Field(description='The value of the preference. Note that this can be of any JSON type.'),
    ] = None


class PreferenceEntry(BaseModel):
    entry: Preference


class List14(BaseModel):
    entries: list[PreferenceEntry] | None = None
    pagination: Pagination | None = None


class PreferencePaging(BaseModel):
    list: List14


class Entry(BaseModel):
    message: str | None = None


class ProbeEntry(BaseModel):
    entry: Entry


class Property(BaseModel):
    constraints: Annotated[
        list[Constraint] | None, Field(description='list of constraints defined for the property')
    ] = None
    dataType: Annotated[
        str | None, Field(description='the name of the property type (e.g. d:text)')
    ] = None
    defaultValue: Annotated[str | None, Field(description='the default value')] = None
    description: Annotated[str | None, Field(description='the human-readable description')] = None
    id: str
    isMandatory: Annotated[
        bool | None, Field(description='define if the property is mandatory')
    ] = None
    isMandatoryEnforced: Annotated[
        bool | None, Field(description='define if the presence of mandatory properties is enforced')
    ] = None
    isMultiValued: Annotated[
        bool | None, Field(description='define if the property is multi-valued')
    ] = None
    isProtected: Annotated[
        bool | None, Field(description='define if the property is system maintained')
    ] = None
    title: Annotated[str | None, Field(description='the human-readable title')] = None


class Aggregate(BaseModel):
    average: int | None = None
    numberOfRatings: int | None = None


class Rating(BaseModel):
    aggregate: Aggregate
    id: str
    myRating: Annotated[
        str | None,
        Field(
            description='The rating. The type is specific to the rating scheme, boolean for the likes and an integer for the fiveStar.'
        ),
    ] = None
    ratedAt: datetime | None = None


class Id(Enum):
    likes = 'likes'
    fiveStar = 'fiveStar'


class RatingBody(BaseModel):
    id: Annotated[
        Id, Field(description='The rating scheme type. Possible values are likes and fiveStar.')
    ]
    myRating: Annotated[
        str,
        Field(
            description='The rating. The type is specific to the rating scheme, boolean for the likes and an integer for the fiveStar'
        ),
    ]


class RatingEntry(BaseModel):
    entry: Rating


class List15(BaseModel):
    entries: list[RatingEntry] | None = None
    pagination: Pagination | None = None


class RatingPaging(BaseModel):
    list: List15


class Status1(Enum):
    CREATED = 'CREATED'
    NOT_CREATED = 'NOT_CREATED'


class Rendition(BaseModel):
    content: ContentInfo | None = None
    id: str | None = None
    status: Status1 | None = None


class RenditionBodyCreate(BaseModel):
    id: str


class RenditionEntry(BaseModel):
    entry: Rendition


class List16(BaseModel):
    entries: list[RenditionEntry] | None = None
    pagination: Pagination | None = None


class RenditionPaging(BaseModel):
    list: List16 | None = None


class RevertBody(BaseModel):
    comment: str | None = None
    majorVersion: bool | None = None


class SharedLinkBodyCreate(BaseModel):
    expiresAt: datetime | None = None
    nodeId: str


class SharedLinkBodyEmail(BaseModel):
    client: str | None = None
    locale: str | None = None
    message: str | None = None
    recipientEmails: list[str] | None = None


class Role(Enum):
    SiteConsumer = 'SiteConsumer'
    SiteCollaborator = 'SiteCollaborator'
    SiteContributor = 'SiteContributor'
    SiteManager = 'SiteManager'


class Visibility(Enum):
    PRIVATE = 'PRIVATE'
    MODERATED = 'MODERATED'
    PUBLIC = 'PUBLIC'


class Site(BaseModel):
    description: str | None = None
    guid: str
    id: str
    preset: str | None = None
    role: Role | None = None
    title: str
    visibility: Visibility


class Visibility1(Enum):
    PUBLIC = 'PUBLIC'
    PRIVATE = 'PRIVATE'
    MODERATED = 'MODERATED'


class SiteBodyCreate(BaseModel):
    description: str | None = None
    id: str | None = None
    title: str
    visibility: Visibility1


class Visibility2(Enum):
    PRIVATE = 'PRIVATE'
    MODERATED = 'MODERATED'
    PUBLIC = 'PUBLIC'


class SiteBodyUpdate(BaseModel):
    description: str | None = None
    title: str | None = None
    visibility: Visibility2 | None = None


class SiteContainer(BaseModel):
    folderId: str
    id: str


class SiteContainerEntry(BaseModel):
    entry: SiteContainer


class List18(BaseModel):
    entries: list[SiteContainerEntry] | None = None
    pagination: Pagination | None = None


class SiteContainerPaging(BaseModel):
    list: List18


class SiteEntry(BaseModel):
    entry: Site


class SiteGroup(BaseModel):
    group: GroupMember
    id: str
    role: Role


class SiteGroupEntry(BaseModel):
    entry: SiteGroup


class List19(BaseModel):
    entries: list[SiteGroupEntry] | None = None
    pagination: Pagination | None = None


class SiteGroupPaging(BaseModel):
    list: List19


class SiteMember(BaseModel):
    id: str
    isMemberOfGroup: bool | None = None
    person: Person
    role: Role


class SiteMemberEntry(BaseModel):
    entry: SiteMember


class List20(BaseModel):
    entries: list[SiteMemberEntry] | None = None
    pagination: Pagination | None = None


class SiteMemberPaging(BaseModel):
    list: List20


class SiteMembershipApprovalBody(BaseModel):
    role: str | None = None


class SiteMembershipBodyCreate(BaseModel):
    id: str
    role: Role


class SiteMembershipBodyUpdate(BaseModel):
    role: Role


class SiteMembershipRejectionBody(BaseModel):
    comment: str | None = None


class SiteMembershipRequest(BaseModel):
    createdAt: datetime
    id: str
    message: str | None = None
    site: Site


class SiteMembershipRequestBodyCreate(BaseModel):
    client: Annotated[
        str | None,
        Field(
            description='Optional client name used when sending an email to the end user, defaults to "share" if not provided.\n**Note:** The client must be registered before this API can send an email.\n**Note:** This is available in Alfresco 7.0.0 and newer versions.\n'
        ),
    ] = None
    id: str
    message: str | None = None
    title: str | None = None


class SiteMembershipRequestBodyUpdate(BaseModel):
    message: str | None = None


class SiteMembershipRequestEntry(BaseModel):
    entry: SiteMembershipRequest


class List21(BaseModel):
    entries: list[SiteMembershipRequestEntry] | None = None
    pagination: Pagination | None = None


class SiteMembershipRequestPaging(BaseModel):
    list: List21


class SiteMembershipRequestWithPerson(BaseModel):
    createdAt: datetime
    id: str
    message: str | None = None
    person: Person
    site: Site


class SiteMembershipRequestWithPersonEntry(BaseModel):
    entry: SiteMembershipRequestWithPerson


class List22(BaseModel):
    entries: list[SiteMembershipRequestWithPersonEntry] | None = None
    pagination: Pagination | None = None


class SiteMembershipRequestWithPersonPaging(BaseModel):
    list: List22


class List23(BaseModel):
    entries: list[SiteEntry] | None = None
    pagination: Pagination | None = None


class SitePaging(BaseModel):
    list: List23


class SiteRole(BaseModel):
    guid: str
    id: str
    role: Role
    site: Site


class SiteRoleEntry(BaseModel):
    entry: SiteRole


class List24(BaseModel):
    entries: list[SiteRoleEntry] | None = None
    pagination: Pagination | None = None


class SiteRolePaging(BaseModel):
    list: List24


class Tag(BaseModel):
    count: float | None = None
    id: str
    tag: str


class TagBody(BaseModel):
    tag: str


class TagEntry(BaseModel):
    entry: Tag


class List25(BaseModel):
    entries: list[TagEntry] | None = None
    pagination: Pagination | None = None


class TagPaging(BaseModel):
    list: List25


class UserInfo(BaseModel):
    displayName: str
    id: str


class Version(BaseModel):
    model_config = ConfigDict(
        regex_engine="python-re",
    )
    aspectNames: list[str] | None = None
    content: ContentInfo | None = None
    id: str
    isFile: bool
    isFolder: bool
    modifiedAt: datetime
    modifiedByUser: UserInfo
    name: Annotated[
        str,
        Field(
            description='The name must not contain spaces or the following special characters: * " < > \\ / ? : and |.\nThe character . must not be used at the end of the name.\n',
            pattern='^(?!(.*[\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$))',
        ),
    ]
    nodeType: str
    properties: dict[str, Any] | None = None
    versionComment: str | None = None


class VersionEntry(BaseModel):
    entry: Version | None = None


class List26(BaseModel):
    entries: list[VersionEntry] | None = None
    pagination: Pagination | None = None


class VersionPaging(BaseModel):
    list: List26 | None = None


class ActionDefinition(BaseModel):
    applicableTypes: Annotated[
        list[str], Field(description='QNames of the types this action applies to')
    ]
    description: Annotated[
        str | None,
        Field(
            description='describes the action definition, e.g. "This will move the matched item to another space."'
        ),
    ] = None
    id: Annotated[
        str,
        Field(
            description='Identifier of the action definition — used for example when executing an action'
        ),
    ]
    name: Annotated[str | None, Field(description='name of the action definition, e.g. "move"')] = (
        None
    )
    parameterDefinitions: list[ActionParameterDefinition] | None = None
    title: Annotated[
        str | None, Field(description='title of the action definition, e.g. "Move"')
    ] = None
    trackStatus: Annotated[
        bool,
        Field(description='whether the basic action definition supports action tracking or not'),
    ]


class ActionDefinitionEntry(BaseModel):
    entry: ActionDefinition


class List(BaseModel):
    entries: list[ActionDefinition] | None = None
    pagination: Pagination | None = None


class ActionDefinitionList(BaseModel):
    list: List | None = None


class List1(BaseModel):
    entries: list[ActivityEntry] | None = None
    pagination: Pagination | None = None


class ActivityPaging(BaseModel):
    list: List1


class List2(BaseModel):
    entries: list[AuditAppEntry] | None = None
    pagination: Pagination | None = None


class AuditAppPaging(BaseModel):
    list: List2 | None = None


class AuditEntry(BaseModel):
    auditApplicationId: str
    createdAt: datetime
    createdByUser: UserInfo
    id: str
    values: dict[str, Any] | None = None


class AuditEntryEntry(BaseModel):
    entry: AuditEntry | None = None


class List3(BaseModel):
    entries: list[AuditEntryEntry] | None = None
    pagination: Pagination | None = None


class AuditEntryPaging(BaseModel):
    list: List3 | None = None


class Comment(BaseModel):
    canDelete: bool
    canEdit: bool
    content: str
    createdAt: datetime
    createdBy: Person
    edited: bool
    id: str
    modifiedAt: datetime
    modifiedBy: Person
    title: str


class CommentEntry(BaseModel):
    entry: Comment


class List4(BaseModel):
    entries: list[CommentEntry] | None = None
    pagination: Pagination | None = None


class CommentPaging(BaseModel):
    list: List4


class Definition(BaseModel):
    properties: Annotated[
        list[Property] | None,
        Field(
            description='List of property definitions effective for this node as the result of combining the type with all aspects.'
        ),
    ] = None


class List6(BaseModel):
    entries: list[FavoriteEntry] | None = None
    pagination: Pagination | None = None


class FavoritePaging(BaseModel):
    list: List6


class List7(BaseModel):
    entries: list[GroupMemberEntry] | None = None
    pagination: Pagination | None = None


class GroupMemberPaging(BaseModel):
    list: List7 | None = None


class List8(BaseModel):
    entries: list[GroupEntry] | None = None
    pagination: Pagination | None = None


class GroupPaging(BaseModel):
    list: List8 | None = None


class Node(BaseModel):
    model_config = ConfigDict(
        regex_engine="python-re",
    )
    allowableOperations: list[str] | None = None
    aspectNames: list[str] | None = None
    content: ContentInfo | None = None
    createdAt: datetime
    createdByUser: UserInfo
    definition: Definition | None = None
    id: str
    isFavorite: bool | None = None
    isFile: bool
    isFolder: bool
    isLink: bool | None = None
    isLocked: bool | None = False
    modifiedAt: datetime
    modifiedByUser: UserInfo
    name: Annotated[
        str,
        Field(
            description='The name must not contain spaces or the following special characters: * " < > \\ / ? : and |.\nThe character . must not be used at the end of the name.\n',
            pattern='^(?!(.*[\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$))',
        ),
    ]
    nodeType: str
    parentId: str | None = None
    path: PathInfo | None = None
    permissions: PermissionsInfo | None = None
    properties: dict[str, Any] | None = None


class NodeAssociation(Node):
    association: AssociationInfo | None = None


class NodeAssociationEntry(BaseModel):
    entry: NodeAssociation


class List9(BaseModel):
    entries: list[NodeAssociationEntry] | None = None
    pagination: Pagination | None = None
    source: Node | None = None


class NodeAssociationPaging(BaseModel):
    list: List9 | None = None


class NodeBodyCreate(BaseModel):
    model_config = ConfigDict(
        regex_engine="python-re",
    )
    aspectNames: list[str] | None = None
    association: Association1 | None = None
    definition: Definition | None = None
    name: Annotated[
        str,
        Field(
            description='The name must not contain spaces or the following special characters: * " < > \\ / ? : and |.\nThe character . must not be used at the end of the name.\n',
            pattern='^(?!(.*[\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$))',
        ),
    ]
    nodeType: str
    permissions: PermissionsBody | None = None
    properties: dict[str, Any] | None = None
    relativePath: str | None = None
    secondaryChildren: list[ChildAssociationBody] | None = None
    targets: list[AssociationBody] | None = None


class NodeBodyUpdate(BaseModel):
    model_config = ConfigDict(
        regex_engine="python-re",
    )
    aspectNames: list[str] | None = None
    name: Annotated[
        str | None,
        Field(
            description='The name must not contain spaces or the following special characters: * " < > \\ / ? : and |.\nThe character . must not be used at the end of the name.\n',
            pattern='^(?!(.*[\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$))',
        ),
    ] = None
    nodeType: str | None = None
    permissions: PermissionsBody | None = None
    properties: dict[str, str] | None = None


class NodeChildAssociation(Node):
    association: ChildAssociationInfo | None = None


class NodeChildAssociationEntry(BaseModel):
    entry: NodeChildAssociation


class List10(BaseModel):
    entries: list[NodeChildAssociationEntry] | None = None
    pagination: Pagination | None = None
    source: Node | None = None


class NodeChildAssociationPaging(BaseModel):
    list: List10 | None = None


class NodeEntry(BaseModel):
    entry: Node


class List11(BaseModel):
    entries: list[NodeEntry] | None = None
    pagination: Pagination | None = None
    source: Node | None = None


class NodePaging(BaseModel):
    list: List11 | None = None


class SharedLink(BaseModel):
    model_config = ConfigDict(
        regex_engine="python-re",
    )
    allowableOperations: Annotated[
        list[str] | None,
        Field(
            description='The allowable operations for the Quickshare link itself. See allowableOperationsOnTarget for the\nallowable operations pertaining to the linked content node.\n'
        ),
    ] = None
    allowableOperationsOnTarget: Annotated[
        list[str] | None,
        Field(description='The allowable operations for the content node being shared.\n'),
    ] = None
    aspectNames: list[str] | None = None
    content: ContentInfo | None = None
    description: str | None = None
    expiresAt: datetime | None = None
    id: str | None = None
    isFavorite: bool | None = None
    modifiedAt: datetime | None = None
    modifiedByUser: UserInfo | None = None
    name: Annotated[
        str | None,
        Field(
            description='The name must not contain spaces or the following special characters: * " < > \\ / ? : and |.\nThe character . must not be used at the end of the name.\n',
            pattern='^(?!(.*[\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$))',
        ),
    ] = None
    nodeId: str | None = None
    path: PathInfo | None = None
    properties: Annotated[
        dict[str, Any] | None,
        Field(
            description="A subset of the target node's properties, system properties and properties already available in the SharedLink are excluded.\n"
        ),
    ] = None
    sharedByUser: UserInfo | None = None
    title: str | None = None


class SharedLinkEntry(BaseModel):
    entry: SharedLink


class List17(BaseModel):
    entries: list[SharedLinkEntry] | None = None
    pagination: Pagination | None = None


class SharedLinkPaging(BaseModel):
    list: List17


class DeletedNode(Node):
    archivedAt: datetime
    archivedByUser: UserInfo


class DeletedNodeEntry(BaseModel):
    entry: DeletedNode | None = None


class List5(BaseModel):
    entries: list[DeletedNodeEntry] | None = None
    pagination: Pagination | None = None


class DeletedNodesPaging(BaseModel):
    list: List5 | None = None
