# generated by datamodel-codegen:
#   filename:  alfresco-model.yaml
#   timestamp: 2025-06-25T01:56:56+00:00

from __future__ import annotations

from typing import Annotated, Any

from pydantic import BaseModel, Field, RootModel


class AbstractClassAssociationSource(BaseModel):
    cls: str | None = None
    isMandatory: bool | None = None
    isMandatoryEnforced: bool | None = None
    isMany: bool | None = None
    role: str | None = None


class Constraint(BaseModel):
    description: Annotated[
        str | None, Field(description='the human-readable constraint description')
    ] = None
    id: str
    parameters: dict[str, dict[str, Any]] | None = None
    title: Annotated[str | None, Field(description='the human-readable constraint title')] = None
    type: Annotated[str | None, Field(description='the type of the constraint')] = None


class Error1(BaseModel):
    briefSummary: str | None = None
    descriptionURL: str | None = None
    errorKey: str | None = None
    logId: str | None = None
    stackTrace: str | None = None
    statusCode: int | None = None


class Error(BaseModel):
    error: Error1


class Model(BaseModel):
    author: str | None = None
    description: str | None = None
    id: str
    namespacePrefix: str | None = None
    namespaceUri: str | None = None


class Pagination(BaseModel):
    count: Annotated[
        int | None, Field(description='The number of objects in the entries array.\n')
    ] = None
    hasMoreItems: Annotated[
        bool | None,
        Field(
            description='A boolean value which is **true** if there are more entities in the collection\nbeyond those in this response. A true value means a request with a larger value\nfor the **skipCount** or the **maxItems** parameter will return more entities.\n'
        ),
    ] = None
    maxItems: Annotated[
        int | None,
        Field(
            description='The value of the **maxItems** parameter used to generate this list.\nIf there was no **maxItems** parameter then the default value is 100.\n'
        ),
    ] = None
    skipCount: Annotated[
        int | None,
        Field(
            description='An integer describing how many entities exist in the collection before\nthose included in this list. If there was no **skipCount** parameter then the\ndefault value is 0.\n'
        ),
    ] = None
    totalItems: Annotated[
        int | None,
        Field(
            description='An integer describing the total number of entities in the collection.\nThe API might not be able to determine this value,\nin which case this property will not be present.\n'
        ),
    ] = None


class Property(BaseModel):
    constraints: Annotated[
        list[Constraint] | None, Field(description='list of constraints defined for the property')
    ] = None
    dataType: Annotated[
        str | None, Field(description='the name of the property type (e.g. d:text)')
    ] = None
    defaultValue: Annotated[str | None, Field(description='the default value')] = None
    description: Annotated[str | None, Field(description='the human-readable description')] = None
    id: str
    isMandatory: Annotated[
        bool | None, Field(description='define if the property is mandatory')
    ] = None
    isMandatoryEnforced: Annotated[
        bool | None, Field(description='define if the presence of mandatory properties is enforced')
    ] = None
    isMultiValued: Annotated[
        bool | None, Field(description='define if the property is multi-valued')
    ] = None
    isProtected: Annotated[
        bool | None, Field(description='define if the property is system maintained')
    ] = None
    title: Annotated[str | None, Field(description='the human-readable title')] = None


class AbstractClassAssociation(BaseModel):
    description: str | None = None
    id: str
    isChild: bool | None = None
    isProtected: bool | None = None
    source: AbstractClassAssociationSource | None = None
    target: AbstractClassAssociationSource | None = None
    title: str | None = None


class AbstractClass(BaseModel):
    associations: list[AbstractClassAssociation] | None = None
    description: str | None = None
    id: str
    includedInSupertypeQuery: bool | None = None
    isArchive: bool | None = None
    isContainer: bool | None = None
    mandatoryAspects: list[str] | None = None
    model: Model | None = None
    parentId: str | None = None
    properties: list[Property] | None = None
    title: str


class Aspect(RootModel[AbstractClass]):
    root: AbstractClass


class AspectEntry(BaseModel):
    entry: Aspect


class List(BaseModel):
    entries: list[AspectEntry] | None = None
    pagination: Pagination | None = None


class AspectPaging(BaseModel):
    list: List | None = None


class Type(RootModel[AbstractClass]):
    root: AbstractClass


class TypeEntry(BaseModel):
    entry: Type


class List1(BaseModel):
    entries: list[TypeEntry] | None = None
    pagination: Pagination | None = None


class TypePaging(BaseModel):
    list: List1 | None = None
