# ALIS: Algorithmic Library for Scalability

ALIS: Algorithmic Library for Scalability is a Python package and a good accompanying reference for Leskovec, Rajaraman, and Ullman's [Mining of Massive Datasets](http://www.mmds.org/). This book currently covers topics from Chapters 3 through 5, and Chapter 10 of the reference.

This book provides:

1. Additional mathematical and code examples
2. Additional exercises both theoretical and practical
3. Re-useable API for scalable data mining

ALIS is inspired by the [Dive into Deep Learning](https://d2l.ai/index.html) interactive book with code, math, and discussion.

## Installation

ALIS was built using a Python version of 3.8.12. To install the package, perform the following steps:

1. Clone the `alis` github repository

```
https://github.com/phdinds-aim/alis.git
```

2. Install the environment or the requirements file via conda or pip

Installation of required libraries via `pip`

```
pip install -r requirements.txt
```

Installation of required libraries via `conda`

```
conda env create -f environment.yml
conda activate alis
```

3. Install the `alis` package as an editable source.

```
pip install -e .
```

Done! 🎉 The `alis` package is now installed in your machine.


## Authors

ALIS is proudly made by the Asian Institute of Management's PhDinDS batch 2024

- Leodegario Lorenzo II
- Michael Dorosan
- Joseph Christian Noel
- Antonio Briza
- Ranzivelle Marianne Roxas-Villanueva

with supervision of our Professor Christian Alis, PhD.
