# coding: utf-8

"""
  Copyright 2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from ..models.get_browse_nodes_resource import GetBrowseNodesResource  # noqa: F401,E501
from ..models.partner_type import PartnerType  # noqa: F401,E501


class GetBrowseNodesRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'browse_node_ids': 'list[str]',
        'languages_of_preference': 'list[str]',
        'marketplace': 'str',
        'partner_tag': 'str',
        'partner_type': 'PartnerType',
        'resources': 'list[GetBrowseNodesResource]'
    }

    attribute_map = {
        'browse_node_ids': 'BrowseNodeIds',
        'languages_of_preference': 'LanguagesOfPreference',
        'marketplace': 'Marketplace',
        'partner_tag': 'PartnerTag',
        'partner_type': 'PartnerType',
        'resources': 'Resources'
    }

    def __init__(self, browse_node_ids=None, languages_of_preference=None, marketplace=None, partner_tag=None, partner_type=None, resources=None):  # noqa: E501
        """GetBrowseNodesRequest - a model defined in Swagger"""  # noqa: E501

        self._browse_node_ids = None
        self._languages_of_preference = None
        self._marketplace = None
        self._partner_tag = None
        self._partner_type = None
        self._resources = None
        self.discriminator = None

        self.browse_node_ids = browse_node_ids
        if languages_of_preference is not None:
            self.languages_of_preference = languages_of_preference
        if marketplace is not None:
            self.marketplace = marketplace
        self.partner_tag = partner_tag
        self.partner_type = partner_type
        if resources is not None:
            self.resources = resources

    @property
    def browse_node_ids(self):
        """Gets the browse_node_ids of this GetBrowseNodesRequest.  # noqa: E501


        :return: The browse_node_ids of this GetBrowseNodesRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._browse_node_ids

    @browse_node_ids.setter
    def browse_node_ids(self, browse_node_ids):
        """Sets the browse_node_ids of this GetBrowseNodesRequest.


        :param browse_node_ids: The browse_node_ids of this GetBrowseNodesRequest.  # noqa: E501
        :type: list[str]
        """
        if browse_node_ids is None:
            raise ValueError("Invalid value for `browse_node_ids`, must not be `None`")  # noqa: E501

        self._browse_node_ids = browse_node_ids

    @property
    def languages_of_preference(self):
        """Gets the languages_of_preference of this GetBrowseNodesRequest.  # noqa: E501


        :return: The languages_of_preference of this GetBrowseNodesRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._languages_of_preference

    @languages_of_preference.setter
    def languages_of_preference(self, languages_of_preference):
        """Sets the languages_of_preference of this GetBrowseNodesRequest.


        :param languages_of_preference: The languages_of_preference of this GetBrowseNodesRequest.  # noqa: E501
        :type: list[str]
        """

        self._languages_of_preference = languages_of_preference

    @property
    def marketplace(self):
        """Gets the marketplace of this GetBrowseNodesRequest.  # noqa: E501


        :return: The marketplace of this GetBrowseNodesRequest.  # noqa: E501
        :rtype: str
        """
        return self._marketplace

    @marketplace.setter
    def marketplace(self, marketplace):
        """Sets the marketplace of this GetBrowseNodesRequest.


        :param marketplace: The marketplace of this GetBrowseNodesRequest.  # noqa: E501
        :type: str
        """

        self._marketplace = marketplace

    @property
    def partner_tag(self):
        """Gets the partner_tag of this GetBrowseNodesRequest.  # noqa: E501


        :return: The partner_tag of this GetBrowseNodesRequest.  # noqa: E501
        :rtype: str
        """
        return self._partner_tag

    @partner_tag.setter
    def partner_tag(self, partner_tag):
        """Sets the partner_tag of this GetBrowseNodesRequest.


        :param partner_tag: The partner_tag of this GetBrowseNodesRequest.  # noqa: E501
        :type: str
        """
        if partner_tag is None:
            raise ValueError("Invalid value for `partner_tag`, must not be `None`")  # noqa: E501

        self._partner_tag = partner_tag

    @property
    def partner_type(self):
        """Gets the partner_type of this GetBrowseNodesRequest.  # noqa: E501


        :return: The partner_type of this GetBrowseNodesRequest.  # noqa: E501
        :rtype: PartnerType
        """
        return self._partner_type

    @partner_type.setter
    def partner_type(self, partner_type):
        """Sets the partner_type of this GetBrowseNodesRequest.


        :param partner_type: The partner_type of this GetBrowseNodesRequest.  # noqa: E501
        :type: PartnerType
        """
        if partner_type is None:
            raise ValueError("Invalid value for `partner_type`, must not be `None`")  # noqa: E501

        self._partner_type = partner_type

    @property
    def resources(self):
        """Gets the resources of this GetBrowseNodesRequest.  # noqa: E501


        :return: The resources of this GetBrowseNodesRequest.  # noqa: E501
        :rtype: list[GetBrowseNodesResource]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this GetBrowseNodesRequest.


        :param resources: The resources of this GetBrowseNodesRequest.  # noqa: E501
        :type: list[GetBrowseNodesResource]
        """

        self._resources = resources

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetBrowseNodesRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetBrowseNodesRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
