# coding: utf-8

"""
  Copyright 2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from ..models.money import Money  # noqa: F401,E501
from ..models.offer_saving_basis import OfferSavingBasis  # noqa: F401,E501
from ..models.offer_savings_v2 import OfferSavingsV2  # noqa: F401,E501


class OfferPriceV2(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'money': 'Money',
        'price_per_unit': 'Money',
        'savings': 'OfferSavingsV2',
        'saving_basis': 'OfferSavingBasis'
    }

    attribute_map = {
        'money': 'Money',
        'price_per_unit': 'PricePerUnit',
        'savings': 'Savings',
        'saving_basis': 'SavingBasis'
    }

    def __init__(self, money=None, price_per_unit=None, savings=None, saving_basis=None):  # noqa: E501
        """OfferPriceV2 - a model defined in Swagger"""  # noqa: E501

        self._money = None
        self._price_per_unit = None
        self._savings = None
        self._saving_basis = None
        self.discriminator = None

        if money is not None:
            self.money = money
        if price_per_unit is not None:
            self.price_per_unit = price_per_unit
        if savings is not None:
            self.savings = savings
        if saving_basis is not None:
            self.saving_basis = saving_basis

    @property
    def money(self):
        """Gets the money of this OfferPriceV2.  # noqa: E501


        :return: The money of this OfferPriceV2.  # noqa: E501
        :rtype: Money
        """
        return self._money

    @money.setter
    def money(self, money):
        """Sets the money of this OfferPriceV2.


        :param money: The money of this OfferPriceV2.  # noqa: E501
        :type: Money
        """

        self._money = money

    @property
    def price_per_unit(self):
        """Gets the price_per_unit of this OfferPriceV2.  # noqa: E501


        :return: The price_per_unit of this OfferPriceV2.  # noqa: E501
        :rtype: Money
        """
        return self._price_per_unit

    @price_per_unit.setter
    def price_per_unit(self, price_per_unit):
        """Sets the price_per_unit of this OfferPriceV2.


        :param price_per_unit: The price_per_unit of this OfferPriceV2.  # noqa: E501
        :type: Money
        """

        self._price_per_unit = price_per_unit

    @property
    def savings(self):
        """Gets the savings of this OfferPriceV2.  # noqa: E501


        :return: The savings of this OfferPriceV2.  # noqa: E501
        :rtype: OfferSavingsV2
        """
        return self._savings

    @savings.setter
    def savings(self, savings):
        """Sets the savings of this OfferPriceV2.


        :param savings: The savings of this OfferPriceV2.  # noqa: E501
        :type: OfferSavingsV2
        """

        self._savings = savings

    @property
    def saving_basis(self):
        """Gets the saving_basis of this OfferPriceV2.  # noqa: E501


        :return: The saving_basis of this OfferPriceV2.  # noqa: E501
        :rtype: OfferSavingBasis
        """
        return self._saving_basis

    @saving_basis.setter
    def saving_basis(self, saving_basis):
        """Sets the saving_basis of this OfferPriceV2.


        :param saving_basis: The saving_basis of this OfferPriceV2.  # noqa: E501
        :type: OfferSavingBasis
        """

        self._saving_basis = saving_basis

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OfferPriceV2, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OfferPriceV2):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
