# coding: utf-8

"""
  Copyright 2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from ..models.big_decimal import BigDecimal  # noqa: F401,E501


class Money(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amount': 'BigDecimal',
        'currency': 'str',
        'display_amount': 'str'
    }

    attribute_map = {
        'amount': 'Amount',
        'currency': 'Currency',
        'display_amount': 'DisplayAmount'
    }

    def __init__(self, amount=None, currency=None, display_amount=None):  # noqa: E501
        """Money - a model defined in Swagger"""  # noqa: E501

        self._amount = None
        self._currency = None
        self._display_amount = None
        self.discriminator = None

        if amount is not None:
            self.amount = amount
        if currency is not None:
            self.currency = currency
        if display_amount is not None:
            self.display_amount = display_amount

    @property
    def amount(self):
        """Gets the amount of this Money.  # noqa: E501


        :return: The amount of this Money.  # noqa: E501
        :rtype: BigDecimal
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Money.


        :param amount: The amount of this Money.  # noqa: E501
        :type: BigDecimal
        """

        self._amount = amount

    @property
    def currency(self):
        """Gets the currency of this Money.  # noqa: E501


        :return: The currency of this Money.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this Money.


        :param currency: The currency of this Money.  # noqa: E501
        :type: str
        """

        self._currency = currency

    @property
    def display_amount(self):
        """Gets the display_amount of this Money.  # noqa: E501


        :return: The display_amount of this Money.  # noqa: E501
        :rtype: str
        """
        return self._display_amount

    @display_amount.setter
    def display_amount(self, display_amount):
        """Sets the display_amount of this Money.


        :param display_amount: The display_amount of this Money.  # noqa: E501
        :type: str
        """

        self._display_amount = display_amount

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Money, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Money):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
