from sp_api_async.base.helpers import sp_endpoint
from sp_api_async.base import Client, ApiResponse


class Sellers(Client):
    """
    :link: https://github.com/amzn/selling-partner-api-docs/blob/main/references/sellers-api/sellers.md

    """

    @sp_endpoint("/sellers/v1/marketplaceParticipations")
    async def get_marketplace_participation(self, **kwargs) -> ApiResponse:
        """
        get_marketplace_participation(self, **kwargs) -> ApiResponse
        Returns a list of marketplaces that the seller submitting the request can sell in and information about the seller's participation in those marketplaces.

        **Usage Plan:**

        ======================================  ==============
        Rate (requests per second)               Burst
        ======================================  ==============
        .016                                    15
        ======================================  ==============

        For more information, see "Usage Plans and Rate Limits" in the Selling Partner API documentation.

        Examples:
            literal blocks::

                res = await Sellers().get_marketplace_participation()

        Args:
            **kwargs:

        Returns:
            GetMarketplaceParticipationsResponse:

        """
        return await self._request(kwargs.pop("path"), add_marketplace=False)

    @sp_endpoint("/sellers/v1/account")
    async def get_account(self, **kwargs) -> ApiResponse:
        """
        get_account(self, **kwargs) -> ApiResponse
        Returns information about a seller account and its marketplaces.

        **Usage Plan:**

        ======================================  ==============
        Rate (requests per second)               Burst
        ======================================  ==============
        .016                                    15
        ======================================  ==============

        For more information, see "Usage Plans and Rate Limits" in the Selling Partner API documentation.

        Examples:
            literal blocks::

                res = await Sellers().get_account()

        Args:
            **kwargs:

        Returns:
            GetAccountResponse:

        """
        return await self._request(kwargs.pop("path"), add_marketplace=False)
