# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class AffordabilityExpenseEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amazon_order_id': 'str',
        'posted_date': 'ModelDate',
        'marketplace_id': 'str',
        'transaction_type': 'str',
        'base_expense': 'Currency',
        'tax_type_cgst': 'Currency',
        'tax_type_sgst': 'Currency',
        'tax_type_igst': 'Currency',
        'total_expense': 'Currency'
    }

    attribute_map = {
        'amazon_order_id': 'AmazonOrderId',
        'posted_date': 'PostedDate',
        'marketplace_id': 'MarketplaceId',
        'transaction_type': 'TransactionType',
        'base_expense': 'BaseExpense',
        'tax_type_cgst': 'TaxTypeCGST',
        'tax_type_sgst': 'TaxTypeSGST',
        'tax_type_igst': 'TaxTypeIGST',
        'total_expense': 'TotalExpense'
    }

    def __init__(self, amazon_order_id=None, posted_date=None, marketplace_id=None, transaction_type=None, base_expense=None, tax_type_cgst=None, tax_type_sgst=None, tax_type_igst=None, total_expense=None):  # noqa: E501
        """AffordabilityExpenseEvent - a model defined in Swagger"""  # noqa: E501
        self._amazon_order_id = None
        self._posted_date = None
        self._marketplace_id = None
        self._transaction_type = None
        self._base_expense = None
        self._tax_type_cgst = None
        self._tax_type_sgst = None
        self._tax_type_igst = None
        self._total_expense = None
        self.discriminator = None
        if amazon_order_id is not None:
            self.amazon_order_id = amazon_order_id
        if posted_date is not None:
            self.posted_date = posted_date
        if marketplace_id is not None:
            self.marketplace_id = marketplace_id
        if transaction_type is not None:
            self.transaction_type = transaction_type
        if base_expense is not None:
            self.base_expense = base_expense
        self.tax_type_cgst = tax_type_cgst
        self.tax_type_sgst = tax_type_sgst
        self.tax_type_igst = tax_type_igst
        if total_expense is not None:
            self.total_expense = total_expense

    @property
    def amazon_order_id(self):
        """Gets the amazon_order_id of this AffordabilityExpenseEvent.  # noqa: E501

        An Amazon-defined identifier for an order.  # noqa: E501

        :return: The amazon_order_id of this AffordabilityExpenseEvent.  # noqa: E501
        :rtype: str
        """
        return self._amazon_order_id

    @amazon_order_id.setter
    def amazon_order_id(self, amazon_order_id):
        """Sets the amazon_order_id of this AffordabilityExpenseEvent.

        An Amazon-defined identifier for an order.  # noqa: E501

        :param amazon_order_id: The amazon_order_id of this AffordabilityExpenseEvent.  # noqa: E501
        :type: str
        """

        self._amazon_order_id = amazon_order_id

    @property
    def posted_date(self):
        """Gets the posted_date of this AffordabilityExpenseEvent.  # noqa: E501


        :return: The posted_date of this AffordabilityExpenseEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this AffordabilityExpenseEvent.


        :param posted_date: The posted_date of this AffordabilityExpenseEvent.  # noqa: E501
        :type: ModelDate
        """

        self._posted_date = posted_date

    @property
    def marketplace_id(self):
        """Gets the marketplace_id of this AffordabilityExpenseEvent.  # noqa: E501

        An encrypted, Amazon-defined marketplace identifier.  # noqa: E501

        :return: The marketplace_id of this AffordabilityExpenseEvent.  # noqa: E501
        :rtype: str
        """
        return self._marketplace_id

    @marketplace_id.setter
    def marketplace_id(self, marketplace_id):
        """Sets the marketplace_id of this AffordabilityExpenseEvent.

        An encrypted, Amazon-defined marketplace identifier.  # noqa: E501

        :param marketplace_id: The marketplace_id of this AffordabilityExpenseEvent.  # noqa: E501
        :type: str
        """

        self._marketplace_id = marketplace_id

    @property
    def transaction_type(self):
        """Gets the transaction_type of this AffordabilityExpenseEvent.  # noqa: E501

        Indicates the type of transaction.   Possible values:  * Charge - For an affordability promotion expense.  * Refund - For an affordability promotion expense reversal.  # noqa: E501

        :return: The transaction_type of this AffordabilityExpenseEvent.  # noqa: E501
        :rtype: str
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """Sets the transaction_type of this AffordabilityExpenseEvent.

        Indicates the type of transaction.   Possible values:  * Charge - For an affordability promotion expense.  * Refund - For an affordability promotion expense reversal.  # noqa: E501

        :param transaction_type: The transaction_type of this AffordabilityExpenseEvent.  # noqa: E501
        :type: str
        """

        self._transaction_type = transaction_type

    @property
    def base_expense(self):
        """Gets the base_expense of this AffordabilityExpenseEvent.  # noqa: E501


        :return: The base_expense of this AffordabilityExpenseEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._base_expense

    @base_expense.setter
    def base_expense(self, base_expense):
        """Sets the base_expense of this AffordabilityExpenseEvent.


        :param base_expense: The base_expense of this AffordabilityExpenseEvent.  # noqa: E501
        :type: Currency
        """

        self._base_expense = base_expense

    @property
    def tax_type_cgst(self):
        """Gets the tax_type_cgst of this AffordabilityExpenseEvent.  # noqa: E501


        :return: The tax_type_cgst of this AffordabilityExpenseEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._tax_type_cgst

    @tax_type_cgst.setter
    def tax_type_cgst(self, tax_type_cgst):
        """Sets the tax_type_cgst of this AffordabilityExpenseEvent.


        :param tax_type_cgst: The tax_type_cgst of this AffordabilityExpenseEvent.  # noqa: E501
        :type: Currency
        """
        if tax_type_cgst is None:
            raise ValueError("Invalid value for `tax_type_cgst`, must not be `None`")  # noqa: E501

        self._tax_type_cgst = tax_type_cgst

    @property
    def tax_type_sgst(self):
        """Gets the tax_type_sgst of this AffordabilityExpenseEvent.  # noqa: E501


        :return: The tax_type_sgst of this AffordabilityExpenseEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._tax_type_sgst

    @tax_type_sgst.setter
    def tax_type_sgst(self, tax_type_sgst):
        """Sets the tax_type_sgst of this AffordabilityExpenseEvent.


        :param tax_type_sgst: The tax_type_sgst of this AffordabilityExpenseEvent.  # noqa: E501
        :type: Currency
        """
        if tax_type_sgst is None:
            raise ValueError("Invalid value for `tax_type_sgst`, must not be `None`")  # noqa: E501

        self._tax_type_sgst = tax_type_sgst

    @property
    def tax_type_igst(self):
        """Gets the tax_type_igst of this AffordabilityExpenseEvent.  # noqa: E501


        :return: The tax_type_igst of this AffordabilityExpenseEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._tax_type_igst

    @tax_type_igst.setter
    def tax_type_igst(self, tax_type_igst):
        """Sets the tax_type_igst of this AffordabilityExpenseEvent.


        :param tax_type_igst: The tax_type_igst of this AffordabilityExpenseEvent.  # noqa: E501
        :type: Currency
        """
        if tax_type_igst is None:
            raise ValueError("Invalid value for `tax_type_igst`, must not be `None`")  # noqa: E501

        self._tax_type_igst = tax_type_igst

    @property
    def total_expense(self):
        """Gets the total_expense of this AffordabilityExpenseEvent.  # noqa: E501


        :return: The total_expense of this AffordabilityExpenseEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._total_expense

    @total_expense.setter
    def total_expense(self, total_expense):
        """Sets the total_expense of this AffordabilityExpenseEvent.


        :param total_expense: The total_expense of this AffordabilityExpenseEvent.  # noqa: E501
        :type: Currency
        """

        self._total_expense = total_expense

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AffordabilityExpenseEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AffordabilityExpenseEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
