# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class ShipmentEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amazon_order_id': 'str',
        'seller_order_id': 'str',
        'marketplace_name': 'str',
        'order_charge_list': 'ChargeComponentList',
        'order_charge_adjustment_list': 'ChargeComponentList',
        'shipment_fee_list': 'FeeComponentList',
        'shipment_fee_adjustment_list': 'FeeComponentList',
        'order_fee_list': 'FeeComponentList',
        'order_fee_adjustment_list': 'FeeComponentList',
        'direct_payment_list': 'DirectPaymentList',
        'posted_date': 'ModelDate',
        'shipment_item_list': 'ShipmentItemList',
        'shipment_item_adjustment_list': 'ShipmentItemList'
    }

    attribute_map = {
        'amazon_order_id': 'AmazonOrderId',
        'seller_order_id': 'SellerOrderId',
        'marketplace_name': 'MarketplaceName',
        'order_charge_list': 'OrderChargeList',
        'order_charge_adjustment_list': 'OrderChargeAdjustmentList',
        'shipment_fee_list': 'ShipmentFeeList',
        'shipment_fee_adjustment_list': 'ShipmentFeeAdjustmentList',
        'order_fee_list': 'OrderFeeList',
        'order_fee_adjustment_list': 'OrderFeeAdjustmentList',
        'direct_payment_list': 'DirectPaymentList',
        'posted_date': 'PostedDate',
        'shipment_item_list': 'ShipmentItemList',
        'shipment_item_adjustment_list': 'ShipmentItemAdjustmentList'
    }

    def __init__(self, amazon_order_id=None, seller_order_id=None, marketplace_name=None, order_charge_list=None, order_charge_adjustment_list=None, shipment_fee_list=None, shipment_fee_adjustment_list=None, order_fee_list=None, order_fee_adjustment_list=None, direct_payment_list=None, posted_date=None, shipment_item_list=None, shipment_item_adjustment_list=None):  # noqa: E501
        """ShipmentEvent - a model defined in Swagger"""  # noqa: E501
        self._amazon_order_id = None
        self._seller_order_id = None
        self._marketplace_name = None
        self._order_charge_list = None
        self._order_charge_adjustment_list = None
        self._shipment_fee_list = None
        self._shipment_fee_adjustment_list = None
        self._order_fee_list = None
        self._order_fee_adjustment_list = None
        self._direct_payment_list = None
        self._posted_date = None
        self._shipment_item_list = None
        self._shipment_item_adjustment_list = None
        self.discriminator = None
        if amazon_order_id is not None:
            self.amazon_order_id = amazon_order_id
        if seller_order_id is not None:
            self.seller_order_id = seller_order_id
        if marketplace_name is not None:
            self.marketplace_name = marketplace_name
        if order_charge_list is not None:
            self.order_charge_list = order_charge_list
        if order_charge_adjustment_list is not None:
            self.order_charge_adjustment_list = order_charge_adjustment_list
        if shipment_fee_list is not None:
            self.shipment_fee_list = shipment_fee_list
        if shipment_fee_adjustment_list is not None:
            self.shipment_fee_adjustment_list = shipment_fee_adjustment_list
        if order_fee_list is not None:
            self.order_fee_list = order_fee_list
        if order_fee_adjustment_list is not None:
            self.order_fee_adjustment_list = order_fee_adjustment_list
        if direct_payment_list is not None:
            self.direct_payment_list = direct_payment_list
        if posted_date is not None:
            self.posted_date = posted_date
        if shipment_item_list is not None:
            self.shipment_item_list = shipment_item_list
        if shipment_item_adjustment_list is not None:
            self.shipment_item_adjustment_list = shipment_item_adjustment_list

    @property
    def amazon_order_id(self):
        """Gets the amazon_order_id of this ShipmentEvent.  # noqa: E501

        An Amazon-defined identifier for an order.  # noqa: E501

        :return: The amazon_order_id of this ShipmentEvent.  # noqa: E501
        :rtype: str
        """
        return self._amazon_order_id

    @amazon_order_id.setter
    def amazon_order_id(self, amazon_order_id):
        """Sets the amazon_order_id of this ShipmentEvent.

        An Amazon-defined identifier for an order.  # noqa: E501

        :param amazon_order_id: The amazon_order_id of this ShipmentEvent.  # noqa: E501
        :type: str
        """

        self._amazon_order_id = amazon_order_id

    @property
    def seller_order_id(self):
        """Gets the seller_order_id of this ShipmentEvent.  # noqa: E501

        A seller-defined identifier for an order.  # noqa: E501

        :return: The seller_order_id of this ShipmentEvent.  # noqa: E501
        :rtype: str
        """
        return self._seller_order_id

    @seller_order_id.setter
    def seller_order_id(self, seller_order_id):
        """Sets the seller_order_id of this ShipmentEvent.

        A seller-defined identifier for an order.  # noqa: E501

        :param seller_order_id: The seller_order_id of this ShipmentEvent.  # noqa: E501
        :type: str
        """

        self._seller_order_id = seller_order_id

    @property
    def marketplace_name(self):
        """Gets the marketplace_name of this ShipmentEvent.  # noqa: E501

        The name of the marketplace where the event occurred.  # noqa: E501

        :return: The marketplace_name of this ShipmentEvent.  # noqa: E501
        :rtype: str
        """
        return self._marketplace_name

    @marketplace_name.setter
    def marketplace_name(self, marketplace_name):
        """Sets the marketplace_name of this ShipmentEvent.

        The name of the marketplace where the event occurred.  # noqa: E501

        :param marketplace_name: The marketplace_name of this ShipmentEvent.  # noqa: E501
        :type: str
        """

        self._marketplace_name = marketplace_name

    @property
    def order_charge_list(self):
        """Gets the order_charge_list of this ShipmentEvent.  # noqa: E501


        :return: The order_charge_list of this ShipmentEvent.  # noqa: E501
        :rtype: ChargeComponentList
        """
        return self._order_charge_list

    @order_charge_list.setter
    def order_charge_list(self, order_charge_list):
        """Sets the order_charge_list of this ShipmentEvent.


        :param order_charge_list: The order_charge_list of this ShipmentEvent.  # noqa: E501
        :type: ChargeComponentList
        """

        self._order_charge_list = order_charge_list

    @property
    def order_charge_adjustment_list(self):
        """Gets the order_charge_adjustment_list of this ShipmentEvent.  # noqa: E501


        :return: The order_charge_adjustment_list of this ShipmentEvent.  # noqa: E501
        :rtype: ChargeComponentList
        """
        return self._order_charge_adjustment_list

    @order_charge_adjustment_list.setter
    def order_charge_adjustment_list(self, order_charge_adjustment_list):
        """Sets the order_charge_adjustment_list of this ShipmentEvent.


        :param order_charge_adjustment_list: The order_charge_adjustment_list of this ShipmentEvent.  # noqa: E501
        :type: ChargeComponentList
        """

        self._order_charge_adjustment_list = order_charge_adjustment_list

    @property
    def shipment_fee_list(self):
        """Gets the shipment_fee_list of this ShipmentEvent.  # noqa: E501


        :return: The shipment_fee_list of this ShipmentEvent.  # noqa: E501
        :rtype: FeeComponentList
        """
        return self._shipment_fee_list

    @shipment_fee_list.setter
    def shipment_fee_list(self, shipment_fee_list):
        """Sets the shipment_fee_list of this ShipmentEvent.


        :param shipment_fee_list: The shipment_fee_list of this ShipmentEvent.  # noqa: E501
        :type: FeeComponentList
        """

        self._shipment_fee_list = shipment_fee_list

    @property
    def shipment_fee_adjustment_list(self):
        """Gets the shipment_fee_adjustment_list of this ShipmentEvent.  # noqa: E501


        :return: The shipment_fee_adjustment_list of this ShipmentEvent.  # noqa: E501
        :rtype: FeeComponentList
        """
        return self._shipment_fee_adjustment_list

    @shipment_fee_adjustment_list.setter
    def shipment_fee_adjustment_list(self, shipment_fee_adjustment_list):
        """Sets the shipment_fee_adjustment_list of this ShipmentEvent.


        :param shipment_fee_adjustment_list: The shipment_fee_adjustment_list of this ShipmentEvent.  # noqa: E501
        :type: FeeComponentList
        """

        self._shipment_fee_adjustment_list = shipment_fee_adjustment_list

    @property
    def order_fee_list(self):
        """Gets the order_fee_list of this ShipmentEvent.  # noqa: E501


        :return: The order_fee_list of this ShipmentEvent.  # noqa: E501
        :rtype: FeeComponentList
        """
        return self._order_fee_list

    @order_fee_list.setter
    def order_fee_list(self, order_fee_list):
        """Sets the order_fee_list of this ShipmentEvent.


        :param order_fee_list: The order_fee_list of this ShipmentEvent.  # noqa: E501
        :type: FeeComponentList
        """

        self._order_fee_list = order_fee_list

    @property
    def order_fee_adjustment_list(self):
        """Gets the order_fee_adjustment_list of this ShipmentEvent.  # noqa: E501


        :return: The order_fee_adjustment_list of this ShipmentEvent.  # noqa: E501
        :rtype: FeeComponentList
        """
        return self._order_fee_adjustment_list

    @order_fee_adjustment_list.setter
    def order_fee_adjustment_list(self, order_fee_adjustment_list):
        """Sets the order_fee_adjustment_list of this ShipmentEvent.


        :param order_fee_adjustment_list: The order_fee_adjustment_list of this ShipmentEvent.  # noqa: E501
        :type: FeeComponentList
        """

        self._order_fee_adjustment_list = order_fee_adjustment_list

    @property
    def direct_payment_list(self):
        """Gets the direct_payment_list of this ShipmentEvent.  # noqa: E501


        :return: The direct_payment_list of this ShipmentEvent.  # noqa: E501
        :rtype: DirectPaymentList
        """
        return self._direct_payment_list

    @direct_payment_list.setter
    def direct_payment_list(self, direct_payment_list):
        """Sets the direct_payment_list of this ShipmentEvent.


        :param direct_payment_list: The direct_payment_list of this ShipmentEvent.  # noqa: E501
        :type: DirectPaymentList
        """

        self._direct_payment_list = direct_payment_list

    @property
    def posted_date(self):
        """Gets the posted_date of this ShipmentEvent.  # noqa: E501


        :return: The posted_date of this ShipmentEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this ShipmentEvent.


        :param posted_date: The posted_date of this ShipmentEvent.  # noqa: E501
        :type: ModelDate
        """

        self._posted_date = posted_date

    @property
    def shipment_item_list(self):
        """Gets the shipment_item_list of this ShipmentEvent.  # noqa: E501


        :return: The shipment_item_list of this ShipmentEvent.  # noqa: E501
        :rtype: ShipmentItemList
        """
        return self._shipment_item_list

    @shipment_item_list.setter
    def shipment_item_list(self, shipment_item_list):
        """Sets the shipment_item_list of this ShipmentEvent.


        :param shipment_item_list: The shipment_item_list of this ShipmentEvent.  # noqa: E501
        :type: ShipmentItemList
        """

        self._shipment_item_list = shipment_item_list

    @property
    def shipment_item_adjustment_list(self):
        """Gets the shipment_item_adjustment_list of this ShipmentEvent.  # noqa: E501


        :return: The shipment_item_adjustment_list of this ShipmentEvent.  # noqa: E501
        :rtype: ShipmentItemList
        """
        return self._shipment_item_adjustment_list

    @shipment_item_adjustment_list.setter
    def shipment_item_adjustment_list(self, shipment_item_adjustment_list):
        """Sets the shipment_item_adjustment_list of this ShipmentEvent.


        :param shipment_item_adjustment_list: The shipment_item_adjustment_list of this ShipmentEvent.  # noqa: E501
        :type: ShipmentItemList
        """

        self._shipment_item_adjustment_list = shipment_item_adjustment_list

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ShipmentEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ShipmentEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
