# coding: utf-8

"""
    Selling Partner API for Notifications

    The Selling Partner API for Notifications lets you subscribe to notifications that are relevant to a selling partner's business. Using this API you can create a destination to receive notifications, subscribe to notifications, delete notification subscriptions, and more.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class Destination(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'destination_id': 'str',
        'resource': 'DestinationResource'
    }

    attribute_map = {
        'name': 'name',
        'destination_id': 'destinationId',
        'resource': 'resource'
    }

    def __init__(self, name=None, destination_id=None, resource=None):  # noqa: E501
        """Destination - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._destination_id = None
        self._resource = None
        self.discriminator = None
        self.name = name
        self.destination_id = destination_id
        self.resource = resource

    @property
    def name(self):
        """Gets the name of this Destination.  # noqa: E501

        The developer-defined name for this destination.  # noqa: E501

        :return: The name of this Destination.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Destination.

        The developer-defined name for this destination.  # noqa: E501

        :param name: The name of this Destination.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def destination_id(self):
        """Gets the destination_id of this Destination.  # noqa: E501

        The destination identifier generated when you created the destination.  # noqa: E501

        :return: The destination_id of this Destination.  # noqa: E501
        :rtype: str
        """
        return self._destination_id

    @destination_id.setter
    def destination_id(self, destination_id):
        """Sets the destination_id of this Destination.

        The destination identifier generated when you created the destination.  # noqa: E501

        :param destination_id: The destination_id of this Destination.  # noqa: E501
        :type: str
        """
        if destination_id is None:
            raise ValueError("Invalid value for `destination_id`, must not be `None`")  # noqa: E501

        self._destination_id = destination_id

    @property
    def resource(self):
        """Gets the resource of this Destination.  # noqa: E501


        :return: The resource of this Destination.  # noqa: E501
        :rtype: DestinationResource
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """Sets the resource of this Destination.


        :param resource: The resource of this Destination.  # noqa: E501
        :type: DestinationResource
        """
        if resource is None:
            raise ValueError("Invalid value for `resource`, must not be `None`")  # noqa: E501

        self._resource = resource

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Destination, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Destination):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
