# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class RetrochargeEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'retrocharge_event_type': 'str',
        'amazon_order_id': 'str',
        'posted_date': 'ModelDate',
        'base_tax': 'Currency',
        'shipping_tax': 'Currency',
        'marketplace_name': 'str',
        'retrocharge_tax_withheld_list': 'TaxWithheldComponentList'
    }

    attribute_map = {
        'retrocharge_event_type': 'RetrochargeEventType',
        'amazon_order_id': 'AmazonOrderId',
        'posted_date': 'PostedDate',
        'base_tax': 'BaseTax',
        'shipping_tax': 'ShippingTax',
        'marketplace_name': 'MarketplaceName',
        'retrocharge_tax_withheld_list': 'RetrochargeTaxWithheldList'
    }

    def __init__(self, retrocharge_event_type=None, amazon_order_id=None, posted_date=None, base_tax=None, shipping_tax=None, marketplace_name=None, retrocharge_tax_withheld_list=None):  # noqa: E501
        """RetrochargeEvent - a model defined in Swagger"""  # noqa: E501
        self._retrocharge_event_type = None
        self._amazon_order_id = None
        self._posted_date = None
        self._base_tax = None
        self._shipping_tax = None
        self._marketplace_name = None
        self._retrocharge_tax_withheld_list = None
        self.discriminator = None
        if retrocharge_event_type is not None:
            self.retrocharge_event_type = retrocharge_event_type
        if amazon_order_id is not None:
            self.amazon_order_id = amazon_order_id
        if posted_date is not None:
            self.posted_date = posted_date
        if base_tax is not None:
            self.base_tax = base_tax
        if shipping_tax is not None:
            self.shipping_tax = shipping_tax
        if marketplace_name is not None:
            self.marketplace_name = marketplace_name
        if retrocharge_tax_withheld_list is not None:
            self.retrocharge_tax_withheld_list = retrocharge_tax_withheld_list

    @property
    def retrocharge_event_type(self):
        """Gets the retrocharge_event_type of this RetrochargeEvent.  # noqa: E501

        The type of event.  Possible values:  * Retrocharge  * RetrochargeReversal  # noqa: E501

        :return: The retrocharge_event_type of this RetrochargeEvent.  # noqa: E501
        :rtype: str
        """
        return self._retrocharge_event_type

    @retrocharge_event_type.setter
    def retrocharge_event_type(self, retrocharge_event_type):
        """Sets the retrocharge_event_type of this RetrochargeEvent.

        The type of event.  Possible values:  * Retrocharge  * RetrochargeReversal  # noqa: E501

        :param retrocharge_event_type: The retrocharge_event_type of this RetrochargeEvent.  # noqa: E501
        :type: str
        """

        self._retrocharge_event_type = retrocharge_event_type

    @property
    def amazon_order_id(self):
        """Gets the amazon_order_id of this RetrochargeEvent.  # noqa: E501

        An Amazon-defined identifier for an order.  # noqa: E501

        :return: The amazon_order_id of this RetrochargeEvent.  # noqa: E501
        :rtype: str
        """
        return self._amazon_order_id

    @amazon_order_id.setter
    def amazon_order_id(self, amazon_order_id):
        """Sets the amazon_order_id of this RetrochargeEvent.

        An Amazon-defined identifier for an order.  # noqa: E501

        :param amazon_order_id: The amazon_order_id of this RetrochargeEvent.  # noqa: E501
        :type: str
        """

        self._amazon_order_id = amazon_order_id

    @property
    def posted_date(self):
        """Gets the posted_date of this RetrochargeEvent.  # noqa: E501


        :return: The posted_date of this RetrochargeEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this RetrochargeEvent.


        :param posted_date: The posted_date of this RetrochargeEvent.  # noqa: E501
        :type: ModelDate
        """

        self._posted_date = posted_date

    @property
    def base_tax(self):
        """Gets the base_tax of this RetrochargeEvent.  # noqa: E501


        :return: The base_tax of this RetrochargeEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._base_tax

    @base_tax.setter
    def base_tax(self, base_tax):
        """Sets the base_tax of this RetrochargeEvent.


        :param base_tax: The base_tax of this RetrochargeEvent.  # noqa: E501
        :type: Currency
        """

        self._base_tax = base_tax

    @property
    def shipping_tax(self):
        """Gets the shipping_tax of this RetrochargeEvent.  # noqa: E501


        :return: The shipping_tax of this RetrochargeEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._shipping_tax

    @shipping_tax.setter
    def shipping_tax(self, shipping_tax):
        """Sets the shipping_tax of this RetrochargeEvent.


        :param shipping_tax: The shipping_tax of this RetrochargeEvent.  # noqa: E501
        :type: Currency
        """

        self._shipping_tax = shipping_tax

    @property
    def marketplace_name(self):
        """Gets the marketplace_name of this RetrochargeEvent.  # noqa: E501

        The name of the marketplace where the retrocharge event occurred.  # noqa: E501

        :return: The marketplace_name of this RetrochargeEvent.  # noqa: E501
        :rtype: str
        """
        return self._marketplace_name

    @marketplace_name.setter
    def marketplace_name(self, marketplace_name):
        """Sets the marketplace_name of this RetrochargeEvent.

        The name of the marketplace where the retrocharge event occurred.  # noqa: E501

        :param marketplace_name: The marketplace_name of this RetrochargeEvent.  # noqa: E501
        :type: str
        """

        self._marketplace_name = marketplace_name

    @property
    def retrocharge_tax_withheld_list(self):
        """Gets the retrocharge_tax_withheld_list of this RetrochargeEvent.  # noqa: E501


        :return: The retrocharge_tax_withheld_list of this RetrochargeEvent.  # noqa: E501
        :rtype: TaxWithheldComponentList
        """
        return self._retrocharge_tax_withheld_list

    @retrocharge_tax_withheld_list.setter
    def retrocharge_tax_withheld_list(self, retrocharge_tax_withheld_list):
        """Sets the retrocharge_tax_withheld_list of this RetrochargeEvent.


        :param retrocharge_tax_withheld_list: The retrocharge_tax_withheld_list of this RetrochargeEvent.  # noqa: E501
        :type: TaxWithheldComponentList
        """

        self._retrocharge_tax_withheld_list = retrocharge_tax_withheld_list

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RetrochargeEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RetrochargeEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
