# coding: utf-8

"""
    Selling Partner API for FBA Inventory

    The Selling Partner API for FBA Inventory lets you programmatically retrieve information about inventory in Amazon's fulfillment network.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class InventorySummary(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'asin': 'str',
        'fn_sku': 'str',
        'seller_sku': 'str',
        'condition': 'str',
        'inventory_details': 'InventoryDetails',
        'last_updated_time': 'datetime',
        'product_name': 'str',
        'total_quantity': 'int'
    }

    attribute_map = {
        'asin': 'asin',
        'fn_sku': 'fnSku',
        'seller_sku': 'sellerSku',
        'condition': 'condition',
        'inventory_details': 'inventoryDetails',
        'last_updated_time': 'lastUpdatedTime',
        'product_name': 'productName',
        'total_quantity': 'totalQuantity'
    }

    def __init__(self, asin=None, fn_sku=None, seller_sku=None, condition=None, inventory_details=None, last_updated_time=None, product_name=None, total_quantity=None):  # noqa: E501
        """InventorySummary - a model defined in Swagger"""  # noqa: E501
        self._asin = None
        self._fn_sku = None
        self._seller_sku = None
        self._condition = None
        self._inventory_details = None
        self._last_updated_time = None
        self._product_name = None
        self._total_quantity = None
        self.discriminator = None
        if asin is not None:
            self.asin = asin
        if fn_sku is not None:
            self.fn_sku = fn_sku
        if seller_sku is not None:
            self.seller_sku = seller_sku
        if condition is not None:
            self.condition = condition
        if inventory_details is not None:
            self.inventory_details = inventory_details
        if last_updated_time is not None:
            self.last_updated_time = last_updated_time
        if product_name is not None:
            self.product_name = product_name
        if total_quantity is not None:
            self.total_quantity = total_quantity

    @property
    def asin(self):
        """Gets the asin of this InventorySummary.  # noqa: E501

        The Amazon Standard Identification Number (ASIN) of an item.  # noqa: E501

        :return: The asin of this InventorySummary.  # noqa: E501
        :rtype: str
        """
        return self._asin

    @asin.setter
    def asin(self, asin):
        """Sets the asin of this InventorySummary.

        The Amazon Standard Identification Number (ASIN) of an item.  # noqa: E501

        :param asin: The asin of this InventorySummary.  # noqa: E501
        :type: str
        """

        self._asin = asin

    @property
    def fn_sku(self):
        """Gets the fn_sku of this InventorySummary.  # noqa: E501

        Amazon's fulfillment network SKU identifier.  # noqa: E501

        :return: The fn_sku of this InventorySummary.  # noqa: E501
        :rtype: str
        """
        return self._fn_sku

    @fn_sku.setter
    def fn_sku(self, fn_sku):
        """Sets the fn_sku of this InventorySummary.

        Amazon's fulfillment network SKU identifier.  # noqa: E501

        :param fn_sku: The fn_sku of this InventorySummary.  # noqa: E501
        :type: str
        """

        self._fn_sku = fn_sku

    @property
    def seller_sku(self):
        """Gets the seller_sku of this InventorySummary.  # noqa: E501

        The seller SKU of the item.  # noqa: E501

        :return: The seller_sku of this InventorySummary.  # noqa: E501
        :rtype: str
        """
        return self._seller_sku

    @seller_sku.setter
    def seller_sku(self, seller_sku):
        """Sets the seller_sku of this InventorySummary.

        The seller SKU of the item.  # noqa: E501

        :param seller_sku: The seller_sku of this InventorySummary.  # noqa: E501
        :type: str
        """

        self._seller_sku = seller_sku

    @property
    def condition(self):
        """Gets the condition of this InventorySummary.  # noqa: E501

        The condition of the item as described by the seller (for example, New Item).  # noqa: E501

        :return: The condition of this InventorySummary.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this InventorySummary.

        The condition of the item as described by the seller (for example, New Item).  # noqa: E501

        :param condition: The condition of this InventorySummary.  # noqa: E501
        :type: str
        """

        self._condition = condition

    @property
    def inventory_details(self):
        """Gets the inventory_details of this InventorySummary.  # noqa: E501


        :return: The inventory_details of this InventorySummary.  # noqa: E501
        :rtype: InventoryDetails
        """
        return self._inventory_details

    @inventory_details.setter
    def inventory_details(self, inventory_details):
        """Sets the inventory_details of this InventorySummary.


        :param inventory_details: The inventory_details of this InventorySummary.  # noqa: E501
        :type: InventoryDetails
        """

        self._inventory_details = inventory_details

    @property
    def last_updated_time(self):
        """Gets the last_updated_time of this InventorySummary.  # noqa: E501

        The date and time that any quantity was last updated.  # noqa: E501

        :return: The last_updated_time of this InventorySummary.  # noqa: E501
        :rtype: datetime
        """
        return self._last_updated_time

    @last_updated_time.setter
    def last_updated_time(self, last_updated_time):
        """Sets the last_updated_time of this InventorySummary.

        The date and time that any quantity was last updated.  # noqa: E501

        :param last_updated_time: The last_updated_time of this InventorySummary.  # noqa: E501
        :type: datetime
        """

        self._last_updated_time = last_updated_time

    @property
    def product_name(self):
        """Gets the product_name of this InventorySummary.  # noqa: E501

        The localized language product title of the item within the specific marketplace.  # noqa: E501

        :return: The product_name of this InventorySummary.  # noqa: E501
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """Sets the product_name of this InventorySummary.

        The localized language product title of the item within the specific marketplace.  # noqa: E501

        :param product_name: The product_name of this InventorySummary.  # noqa: E501
        :type: str
        """

        self._product_name = product_name

    @property
    def total_quantity(self):
        """Gets the total_quantity of this InventorySummary.  # noqa: E501

        The total number of units in an inbound shipment or in Amazon fulfillment centers.  # noqa: E501

        :return: The total_quantity of this InventorySummary.  # noqa: E501
        :rtype: int
        """
        return self._total_quantity

    @total_quantity.setter
    def total_quantity(self, total_quantity):
        """Sets the total_quantity of this InventorySummary.

        The total number of units in an inbound shipment or in Amazon fulfillment centers.  # noqa: E501

        :param total_quantity: The total_quantity of this InventorySummary.  # noqa: E501
        :type: int
        """

        self._total_quantity = total_quantity

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(InventorySummary, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InventorySummary):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
