# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class AdjustmentEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'adjustment_type': 'str',
        'posted_date': 'ModelDate',
        'adjustment_amount': 'Currency',
        'adjustment_item_list': 'AdjustmentItemList'
    }

    attribute_map = {
        'adjustment_type': 'AdjustmentType',
        'posted_date': 'PostedDate',
        'adjustment_amount': 'AdjustmentAmount',
        'adjustment_item_list': 'AdjustmentItemList'
    }

    def __init__(self, adjustment_type=None, posted_date=None, adjustment_amount=None, adjustment_item_list=None):  # noqa: E501
        """AdjustmentEvent - a model defined in Swagger"""  # noqa: E501
        self._adjustment_type = None
        self._posted_date = None
        self._adjustment_amount = None
        self._adjustment_item_list = None
        self.discriminator = None
        if adjustment_type is not None:
            self.adjustment_type = adjustment_type
        if posted_date is not None:
            self.posted_date = posted_date
        if adjustment_amount is not None:
            self.adjustment_amount = adjustment_amount
        if adjustment_item_list is not None:
            self.adjustment_item_list = adjustment_item_list

    @property
    def adjustment_type(self):
        """Gets the adjustment_type of this AdjustmentEvent.  # noqa: E501

        The type of adjustment.  Possible values:  * FBAInventoryReimbursement - An FBA inventory reimbursement to a seller's account. This occurs if a seller's inventory is damaged.  * ReserveEvent - A reserve event that is generated at the time of a settlement period closing. This occurs when some money from a seller's account is held back.  * PostageBilling - The amount paid by a seller for shipping labels.  * PostageRefund - The reimbursement of shipping labels purchased for orders that were canceled or refunded.  * LostOrDamagedReimbursement - An Amazon Easy Ship reimbursement to a seller's account for a package that we lost or damaged.  * CanceledButPickedUpReimbursement - An Amazon Easy Ship reimbursement to a seller's account. This occurs when a package is picked up and the order is subsequently canceled. This value is used only in the India marketplace.  * ReimbursementClawback - An Amazon Easy Ship reimbursement clawback from a seller's account. This occurs when a prior reimbursement is reversed. This value is used only in the India marketplace.  * SellerRewards - An award credited to a seller's account for their participation in an offer in the Seller Rewards program. Applies only to the India marketplace.  # noqa: E501

        :return: The adjustment_type of this AdjustmentEvent.  # noqa: E501
        :rtype: str
        """
        return self._adjustment_type

    @adjustment_type.setter
    def adjustment_type(self, adjustment_type):
        """Sets the adjustment_type of this AdjustmentEvent.

        The type of adjustment.  Possible values:  * FBAInventoryReimbursement - An FBA inventory reimbursement to a seller's account. This occurs if a seller's inventory is damaged.  * ReserveEvent - A reserve event that is generated at the time of a settlement period closing. This occurs when some money from a seller's account is held back.  * PostageBilling - The amount paid by a seller for shipping labels.  * PostageRefund - The reimbursement of shipping labels purchased for orders that were canceled or refunded.  * LostOrDamagedReimbursement - An Amazon Easy Ship reimbursement to a seller's account for a package that we lost or damaged.  * CanceledButPickedUpReimbursement - An Amazon Easy Ship reimbursement to a seller's account. This occurs when a package is picked up and the order is subsequently canceled. This value is used only in the India marketplace.  * ReimbursementClawback - An Amazon Easy Ship reimbursement clawback from a seller's account. This occurs when a prior reimbursement is reversed. This value is used only in the India marketplace.  * SellerRewards - An award credited to a seller's account for their participation in an offer in the Seller Rewards program. Applies only to the India marketplace.  # noqa: E501

        :param adjustment_type: The adjustment_type of this AdjustmentEvent.  # noqa: E501
        :type: str
        """

        self._adjustment_type = adjustment_type

    @property
    def posted_date(self):
        """Gets the posted_date of this AdjustmentEvent.  # noqa: E501


        :return: The posted_date of this AdjustmentEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this AdjustmentEvent.


        :param posted_date: The posted_date of this AdjustmentEvent.  # noqa: E501
        :type: ModelDate
        """

        self._posted_date = posted_date

    @property
    def adjustment_amount(self):
        """Gets the adjustment_amount of this AdjustmentEvent.  # noqa: E501


        :return: The adjustment_amount of this AdjustmentEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._adjustment_amount

    @adjustment_amount.setter
    def adjustment_amount(self, adjustment_amount):
        """Sets the adjustment_amount of this AdjustmentEvent.


        :param adjustment_amount: The adjustment_amount of this AdjustmentEvent.  # noqa: E501
        :type: Currency
        """

        self._adjustment_amount = adjustment_amount

    @property
    def adjustment_item_list(self):
        """Gets the adjustment_item_list of this AdjustmentEvent.  # noqa: E501


        :return: The adjustment_item_list of this AdjustmentEvent.  # noqa: E501
        :rtype: AdjustmentItemList
        """
        return self._adjustment_item_list

    @adjustment_item_list.setter
    def adjustment_item_list(self, adjustment_item_list):
        """Sets the adjustment_item_list of this AdjustmentEvent.


        :param adjustment_item_list: The adjustment_item_list of this AdjustmentEvent.  # noqa: E501
        :type: AdjustmentItemList
        """

        self._adjustment_item_list = adjustment_item_list

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AdjustmentEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdjustmentEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
