# coding: utf-8

"""
    Consolidate Services

    Description of all APIs  # noqa: E501

    OpenAPI spec version: version not set
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from argocd.api_client import ApiClient


class ApplicationServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def application_service_create(self, body, **kwargs):  # noqa: E501
        """Create creates an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_create(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1Application body: (required)
        :param bool upsert:
        :param bool validate:
        :return: V1alpha1Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_create_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_create_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def application_service_create_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create creates an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_create_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1Application body: (required)
        :param bool upsert:
        :param bool validate:
        :return: V1alpha1Application
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'upsert', 'validate']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `application_service_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'upsert' in params:
            query_params.append(('upsert', params['upsert']))  # noqa: E501
        if 'validate' in params:
            query_params.append(('validate', params['validate']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_delete(self, name, **kwargs):  # noqa: E501
        """Delete deletes an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_delete(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param bool cascade:
        :param str propagation_policy:
        :param str app_namespace:
        :param str project:
        :return: ApplicationApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_delete_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_delete_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def application_service_delete_with_http_info(self, name, **kwargs):  # noqa: E501
        """Delete deletes an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_delete_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param bool cascade:
        :param str propagation_policy:
        :param str app_namespace:
        :param str project:
        :return: ApplicationApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'cascade', 'propagation_policy', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'cascade' in params:
            query_params.append(('cascade', params['cascade']))  # noqa: E501
        if 'propagation_policy' in params:
            query_params.append(('propagationPolicy', params['propagation_policy']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationApplicationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_delete_resource(self, name, **kwargs):  # noqa: E501
        """DeleteResource deletes a single application resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_delete_resource(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str namespace:
        :param str resource_name:
        :param str version:
        :param str group:
        :param str kind:
        :param bool force:
        :param bool orphan:
        :param str app_namespace:
        :param str project:
        :return: ApplicationApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_delete_resource_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_delete_resource_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def application_service_delete_resource_with_http_info(self, name, **kwargs):  # noqa: E501
        """DeleteResource deletes a single application resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_delete_resource_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str namespace:
        :param str resource_name:
        :param str version:
        :param str group:
        :param str kind:
        :param bool force:
        :param bool orphan:
        :param str app_namespace:
        :param str project:
        :return: ApplicationApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'resource_name', 'version', 'group', 'kind', 'force', 'orphan', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_delete_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_delete_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'resource_name' in params:
            query_params.append(('resourceName', params['resource_name']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501
        if 'kind' in params:
            query_params.append(('kind', params['kind']))  # noqa: E501
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'orphan' in params:
            query_params.append(('orphan', params['orphan']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/resource', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationApplicationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_get(self, name, **kwargs):  # noqa: E501
        """Get returns an application by name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_get(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: the application's name (required)
        :param str refresh: forces application reconciliation if set to 'hard'.
        :param list[str] projects: the project names to restrict returned list applications.
        :param str resource_version: when specified with a watch call, shows changes that occur after that particular version of a resource.
        :param str selector: the selector to restrict returned list to applications only with matched labels.
        :param str repo: the repoURL to restrict returned list applications.
        :param str app_namespace: the application's namespace.
        :param list[str] project: the project names to restrict returned list applications (legacy name for backwards-compatibility).
        :return: V1alpha1Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_get_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_get_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def application_service_get_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get returns an application by name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_get_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: the application's name (required)
        :param str refresh: forces application reconciliation if set to 'hard'.
        :param list[str] projects: the project names to restrict returned list applications.
        :param str resource_version: when specified with a watch call, shows changes that occur after that particular version of a resource.
        :param str selector: the selector to restrict returned list to applications only with matched labels.
        :param str repo: the repoURL to restrict returned list applications.
        :param str app_namespace: the application's namespace.
        :param list[str] project: the project names to restrict returned list applications (legacy name for backwards-compatibility).
        :return: V1alpha1Application
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'refresh', 'projects', 'resource_version', 'selector', 'repo', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))  # noqa: E501
        if 'projects' in params:
            query_params.append(('projects', params['projects']))  # noqa: E501
            collection_formats['projects'] = 'multi'  # noqa: E501
        if 'resource_version' in params:
            query_params.append(('resourceVersion', params['resource_version']))  # noqa: E501
        if 'selector' in params:
            query_params.append(('selector', params['selector']))  # noqa: E501
        if 'repo' in params:
            query_params.append(('repo', params['repo']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501
            collection_formats['project'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_get_application_sync_windows(self, name, **kwargs):  # noqa: E501
        """Get returns sync windows of the application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_get_application_sync_windows(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str app_namespace:
        :param str project:
        :return: ApplicationApplicationSyncWindowsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_get_application_sync_windows_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_get_application_sync_windows_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def application_service_get_application_sync_windows_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get returns sync windows of the application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_get_application_sync_windows_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str app_namespace:
        :param str project:
        :return: ApplicationApplicationSyncWindowsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_get_application_sync_windows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_get_application_sync_windows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/syncwindows', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationApplicationSyncWindowsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_get_manifests(self, name, **kwargs):  # noqa: E501
        """GetManifests returns application manifests  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_get_manifests(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str revision:
        :param str app_namespace:
        :param str project:
        :return: RepositoryManifestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_get_manifests_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_get_manifests_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def application_service_get_manifests_with_http_info(self, name, **kwargs):  # noqa: E501
        """GetManifests returns application manifests  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_get_manifests_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str revision:
        :param str app_namespace:
        :param str project:
        :return: RepositoryManifestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'revision', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_get_manifests" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_get_manifests`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'revision' in params:
            query_params.append(('revision', params['revision']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/manifests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryManifestResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_get_manifests_with_files(self, body, **kwargs):  # noqa: E501
        """GetManifestsWithFiles returns application manifests using provided files to generate them  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_get_manifests_with_files(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplicationApplicationManifestQueryWithFilesWrapper body:  (streaming inputs) (required)
        :return: RepositoryManifestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_get_manifests_with_files_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_get_manifests_with_files_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def application_service_get_manifests_with_files_with_http_info(self, body, **kwargs):  # noqa: E501
        """GetManifestsWithFiles returns application manifests using provided files to generate them  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_get_manifests_with_files_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplicationApplicationManifestQueryWithFilesWrapper body:  (streaming inputs) (required)
        :return: RepositoryManifestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_get_manifests_with_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `application_service_get_manifests_with_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/manifestsWithFiles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryManifestResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_get_resource(self, name, **kwargs):  # noqa: E501
        """GetResource returns single application resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_get_resource(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str namespace:
        :param str resource_name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: ApplicationApplicationResourceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_get_resource_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_get_resource_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def application_service_get_resource_with_http_info(self, name, **kwargs):  # noqa: E501
        """GetResource returns single application resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_get_resource_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str namespace:
        :param str resource_name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: ApplicationApplicationResourceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'resource_name', 'version', 'group', 'kind', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_get_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_get_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'resource_name' in params:
            query_params.append(('resourceName', params['resource_name']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501
        if 'kind' in params:
            query_params.append(('kind', params['kind']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/resource', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationApplicationResourceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_list(self, **kwargs):  # noqa: E501
        """List returns list of applications  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: the application's name.
        :param str refresh: forces application reconciliation if set to 'hard'.
        :param list[str] projects: the project names to restrict returned list applications.
        :param str resource_version: when specified with a watch call, shows changes that occur after that particular version of a resource.
        :param str selector: the selector to restrict returned list to applications only with matched labels.
        :param str repo: the repoURL to restrict returned list applications.
        :param str app_namespace: the application's namespace.
        :param list[str] project: the project names to restrict returned list applications (legacy name for backwards-compatibility).
        :return: V1alpha1ApplicationList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.application_service_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def application_service_list_with_http_info(self, **kwargs):  # noqa: E501
        """List returns list of applications  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: the application's name.
        :param str refresh: forces application reconciliation if set to 'hard'.
        :param list[str] projects: the project names to restrict returned list applications.
        :param str resource_version: when specified with a watch call, shows changes that occur after that particular version of a resource.
        :param str selector: the selector to restrict returned list to applications only with matched labels.
        :param str repo: the repoURL to restrict returned list applications.
        :param str app_namespace: the application's namespace.
        :param list[str] project: the project names to restrict returned list applications (legacy name for backwards-compatibility).
        :return: V1alpha1ApplicationList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'refresh', 'projects', 'resource_version', 'selector', 'repo', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))  # noqa: E501
        if 'projects' in params:
            query_params.append(('projects', params['projects']))  # noqa: E501
            collection_formats['projects'] = 'multi'  # noqa: E501
        if 'resource_version' in params:
            query_params.append(('resourceVersion', params['resource_version']))  # noqa: E501
        if 'selector' in params:
            query_params.append(('selector', params['selector']))  # noqa: E501
        if 'repo' in params:
            query_params.append(('repo', params['repo']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501
            collection_formats['project'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1ApplicationList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_list_links(self, name, **kwargs):  # noqa: E501
        """ListLinks returns the list of all application deep links  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_list_links(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str namespace:
        :param str project:
        :return: ApplicationLinksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_list_links_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_list_links_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def application_service_list_links_with_http_info(self, name, **kwargs):  # noqa: E501
        """ListLinks returns the list of all application deep links  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_list_links_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str namespace:
        :param str project:
        :return: ApplicationLinksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_list_links" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_list_links`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/links', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationLinksResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_list_resource_actions(self, name, **kwargs):  # noqa: E501
        """ListResourceActions returns list of resource actions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_list_resource_actions(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str namespace:
        :param str resource_name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: ApplicationResourceActionsListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_list_resource_actions_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_list_resource_actions_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def application_service_list_resource_actions_with_http_info(self, name, **kwargs):  # noqa: E501
        """ListResourceActions returns list of resource actions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_list_resource_actions_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str namespace:
        :param str resource_name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: ApplicationResourceActionsListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'resource_name', 'version', 'group', 'kind', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_list_resource_actions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_list_resource_actions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'resource_name' in params:
            query_params.append(('resourceName', params['resource_name']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501
        if 'kind' in params:
            query_params.append(('kind', params['kind']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/resource/actions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationResourceActionsListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_list_resource_events(self, name, **kwargs):  # noqa: E501
        """ListResourceEvents returns a list of event resources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_list_resource_events(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str resource_namespace:
        :param str resource_name:
        :param str resource_uid:
        :param str app_namespace:
        :param str project:
        :return: V1EventList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_list_resource_events_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_list_resource_events_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def application_service_list_resource_events_with_http_info(self, name, **kwargs):  # noqa: E501
        """ListResourceEvents returns a list of event resources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_list_resource_events_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str resource_namespace:
        :param str resource_name:
        :param str resource_uid:
        :param str app_namespace:
        :param str project:
        :return: V1EventList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'resource_namespace', 'resource_name', 'resource_uid', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_list_resource_events" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_list_resource_events`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'resource_namespace' in params:
            query_params.append(('resourceNamespace', params['resource_namespace']))  # noqa: E501
        if 'resource_name' in params:
            query_params.append(('resourceName', params['resource_name']))  # noqa: E501
        if 'resource_uid' in params:
            query_params.append(('resourceUID', params['resource_uid']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1EventList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_list_resource_links(self, name, **kwargs):  # noqa: E501
        """ListResourceLinks returns the list of all resource deep links  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_list_resource_links(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str namespace:
        :param str resource_name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: ApplicationLinksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_list_resource_links_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_list_resource_links_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def application_service_list_resource_links_with_http_info(self, name, **kwargs):  # noqa: E501
        """ListResourceLinks returns the list of all resource deep links  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_list_resource_links_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str namespace:
        :param str resource_name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: ApplicationLinksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'resource_name', 'version', 'group', 'kind', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_list_resource_links" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_list_resource_links`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'resource_name' in params:
            query_params.append(('resourceName', params['resource_name']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501
        if 'kind' in params:
            query_params.append(('kind', params['kind']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/resource/links', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationLinksResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_managed_resources(self, application_name, **kwargs):  # noqa: E501
        """ManagedResources returns list of managed resources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_managed_resources(application_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application_name: (required)
        :param str namespace:
        :param str name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: ApplicationManagedResourcesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_managed_resources_with_http_info(application_name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_managed_resources_with_http_info(application_name, **kwargs)  # noqa: E501
            return data

    def application_service_managed_resources_with_http_info(self, application_name, **kwargs):  # noqa: E501
        """ManagedResources returns list of managed resources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_managed_resources_with_http_info(application_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application_name: (required)
        :param str namespace:
        :param str name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: ApplicationManagedResourcesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_name', 'namespace', 'name', 'version', 'group', 'kind', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_managed_resources" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_name' is set
        if ('application_name' not in params or
                params['application_name'] is None):
            raise ValueError("Missing the required parameter `application_name` when calling `application_service_managed_resources`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_name' in params:
            path_params['applicationName'] = params['application_name']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501
        if 'kind' in params:
            query_params.append(('kind', params['kind']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationName}/managed-resources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationManagedResourcesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_patch(self, body, name, **kwargs):  # noqa: E501
        """Patch patch an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_patch(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplicationApplicationPatchRequest body: (required)
        :param str name: (required)
        :return: V1alpha1Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_patch_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_patch_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def application_service_patch_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """Patch patch an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_patch_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplicationApplicationPatchRequest body: (required)
        :param str name: (required)
        :return: V1alpha1Application
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `application_service_patch`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_patch_resource(self, body, name, **kwargs):  # noqa: E501
        """PatchResource patch single application resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_patch_resource(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str name: (required)
        :param str namespace:
        :param str resource_name:
        :param str version:
        :param str group:
        :param str kind:
        :param str patch_type:
        :param str app_namespace:
        :param str project:
        :return: ApplicationApplicationResourceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_patch_resource_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_patch_resource_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def application_service_patch_resource_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """PatchResource patch single application resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_patch_resource_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str name: (required)
        :param str namespace:
        :param str resource_name:
        :param str version:
        :param str group:
        :param str kind:
        :param str patch_type:
        :param str app_namespace:
        :param str project:
        :return: ApplicationApplicationResourceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name', 'namespace', 'resource_name', 'version', 'group', 'kind', 'patch_type', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_patch_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `application_service_patch_resource`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_patch_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'resource_name' in params:
            query_params.append(('resourceName', params['resource_name']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501
        if 'kind' in params:
            query_params.append(('kind', params['kind']))  # noqa: E501
        if 'patch_type' in params:
            query_params.append(('patchType', params['patch_type']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/resource', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationApplicationResourceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_pod_logs(self, name, pod_name, **kwargs):  # noqa: E501
        """PodLogs returns stream of log entries for the specified pod. Pod  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_pod_logs(name, pod_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str pod_name: (required)
        :param str namespace:
        :param str container:
        :param str since_seconds:
        :param str since_time_seconds: Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.
        :param int since_time_nanos: Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive. This field may be limited in precision depending on context.
        :param str tail_lines:
        :param bool follow:
        :param str until_time:
        :param str filter:
        :param str kind:
        :param str group:
        :param str resource_name:
        :param bool previous:
        :param str app_namespace:
        :param str project:
        :return: StreamResultOfApplicationLogEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_pod_logs_with_http_info(name, pod_name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_pod_logs_with_http_info(name, pod_name, **kwargs)  # noqa: E501
            return data

    def application_service_pod_logs_with_http_info(self, name, pod_name, **kwargs):  # noqa: E501
        """PodLogs returns stream of log entries for the specified pod. Pod  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_pod_logs_with_http_info(name, pod_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str pod_name: (required)
        :param str namespace:
        :param str container:
        :param str since_seconds:
        :param str since_time_seconds: Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.
        :param int since_time_nanos: Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive. This field may be limited in precision depending on context.
        :param str tail_lines:
        :param bool follow:
        :param str until_time:
        :param str filter:
        :param str kind:
        :param str group:
        :param str resource_name:
        :param bool previous:
        :param str app_namespace:
        :param str project:
        :return: StreamResultOfApplicationLogEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'pod_name', 'namespace', 'container', 'since_seconds', 'since_time_seconds', 'since_time_nanos', 'tail_lines', 'follow', 'until_time', 'filter', 'kind', 'group', 'resource_name', 'previous', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_pod_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_pod_logs`")  # noqa: E501
        # verify the required parameter 'pod_name' is set
        if ('pod_name' not in params or
                params['pod_name'] is None):
            raise ValueError("Missing the required parameter `pod_name` when calling `application_service_pod_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'pod_name' in params:
            path_params['podName'] = params['pod_name']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'container' in params:
            query_params.append(('container', params['container']))  # noqa: E501
        if 'since_seconds' in params:
            query_params.append(('sinceSeconds', params['since_seconds']))  # noqa: E501
        if 'since_time_seconds' in params:
            query_params.append(('sinceTime.seconds', params['since_time_seconds']))  # noqa: E501
        if 'since_time_nanos' in params:
            query_params.append(('sinceTime.nanos', params['since_time_nanos']))  # noqa: E501
        if 'tail_lines' in params:
            query_params.append(('tailLines', params['tail_lines']))  # noqa: E501
        if 'follow' in params:
            query_params.append(('follow', params['follow']))  # noqa: E501
        if 'until_time' in params:
            query_params.append(('untilTime', params['until_time']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'kind' in params:
            query_params.append(('kind', params['kind']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501
        if 'resource_name' in params:
            query_params.append(('resourceName', params['resource_name']))  # noqa: E501
        if 'previous' in params:
            query_params.append(('previous', params['previous']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/pods/{podName}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StreamResultOfApplicationLogEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_pod_logs2(self, name, **kwargs):  # noqa: E501
        """PodLogs returns stream of log entries for the specified pod. Pod  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_pod_logs2(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str namespace:
        :param str pod_name:
        :param str container:
        :param str since_seconds:
        :param str since_time_seconds: Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.
        :param int since_time_nanos: Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive. This field may be limited in precision depending on context.
        :param str tail_lines:
        :param bool follow:
        :param str until_time:
        :param str filter:
        :param str kind:
        :param str group:
        :param str resource_name:
        :param bool previous:
        :param str app_namespace:
        :param str project:
        :return: StreamResultOfApplicationLogEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_pod_logs2_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_pod_logs2_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def application_service_pod_logs2_with_http_info(self, name, **kwargs):  # noqa: E501
        """PodLogs returns stream of log entries for the specified pod. Pod  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_pod_logs2_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str namespace:
        :param str pod_name:
        :param str container:
        :param str since_seconds:
        :param str since_time_seconds: Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.
        :param int since_time_nanos: Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive. This field may be limited in precision depending on context.
        :param str tail_lines:
        :param bool follow:
        :param str until_time:
        :param str filter:
        :param str kind:
        :param str group:
        :param str resource_name:
        :param bool previous:
        :param str app_namespace:
        :param str project:
        :return: StreamResultOfApplicationLogEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pod_name', 'container', 'since_seconds', 'since_time_seconds', 'since_time_nanos', 'tail_lines', 'follow', 'until_time', 'filter', 'kind', 'group', 'resource_name', 'previous', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_pod_logs2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_pod_logs2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'pod_name' in params:
            query_params.append(('podName', params['pod_name']))  # noqa: E501
        if 'container' in params:
            query_params.append(('container', params['container']))  # noqa: E501
        if 'since_seconds' in params:
            query_params.append(('sinceSeconds', params['since_seconds']))  # noqa: E501
        if 'since_time_seconds' in params:
            query_params.append(('sinceTime.seconds', params['since_time_seconds']))  # noqa: E501
        if 'since_time_nanos' in params:
            query_params.append(('sinceTime.nanos', params['since_time_nanos']))  # noqa: E501
        if 'tail_lines' in params:
            query_params.append(('tailLines', params['tail_lines']))  # noqa: E501
        if 'follow' in params:
            query_params.append(('follow', params['follow']))  # noqa: E501
        if 'until_time' in params:
            query_params.append(('untilTime', params['until_time']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'kind' in params:
            query_params.append(('kind', params['kind']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501
        if 'resource_name' in params:
            query_params.append(('resourceName', params['resource_name']))  # noqa: E501
        if 'previous' in params:
            query_params.append(('previous', params['previous']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StreamResultOfApplicationLogEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_resource_tree(self, application_name, **kwargs):  # noqa: E501
        """ResourceTree returns resource tree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_resource_tree(application_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application_name: (required)
        :param str namespace:
        :param str name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: V1alpha1ApplicationTree
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_resource_tree_with_http_info(application_name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_resource_tree_with_http_info(application_name, **kwargs)  # noqa: E501
            return data

    def application_service_resource_tree_with_http_info(self, application_name, **kwargs):  # noqa: E501
        """ResourceTree returns resource tree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_resource_tree_with_http_info(application_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application_name: (required)
        :param str namespace:
        :param str name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: V1alpha1ApplicationTree
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_name', 'namespace', 'name', 'version', 'group', 'kind', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_resource_tree" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_name' is set
        if ('application_name' not in params or
                params['application_name'] is None):
            raise ValueError("Missing the required parameter `application_name` when calling `application_service_resource_tree`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_name' in params:
            path_params['applicationName'] = params['application_name']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501
        if 'kind' in params:
            query_params.append(('kind', params['kind']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationName}/resource-tree', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1ApplicationTree',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_revision_chart_details(self, name, revision, **kwargs):  # noqa: E501
        """Get the chart metadata (description, maintainers, home) for a specific revision of the application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_revision_chart_details(name, revision, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: the application's name (required)
        :param str revision: the revision of the app (required)
        :param str app_namespace: the application's namespace.
        :param str project:
        :return: V1alpha1ChartDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_revision_chart_details_with_http_info(name, revision, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_revision_chart_details_with_http_info(name, revision, **kwargs)  # noqa: E501
            return data

    def application_service_revision_chart_details_with_http_info(self, name, revision, **kwargs):  # noqa: E501
        """Get the chart metadata (description, maintainers, home) for a specific revision of the application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_revision_chart_details_with_http_info(name, revision, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: the application's name (required)
        :param str revision: the revision of the app (required)
        :param str app_namespace: the application's namespace.
        :param str project:
        :return: V1alpha1ChartDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'revision', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_revision_chart_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_revision_chart_details`")  # noqa: E501
        # verify the required parameter 'revision' is set
        if ('revision' not in params or
                params['revision'] is None):
            raise ValueError("Missing the required parameter `revision` when calling `application_service_revision_chart_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'revision' in params:
            path_params['revision'] = params['revision']  # noqa: E501

        query_params = []
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/revisions/{revision}/chartdetails', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1ChartDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_revision_metadata(self, name, revision, **kwargs):  # noqa: E501
        """Get the meta-data (author, date, tags, message) for a specific revision of the application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_revision_metadata(name, revision, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: the application's name (required)
        :param str revision: the revision of the app (required)
        :param str app_namespace: the application's namespace.
        :param str project:
        :return: V1alpha1RevisionMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_revision_metadata_with_http_info(name, revision, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_revision_metadata_with_http_info(name, revision, **kwargs)  # noqa: E501
            return data

    def application_service_revision_metadata_with_http_info(self, name, revision, **kwargs):  # noqa: E501
        """Get the meta-data (author, date, tags, message) for a specific revision of the application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_revision_metadata_with_http_info(name, revision, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: the application's name (required)
        :param str revision: the revision of the app (required)
        :param str app_namespace: the application's namespace.
        :param str project:
        :return: V1alpha1RevisionMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'revision', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_revision_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_revision_metadata`")  # noqa: E501
        # verify the required parameter 'revision' is set
        if ('revision' not in params or
                params['revision'] is None):
            raise ValueError("Missing the required parameter `revision` when calling `application_service_revision_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'revision' in params:
            path_params['revision'] = params['revision']  # noqa: E501

        query_params = []
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/revisions/{revision}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1RevisionMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_rollback(self, body, name, **kwargs):  # noqa: E501
        """Rollback syncs an application to its target state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_rollback(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplicationApplicationRollbackRequest body: (required)
        :param str name: (required)
        :return: V1alpha1Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_rollback_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_rollback_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def application_service_rollback_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """Rollback syncs an application to its target state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_rollback_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplicationApplicationRollbackRequest body: (required)
        :param str name: (required)
        :return: V1alpha1Application
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_rollback" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `application_service_rollback`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_rollback`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/rollback', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_run_resource_action(self, body, name, **kwargs):  # noqa: E501
        """RunResourceAction run resource action  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_run_resource_action(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str name: (required)
        :param str namespace:
        :param str resource_name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: ApplicationApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_run_resource_action_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_run_resource_action_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def application_service_run_resource_action_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """RunResourceAction run resource action  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_run_resource_action_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str name: (required)
        :param str namespace:
        :param str resource_name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: ApplicationApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name', 'namespace', 'resource_name', 'version', 'group', 'kind', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_run_resource_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `application_service_run_resource_action`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_run_resource_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'resource_name' in params:
            query_params.append(('resourceName', params['resource_name']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501
        if 'kind' in params:
            query_params.append(('kind', params['kind']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/resource/actions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationApplicationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_sync(self, body, name, **kwargs):  # noqa: E501
        """Sync syncs an application to its target state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_sync(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplicationApplicationSyncRequest body: (required)
        :param str name: (required)
        :return: V1alpha1Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_sync_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_sync_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def application_service_sync_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """Sync syncs an application to its target state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_sync_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplicationApplicationSyncRequest body: (required)
        :param str name: (required)
        :return: V1alpha1Application
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_sync" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `application_service_sync`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_sync`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/sync', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_terminate_operation(self, name, **kwargs):  # noqa: E501
        """TerminateOperation terminates the currently running operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_terminate_operation(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str app_namespace:
        :param str project:
        :return: ApplicationOperationTerminateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_terminate_operation_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_terminate_operation_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def application_service_terminate_operation_with_http_info(self, name, **kwargs):  # noqa: E501
        """TerminateOperation terminates the currently running operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_terminate_operation_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str app_namespace:
        :param str project:
        :return: ApplicationOperationTerminateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_terminate_operation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_terminate_operation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/operation', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationOperationTerminateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_update(self, body, application_metadata_name, **kwargs):  # noqa: E501
        """Update updates an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_update(body, application_metadata_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1Application body: (required)
        :param str application_metadata_name: Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names +optional (required)
        :param bool validate:
        :param str project:
        :return: V1alpha1Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_update_with_http_info(body, application_metadata_name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_update_with_http_info(body, application_metadata_name, **kwargs)  # noqa: E501
            return data

    def application_service_update_with_http_info(self, body, application_metadata_name, **kwargs):  # noqa: E501
        """Update updates an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_update_with_http_info(body, application_metadata_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1Application body: (required)
        :param str application_metadata_name: Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names +optional (required)
        :param bool validate:
        :param str project:
        :return: V1alpha1Application
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'application_metadata_name', 'validate', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `application_service_update`")  # noqa: E501
        # verify the required parameter 'application_metadata_name' is set
        if ('application_metadata_name' not in params or
                params['application_metadata_name'] is None):
            raise ValueError("Missing the required parameter `application_metadata_name` when calling `application_service_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_metadata_name' in params:
            path_params['application.metadata.name'] = params['application_metadata_name']  # noqa: E501

        query_params = []
        if 'validate' in params:
            query_params.append(('validate', params['validate']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{application.metadata.name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_update_spec(self, body, name, **kwargs):  # noqa: E501
        """UpdateSpec updates an application spec  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_update_spec(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1ApplicationSpec body: (required)
        :param str name: (required)
        :param bool validate:
        :param str app_namespace:
        :param str project:
        :return: V1alpha1ApplicationSpec
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_update_spec_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_update_spec_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def application_service_update_spec_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """UpdateSpec updates an application spec  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_update_spec_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1ApplicationSpec body: (required)
        :param str name: (required)
        :param bool validate:
        :param str app_namespace:
        :param str project:
        :return: V1alpha1ApplicationSpec
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name', 'validate', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_update_spec" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `application_service_update_spec`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `application_service_update_spec`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'validate' in params:
            query_params.append(('validate', params['validate']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{name}/spec', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1ApplicationSpec',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_watch(self, **kwargs):  # noqa: E501
        """Watch returns stream of application change events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_watch(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: the application's name.
        :param str refresh: forces application reconciliation if set to 'hard'.
        :param list[str] projects: the project names to restrict returned list applications.
        :param str resource_version: when specified with a watch call, shows changes that occur after that particular version of a resource.
        :param str selector: the selector to restrict returned list to applications only with matched labels.
        :param str repo: the repoURL to restrict returned list applications.
        :param str app_namespace: the application's namespace.
        :param list[str] project: the project names to restrict returned list applications (legacy name for backwards-compatibility).
        :return: StreamResultOfV1alpha1ApplicationWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_watch_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.application_service_watch_with_http_info(**kwargs)  # noqa: E501
            return data

    def application_service_watch_with_http_info(self, **kwargs):  # noqa: E501
        """Watch returns stream of application change events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_watch_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: the application's name.
        :param str refresh: forces application reconciliation if set to 'hard'.
        :param list[str] projects: the project names to restrict returned list applications.
        :param str resource_version: when specified with a watch call, shows changes that occur after that particular version of a resource.
        :param str selector: the selector to restrict returned list to applications only with matched labels.
        :param str repo: the repoURL to restrict returned list applications.
        :param str app_namespace: the application's namespace.
        :param list[str] project: the project names to restrict returned list applications (legacy name for backwards-compatibility).
        :return: StreamResultOfV1alpha1ApplicationWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'refresh', 'projects', 'resource_version', 'selector', 'repo', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_watch" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))  # noqa: E501
        if 'projects' in params:
            query_params.append(('projects', params['projects']))  # noqa: E501
            collection_formats['projects'] = 'multi'  # noqa: E501
        if 'resource_version' in params:
            query_params.append(('resourceVersion', params['resource_version']))  # noqa: E501
        if 'selector' in params:
            query_params.append(('selector', params['selector']))  # noqa: E501
        if 'repo' in params:
            query_params.append(('repo', params['repo']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501
            collection_formats['project'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/stream/applications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StreamResultOfV1alpha1ApplicationWatchEvent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_service_watch_resource_tree(self, application_name, **kwargs):  # noqa: E501
        """Watch returns stream of application resource tree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_watch_resource_tree(application_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application_name: (required)
        :param str namespace:
        :param str name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: StreamResultOfV1alpha1ApplicationTree
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.application_service_watch_resource_tree_with_http_info(application_name, **kwargs)  # noqa: E501
        else:
            (data) = self.application_service_watch_resource_tree_with_http_info(application_name, **kwargs)  # noqa: E501
            return data

    def application_service_watch_resource_tree_with_http_info(self, application_name, **kwargs):  # noqa: E501
        """Watch returns stream of application resource tree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.application_service_watch_resource_tree_with_http_info(application_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application_name: (required)
        :param str namespace:
        :param str name:
        :param str version:
        :param str group:
        :param str kind:
        :param str app_namespace:
        :param str project:
        :return: StreamResultOfV1alpha1ApplicationTree
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_name', 'namespace', 'name', 'version', 'group', 'kind', 'app_namespace', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_service_watch_resource_tree" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_name' is set
        if ('application_name' not in params or
                params['application_name'] is None):
            raise ValueError("Missing the required parameter `application_name` when calling `application_service_watch_resource_tree`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_name' in params:
            path_params['applicationName'] = params['application_name']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501
        if 'kind' in params:
            query_params.append(('kind', params['kind']))  # noqa: E501
        if 'app_namespace' in params:
            query_params.append(('appNamespace', params['app_namespace']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/stream/applications/{applicationName}/resource-tree', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StreamResultOfV1alpha1ApplicationTree',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
