# coding: utf-8

"""
    Consolidate Services

    Description of all APIs  # noqa: E501

    OpenAPI spec version: version not set
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from argocd.api_client import ApiClient


class CertificateServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def certificate_service_create_certificate(self, body, **kwargs):  # noqa: E501
        """Creates repository certificates on the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.certificate_service_create_certificate(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1RepositoryCertificateList body: List of certificates to be created (required)
        :param bool upsert: Whether to upsert already existing certificates.
        :return: V1alpha1RepositoryCertificateList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.certificate_service_create_certificate_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.certificate_service_create_certificate_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def certificate_service_create_certificate_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates repository certificates on the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.certificate_service_create_certificate_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1RepositoryCertificateList body: List of certificates to be created (required)
        :param bool upsert: Whether to upsert already existing certificates.
        :return: V1alpha1RepositoryCertificateList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'upsert']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method certificate_service_create_certificate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `certificate_service_create_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'upsert' in params:
            query_params.append(('upsert', params['upsert']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/certificates', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1RepositoryCertificateList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def certificate_service_delete_certificate(self, **kwargs):  # noqa: E501
        """Delete the certificates that match the RepositoryCertificateQuery  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.certificate_service_delete_certificate(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str host_name_pattern: A file-glob pattern (not regular expression) the host name has to match.
        :param str cert_type: The type of the certificate to match (ssh or https).
        :param str cert_sub_type: The sub type of the certificate to match (protocol dependent, usually only used for ssh certs).
        :return: V1alpha1RepositoryCertificateList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.certificate_service_delete_certificate_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.certificate_service_delete_certificate_with_http_info(**kwargs)  # noqa: E501
            return data

    def certificate_service_delete_certificate_with_http_info(self, **kwargs):  # noqa: E501
        """Delete the certificates that match the RepositoryCertificateQuery  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.certificate_service_delete_certificate_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str host_name_pattern: A file-glob pattern (not regular expression) the host name has to match.
        :param str cert_type: The type of the certificate to match (ssh or https).
        :param str cert_sub_type: The sub type of the certificate to match (protocol dependent, usually only used for ssh certs).
        :return: V1alpha1RepositoryCertificateList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_name_pattern', 'cert_type', 'cert_sub_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method certificate_service_delete_certificate" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'host_name_pattern' in params:
            query_params.append(('hostNamePattern', params['host_name_pattern']))  # noqa: E501
        if 'cert_type' in params:
            query_params.append(('certType', params['cert_type']))  # noqa: E501
        if 'cert_sub_type' in params:
            query_params.append(('certSubType', params['cert_sub_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/certificates', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1RepositoryCertificateList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def certificate_service_list_certificates(self, **kwargs):  # noqa: E501
        """List all available repository certificates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.certificate_service_list_certificates(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str host_name_pattern: A file-glob pattern (not regular expression) the host name has to match.
        :param str cert_type: The type of the certificate to match (ssh or https).
        :param str cert_sub_type: The sub type of the certificate to match (protocol dependent, usually only used for ssh certs).
        :return: V1alpha1RepositoryCertificateList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.certificate_service_list_certificates_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.certificate_service_list_certificates_with_http_info(**kwargs)  # noqa: E501
            return data

    def certificate_service_list_certificates_with_http_info(self, **kwargs):  # noqa: E501
        """List all available repository certificates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.certificate_service_list_certificates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str host_name_pattern: A file-glob pattern (not regular expression) the host name has to match.
        :param str cert_type: The type of the certificate to match (ssh or https).
        :param str cert_sub_type: The sub type of the certificate to match (protocol dependent, usually only used for ssh certs).
        :return: V1alpha1RepositoryCertificateList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_name_pattern', 'cert_type', 'cert_sub_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method certificate_service_list_certificates" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'host_name_pattern' in params:
            query_params.append(('hostNamePattern', params['host_name_pattern']))  # noqa: E501
        if 'cert_type' in params:
            query_params.append(('certType', params['cert_type']))  # noqa: E501
        if 'cert_sub_type' in params:
            query_params.append(('certSubType', params['cert_sub_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/certificates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1RepositoryCertificateList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
