# coding: utf-8

"""
    Consolidate Services

    Description of all APIs  # noqa: E501

    OpenAPI spec version: version not set
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from argocd.api_client import ApiClient


class ClusterServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cluster_service_create(self, body, **kwargs):  # noqa: E501
        """Create creates a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_create(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1Cluster body: (required)
        :param bool upsert:
        :return: V1alpha1Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cluster_service_create_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.cluster_service_create_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def cluster_service_create_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create creates a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_create_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1Cluster body: (required)
        :param bool upsert:
        :return: V1alpha1Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'upsert']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cluster_service_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `cluster_service_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'upsert' in params:
            query_params.append(('upsert', params['upsert']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/clusters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cluster_service_delete(self, id_value, **kwargs):  # noqa: E501
        """Delete deletes a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_delete(id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_value: value holds the cluster server URL or cluster name (required)
        :param str server:
        :param str name:
        :param str id_type: type is the type of the specified cluster identifier ( \"server\" - default, \"name\" ).
        :return: ClusterClusterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cluster_service_delete_with_http_info(id_value, **kwargs)  # noqa: E501
        else:
            (data) = self.cluster_service_delete_with_http_info(id_value, **kwargs)  # noqa: E501
            return data

    def cluster_service_delete_with_http_info(self, id_value, **kwargs):  # noqa: E501
        """Delete deletes a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_delete_with_http_info(id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_value: value holds the cluster server URL or cluster name (required)
        :param str server:
        :param str name:
        :param str id_type: type is the type of the specified cluster identifier ( \"server\" - default, \"name\" ).
        :return: ClusterClusterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_value', 'server', 'name', 'id_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cluster_service_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_value' is set
        if ('id_value' not in params or
                params['id_value'] is None):
            raise ValueError("Missing the required parameter `id_value` when calling `cluster_service_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_value' in params:
            path_params['id.value'] = params['id_value']  # noqa: E501

        query_params = []
        if 'server' in params:
            query_params.append(('server', params['server']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'id_type' in params:
            query_params.append(('id.type', params['id_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/clusters/{id.value}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterClusterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cluster_service_get(self, id_value, **kwargs):  # noqa: E501
        """Get returns a cluster by server address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_get(id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_value: value holds the cluster server URL or cluster name (required)
        :param str server:
        :param str name:
        :param str id_type: type is the type of the specified cluster identifier ( \"server\" - default, \"name\" ).
        :return: V1alpha1Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cluster_service_get_with_http_info(id_value, **kwargs)  # noqa: E501
        else:
            (data) = self.cluster_service_get_with_http_info(id_value, **kwargs)  # noqa: E501
            return data

    def cluster_service_get_with_http_info(self, id_value, **kwargs):  # noqa: E501
        """Get returns a cluster by server address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_get_with_http_info(id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_value: value holds the cluster server URL or cluster name (required)
        :param str server:
        :param str name:
        :param str id_type: type is the type of the specified cluster identifier ( \"server\" - default, \"name\" ).
        :return: V1alpha1Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_value', 'server', 'name', 'id_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cluster_service_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_value' is set
        if ('id_value' not in params or
                params['id_value'] is None):
            raise ValueError("Missing the required parameter `id_value` when calling `cluster_service_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_value' in params:
            path_params['id.value'] = params['id_value']  # noqa: E501

        query_params = []
        if 'server' in params:
            query_params.append(('server', params['server']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'id_type' in params:
            query_params.append(('id.type', params['id_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/clusters/{id.value}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cluster_service_invalidate_cache(self, id_value, **kwargs):  # noqa: E501
        """InvalidateCache invalidates cluster cache  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_invalidate_cache(id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_value: value holds the cluster server URL or cluster name (required)
        :return: V1alpha1Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cluster_service_invalidate_cache_with_http_info(id_value, **kwargs)  # noqa: E501
        else:
            (data) = self.cluster_service_invalidate_cache_with_http_info(id_value, **kwargs)  # noqa: E501
            return data

    def cluster_service_invalidate_cache_with_http_info(self, id_value, **kwargs):  # noqa: E501
        """InvalidateCache invalidates cluster cache  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_invalidate_cache_with_http_info(id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_value: value holds the cluster server URL or cluster name (required)
        :return: V1alpha1Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_value']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cluster_service_invalidate_cache" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_value' is set
        if ('id_value' not in params or
                params['id_value'] is None):
            raise ValueError("Missing the required parameter `id_value` when calling `cluster_service_invalidate_cache`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_value' in params:
            path_params['id.value'] = params['id_value']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/clusters/{id.value}/invalidate-cache', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cluster_service_list(self, **kwargs):  # noqa: E501
        """List returns list of clusters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server:
        :param str name:
        :param str id_type: type is the type of the specified cluster identifier ( \"server\" - default, \"name\" ).
        :param str id_value: value holds the cluster server URL or cluster name.
        :return: V1alpha1ClusterList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cluster_service_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.cluster_service_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def cluster_service_list_with_http_info(self, **kwargs):  # noqa: E501
        """List returns list of clusters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server:
        :param str name:
        :param str id_type: type is the type of the specified cluster identifier ( \"server\" - default, \"name\" ).
        :param str id_value: value holds the cluster server URL or cluster name.
        :return: V1alpha1ClusterList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'name', 'id_type', 'id_value']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cluster_service_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'server' in params:
            query_params.append(('server', params['server']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'id_type' in params:
            query_params.append(('id.type', params['id_type']))  # noqa: E501
        if 'id_value' in params:
            query_params.append(('id.value', params['id_value']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/clusters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1ClusterList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cluster_service_rotate_auth(self, id_value, **kwargs):  # noqa: E501
        """RotateAuth rotates the bearer token used for a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_rotate_auth(id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_value: value holds the cluster server URL or cluster name (required)
        :return: ClusterClusterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cluster_service_rotate_auth_with_http_info(id_value, **kwargs)  # noqa: E501
        else:
            (data) = self.cluster_service_rotate_auth_with_http_info(id_value, **kwargs)  # noqa: E501
            return data

    def cluster_service_rotate_auth_with_http_info(self, id_value, **kwargs):  # noqa: E501
        """RotateAuth rotates the bearer token used for a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_rotate_auth_with_http_info(id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_value: value holds the cluster server URL or cluster name (required)
        :return: ClusterClusterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_value']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cluster_service_rotate_auth" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_value' is set
        if ('id_value' not in params or
                params['id_value'] is None):
            raise ValueError("Missing the required parameter `id_value` when calling `cluster_service_rotate_auth`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_value' in params:
            path_params['id.value'] = params['id_value']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/clusters/{id.value}/rotate-auth', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterClusterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cluster_service_update(self, body, id_value, **kwargs):  # noqa: E501
        """Update updates a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_update(body, id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1Cluster body: (required)
        :param str id_value: value holds the cluster server URL or cluster name (required)
        :param list[str] updated_fields:
        :param str id_type: type is the type of the specified cluster identifier ( \"server\" - default, \"name\" ).
        :return: V1alpha1Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cluster_service_update_with_http_info(body, id_value, **kwargs)  # noqa: E501
        else:
            (data) = self.cluster_service_update_with_http_info(body, id_value, **kwargs)  # noqa: E501
            return data

    def cluster_service_update_with_http_info(self, body, id_value, **kwargs):  # noqa: E501
        """Update updates a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cluster_service_update_with_http_info(body, id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1Cluster body: (required)
        :param str id_value: value holds the cluster server URL or cluster name (required)
        :param list[str] updated_fields:
        :param str id_type: type is the type of the specified cluster identifier ( \"server\" - default, \"name\" ).
        :return: V1alpha1Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id_value', 'updated_fields', 'id_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cluster_service_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `cluster_service_update`")  # noqa: E501
        # verify the required parameter 'id_value' is set
        if ('id_value' not in params or
                params['id_value'] is None):
            raise ValueError("Missing the required parameter `id_value` when calling `cluster_service_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_value' in params:
            path_params['id.value'] = params['id_value']  # noqa: E501

        query_params = []
        if 'updated_fields' in params:
            query_params.append(('updatedFields', params['updated_fields']))  # noqa: E501
            collection_formats['updatedFields'] = 'multi'  # noqa: E501
        if 'id_type' in params:
            query_params.append(('id.type', params['id_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/clusters/{id.value}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
