# coding: utf-8

"""
    Consolidate Services

    Description of all APIs  # noqa: E501

    OpenAPI spec version: version not set
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from argocd.api_client import ApiClient


class GPGKeyServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def g_pg_key_service_create(self, body, **kwargs):  # noqa: E501
        """Create one or more GPG public keys in the server's configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.g_pg_key_service_create(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1GnuPGPublicKey body: Raw key data of the GPG key(s) to create (required)
        :param bool upsert: Whether to upsert already existing public keys.
        :return: GpgkeyGnuPGPublicKeyCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.g_pg_key_service_create_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.g_pg_key_service_create_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def g_pg_key_service_create_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create one or more GPG public keys in the server's configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.g_pg_key_service_create_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1GnuPGPublicKey body: Raw key data of the GPG key(s) to create (required)
        :param bool upsert: Whether to upsert already existing public keys.
        :return: GpgkeyGnuPGPublicKeyCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'upsert']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method g_pg_key_service_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `g_pg_key_service_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'upsert' in params:
            query_params.append(('upsert', params['upsert']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/gpgkeys', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GpgkeyGnuPGPublicKeyCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def g_pg_key_service_delete(self, **kwargs):  # noqa: E501
        """Delete specified GPG public key from the server's configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.g_pg_key_service_delete(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_id: The GPG key ID to query for.
        :return: GpgkeyGnuPGPublicKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.g_pg_key_service_delete_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.g_pg_key_service_delete_with_http_info(**kwargs)  # noqa: E501
            return data

    def g_pg_key_service_delete_with_http_info(self, **kwargs):  # noqa: E501
        """Delete specified GPG public key from the server's configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.g_pg_key_service_delete_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_id: The GPG key ID to query for.
        :return: GpgkeyGnuPGPublicKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method g_pg_key_service_delete" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key_id' in params:
            query_params.append(('keyID', params['key_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/gpgkeys', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GpgkeyGnuPGPublicKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def g_pg_key_service_get(self, key_id, **kwargs):  # noqa: E501
        """Get information about specified GPG public key from the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.g_pg_key_service_get(key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_id: The GPG key ID to query for (required)
        :return: V1alpha1GnuPGPublicKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.g_pg_key_service_get_with_http_info(key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.g_pg_key_service_get_with_http_info(key_id, **kwargs)  # noqa: E501
            return data

    def g_pg_key_service_get_with_http_info(self, key_id, **kwargs):  # noqa: E501
        """Get information about specified GPG public key from the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.g_pg_key_service_get_with_http_info(key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_id: The GPG key ID to query for (required)
        :return: V1alpha1GnuPGPublicKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method g_pg_key_service_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key_id' is set
        if ('key_id' not in params or
                params['key_id'] is None):
            raise ValueError("Missing the required parameter `key_id` when calling `g_pg_key_service_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key_id' in params:
            path_params['keyID'] = params['key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/gpgkeys/{keyID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1GnuPGPublicKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def g_pg_key_service_list(self, **kwargs):  # noqa: E501
        """List all available repository certificates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.g_pg_key_service_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_id: The GPG key ID to query for.
        :return: V1alpha1GnuPGPublicKeyList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.g_pg_key_service_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.g_pg_key_service_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def g_pg_key_service_list_with_http_info(self, **kwargs):  # noqa: E501
        """List all available repository certificates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.g_pg_key_service_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_id: The GPG key ID to query for.
        :return: V1alpha1GnuPGPublicKeyList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method g_pg_key_service_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key_id' in params:
            query_params.append(('keyID', params['key_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/gpgkeys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1GnuPGPublicKeyList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
