# coding: utf-8

"""
    Consolidate Services

    Description of all APIs  # noqa: E501

    OpenAPI spec version: version not set
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from argocd.api_client import ApiClient


class RepositoryServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def repository_service_create_repository(self, body, **kwargs):  # noqa: E501
        """CreateRepository creates a new repository configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_create_repository(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1Repository body: Repository definition (required)
        :param bool upsert: Whether to create in upsert mode.
        :param bool creds_only: Whether to operate on credential set instead of repository.
        :return: V1alpha1Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repository_service_create_repository_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.repository_service_create_repository_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def repository_service_create_repository_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateRepository creates a new repository configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_create_repository_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1Repository body: Repository definition (required)
        :param bool upsert: Whether to create in upsert mode.
        :param bool creds_only: Whether to operate on credential set instead of repository.
        :return: V1alpha1Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'upsert', 'creds_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_service_create_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `repository_service_create_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'upsert' in params:
            query_params.append(('upsert', params['upsert']))  # noqa: E501
        if 'creds_only' in params:
            query_params.append(('credsOnly', params['creds_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/repositories', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Repository',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repository_service_delete_repository(self, repo, **kwargs):  # noqa: E501
        """DeleteRepository deletes a repository from the configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_delete_repository(repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo: Repo URL for query (required)
        :param bool force_refresh: Whether to force a cache refresh on repo's connection state.
        :return: RepositoryRepoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repository_service_delete_repository_with_http_info(repo, **kwargs)  # noqa: E501
        else:
            (data) = self.repository_service_delete_repository_with_http_info(repo, **kwargs)  # noqa: E501
            return data

    def repository_service_delete_repository_with_http_info(self, repo, **kwargs):  # noqa: E501
        """DeleteRepository deletes a repository from the configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_delete_repository_with_http_info(repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo: Repo URL for query (required)
        :param bool force_refresh: Whether to force a cache refresh on repo's connection state.
        :return: RepositoryRepoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo', 'force_refresh']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_service_delete_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError("Missing the required parameter `repo` when calling `repository_service_delete_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []
        if 'force_refresh' in params:
            query_params.append(('forceRefresh', params['force_refresh']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/repositories/{repo}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryRepoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repository_service_get(self, repo, **kwargs):  # noqa: E501
        """Get returns a repository or its credentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_get(repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo: Repo URL for query (required)
        :param bool force_refresh: Whether to force a cache refresh on repo's connection state.
        :return: V1alpha1Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repository_service_get_with_http_info(repo, **kwargs)  # noqa: E501
        else:
            (data) = self.repository_service_get_with_http_info(repo, **kwargs)  # noqa: E501
            return data

    def repository_service_get_with_http_info(self, repo, **kwargs):  # noqa: E501
        """Get returns a repository or its credentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_get_with_http_info(repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo: Repo URL for query (required)
        :param bool force_refresh: Whether to force a cache refresh on repo's connection state.
        :return: V1alpha1Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo', 'force_refresh']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_service_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError("Missing the required parameter `repo` when calling `repository_service_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []
        if 'force_refresh' in params:
            query_params.append(('forceRefresh', params['force_refresh']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/repositories/{repo}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Repository',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repository_service_get_app_details(self, body, source_repo_url, **kwargs):  # noqa: E501
        """GetAppDetails returns application details by given path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_get_app_details(body, source_repo_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RepositoryRepoAppDetailsQuery body: (required)
        :param str source_repo_url: RepoURL is the URL to the repository (Git or Helm) that contains the application manifests (required)
        :return: RepositoryRepoAppDetailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repository_service_get_app_details_with_http_info(body, source_repo_url, **kwargs)  # noqa: E501
        else:
            (data) = self.repository_service_get_app_details_with_http_info(body, source_repo_url, **kwargs)  # noqa: E501
            return data

    def repository_service_get_app_details_with_http_info(self, body, source_repo_url, **kwargs):  # noqa: E501
        """GetAppDetails returns application details by given path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_get_app_details_with_http_info(body, source_repo_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RepositoryRepoAppDetailsQuery body: (required)
        :param str source_repo_url: RepoURL is the URL to the repository (Git or Helm) that contains the application manifests (required)
        :return: RepositoryRepoAppDetailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'source_repo_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_service_get_app_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `repository_service_get_app_details`")  # noqa: E501
        # verify the required parameter 'source_repo_url' is set
        if ('source_repo_url' not in params or
                params['source_repo_url'] is None):
            raise ValueError("Missing the required parameter `source_repo_url` when calling `repository_service_get_app_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'source_repo_url' in params:
            path_params['source.repoURL'] = params['source_repo_url']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/repositories/{source.repoURL}/appdetails', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryRepoAppDetailsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repository_service_get_helm_charts(self, repo, **kwargs):  # noqa: E501
        """GetHelmCharts returns list of helm charts in the specified repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_get_helm_charts(repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo: Repo URL for query (required)
        :param bool force_refresh: Whether to force a cache refresh on repo's connection state.
        :return: RepositoryHelmChartsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repository_service_get_helm_charts_with_http_info(repo, **kwargs)  # noqa: E501
        else:
            (data) = self.repository_service_get_helm_charts_with_http_info(repo, **kwargs)  # noqa: E501
            return data

    def repository_service_get_helm_charts_with_http_info(self, repo, **kwargs):  # noqa: E501
        """GetHelmCharts returns list of helm charts in the specified repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_get_helm_charts_with_http_info(repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo: Repo URL for query (required)
        :param bool force_refresh: Whether to force a cache refresh on repo's connection state.
        :return: RepositoryHelmChartsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo', 'force_refresh']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_service_get_helm_charts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError("Missing the required parameter `repo` when calling `repository_service_get_helm_charts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []
        if 'force_refresh' in params:
            query_params.append(('forceRefresh', params['force_refresh']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/repositories/{repo}/helmcharts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryHelmChartsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repository_service_list_apps(self, repo, **kwargs):  # noqa: E501
        """ListApps returns list of apps in the repo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_list_apps(repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo: (required)
        :param str revision:
        :param str app_name:
        :param str app_project:
        :return: RepositoryRepoAppsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repository_service_list_apps_with_http_info(repo, **kwargs)  # noqa: E501
        else:
            (data) = self.repository_service_list_apps_with_http_info(repo, **kwargs)  # noqa: E501
            return data

    def repository_service_list_apps_with_http_info(self, repo, **kwargs):  # noqa: E501
        """ListApps returns list of apps in the repo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_list_apps_with_http_info(repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo: (required)
        :param str revision:
        :param str app_name:
        :param str app_project:
        :return: RepositoryRepoAppsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo', 'revision', 'app_name', 'app_project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_service_list_apps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError("Missing the required parameter `repo` when calling `repository_service_list_apps`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []
        if 'revision' in params:
            query_params.append(('revision', params['revision']))  # noqa: E501
        if 'app_name' in params:
            query_params.append(('appName', params['app_name']))  # noqa: E501
        if 'app_project' in params:
            query_params.append(('appProject', params['app_project']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/repositories/{repo}/apps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryRepoAppsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repository_service_list_refs(self, repo, **kwargs):  # noqa: E501
        """repository_service_list_refs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_list_refs(repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo: Repo URL for query (required)
        :param bool force_refresh: Whether to force a cache refresh on repo's connection state.
        :return: RepositoryRefs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repository_service_list_refs_with_http_info(repo, **kwargs)  # noqa: E501
        else:
            (data) = self.repository_service_list_refs_with_http_info(repo, **kwargs)  # noqa: E501
            return data

    def repository_service_list_refs_with_http_info(self, repo, **kwargs):  # noqa: E501
        """repository_service_list_refs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_list_refs_with_http_info(repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo: Repo URL for query (required)
        :param bool force_refresh: Whether to force a cache refresh on repo's connection state.
        :return: RepositoryRefs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo', 'force_refresh']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_service_list_refs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError("Missing the required parameter `repo` when calling `repository_service_list_refs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []
        if 'force_refresh' in params:
            query_params.append(('forceRefresh', params['force_refresh']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/repositories/{repo}/refs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryRefs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repository_service_list_repositories(self, **kwargs):  # noqa: E501
        """ListRepositories gets a list of all configured repositories  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_list_repositories(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo: Repo URL for query.
        :param bool force_refresh: Whether to force a cache refresh on repo's connection state.
        :return: V1alpha1RepositoryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repository_service_list_repositories_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.repository_service_list_repositories_with_http_info(**kwargs)  # noqa: E501
            return data

    def repository_service_list_repositories_with_http_info(self, **kwargs):  # noqa: E501
        """ListRepositories gets a list of all configured repositories  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_list_repositories_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo: Repo URL for query.
        :param bool force_refresh: Whether to force a cache refresh on repo's connection state.
        :return: V1alpha1RepositoryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo', 'force_refresh']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_service_list_repositories" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'repo' in params:
            query_params.append(('repo', params['repo']))  # noqa: E501
        if 'force_refresh' in params:
            query_params.append(('forceRefresh', params['force_refresh']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/repositories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1RepositoryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repository_service_update_repository(self, body, repo_repo, **kwargs):  # noqa: E501
        """UpdateRepository updates a repository configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_update_repository(body, repo_repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1Repository body: (required)
        :param str repo_repo: Repo contains the URL to the remote repository (required)
        :return: V1alpha1Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repository_service_update_repository_with_http_info(body, repo_repo, **kwargs)  # noqa: E501
        else:
            (data) = self.repository_service_update_repository_with_http_info(body, repo_repo, **kwargs)  # noqa: E501
            return data

    def repository_service_update_repository_with_http_info(self, body, repo_repo, **kwargs):  # noqa: E501
        """UpdateRepository updates a repository configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_update_repository_with_http_info(body, repo_repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1alpha1Repository body: (required)
        :param str repo_repo: Repo contains the URL to the remote repository (required)
        :return: V1alpha1Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repo_repo']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_service_update_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `repository_service_update_repository`")  # noqa: E501
        # verify the required parameter 'repo_repo' is set
        if ('repo_repo' not in params or
                params['repo_repo'] is None):
            raise ValueError("Missing the required parameter `repo_repo` when calling `repository_service_update_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_repo' in params:
            path_params['repo.repo'] = params['repo_repo']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/repositories/{repo.repo}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Repository',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repository_service_validate_access(self, body, repo, **kwargs):  # noqa: E501
        """ValidateAccess validates access to a repository with given parameters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_validate_access(body, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The URL to the repo (required)
        :param str repo: The URL to the repo (required)
        :param str username: Username for accessing repo.
        :param str password: Password for accessing repo.
        :param str ssh_private_key: Private key data for accessing SSH repository.
        :param bool insecure: Whether to skip certificate or host key validation.
        :param str tls_client_cert_data: TLS client cert data for accessing HTTPS repository.
        :param str tls_client_cert_key: TLS client cert key for accessing HTTPS repository.
        :param str type: The type of the repo.
        :param str name: The name of the repo.
        :param bool enable_oci: Whether helm-oci support should be enabled for this repo.
        :param str github_app_private_key: Github App Private Key PEM data.
        :param str github_app_id: Github App ID of the app used to access the repo.
        :param str github_app_installation_id: Github App Installation ID of the installed GitHub App.
        :param str github_app_enterprise_base_url: Github App Enterprise base url if empty will default to https://api.github.com.
        :param str proxy: HTTP/HTTPS proxy to access the repository.
        :param str project: Reference between project and repository that allow you automatically to be added as item inside SourceRepos project entity.
        :param str gcp_service_account_key: Google Cloud Platform service account key.
        :param bool force_http_basic_auth: Whether to force HTTP basic auth.
        :return: RepositoryRepoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repository_service_validate_access_with_http_info(body, repo, **kwargs)  # noqa: E501
        else:
            (data) = self.repository_service_validate_access_with_http_info(body, repo, **kwargs)  # noqa: E501
            return data

    def repository_service_validate_access_with_http_info(self, body, repo, **kwargs):  # noqa: E501
        """ValidateAccess validates access to a repository with given parameters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repository_service_validate_access_with_http_info(body, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The URL to the repo (required)
        :param str repo: The URL to the repo (required)
        :param str username: Username for accessing repo.
        :param str password: Password for accessing repo.
        :param str ssh_private_key: Private key data for accessing SSH repository.
        :param bool insecure: Whether to skip certificate or host key validation.
        :param str tls_client_cert_data: TLS client cert data for accessing HTTPS repository.
        :param str tls_client_cert_key: TLS client cert key for accessing HTTPS repository.
        :param str type: The type of the repo.
        :param str name: The name of the repo.
        :param bool enable_oci: Whether helm-oci support should be enabled for this repo.
        :param str github_app_private_key: Github App Private Key PEM data.
        :param str github_app_id: Github App ID of the app used to access the repo.
        :param str github_app_installation_id: Github App Installation ID of the installed GitHub App.
        :param str github_app_enterprise_base_url: Github App Enterprise base url if empty will default to https://api.github.com.
        :param str proxy: HTTP/HTTPS proxy to access the repository.
        :param str project: Reference between project and repository that allow you automatically to be added as item inside SourceRepos project entity.
        :param str gcp_service_account_key: Google Cloud Platform service account key.
        :param bool force_http_basic_auth: Whether to force HTTP basic auth.
        :return: RepositoryRepoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repo', 'username', 'password', 'ssh_private_key', 'insecure', 'tls_client_cert_data', 'tls_client_cert_key', 'type', 'name', 'enable_oci', 'github_app_private_key', 'github_app_id', 'github_app_installation_id', 'github_app_enterprise_base_url', 'proxy', 'project', 'gcp_service_account_key', 'force_http_basic_auth']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_service_validate_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `repository_service_validate_access`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError("Missing the required parameter `repo` when calling `repository_service_validate_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'ssh_private_key' in params:
            query_params.append(('sshPrivateKey', params['ssh_private_key']))  # noqa: E501
        if 'insecure' in params:
            query_params.append(('insecure', params['insecure']))  # noqa: E501
        if 'tls_client_cert_data' in params:
            query_params.append(('tlsClientCertData', params['tls_client_cert_data']))  # noqa: E501
        if 'tls_client_cert_key' in params:
            query_params.append(('tlsClientCertKey', params['tls_client_cert_key']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'enable_oci' in params:
            query_params.append(('enableOci', params['enable_oci']))  # noqa: E501
        if 'github_app_private_key' in params:
            query_params.append(('githubAppPrivateKey', params['github_app_private_key']))  # noqa: E501
        if 'github_app_id' in params:
            query_params.append(('githubAppID', params['github_app_id']))  # noqa: E501
        if 'github_app_installation_id' in params:
            query_params.append(('githubAppInstallationID', params['github_app_installation_id']))  # noqa: E501
        if 'github_app_enterprise_base_url' in params:
            query_params.append(('githubAppEnterpriseBaseUrl', params['github_app_enterprise_base_url']))  # noqa: E501
        if 'proxy' in params:
            query_params.append(('proxy', params['proxy']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501
        if 'gcp_service_account_key' in params:
            query_params.append(('gcpServiceAccountKey', params['gcp_service_account_key']))  # noqa: E501
        if 'force_http_basic_auth' in params:
            query_params.append(('forceHttpBasicAuth', params['force_http_basic_auth']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/repositories/{repo}/validate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryRepoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
