from pydantic import BaseModel


CLASS_NAMES = [
    "AccountTypeEnum",
    "AfdsTransactionEnum",
    "AnetApiRequest",
    "AnetApiResponse",
    "ArbTransaction",
    "ArbcancelSubscriptionRequest",
    "ArbcancelSubscriptionResponse",
    "ArbcreateSubscriptionRequest",
    "ArbcreateSubscriptionResponse",
    "ArbgetSubscriptionListOrderFieldEnum",
    "ArbgetSubscriptionListRequest",
    "ArbgetSubscriptionListResponse",
    "ArbgetSubscriptionListSearchTypeEnum",
    "ArbgetSubscriptionListSorting",
    "ArbgetSubscriptionRequest",
    "ArbgetSubscriptionResponse",
    "ArbgetSubscriptionStatusRequest",
    "ArbgetSubscriptionStatusResponse",
    "ArbsubscriptionMaskedType",
    "ArbsubscriptionStatusEnum",
    "ArbsubscriptionType",
    "ArbsubscriptionUnitEnum",
    "ArbtransactionList",
    "ArbupdateSubscriptionRequest",
    "ArbupdateSubscriptionResponse",
    "ArrayOfAuresponseType",
    "ArrayOfBatchDetailsType",
    "ArrayOfBatchStatisticType",
    "ArrayOfCardType",
    "ArrayOfContactDetail",
    "ArrayOfCurrencyCode",
    "ArrayOfCustomerPaymentProfileListItemType",
    "ArrayOfFdsfilter",
    "ArrayOfFraudFilterType",
    "ArrayOfLineItem",
    "ArrayOfLong",
    "ArrayOfMarketType",
    "ArrayOfNumericString",
    "ArrayOfPaymentMethod",
    "ArrayOfPermissionType",
    "ArrayOfProcessorType",
    "ArrayOfProductCode",
    "ArrayOfReturnedItem",
    "ArrayOfSetting",
    "ArrayOfString",
    "ArrayOfSubscription",
    "ArrayOfTransactionSummaryType",
    "AsyncClient",
    "AuDeleteType",
    "AuDetailsType",
    "AuResponseType",
    "AuUpdateType",
    "AujobTypeEnum",
    "AuthIndicatorEnum",
    "AuthenticateTestRequest",
    "AuthenticateTestResponse",
    "AuthorizationIndicatorType",
    "BankAccountMaskedType",
    "BankAccountType",
    "BankAccountTypeEnum",
    "BatchDetailsType",
    "BatchStatisticType",
    "CardArt",
    "CardTypeEnum",
    "CcAuthenticationType",
    "Client",
    "ContactDetailType",
    "CreateCustomerPaymentProfileRequest",
    "CreateCustomerPaymentProfileResponse",
    "CreateCustomerProfileFromTransactionRequest",
    "CreateCustomerProfileRequest",
    "CreateCustomerProfileResponse",
    "CreateCustomerProfileTransactionRequest",
    "CreateCustomerProfileTransactionResponse",
    "CreateCustomerShippingAddressRequest",
    "CreateCustomerShippingAddressResponse",
    "CreateProfileResponse",
    "CreateTransactionRequest",
    "CreateTransactionResponse",
    "CreditCardMaskedType",
    "CreditCardSimpleType",
    "CreditCardTrackType",
    "CreditCardType",
    "CustomerAddressExType",
    "CustomerAddressType",
    "CustomerDataType",
    "CustomerPaymentProfileBaseType",
    "CustomerPaymentProfileExType",
    "CustomerPaymentProfileListItemType",
    "CustomerPaymentProfileMaskedType",
    "CustomerPaymentProfileOrderFieldEnum",
    "CustomerPaymentProfileSearchTypeEnum",
    "CustomerPaymentProfileSorting",
    "CustomerPaymentProfileType",
    "CustomerProfileBaseType",
    "CustomerProfileExType",
    "CustomerProfileIdType",
    "CustomerProfileInfoExType",
    "CustomerProfileMaskedType",
    "CustomerProfilePaymentType",
    "CustomerProfileSummaryType",
    "CustomerProfileType",
    "CustomerProfileTypeEnum",
    "CustomerType",
    "CustomerTypeEnum",
    "DecryptPaymentDataRequest",
    "DecryptPaymentDataResponse",
    "DeleteCustomerPaymentProfileRequest",
    "DeleteCustomerPaymentProfileResponse",
    "DeleteCustomerProfileRequest",
    "DeleteCustomerProfileResponse",
    "DeleteCustomerShippingAddressRequest",
    "DeleteCustomerShippingAddressResponse",
    "DeviceActivationEnum",
    "DriversLicenseMaskedType",
    "DriversLicenseType",
    "EcheckTypeEnum",
    "EmailSettingsType",
    "EmvTag",
    "EncodingType",
    "EncryptedTrackDataType",
    "EncryptionAlgorithmType",
    "EnumCollection",
    "ErrorResponse",
    "ExtendedAmountType",
    "FdsfilterActionEnum",
    "FdsfilterType",
    "FingerPrintType",
    "FraudInformationType",
    "GetAujobDetailsRequest",
    "GetAujobDetailsResponse",
    "GetAujobSummaryRequest",
    "GetAujobSummaryResponse",
    "GetBatchStatisticsRequest",
    "GetBatchStatisticsResponse",
    "GetCustomerPaymentProfileListRequest",
    "GetCustomerPaymentProfileListResponse",
    "GetCustomerPaymentProfileNonceRequest",
    "GetCustomerPaymentProfileNonceResponse",
    "GetCustomerPaymentProfileRequest",
    "GetCustomerPaymentProfileResponse",
    "GetCustomerProfileIdsRequest",
    "GetCustomerProfileIdsResponse",
    "GetCustomerProfileRequest",
    "GetCustomerProfileResponse",
    "GetCustomerShippingAddressRequest",
    "GetCustomerShippingAddressResponse",
    "GetHostedPaymentPageRequest",
    "GetHostedPaymentPageResponse",
    "GetHostedProfilePageRequest",
    "GetHostedProfilePageResponse",
    "GetMerchantDetailsRequest",
    "GetMerchantDetailsResponse",
    "GetSettledBatchListRequest",
    "GetSettledBatchListResponse",
    "GetTransactionDetailsRequest",
    "GetTransactionDetailsResponse",
    "GetTransactionListForCustomerRequest",
    "GetTransactionListRequest",
    "GetTransactionListResponse",
    "GetUnsettledTransactionListRequest",
    "GetUnsettledTransactionListResponse",
    "HeldTransactionRequestType",
    "ImpersonationAuthenticationType",
    "IsAliveRequest",
    "IsAliveResponse",
    "KeyBlock",
    "KeyManagementScheme",
    "KeyValue",
    "LineItemType",
    "ListOfAudetailsType",
    "LogoutRequest",
    "LogoutResponse",
    "MerchantAuthenticationType",
    "MerchantContactType",
    "MerchantInitTransReasonEnum",
    "MessageTypeEnum",
    "MessagesType",
    "MobileDeviceLoginRequest",
    "MobileDeviceLoginResponse",
    "MobileDeviceRegistrationRequest",
    "MobileDeviceRegistrationResponse",
    "MobileDeviceType",
    "NameAndAddressType",
    "OpaqueDataType",
    "OperationType",
    "OrderExType",
    "OrderType",
    "OtherTaxType",
    "Paging",
    "PayPalType",
    "PaymentDetails",
    "PaymentEmvType",
    "PaymentMaskedType",
    "PaymentMethodEnum",
    "PaymentMethodsTypeEnum",
    "PaymentProfile",
    "PaymentScheduleType",
    "PaymentSimpleType",
    "PaymentType",
    "PermissionType",
    "PermissionsEnum",
    "ProcessingOptions",
    "ProcessorType",
    "ProfileTransAmountType",
    "ProfileTransAuthCaptureType",
    "ProfileTransAuthOnlyType",
    "ProfileTransCaptureOnlyType",
    "ProfileTransOrderType",
    "ProfileTransPriorAuthCaptureType",
    "ProfileTransRefundType",
    "ProfileTransVoidType",
    "ProfileTransactionType",
    "ReturnedItemType",
    "SecurePaymentContainerErrorType",
    "SecurePaymentContainerRequest",
    "SecurePaymentContainerResponse",
    "SendCustomerTransactionReceiptRequest",
    "SendCustomerTransactionReceiptResponse",
    "SettingNameEnum",
    "SettingType",
    "SettlementStateEnum",
    "SolutionType",
    "SplitTenderStatusEnum",
    "SubMerchantType",
    "SubscriptionCustomerProfileType",
    "SubscriptionDetail",
    "SubscriptionIdList",
    "SubscriptionPaymentType",
    "SubsequentAuthInformation",
    "TokenMaskedType",
    "TransRetailInfoType",
    "TransactionDetailsType",
    "TransactionGroupStatusEnum",
    "TransactionListOrderFieldEnum",
    "TransactionListSorting",
    "TransactionRequestType",
    "TransactionResponse",
    "TransactionStatusEnum",
    "TransactionSummaryType",
    "TransactionTypeEnum",
    "UpdateCustomerPaymentProfileRequest",
    "UpdateCustomerPaymentProfileResponse",
    "UpdateCustomerProfileRequest",
    "UpdateCustomerProfileResponse",
    "UpdateCustomerShippingAddressRequest",
    "UpdateCustomerShippingAddressResponse",
    "UpdateHeldTransactionRequest",
    "UpdateHeldTransactionResponse",
    "UpdateMerchantDetailsRequest",
    "UpdateMerchantDetailsResponse",
    "UpdateSplitTenderGroupRequest",
    "UpdateSplitTenderGroupResponse",
    "UserField",
    "ValidateCustomerPaymentProfileRequest",
    "ValidateCustomerPaymentProfileResponse",
    "ValidationModeEnum",
    "WebCheckOutDataType",
    "WebCheckOutDataTypeToken",
    "WebCheckOutTypeEnum",
]


def generate_pydantic_code(instance: BaseModel) -> str:
    code = repr(instance)
    for class_name in CLASS_NAMES:
        code = code.replace(class_name, f"authorizenet.{class_name}")
    return code
