import json
from pathlib import Path

import pytest

from autojob.tasks.calculation import Calculation
from autojob.tasks.calculation import CalculationInputs


class TestCalculationInputsFromInputsJSON:
    @staticmethod
    @pytest.fixture(name="calculation")
    def fixture_calculation() -> Calculation:
        return Calculation()

    @staticmethod
    def test_should_load_calculation_inputs_from_input_json_data(
        calculation: Calculation, tmp_path: Path
    ) -> None:
        inputs_json = calculation.write_inputs_json(tmp_path)
        calculation_inputs = calculation.calculation_inputs.model_dump()
        with inputs_json.open(mode="r", encoding="utf-8") as file:
            data = json.load(file)

        loaded_calculation_inputs = CalculationInputs.model_validate(
            data.get("calculation_inputs")
        )
        assert loaded_calculation_inputs
        assert loaded_calculation_inputs.model_dump() == calculation_inputs
