import os
from pathlib import Path
import tomllib

import pytest

from autojob.settings import AutojobSettings


@pytest.fixture(name="config_file")
def fixture_config_file(datadir: Path) -> Path:
    return datadir.joinpath("config.toml")


@pytest.fixture(name="settings_from_file")
def fixture_settings_from_file(
    config_file: Path,
) -> AutojobSettings:
    with config_file.open(mode="r", encoding="utf-8") as f:
        data = tomllib.loads(f.read())
    return AutojobSettings(**data)


def test_should_read_configuration_from_config_file(
    settings_from_file: AutojobSettings,
    config_file: Path,
    monkeypatch: pytest.MonkeyPatch,
) -> None:
    with monkeypatch.context() as m:
        m.setitem(os.environ, "AUTOJOB_CONFIG_FILE", str(config_file))
        settings = AutojobSettings()
        assert settings.model_dump() == settings_from_file.model_dump()
