from datetime import UTC
from datetime import datetime
from pathlib import Path

import pytest

from autojob.study import Study
from autojob.study_group import StudyGroup
from autojob.tasks.calculation import Calculation


class TestToDirectory:
    @staticmethod
    def test_should_create_study_directories_for_tasks(
        study_group: StudyGroup, study_group_directory: Path
    ) -> None:
        study_group.to_directory(study_group_directory)

        studies_created = []
        files = [f.name for f in study_group_directory.iterdir()]

        for study in study_group.studies:
            studies_created.append(str(study.study_id) in files)

        assert all(studies_created)


class TestToDirectoryForCalculations(TestToDirectory):
    @staticmethod
    @pytest.fixture(name="study")
    def fixture_study(
        calculation: Calculation, study_id: str, study_group_id: str
    ) -> Study:
        study = Study(
            tasks=[calculation],
            date_created=datetime.now(tz=UTC),
            study_id=(study_id),
            study_group_id=study_group_id,
        )
        return study
