from pathlib import Path

from ase import Atoms
import pytest

from autojob import SETTINGS
from autojob.tasks.task import TaskOutputs


class TestFromDirectory:
    @staticmethod
    def test_should_retrieve_output_atoms_if_present(tmp_path: Path) -> None:
        atoms = Atoms("C")
        atoms.write(Path(tmp_path, SETTINGS.OUTPUT_ATOMS_FILE))
        outputs = TaskOutputs.from_directory(tmp_path, strict_mode=True)
        assert outputs.atoms == atoms

    @staticmethod
    def test_should_raise_error_without_output_atoms_if_strict_mode_enabled(
        tmp_path: Path,
    ) -> None:
        with pytest.raises(FileNotFoundError):
            _ = TaskOutputs.from_directory(tmp_path, strict_mode=True)

    @staticmethod
    def test_should_return_without_error_or_output_atoms_if_strict_mode_disabled(
        tmp_path: Path,
    ) -> None:
        assert (
            TaskOutputs.from_directory(tmp_path, strict_mode=False).atoms
            is None
        )
