"""Tools for DFT job automation on massively parallel computing resources."""

from __future__ import annotations

import logging
import warnings

from ase import __version__ as ase_version

from autojob.settings import AutojobSettings

logger = logging.getLogger(__name__)


if tuple(ase_version) <= tuple("3.22.1"):
    warnings.warn(
        "Your ASE version ({ase_version}) is <= 3.22.1. Please upgrade your "
        "ASE version: pip install --upgrade https://gitlab.com/ase/ase/-/"
        "archive/master/ase-master.zip",
        UserWarning,
        stacklevel=1,
    )


SETTINGS = AutojobSettings()
