"""This module defines the :class:`AnalysisBase` protocol."""

from pathlib import Path
from typing import Protocol
from typing import runtime_checkable


@runtime_checkable
class AnalysisBase(Protocol):
    """A protocol defining functions that perform a post-calculation analysis."""

    def __call__(self, src: Path, **kwargs) -> None: ...  # noqa: D102 # type: ignore[no-untyped-def]
