"""This module defines the :class:`HarvesterBase` protocol."""

from pathlib import Path
from typing import Any
from typing import Protocol
from typing import runtime_checkable


@runtime_checkable
class HarvesterBase(Protocol):
    """A protocol for functions that harvest post-calculation analysis results."""

    def __call__(self, src: str | Path) -> dict[str, Any]: ...  # noqa: D102
